/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.internal.evaluation.JMergeUtil;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoEvaluationContext {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String JMERGE_TAG = "@generated";
    private static final List<Future<Object>> LOST_CREATION_TASKS = new ArrayList<Future<Object>>();
    private static final ExecutorService LOST_CREATORS_POOL = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    protected final Map<String, Writer> generationPreview = new HashMap<String, Writer>();
    protected final boolean previewMode;
    private final Monitor progressMonitor;
    private final LinkedList<Map<String, Object>> blockVariables = new LinkedList();
    private final File generationRoot;
    private boolean hasJMergeTag;
    private final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>(3);
    private final Map<Writer, Map<String, String>> userCodeBlocks = new HashMap<Writer, Map<String, String>>();
    private final LinkedList<Writer> writers = new LinkedList();

    public AcceleoEvaluationContext(File root, List<IAcceleoTextGenerationListener> listeners, boolean preview, Monitor monitor) {
        this.generationRoot = root;
        this.previewMode = preview;
        this.listeners.addAll(listeners);
        this.progressMonitor = monitor != null ? monitor : new BasicMonitor();
        this.flatten();
    }

    public static void awaitCompletion() throws InterruptedException {
        for (Future<Object> task : new ArrayList<Future<Object>>(LOST_CREATION_TASKS)) {
            while (!task.isDone() && !task.isCancelled()) {
                try {
                    task.get();
                }
                catch (ExecutionException executionException) {}
            }
            LOST_CREATION_TASKS.remove(task);
        }
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) throws AcceleoEvaluationException {
        try {
            Writer currentWriter = this.writers.getLast();
            currentWriter.append(string);
            if (fireEvent) {
                this.fireTextGenerated(new AcceleoTextGenerationEvent(string, sourceBlock, source));
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.AppendError"), e);
        }
    }

    public String closeContext() throws AcceleoEvaluationException {
        Writer last = this.writers.removeLast();
        try {
            String result;
            if (last instanceof AcceleoWriterDecorator) {
                String filePath = ((AcceleoWriterDecorator)last).getTargetPath();
                Map<String, String> lostCode = this.userCodeBlocks.remove(last);
                if (lostCode.size() > 0) {
                    this.createLostFile(filePath, lostCode);
                }
                last.close();
                if (this.previewMode) {
                    this.generationPreview.put(filePath, last);
                }
                result = "";
            } else if (last instanceof OutputStreamWriter) {
                last.close();
                result = "";
            } else {
                result = last.toString();
            }
            return result;
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.WriteError"), e);
        }
    }

    public void dispose() throws AcceleoEvaluationException {
        AcceleoEvaluationException exception = null;
        try {
            try {
                AcceleoEvaluationContext.awaitCompletion();
            }
            catch (InterruptedException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
            try {
                for (Writer writer : this.writers) {
                    writer.close();
                }
            }
            catch (IOException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
        }
        finally {
            LOST_CREATION_TASKS.clear();
            this.generationPreview.clear();
            this.blockVariables.clear();
            this.listeners.clear();
            this.userCodeBlocks.clear();
            this.writers.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Map<String, Writer> getGenerationPreview() {
        return new HashMap<String, Writer>(this.generationPreview);
    }

    public Map<String, Object> getLastVariablesValues() {
        return this.blockVariables.removeLast();
    }

    public Monitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public String getProtectedAreaContent(String marker) {
        Writer writer = null;
        int i = this.writers.size() - 1;
        while (i >= 0) {
            writer = this.writers.get(i);
            if (writer instanceof AcceleoWriterDecorator) break;
            writer = null;
            --i;
        }
        Map<String, String> areas = this.userCodeBlocks.get(writer);
        if (areas != null) {
            return areas.remove(marker);
        }
        return null;
    }

    public void openNested() throws AcceleoEvaluationException {
        try {
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add(new StringWriter(1024));
    }

    public void openNested(OutputStream stream) {
        try {
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add(new OutputStreamWriter(new AcceleoFilterOutputStream(stream)));
    }

    public void openNested(String filePath, Block fileBlock, EObject source, boolean appendMode) throws AcceleoEvaluationException {
        File generatedFile = filePath.startsWith("file:") ? new File(filePath) : new File(this.generationRoot, filePath);
        this.fireFilePathComputed(new AcceleoTextGenerationEvent(generatedFile.getPath(), fileBlock, source));
        if (!(this.previewMode || generatedFile.getParentFile().exists() || generatedFile.getParentFile().mkdirs())) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FolderCreationError", generatedFile.getParentFile()));
        }
        try {
            Writer writer;
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
            HashMap<String, String> savedCodeBlocks = new HashMap<String, String>();
            if (generatedFile.exists()) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(generatedFile));
            }
            if (this.generationPreview.containsKey(generatedFile.getPath())) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(this.generationPreview.get(generatedFile.getPath()).toString()));
            }
            if (!(this.previewMode || this.hasJMergeTag && !appendMode)) {
                writer = new AcceleoWriterDecorator(generatedFile, appendMode);
                if (appendMode) {
                    writer.append(LINE_SEPARATOR);
                }
            } else {
                if (appendMode && this.generationPreview.containsKey(generatedFile.getPath())) {
                    writer = this.generationPreview.get(generatedFile.getPath());
                    writer.append(System.getProperty("line.separator"));
                } else if (!appendMode && this.hasJMergeTag) {
                    if (!this.previewMode) {
                        writer = new AcceleoWriterDecorator(generatedFile.getPath(), this.hasJMergeTag);
                    } else {
                        writer = this.generationPreview.get(generatedFile.getPath());
                        ((AcceleoWriterDecorator)writer).reinit();
                    }
                } else {
                    writer = new AcceleoWriterDecorator(generatedFile.getPath());
                }
                this.generationPreview.put(generatedFile.getPath(), writer);
                this.hasJMergeTag = false;
            }
            this.userCodeBlocks.put(writer, savedCodeBlocks);
            this.writers.add(writer);
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileCreationError", generatedFile.getPath()), e);
        }
    }

    public void saveVariableValues(Map<String, Object> vars) {
        this.blockVariables.add(vars);
    }

    private void createLostFile(String originalPath, Map<String, String> lostAreas) {
        LostFileWriter fileCreator = new LostFileWriter(originalPath, lostAreas);
        LOST_CREATION_TASKS.add(LOST_CREATORS_POOL.submit(fileCreator));
    }

    private void fireFilePathComputed(AcceleoTextGenerationEvent event) {
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.filePathComputed(event);
        }
    }

    private void fireTextGenerated(AcceleoTextGenerationEvent event) {
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.textGenerated(event);
        }
    }

    private void flatten() {
        for (Future<Object> task : new ArrayList<Future<Object>>(LOST_CREATION_TASKS)) {
            if (!task.isDone() && !task.isCancelled()) continue;
            LOST_CREATION_TASKS.remove(task);
        }
    }

    private Map<String, String> internalSaveProtectedAreas(BufferedReader reader) throws IOException {
        HashMap<String, String> protectedAreas = new HashMap<String, String>();
        String usercodeStart = AcceleoEngineMessages.getString("usercode.start");
        String usercodeEnd = AcceleoEngineMessages.getString("usercode.end");
        String line = reader.readLine();
        while (line != null) {
            if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                this.hasJMergeTag = true;
            }
            if (line.contains(usercodeStart)) {
                String previous;
                String marker = line.substring(line.indexOf(usercodeStart) + usercodeStart.length()).trim();
                StringBuffer areaContent = new StringBuffer(1024);
                if (line.indexOf(usercodeStart) - LINE_SEPARATOR.length() > 0 && LINE_SEPARATOR.equals(previous = line.substring(line.indexOf(usercodeStart) - LINE_SEPARATOR.length(), line.indexOf(usercodeStart)))) {
                    areaContent.append(LINE_SEPARATOR);
                }
                areaContent.append(line.substring(line.indexOf(usercodeStart)));
                line = reader.readLine();
                while (line != null) {
                    areaContent.append(LINE_SEPARATOR);
                    if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                        this.hasJMergeTag = true;
                    }
                    if (line.contains(usercodeEnd)) {
                        int endOffset = line.indexOf(usercodeEnd) + usercodeEnd.length();
                        areaContent.append(line.substring(0, endOffset));
                        if (endOffset + LINE_SEPARATOR.length() > line.length() || !LINE_SEPARATOR.equals(line.substring(endOffset, endOffset + LINE_SEPARATOR.length()))) break;
                        areaContent.append(LINE_SEPARATOR);
                        break;
                    }
                    areaContent.append(line);
                    line = reader.readLine();
                }
                protectedAreas.put(marker, areaContent.toString());
            }
            line = reader.readLine();
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(File file) throws IOException {
        Map<String, String> protectedAreas = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                protectedAreas = this.internalSaveProtectedAreas(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(String buffer) {
        Map<String, String> protectedAreas;
        block14: {
            protectedAreas = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new StringReader(buffer));
                    protectedAreas = this.internalSaveProtectedAreas(reader);
                }
                catch (IOException iOException) {
                    if (!this.previewMode && reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (!this.previewMode && reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (!this.previewMode && reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return protectedAreas;
    }

    private final class AcceleoFilterOutputStream
    extends FilterOutputStream {
        public AcceleoFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {}
            if (this.out != System.out) {
                this.out.close();
            }
        }
    }

    private final class AcceleoWriterDecorator
    extends Writer {
        private Writer delegate;
        private final boolean isFile;
        private String oldContent;
        private boolean shouldMerge;
        private final String targetPath;

        public AcceleoWriterDecorator(File target, boolean appendMode) throws IOException {
            this.delegate = new BufferedWriter(new FileWriter(target, appendMode));
            if (appendMode) {
                ((BufferedWriter)this.delegate).newLine();
            }
            this.targetPath = target.getAbsolutePath();
            this.isFile = true;
            this.shouldMerge = false;
        }

        public AcceleoWriterDecorator(String filePath) {
            this.delegate = new StringWriter(1024);
            this.targetPath = filePath;
            this.isFile = false;
            this.shouldMerge = false;
        }

        public AcceleoWriterDecorator(String filePath, boolean merge) {
            this.delegate = new StringWriter(1024);
            this.targetPath = filePath;
            this.isFile = true;
            this.shouldMerge = merge;
        }

        public void close() throws IOException {
            if (this.isFile) {
                if (!this.shouldMerge) {
                    this.delegate.close();
                } else {
                    this.flush();
                    try {
                        Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                        Writer newDelegate = JMergeUtil.mergeFileContent(new File(this.targetPath), this.toString(), AcceleoEvaluationContext.this.previewMode, this.oldContent);
                        if (newDelegate != null) {
                            this.delegate = newDelegate;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            } else {
                this.flush();
            }
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void reinit() {
            this.oldContent = this.toString();
            this.shouldMerge = true;
            this.delegate = new StringWriter(1024);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }

        public void write(int c) throws IOException {
            this.delegate.write(c);
        }

        public void write(String str, int off, int len) throws IOException {
            this.delegate.write(str, off, len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LostFileWriter
    implements Callable<Object> {
        private final Map<String, String> lostAreas;
        private final String originalPath;

        LostFileWriter(String originalPath, Map<String, String> lostAreas) {
            this.originalPath = originalPath;
            this.lostAreas = lostAreas;
        }

        @Override
        public Object call() {
            block21: {
                StringBuilder lostContent = new StringBuilder();
                for (String lostAreaContent : this.lostAreas.values()) {
                    lostContent.append(lostAreaContent);
                    lostContent.append(LINE_SEPARATOR);
                }
                Writer writer = null;
                try {
                    try {
                        File lostFile = new File(this.originalPath.concat(".lost"));
                        if (!AcceleoEvaluationContext.this.previewMode) {
                            writer = new BufferedWriter(new FileWriter(lostFile, true));
                        } else {
                            writer = new StringWriter(1024);
                            if (lostFile.exists() && lostFile.canRead()) {
                                BufferedReader lostFileReader = new BufferedReader(new FileReader(lostFile));
                                String line = lostFileReader.readLine();
                                while (line != null) {
                                    writer.append(line);
                                    line = lostFileReader.readLine();
                                }
                            }
                        }
                        writer.append(LINE_SEPARATOR).append(Calendar.getInstance().getTime().toString()).append(LINE_SEPARATOR);
                        writer.append("================================================================================");
                        writer.append(LINE_SEPARATOR);
                        writer.append(lostContent);
                    }
                    catch (IOException iOException) {
                        String errorMessage = AcceleoEngineMessages.getString("AcceleoEvaluationContext.LostContent", this.originalPath, lostContent);
                        AcceleoEnginePlugin.log(errorMessage, false);
                        if (writer == null) break block21;
                        try {
                            if (!AcceleoEvaluationContext.this.previewMode) {
                                writer.close();
                            } else {
                                writer.flush();
                                AcceleoEvaluationContext.this.generationPreview.put(this.originalPath.concat(".lost"), writer);
                            }
                        }
                        catch (IOException e) {
                            AcceleoEnginePlugin.log(e, false);
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            if (!AcceleoEvaluationContext.this.previewMode) {
                                writer.close();
                            } else {
                                writer.flush();
                                AcceleoEvaluationContext.this.generationPreview.put(this.originalPath.concat(".lost"), writer);
                            }
                        }
                        catch (IOException e) {
                            AcceleoEnginePlugin.log(e, false);
                        }
                    }
                }
            }
            return null;
        }
    }
}

