/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoCompileOperation;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateBuildAcceleoWriter;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.acceleo.ide.ui.acceleoBuilder";
    private IPath outputFolder;

    protected IProject[] build(int kind, Map arguments, IProgressMonitor monitor) throws CoreException {
        block8: {
            if (this.getProject() == null || !this.getProject().isAccessible()) {
                return new IProject[0];
            }
            this.outputFolder = this.getOutputFolder(this.getProject());
            try {
                try {
                    if (kind == 6) {
                        this.clean(monitor);
                        this.fullBuild(monitor);
                        break block8;
                    }
                    IResourceDelta delta = this.getDelta(this.getProject());
                    if (delta == null) {
                        this.clean(monitor);
                        this.fullBuild(monitor);
                        break block8;
                    }
                    this.incrementalBuild(delta, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.outputFolder = null;
                }
            }
            finally {
                this.outputFolder = null;
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> filesOutput = new ArrayList<IFile>();
        this.members(filesOutput, (IContainer)this.getProject());
        if (filesOutput.size() > 0) {
            Collections.sort(filesOutput, new Comparator<IFile>(){

                @Override
                public int compare(IFile arg0, IFile arg1) {
                    long m1;
                    long m0 = arg0.getLocation().toFile().lastModified();
                    if (m0 < (m1 = arg1.getLocation().toFile().lastModified())) {
                        return 1;
                    }
                    return -1;
                }
            });
            IFile[] files = filesOutput.toArray(new IFile[filesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.getProject(), files, false);
            compileOperation.run(monitor);
            this.validateAcceleoBuildFile(monitor);
        }
    }

    private void validateAcceleoBuildFile(IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = this.getProject().getFile("build.properties");
        if (buildProperties.exists()) {
            IFile buildAcceleo = this.getProject().getFile("build.acceleo");
            CreateBuildAcceleoWriter buildWriter = new CreateBuildAcceleoWriter();
            String buildText = buildWriter.generate(null);
            if (!buildAcceleo.exists() || !buildText.equals(FileContent.getFileContent((File)buildAcceleo.getLocation().toFile()).toString())) {
                try {
                    ByteArrayInputStream javaStream = new ByteArrayInputStream(buildText.getBytes("UTF8"));
                    if (!buildAcceleo.exists()) {
                        buildAcceleo.create((InputStream)javaStream, true, monitor);
                    } else {
                        buildAcceleo.setContents((InputStream)javaStream, true, false, monitor);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                }
            }
            if (FileContent.getFileContent((File)buildProperties.getLocation().toFile()).indexOf(buildAcceleo.getName()) == -1) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("AcceleoBuilder.AcceleoBuildFileIssue", this.getProject().getName())));
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> deltaFilesOutput = new ArrayList<IFile>();
        this.deltaMembers(deltaFilesOutput, delta, monitor);
        if (deltaFilesOutput.size() > 0) {
            boolean containsManifest = false;
            int i = 0;
            while (!containsManifest && i < deltaFilesOutput.size()) {
                containsManifest = "MANIFEST.MF".equals(((IFile)deltaFilesOutput.get(i)).getName());
                ++i;
            }
            if (containsManifest) {
                deltaFilesOutput.clear();
                this.members(deltaFilesOutput, (IContainer)this.getProject());
            } else {
                this.computeOtherFilesToBuild(deltaFilesOutput);
            }
        } else {
            this.computeOtherFilesToBuild(deltaFilesOutput);
        }
        if (deltaFilesOutput.size() > 0) {
            Collections.sort(deltaFilesOutput, new Comparator<IFile>(){

                @Override
                public int compare(IFile arg0, IFile arg1) {
                    long m1;
                    long m0 = arg0.getLocation().toFile().lastModified();
                    if (m0 < (m1 = arg1.getLocation().toFile().lastModified())) {
                        return 1;
                    }
                    return -1;
                }
            });
            IFile[] files = deltaFilesOutput.toArray(new IFile[deltaFilesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.getProject(), files, false);
            compileOperation.run(monitor);
        }
    }

    private void computeOtherFilesToBuild(List<IFile> deltaFiles) throws CoreException {
        ArrayList<IFile> otherTemplates = new ArrayList<IFile>();
        this.members(otherTemplates, (IContainer)this.getProject());
        ArrayList<Sequence> importSequencesToSearch = new ArrayList<Sequence>();
        int i = 0;
        while (i < deltaFiles.size()) {
            IFile deltaFile = deltaFiles.get(i);
            if ("mtl".equals(deltaFile.getFileExtension())) {
                String[] tokens = new String[]{"[", "import", new Path(deltaFile.getName()).removeFileExtension().lastSegment()};
                importSequencesToSearch.add(new Sequence(tokens));
                tokens = new String[]{"extends", new Path(deltaFile.getName()).removeFileExtension().lastSegment()};
                importSequencesToSearch.add(new Sequence(tokens));
                otherTemplates.remove(deltaFile);
            }
            ++i;
        }
        List<IFile> otherTemplatesToBuild = this.getOtherTemplatesToBuild(otherTemplates, importSequencesToSearch);
        while (otherTemplatesToBuild.size() > 0) {
            int i2 = 0;
            while (i2 < otherTemplatesToBuild.size()) {
                IFile otherTemplateToBuild = otherTemplatesToBuild.get(i2);
                otherTemplates.remove(otherTemplateToBuild);
                if (!deltaFiles.contains(otherTemplateToBuild)) {
                    deltaFiles.add(otherTemplateToBuild);
                    String[] tokens = new String[]{"[", "import", new Path(otherTemplateToBuild.getName()).removeFileExtension().lastSegment()};
                    importSequencesToSearch.add(new Sequence(tokens));
                    tokens = new String[]{"extends", new Path(otherTemplateToBuild.getName()).removeFileExtension().lastSegment()};
                    importSequencesToSearch.add(new Sequence(tokens));
                }
                ++i2;
            }
            otherTemplatesToBuild = this.getOtherTemplatesToBuild(otherTemplates, importSequencesToSearch);
        }
    }

    private List<IFile> getOtherTemplatesToBuild(List<IFile> otherTemplates, List<Sequence> importSequencesToSearch) {
        AcceleoProject acceleoProject = new AcceleoProject(this.getProject());
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < otherTemplates.size()) {
            IFile otherTemplate = otherTemplates.get(i);
            IPath outputPath = acceleoProject.getOutputFilePath(otherTemplate);
            if (outputPath != null && !this.getProject().getFile(outputPath.removeFirstSegments(1)).exists()) {
                result.add(otherTemplate);
            } else {
                StringBuffer otherTemplateContent = FileContent.getFileContent((File)otherTemplate.getLocation().toFile());
                int j = 0;
                while (j < importSequencesToSearch.size()) {
                    Sequence importSequence = importSequencesToSearch.get(j);
                    if (importSequence.search(otherTemplateContent).b() > -1) {
                        result.add(otherTemplate);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        ArrayList<IFile> filesOutput = new ArrayList<IFile>();
        this.members(filesOutput, (IContainer)this.getProject());
        if (filesOutput.size() > 0) {
            IFile[] files = filesOutput.toArray(new IFile[filesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.getProject(), files, true);
            compileOperation.run(monitor);
        }
    }

    private void deltaMembers(List<IFile> deltaFilesOutput, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                if (delta.getKind() == 2 && "mtl".equals(resource.getFileExtension())) {
                    this.removeOutputFile((IFile)resource, monitor);
                }
                if (delta.getKind() != 2 && ("mtl".equals(resource.getFileExtension()) || "MANIFEST.MF".equals(resource.getName()))) {
                    deltaFilesOutput.add((IFile)resource);
                }
            } else if (this.outputFolder == null || !this.outputFolder.isPrefixOf(resource.getFullPath())) {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.deltaMembers(deltaFilesOutput, children[i], monitor);
                    ++i;
                }
            }
        }
    }

    private void removeOutputFile(IFile inputFile, IProgressMonitor monitor) throws CoreException {
        AcceleoProject acceleoProject = new AcceleoProject(this.getProject());
        IPath outputPath = acceleoProject.getOutputFilePath(inputFile);
        IResource outputFile = ResourcesPlugin.getWorkspace().getRoot().findMember(outputPath);
        if (outputFile instanceof IFile && outputFile.isAccessible()) {
            outputFile.delete(true, monitor);
        }
    }

    private void members(List<IFile> filesOutput, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    filesOutput.add((IFile)resource);
                } else if (resource instanceof IContainer && (this.outputFolder == null || !this.outputFolder.isPrefixOf(resource.getFullPath()))) {
                    this.members(filesOutput, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    private IPath getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder.getFullPath();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }
}

