/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.IAcceleoParserProblemsConstants;
import org.eclipse.acceleo.internal.parser.cst.CSTParserBlock;
import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.ParserUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.acceleo.parser.cst.VisibilityKind;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSTParser {
    private static final String MISSING_CHARACTER_KEY = "Parser.MissingCharacter";
    private static final String INVALID_STMT_HEADER = "CSTParser.InvalidStatementHeader";
    private static final String INVALID_STMT = "CSTParser.InvalidStatement";
    protected final AcceleoSourceBuffer source;
    protected final SequenceBlock pLiteral;
    protected final SequenceBlock pComment;
    protected final SequenceBlock pParenthesis;
    protected final SequenceBlock pBrackets;
    protected final Sequence pComma;
    protected final Sequence pSemicolon;
    protected final Sequence pPipe;
    protected final Sequence pGuard;
    protected final SequenceBlock pModule;
    protected final SequenceBlock pImport;
    protected final SequenceBlock pTemplate;
    protected final SequenceBlock pMacro;
    protected final SequenceBlock pQuery;
    protected final CSTParserBlock pBlock;

    public CSTParser(AcceleoSourceBuffer source) {
        this.source = source;
        Sequence literalEscape = new Sequence("\\'");
        this.pLiteral = new SequenceBlock(new Sequence("'"), new Sequence("'"), literalEscape, false, null);
        this.pComment = ParserUtils.createAcceleoSequenceBlock(false, "comment", false, null, null);
        this.pParenthesis = new SequenceBlock(new Sequence("("), new Sequence(")"), null, true, new SequenceBlock[]{this.pLiteral});
        this.pBrackets = new SequenceBlock(new Sequence("{"), new Sequence("}"), null, true, new SequenceBlock[]{this.pLiteral});
        this.pComma = new Sequence(",");
        this.pSemicolon = new Sequence(";");
        this.pPipe = new Sequence("|");
        this.pGuard = new Sequence("?");
        this.pModule = ParserUtils.createAcceleoSequenceBlock(true, "module", false, new SequenceBlock[]{this.pLiteral}, null);
        this.pImport = ParserUtils.createAcceleoSequenceBlock(true, "import", false, new SequenceBlock[]{this.pLiteral}, null);
        this.pTemplate = ParserUtils.createAcceleoSequenceBlock(false, "template", false, new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pMacro = ParserUtils.createAcceleoSequenceBlock(false, "macro", true, new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pQuery = ParserUtils.createAcceleoSequenceBlock(false, "query", false, new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pBlock = new CSTParserBlock(this);
    }

    public AcceleoSourceBuffer getSource() {
        return this.source;
    }

    public CSTParserBlock getPBlock() {
        return this.pBlock;
    }

    protected void setPositions(CSTNode eCSTNode, int posBegin, int posEnd) {
        if (eCSTNode instanceof TextExpression || eCSTNode instanceof Block) {
            eCSTNode.setStartPosition(posBegin);
            eCSTNode.setEndPosition(posEnd);
        } else {
            int[] pos = this.source.trim(posBegin, posEnd);
            if (pos[0] == pos[1] && posBegin != posEnd) {
                eCSTNode.setStartPosition(posBegin);
                eCSTNode.setEndPosition(posEnd);
            } else {
                eCSTNode.setStartPosition(pos[0]);
                eCSTNode.setEndPosition(pos[1]);
            }
        }
    }

    public Module parse() {
        if (this.source.getBuffer() == null || this.source.getBuffer().length() == 0) {
            this.log(AcceleoParserMessages.getString("CSTParser.EmptyBuffer"), 0, -1);
        } else {
            Region bH = this.pModule.searchBeginHeader(this.source.getBuffer(), 0, this.source.getBuffer().length());
            if (bH.b() == -1) {
                this.log(AcceleoParserMessages.getString("CSTParser.MissingModule"), 0, -1);
            } else {
                Region eH = this.pModule.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, this.source.getBuffer().length());
                if (eH.b() == -1) {
                    this.log(AcceleoParserMessages.getString("CSTParser.MissingModuleEnd"), bH.b(), bH.e());
                } else {
                    Module eModule = CstFactory.eINSTANCE.createModule();
                    this.setPositions(eModule, bH.b(), this.source.getBuffer().length());
                    this.parseModuleHeader(bH.e(), eH.b(), eModule);
                    this.parseModuleBody(eH.e(), this.source.getBuffer().length(), eModule);
                    return eModule;
                }
            }
        }
        return null;
    }

    public void parseModuleHeader(int posBegin, int posEnd, Module eModule) {
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
        if (bH.b() == -1) {
            this.log(AcceleoParserMessages.getString("CSTParser.MissingMetamodel"), posBegin, posEnd);
            String name = this.source.getBuffer().substring(posBegin, posEnd).trim();
            eModule.setName(name);
            if (this.source.getFile() != null && !this.checkModuleDefinition(name, this.source.getFile())) {
                this.log(AcceleoParserMessages.getString("CSTParser.InvalidModuleDefinition", name), posBegin, posEnd);
            }
        } else {
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                this.parseModuleHeaderTypedModels(bH.e(), eH.b(), eModule);
                int eExtend = this.parseModuleHeaderExtends(eH.e(), posEnd, eModule);
                if (this.source.getBuffer().substring(eExtend, posEnd).trim().length() > 0) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, eExtend, posEnd);
                }
            }
            String name = this.source.getBuffer().substring(posBegin, bH.b()).trim();
            eModule.setName(name);
            if (this.source.getFile() != null && !this.checkModuleDefinition(name, this.source.getFile())) {
                this.log(AcceleoParserMessages.getString("CSTParser.InvalidModuleDefinition", name), posBegin, bH.b());
            }
        }
    }

    private boolean checkModuleDefinition(String name, File file) {
        StringTokenizer st = new StringTokenizer(String.valueOf(name) + "." + "mtl", "::");
        String[] segments = new String[st.countTokens()];
        int i = 0;
        while (i < segments.length) {
            segments[i] = st.nextToken();
            ++i;
        }
        boolean result = true;
        File current = file;
        int i2 = segments.length - 1;
        while (result && i2 >= 0) {
            if (current == null || current.getName() == null || !current.getName().equals(segments[i2])) {
                result = false;
            } else {
                current = current.getParentFile();
            }
            --i2;
        }
        return result;
    }

    private void parseModuleHeaderTypedModels(int posBegin, int posEnd, Module eModule) {
        int currentPos = posBegin;
        while (currentPos != posEnd) {
            Region comma = this.pComma.search(this.source.getBuffer(), currentPos, posEnd, null, new SequenceBlock[]{this.pLiteral});
            TypedModel typedModel = CstFactory.eINSTANCE.createTypedModel();
            int e = comma.b() == -1 ? posEnd : comma.b();
            this.setPositions(typedModel, currentPos, e);
            String ePackageKey = this.source.getBuffer().substring(currentPos, e).trim();
            EPackage ePackage = ModelUtils.getEPackage((String)ePackageKey);
            if (ePackage == null && ePackageKey.startsWith("'") && ePackageKey.endsWith("'") && (ePackage = ModelUtils.getEPackage((String)(ePackageKey = ePackageKey.substring("'".length(), ePackageKey.length() - "'".length())))) == null) {
                try {
                    ePackageKey = this.registerEcore(ePackageKey);
                }
                catch (WrappedException wrappedException) {
                    ePackage = null;
                }
                ePackage = ModelUtils.getEPackage((String)ePackageKey);
                if (ePackage == null) {
                    this.log(AcceleoParserMessages.getString("CSTParser.MetamodelNotFound"), currentPos, e);
                }
            }
            currentPos = comma.b() == -1 ? posEnd : comma.e();
            if (ePackage != null) {
                typedModel.getTakesTypesFrom().add((Object)ePackage);
                typedModel.getTakesTypesFrom().addAll(this.getAllSubpackages(ePackage));
            }
            eModule.getInput().add((Object)typedModel);
        }
    }

    private String registerEcore(String pathName) {
        EObject eObject;
        if (pathName != null && pathName.endsWith(".ecore")) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI metaURI = URI.createURI((String)pathName, (boolean)false);
            try {
                eObject = ModelUtils.load((URI)metaURI, (ResourceSet)resourceSet);
            }
            catch (IOException iOException) {
                eObject = null;
            }
            catch (WrappedException wrappedException) {
                eObject = null;
            }
            if (!(eObject instanceof EPackage)) {
                resourceSet = new ResourceSetImpl();
                metaURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
                try {
                    eObject = ModelUtils.load((URI)metaURI, (ResourceSet)resourceSet);
                }
                catch (IOException iOException) {
                    eObject = null;
                }
                catch (WrappedException wrappedException) {
                    eObject = null;
                }
                if (!(eObject instanceof EPackage)) {
                    resourceSet = new ResourceSetImpl();
                    metaURI = URI.createPlatformPluginURI((String)pathName, (boolean)false);
                    try {
                        eObject = ModelUtils.load((URI)metaURI, (ResourceSet)resourceSet);
                    }
                    catch (IOException iOException) {
                        eObject = null;
                    }
                    catch (WrappedException wrappedException) {
                        eObject = null;
                    }
                }
            }
        } else {
            eObject = null;
        }
        if (eObject instanceof EPackage) {
            EPackage ePackage = (EPackage)eObject;
            this.registerEcorePackageHierarchy(ePackage);
            return ePackage.getNsURI();
        }
        return pathName;
    }

    private void registerEcorePackageHierarchy(EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            ePackage.getEFactoryInstance().create((EClass)eClassifier);
            break;
        }
        if (ePackage.getESuperPackage() == null && ePackage.eResource() != null) {
            ePackage.eResource().setURI(URI.createURI((String)ePackage.getNsURI()));
        }
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.registerEcorePackageHierarchy(subPackage);
        }
    }

    private int parseModuleHeaderExtends(int posBegin, int posEnd, Module eModule) {
        int bExtend = ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "extends", true);
        if (bExtend != posBegin) {
            while (bExtend != posEnd) {
                ModuleExtendsValue eModuleExtendsValue;
                Region comma = this.pComma.search(this.source.getBuffer(), bExtend, posEnd, null, new SequenceBlock[]{this.pLiteral});
                if (comma.b() == -1) {
                    eModuleExtendsValue = CstFactory.eINSTANCE.createModuleExtendsValue();
                    this.setPositions(eModuleExtendsValue, bExtend, posEnd);
                    eModuleExtendsValue.setName(this.source.getBuffer().substring(bExtend, posEnd).trim());
                    eModule.getExtends().add((Object)eModuleExtendsValue);
                    bExtend = posEnd;
                    continue;
                }
                eModuleExtendsValue = CstFactory.eINSTANCE.createModuleExtendsValue();
                this.setPositions(eModuleExtendsValue, bExtend, comma.b());
                eModuleExtendsValue.setName(this.source.getBuffer().substring(bExtend, comma.b()).trim());
                eModule.getExtends().add((Object)eModuleExtendsValue);
                bExtend = comma.e();
            }
        }
        return bExtend;
    }

    private Collection<EPackage> getAllSubpackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage eSubpackage : ePackage.getESubpackages()) {
            result.add(eSubpackage);
            result.addAll(this.getAllSubpackages(eSubpackage));
        }
        return result;
    }

    public void parseModuleBody(int posBegin, int posEnd, Module eModule) {
        int currentPosBegin = posBegin;
        ISequence[] pModuleElements = new SequenceBlock[]{this.pComment, this.pImport, this.pTemplate, this.pMacro, this.pQuery};
        Region[] positions = Region.createPositions(pModuleElements.length);
        while (currentPosBegin > -1 && currentPosBegin < posEnd) {
            int i = ParserUtils.getNextSequence(this.source.getBuffer(), currentPosBegin, posEnd, pModuleElements, positions);
            if (i == -1) {
                if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                    this.log(AcceleoParserMessages.getString("CSTParser.InvalidModel"), currentPosBegin, posEnd);
                }
                currentPosBegin = -1;
                continue;
            }
            ISequence pModuleElement = pModuleElements[i];
            Region bH = positions[i];
            if (this.source.getBuffer().substring(currentPosBegin, bH.b()).trim().length() > 0) {
                this.log(AcceleoParserMessages.getString("CSTParser.InvalidModuleElement"), currentPosBegin, bH.b());
            }
            currentPosBegin = pModuleElement == this.pComment ? this.parseCommentEnding(bH, posEnd, eModule) : (pModuleElement == this.pImport ? this.parseImportEnding(bH, posEnd, eModule) : (pModuleElement == this.pTemplate ? this.parseTemplateEnding(bH, posEnd, eModule) : (pModuleElement == this.pMacro ? this.parseMacroEnding(bH, posEnd, eModule) : (pModuleElement == this.pQuery ? this.parseQueryEnding(bH, posEnd, eModule) : -1))));
        }
    }

    private int parseCommentEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pComment.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "comment"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pComment.getEndHeaderBody()) {
            Comment eComment = CstFactory.eINSTANCE.createComment();
            this.setPositions(eComment, beginHeader.b(), eH.e());
            eComment.setBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            eModule.getOwnedModuleElement().add((Object)eComment);
            posBegin = eH.e();
        } else {
            Region eB = this.pComment.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_STMT, "comment"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                Comment eComment = CstFactory.eINSTANCE.createComment();
                this.setPositions(eComment, beginHeader.b(), eB.e());
                eComment.setBody(this.source.getBuffer().substring(eH.e(), eB.b()));
                eModule.getOwnedModuleElement().add((Object)eComment);
                posBegin = eB.e();
            }
        }
        return posBegin;
    }

    private int parseImportEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pImport.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "import"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else {
            ModuleImportsValue eModuleImportsValue = CstFactory.eINSTANCE.createModuleImportsValue();
            this.setPositions(eModuleImportsValue, beginHeader.e(), eH.b());
            eModuleImportsValue.setName(this.source.getBuffer().substring(beginHeader.e(), eH.b()).trim());
            eModule.getImports().add((Object)eModuleImportsValue);
            posBegin = eH.e();
        }
        return posBegin;
    }

    private int parseTemplateEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pTemplate.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "template"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pTemplate.getEndHeaderBody()) {
            posBegin = eH.e();
            Template eTemplate = CstFactory.eINSTANCE.createTemplate();
            this.setPositions(eTemplate, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eTemplate);
            this.parseTemplateHeader(beginHeader.e(), eH.b(), eTemplate);
        } else {
            Region eB = this.pTemplate.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_STMT, "template"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                Template eTemplate = CstFactory.eINSTANCE.createTemplate();
                this.setPositions(eTemplate, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eTemplate);
                this.parseTemplateHeader(beginHeader.e(), eH.b(), eTemplate);
                this.parseTemplateBody(eH.e(), eB.b(), eTemplate);
            }
        }
        return posBegin;
    }

    private int parseMacroEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pMacro.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "macro"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pMacro.getEndHeaderBody()) {
            posBegin = eH.e();
            Macro eMacro = CstFactory.eINSTANCE.createMacro();
            this.setPositions(eMacro, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eMacro);
            this.parseMacroHeader(beginHeader.e(), eH.b(), eMacro);
        } else {
            Region eB = this.pMacro.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_STMT, "macro"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                Macro eMacro = CstFactory.eINSTANCE.createMacro();
                this.setPositions(eMacro, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eMacro);
                this.parseMacroHeader(beginHeader.e(), eH.b(), eMacro);
                this.parseMacroBody(eH.e(), eB.b(), eMacro);
            }
        }
        return posBegin;
    }

    private int parseQueryEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pQuery.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "query"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pQuery.getEndHeaderBody()) {
            posBegin = eH.e();
            Query eQuery = CstFactory.eINSTANCE.createQuery();
            this.setPositions(eQuery, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eQuery);
            this.parseQueryHeader(beginHeader.e(), eH.b(), eQuery);
        } else {
            Region eB = this.pQuery.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString("CSTParser.InvalidQuery"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                this.log(AcceleoParserMessages.getString("CSTParser.InvalidQuery"), beginHeader.b(), eB.e());
                posBegin = eB.e();
                Query eQuery = CstFactory.eINSTANCE.createQuery();
                this.setPositions(eQuery, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eQuery);
                this.parseQueryHeader(beginHeader.e(), eH.b(), eQuery);
            }
        }
        return posBegin;
    }

    public void parseTemplateHeader(int posBegin, int posEnd, Template eTemplate) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eTemplate);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            eTemplate.setName(name);
        } else {
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            eTemplate.setName(name);
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                Module eModule = this.getModule(eTemplate);
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b(), eModule);
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eTemplate.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int currentPosEnd = this.parseTemplateHeaderIndexOfGuardOrBrackets(currentPosBegin, posEnd);
                currentPosBegin = this.parseTemplateHeaderOverrides(currentPosBegin, currentPosEnd, eTemplate);
                currentPosEnd = posEnd;
                currentPosBegin = this.parseTemplateHeaderGuard(currentPosBegin, currentPosEnd, posEnd, eTemplate);
                currentPosBegin = this.shiftInitSectionBody(currentPosBegin, currentPosEnd, eTemplate);
                if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, currentPosBegin, posEnd);
                }
            }
        }
    }

    private int parseTemplateHeaderIndexOfGuardOrBrackets(int posBegin, int posEnd) {
        int currentPosEnd = posEnd;
        Region guard = this.pGuard.search(this.source.getBuffer(), posBegin, currentPosEnd, null, new SequenceBlock[]{this.pLiteral});
        if (guard.b() > -1) {
            currentPosEnd = guard.b();
        } else {
            Region bracket = this.pBrackets.search(this.source.getBuffer(), posBegin, currentPosEnd, null, new SequenceBlock[]{this.pLiteral});
            if (bracket.b() > -1) {
                currentPosEnd = bracket.b();
            }
        }
        return currentPosEnd;
    }

    private int parseTemplateHeaderOverrides(int posBegin, int posEnd, Template eTemplate) {
        int currentPosBegin = posBegin;
        int bOverride = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, "overrides", true);
        if (bOverride != currentPosBegin) {
            currentPosBegin = bOverride;
            while (currentPosBegin != posEnd) {
                TemplateOverridesValue eTemplateOverridesValue;
                Region comma = this.pComma.search(this.source.getBuffer(), currentPosBegin, posEnd, null, new SequenceBlock[]{this.pLiteral});
                if (comma.b() == -1) {
                    eTemplateOverridesValue = CstFactory.eINSTANCE.createTemplateOverridesValue();
                    this.setPositions(eTemplateOverridesValue, currentPosBegin, posEnd);
                    eTemplateOverridesValue.setName(this.source.getBuffer().substring(currentPosBegin, posEnd).trim());
                    eTemplate.getOverrides().add((Object)eTemplateOverridesValue);
                    currentPosBegin = posEnd;
                    continue;
                }
                eTemplateOverridesValue = CstFactory.eINSTANCE.createTemplateOverridesValue();
                this.setPositions(eTemplateOverridesValue, currentPosBegin, comma.b());
                eTemplateOverridesValue.setName(this.source.getBuffer().substring(currentPosBegin, comma.b()).trim());
                eTemplate.getOverrides().add((Object)eTemplateOverridesValue);
                currentPosBegin = comma.e();
            }
        }
        return currentPosBegin;
    }

    private int parseTemplateHeaderGuard(int posBegin, int posEnd, int headerPosEnd, Template eTemplate) {
        int currentPos = posBegin;
        int bGuard = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "?", false);
        if (bGuard != currentPos) {
            currentPos = bGuard;
            if (ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "(", false) == currentPos) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, currentPos, posEnd);
                currentPos = headerPosEnd;
            } else {
                Region bHParenthesis = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), currentPos, posEnd);
                Region eHParenthesis = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHParenthesis, posEnd);
                if (eHParenthesis.b() == -1) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bHParenthesis.b(), bHParenthesis.e());
                    currentPos = headerPosEnd;
                } else {
                    ModelExpression eGuard = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eGuard, bHParenthesis.e(), eHParenthesis.b());
                    eTemplate.setGuard(eGuard);
                    this.pBlock.parseExpressionHeader(bHParenthesis.e(), eHParenthesis.b(), eGuard);
                    currentPos = eHParenthesis.e();
                }
            }
        }
        return currentPos;
    }

    private int shiftVisibility(int posBegin, int posEnd, ModuleElement eModuleElement) {
        int b = posBegin;
        int posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "private", true);
        if (b != posShift) {
            eModuleElement.setVisibility(VisibilityKind.PRIVATE);
        } else {
            posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posShift, posEnd, "protected", true);
            if (b != posShift) {
                eModuleElement.setVisibility(VisibilityKind.PROTECTED);
            } else {
                posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posShift, posEnd, "public", true);
                if (b != posShift) {
                    eModuleElement.setVisibility(VisibilityKind.PUBLIC);
                }
            }
        }
        return posShift;
    }

    protected int shiftInitSectionBody(int posBegin, int posEnd, Block eBlock) {
        if (ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "{", false) != posBegin) {
            int posResult;
            Region bHBrackets = this.pBrackets.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
            Region eHBrackets = this.pBrackets.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHBrackets, posEnd);
            if (eHBrackets.b() == -1) {
                this.log(AcceleoParserMessages.getString("CSTParser.MissingClosingBracket"), bHBrackets.b(), bHBrackets.e());
                posResult = posEnd;
            } else {
                InitSection eInitSection = CstFactory.eINSTANCE.createInitSection();
                this.setPositions(eInitSection, bHBrackets.b(), eHBrackets.e());
                eBlock.setInit(eInitSection);
                boolean semicolonFound = this.shiftInitSectionBodyCreatesVariables(bHBrackets.e(), eHBrackets.b(), eInitSection);
                if (!semicolonFound) {
                    this.log(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ";"), bHBrackets.e(), eHBrackets.b());
                }
                posResult = eHBrackets.e();
            }
            return posResult;
        }
        return posBegin;
    }

    private boolean shiftInitSectionBodyCreatesVariables(int posBegin, int posEnd, InitSection eInitSection) {
        List<Region> positions = this.pSemicolon.split(this.source.getBuffer(), posBegin, posEnd, true, null, null);
        Module eModule = this.getModule(eInitSection);
        boolean semicolonFound = false;
        int i = 0;
        while (i < positions.size()) {
            Variable eVariable;
            Region variablePos = positions.get(i);
            String text = this.source.getBuffer().substring(variablePos.b(), variablePos.e()).trim();
            if (text.equals(";")) {
                if (!semicolonFound) {
                    semicolonFound = true;
                }
            } else if (text.length() > 0 && (eVariable = this.createVariable(variablePos.b(), variablePos.e(), eModule)) != null) {
                eInitSection.getVariable().add((Object)eVariable);
            }
            ++i;
        }
        return semicolonFound;
    }

    protected Variable[] createVariablesCommaSeparator(int posBegin, int posEnd, Module eModule) {
        List<Region> positions = this.pComma.split(this.source.getBuffer(), posBegin, posEnd, false, null, null);
        Variable[] eVariables = new Variable[positions.size()];
        ArrayList<String> variableNames = new ArrayList<String>();
        int i = 0;
        while (i < eVariables.length) {
            Variable eVariable;
            Region variablePos = positions.get(i);
            eVariables[i] = eVariable = this.createVariable(variablePos.b(), variablePos.e(), eModule);
            if (eVariable != null) {
                if (!variableNames.contains(eVariable.getName())) {
                    variableNames.add(eVariable.getName());
                } else {
                    this.log(AcceleoParserMessages.getString("CSTParser.DuplicatedVariable", eVariable.getName()), variablePos.b(), variablePos.e());
                }
            }
            ++i;
        }
        return eVariables;
    }

    public Variable createVariable(int posBegin, int posEnd, Module eModule) {
        Variable eVariable;
        String variableBuffer = this.source.getBuffer().substring(posBegin, posEnd);
        int bDot = variableBuffer.indexOf(":");
        if (bDot == -1) {
            this.log(AcceleoParserMessages.getString("CSTParser.InvalidVariable", variableBuffer.trim()), posBegin, posEnd);
            eVariable = null;
        } else {
            String name = variableBuffer.substring(0, bDot);
            String type = variableBuffer.substring(bDot + ":".length());
            eVariable = CstFactory.eINSTANCE.createVariable();
            this.setPositions(eVariable, posBegin, posEnd);
            int bInit = variableBuffer.indexOf("=", bDot + ":".length());
            if (bInit != -1) {
                type = variableBuffer.substring(bDot + ":".length(), bInit);
                String initExpression = variableBuffer.substring(bInit + "=".length());
                ModelExpression eInitExpression = CstFactory.eINSTANCE.createModelExpression();
                this.setPositions(eInitExpression, posBegin + bInit + "=".length(), posEnd);
                eVariable.setInitExpression(eInitExpression);
                eInitExpression.setBody(initExpression);
                this.pBlock.parseExpressionHeader(posBegin + bInit + "=".length(), posEnd, eInitExpression);
            }
            eVariable.setName(name.trim());
            eVariable.setType(type.trim());
        }
        return eVariable;
    }

    protected Module getModule(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof Module) {
                return (Module)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public void parseTemplateBody(int posBegin, int posEnd, Template eTemplate) {
        this.pBlock.parse(posBegin, posEnd, eTemplate);
    }

    public void parseQueryHeader(int posBegin, int posEnd, Query eQuery) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eQuery);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            eQuery.setName(name);
        } else {
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            eQuery.setName(name);
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                String bodyText;
                int bInit;
                Module eModule = this.getModule(eQuery);
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b(), eModule);
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eQuery.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int eDot = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, ":", false);
                if (eDot == currentPosBegin) {
                    this.log(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ":"), currentPosBegin, posEnd);
                }
                if ((bInit = (bodyText = this.source.getBuffer().substring(eDot, posEnd)).indexOf("=")) != -1) {
                    String type = bodyText.substring(0, bInit).trim();
                    eQuery.setType(type);
                    String initExpression = bodyText.substring(bInit + "=".length());
                    ModelExpression eExpression = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eExpression, eDot + bInit + "=".length(), posEnd);
                    eQuery.setExpression(eExpression);
                    eExpression.setBody(initExpression);
                    this.pBlock.parseExpressionHeader(eDot + bInit + "=".length(), posEnd, eExpression);
                } else {
                    this.log(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, "="), currentPosBegin, posEnd);
                }
            }
        }
    }

    public void parseMacroHeader(int posBegin, int posEnd, Macro eMacro) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eMacro);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            eMacro.setName(name);
        } else {
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.log(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            eMacro.setName(name);
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                Module eModule = this.getModule(eMacro);
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b(), eModule);
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eMacro.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int eDot = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, ":", false);
                if (eDot == currentPosBegin) {
                    this.log(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ":"), currentPosBegin, posEnd);
                }
                String type = this.source.getBuffer().substring(eDot, posEnd).trim();
                eMacro.setType(type);
            }
        }
    }

    public void parseMacroBody(int posBegin, int posEnd, Macro eMacro) {
        this.pBlock.parse(posBegin, posEnd, eMacro);
    }

    private void log(String message, int posBegin, int posEnd) {
        this.source.log(message, posBegin, posEnd);
    }
}

