/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AbstractAcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEngine
implements IAcceleoEngine {
    protected final Properties customProperties = new Properties();
    protected final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>();
    protected final Map<File, Properties> loadedProperties = new LinkedHashMap<File, Properties>();
    private OCL ocl;

    @Override
    public void addListener(IAcceleoTextGenerationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addProperties(File propertiesHolder) throws IOException {
        Properties property = new Properties();
        FileInputStream stream = new FileInputStream(propertiesHolder);
        try {
            property.load(stream);
        }
        finally {
            ((InputStream)stream).close();
        }
        property.put("properties.holder.file.name", propertiesHolder.getName());
        this.loadedProperties.put(propertiesHolder, property);
    }

    @Override
    public void addProperties(Map<String, String> customProps) {
        this.customProperties.putAll(customProps);
    }

    @Override
    public Map<String, String> evaluate(Template template, List<? extends Object> arguments, File generationRoot, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        if (template == null || arguments == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEngine.NullArguments"));
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != arguments.size()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalArguments"));
        }
        AbstractAcceleoEnvironmentFactory factory = this.createEnvironmentFactory(generationRoot, (Module)template.eContainer(), strategy, monitor);
        this.ocl = OCL.newInstance((EnvironmentFactory)factory);
        try {
            this.doEvaluate(template, arguments);
        }
        catch (AcceleoEvaluationCancelledException acceleoEvaluationCancelledException) {}
        factory.hookGenerationEnd();
        Map<String, String> result = Collections.emptyMap();
        if (strategy.willReturnPreview()) {
            result = factory.getEvaluationPreview();
        }
        factory.dispose();
        return result;
    }

    @Override
    public void removeCustomProperties(Set<String> customPropertyKeys) {
        for (String key : customPropertyKeys) {
            this.customProperties.remove(key);
        }
    }

    @Override
    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeProperties(File propertiesHolder) {
        this.loadedProperties.remove(propertiesHolder);
    }

    @Override
    public void reset() {
        this.listeners.clear();
        this.loadedProperties.clear();
        this.customProperties.clear();
    }

    protected AbstractAcceleoEnvironmentFactory createEnvironmentFactory(File generationRoot, Module rootModule, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        ArrayList<IAcceleoTextGenerationListener> listenersCopy = new ArrayList<IAcceleoTextGenerationListener>(this.listeners);
        ArrayList<Properties> propertiesCopy = new ArrayList<Properties>(this.loadedProperties.values());
        propertiesCopy.add(0, this.customProperties);
        return new AcceleoEnvironmentFactory(generationRoot, rootModule, listenersCopy, propertiesCopy, strategy, monitor);
    }

    private void doEvaluate(Template template, List<? extends Object> arguments) {
        Object value;
        Variable param;
        int i;
        boolean guardValue = true;
        if (template.getGuard() != null) {
            OCL.Query guard = this.ocl.createQuery((OCLExpression)template.getGuard());
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", template.getName()));
                }
                guard.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    guard.getEvaluationEnvironment().add("self", value);
                    guard.getEvaluationEnvironment().add("context0", value);
                }
                ++i;
            }
            guardValue = (Boolean)guard.evaluate();
        }
        if (guardValue) {
            OCL.Query query = this.ocl.createQuery((OCLExpression)template);
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", template.getName()));
                }
                query.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    query.getEvaluationEnvironment().add("self", value);
                    query.getEvaluationEnvironment().add("context0", value);
                }
                ++i;
            }
            query.evaluate();
        }
    }
}

