/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoEvaluationContext {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String JMERGE_TAG = "@generated";
    protected final Map<String, Writer> generationPreview = new HashMap<String, Writer>();
    private final File generationRoot;
    private boolean hasJMergeTag;
    private final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>(3);
    private final Monitor progressMonitor;
    private final IAcceleoGenerationStrategy strategy;
    private final Map<Writer, Map<String, String>> userCodeBlocks = new HashMap<Writer, Map<String, String>>();
    private final LinkedList<Writer> writers = new LinkedList();

    public AcceleoEvaluationContext(File root, List<IAcceleoTextGenerationListener> listeners, IAcceleoGenerationStrategy generationStrategy, Monitor monitor) {
        this.generationRoot = root;
        this.strategy = generationStrategy;
        this.listeners.addAll(listeners);
        this.progressMonitor = monitor != null ? monitor : new BasicMonitor();
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) throws AcceleoEvaluationException {
        try {
            Writer currentWriter = this.writers.getLast();
            currentWriter.append(string);
            if (fireEvent) {
                this.fireTextGenerated(new AcceleoTextGenerationEvent(string, sourceBlock, source));
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.AppendError"), e);
        }
    }

    public void awaitCompletion() throws InterruptedException {
        this.strategy.awaitCompletion();
    }

    public String closeContext() throws AcceleoEvaluationException {
        Writer last = this.writers.removeLast();
        try {
            String result;
            if (last instanceof AbstractAcceleoWriter) {
                Map<String, StringWriter> lostFiles;
                String filePath = ((AbstractAcceleoWriter)last).getTargetPath();
                Map<String, String> lostCode = this.userCodeBlocks.get(last);
                if (lostCode.size() > 0 && (lostFiles = this.strategy.createLostFile(filePath, lostCode)) != null) {
                    for (Map.Entry<String, StringWriter> lostFile : lostFiles.entrySet()) {
                        this.generationPreview.put(lostFile.getKey(), lostFile.getValue());
                    }
                }
                this.strategy.flushWriter(filePath, last);
                result = "";
            } else if (last instanceof OutputStreamWriter) {
                last.close();
                result = "";
            } else {
                result = last.toString();
            }
            return result;
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.WriteError"), e);
        }
    }

    public void dispose() throws AcceleoEvaluationException {
        AcceleoEvaluationException exception = null;
        try {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
            try {
                for (Writer writer : this.writers) {
                    writer.close();
                }
            }
            catch (IOException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
        }
        finally {
            this.generationPreview.clear();
            this.listeners.clear();
            this.userCodeBlocks.clear();
            this.writers.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public File getFileFor(String filePath) {
        File generatedFile = filePath.startsWith("file:") ? new File(filePath) : new File(this.generationRoot, filePath);
        return generatedFile;
    }

    public Map<String, String> getGenerationPreview() {
        return new HashMap<String, String>(this.strategy.preparePreview(this.generationPreview));
    }

    public Monitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public String getProtectedAreaContent(String marker) {
        Writer writer = null;
        int i = this.writers.size() - 1;
        while (i >= 0) {
            writer = this.writers.get(i);
            if (writer instanceof AbstractAcceleoWriter) break;
            writer = null;
            --i;
        }
        Map<String, String> areas = this.userCodeBlocks.get(writer);
        if (areas != null) {
            return areas.remove(marker);
        }
        return null;
    }

    public void hookGenerationEnd() {
        HashMap<String, Map<String, String>> lostCode = new HashMap<String, Map<String, String>>();
        for (Map.Entry<Writer, Map<String, String>> entry : this.userCodeBlocks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            String filePath = ((AbstractAcceleoWriter)entry.getKey()).getTargetPath();
            lostCode.put(filePath, entry.getValue());
        }
        if (!lostCode.isEmpty()) {
            this.strategy.createLostFiles(lostCode);
        }
        try {
            this.strategy.flushWriters(this.generationPreview);
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.WriteError"), e);
        }
    }

    public void openNested() throws AcceleoEvaluationException {
        try {
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add(new StringWriter(1024));
    }

    public void openNested(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        this.fireFilePathComputed(new AcceleoTextGenerationEvent(generatedFile.getPath(), fileBlock, source));
        try {
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
            HashMap<String, String> savedCodeBlocks = new HashMap<String, String>();
            if (generatedFile.exists()) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(generatedFile));
            }
            if (this.generationPreview.containsKey(generatedFile.getPath())) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(this.generationPreview.get(generatedFile.getPath()).toString()));
            }
            AbstractAcceleoWriter writer = charset != null ? this.strategy.createWriterFor(generatedFile, (AbstractAcceleoWriter)this.generationPreview.get(generatedFile.getPath()), appendMode, this.hasJMergeTag, charset) : this.strategy.createWriterFor(generatedFile, (AbstractAcceleoWriter)this.generationPreview.get(generatedFile.getPath()), appendMode, this.hasJMergeTag);
            this.generationPreview.put(generatedFile.getPath(), writer);
            this.hasJMergeTag = false;
            this.userCodeBlocks.put(writer, savedCodeBlocks);
            this.writers.add(writer);
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileCreationError", generatedFile.getPath()), e);
        }
    }

    public void openNested(OutputStream stream) {
        try {
            if (this.writers.size() > 0) {
                this.writers.getLast().flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add(new OutputStreamWriter(new AcceleoFilterOutputStream(stream)));
    }

    public void openNested(String filePath, Block fileBlock, EObject source, boolean appendMode) throws AcceleoEvaluationException {
        this.openNested(this.getFileFor(filePath), fileBlock, source, appendMode, null);
    }

    private void fireFilePathComputed(AcceleoTextGenerationEvent event) {
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.filePathComputed(event);
        }
    }

    private void fireTextGenerated(AcceleoTextGenerationEvent event) {
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.textGenerated(event);
        }
    }

    private Map<String, String> internalSaveProtectedAreas(BufferedReader reader) throws IOException {
        HashMap<String, String> protectedAreas = new HashMap<String, String>();
        String usercodeStart = AcceleoEngineMessages.getString("usercode.start");
        String usercodeEnd = AcceleoEngineMessages.getString("usercode.end");
        String line = reader.readLine();
        while (line != null) {
            if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                this.hasJMergeTag = true;
            }
            if (line.contains(usercodeStart)) {
                String previous;
                String marker = line.substring(line.indexOf(usercodeStart) + usercodeStart.length()).trim();
                StringBuffer areaContent = new StringBuffer(1024);
                if (line.indexOf(usercodeStart) - LINE_SEPARATOR.length() > 0 && LINE_SEPARATOR.equals(previous = line.substring(line.indexOf(usercodeStart) - LINE_SEPARATOR.length(), line.indexOf(usercodeStart)))) {
                    areaContent.append(LINE_SEPARATOR);
                }
                areaContent.append(line.substring(line.indexOf(usercodeStart)));
                line = reader.readLine();
                while (line != null) {
                    areaContent.append(LINE_SEPARATOR);
                    if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                        this.hasJMergeTag = true;
                    }
                    if (line.contains(usercodeEnd)) {
                        int endOffset = line.indexOf(usercodeEnd) + usercodeEnd.length();
                        areaContent.append(line.substring(0, endOffset));
                        if (endOffset + LINE_SEPARATOR.length() > line.length() || !LINE_SEPARATOR.equals(line.substring(endOffset, endOffset + LINE_SEPARATOR.length()))) break;
                        areaContent.append(LINE_SEPARATOR);
                        break;
                    }
                    areaContent.append(line);
                    line = reader.readLine();
                }
                protectedAreas.put(marker, areaContent.toString());
            }
            line = reader.readLine();
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(File file) throws IOException {
        Map<String, String> protectedAreas = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                protectedAreas = this.internalSaveProtectedAreas(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(String buffer) {
        Map<String, String> protectedAreas;
        block14: {
            protectedAreas = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new StringReader(buffer));
                    protectedAreas = this.internalSaveProtectedAreas(reader);
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return protectedAreas;
    }

    private final class AcceleoFilterOutputStream
    extends FilterOutputStream {
        public AcceleoFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {}
            if (this.out != System.out) {
                this.out.close();
            }
        }
    }
}

