/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoDeltaVisitor;
import org.eclipse.acceleo.common.internal.utils.workspace.WorkspaceClassInstance;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoWorkspaceUtil {
    public static final AcceleoWorkspaceUtil INSTANCE = new AcceleoWorkspaceUtil();
    private static final String UNINSTALLATION_FAILURE_KEY = "WorkspaceUtil.UninstallationFailure";
    final Set<IPluginModelBase> changedContributions = new LinkedHashSet<IPluginModelBase>();
    final Map<IPluginModelBase, Bundle> workspaceInstalledBundles = new HashMap<IPluginModelBase, Bundle>();
    final Map<String, WorkspaceClassInstance> workspaceLoadedClasses = new HashMap<String, WorkspaceClassInstance>();
    private final IResourceChangeListener workspaceListener = new WorkspaceResourcesListener();

    private AcceleoWorkspaceUtil() {
    }

    public synchronized void addWorkspaceContribution(IProject project) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null && !this.workspaceInstalledBundles.containsKey(model)) {
            this.changedContributions.add(model);
        }
    }

    public synchronized void dispose() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    public synchronized Class<?> getClass(String qualifiedName) {
        return this.getClass(qualifiedName, true);
    }

    public synchronized Class<?> getClass(String qualifiedName, boolean honorOSGiVisibility) {
        IPluginModelBase model;
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        Class<?> clazz = null;
        WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
        if (workspaceInstance != null) {
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    Object instance = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setInstance(instance);
                    clazz = instance.getClass();
                    break;
                }
            } else {
                clazz = workspaceInstance.getInstance().getClass();
            }
        }
        if (clazz != null) {
            return clazz;
        }
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            block14: {
                model = entry.getKey();
                String packageName = "";
                int end = qualifiedName.lastIndexOf(46);
                if (end != -1) {
                    packageName = qualifiedName.substring(0, end);
                }
                if (honorOSGiVisibility) {
                    boolean packageFound = false;
                    ExportPackageDescription[] exportPackageDescriptionArray = model.getBundleDescription().getExportPackages();
                    int n = exportPackageDescriptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExportPackageDescription exported = exportPackageDescriptionArray[n2];
                        if (packageName.startsWith(exported.getName())) {
                            packageFound = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!packageFound) continue;
                }
                Bundle bundle = entry.getValue();
                try {
                    clazz = bundle.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException e) {
                    if (!honorOSGiVisibility) break block14;
                    AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
                }
            }
            if (clazz != null) break;
        }
        return clazz;
    }

    public synchronized Object getClassInstance(IProject project, String qualifiedName) {
        Object instance = null;
        this.addWorkspaceContribution(project);
        this.refreshContributions();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        Bundle installedBundle = this.workspaceInstalledBundles.get(model);
        if (installedBundle != null) {
            instance = this.internalLoadClass(installedBundle, qualifiedName);
        }
        return instance;
    }

    public synchronized Object getClassInstance(String qualifiedName) {
        IPluginModelBase model;
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        Object instance = null;
        WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
        if (workspaceInstance != null) {
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    instance = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setInstance(instance);
                    break;
                }
            } else {
                instance = workspaceInstance.getInstance();
            }
        }
        if (instance != null) {
            return instance;
        }
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle;
            model = entry.getKey();
            String packageName = "";
            int end = qualifiedName.lastIndexOf(46);
            if (end != -1) {
                packageName = qualifiedName.substring(0, end);
            }
            boolean packageFound = false;
            ExportPackageDescription[] exportPackageDescriptionArray = model.getBundleDescription().getExportPackages();
            int n = exportPackageDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription exported = exportPackageDescriptionArray[n2];
                if (packageName.startsWith(exported.getName())) {
                    packageFound = true;
                    break;
                }
                ++n2;
            }
            if (packageFound && (instance = this.internalLoadClass(bundle = entry.getValue(), qualifiedName)) != null) break;
        }
        return instance;
    }

    public IProject getProject(String bundleName) {
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getBundleDescription().getSymbolicName().equals(bundleName)) {
                return model.getUnderlyingResource().getProject();
            }
            ++n2;
        }
        return null;
    }

    public IFile getWorkspaceFile(File file) {
        Path filePath;
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation.isPrefixOf((IPath)(filePath = new Path(file.getAbsolutePath())))) {
            filePath = filePath.removeFirstSegments(workspaceLocation.segmentCount());
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            return soughtIFile;
        }
        return null;
    }

    public File getWorkspaceFile(String path) throws IOException {
        File soughtFile;
        if (path.startsWith("platform:/resource/")) {
            Path relativePath = new Path(path.substring("platform:/resource/".length()));
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)relativePath);
            soughtFile = soughtIFile.getLocation().toFile();
        } else if (path.startsWith("platform:/plugin/")) {
            int bundleNameEnd = path.indexOf("/", "platform:/plugin/".length() + 1);
            String bundleName = path.substring("platform:/plugin/".length(), bundleNameEnd);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                URL bundleFileURL = bundle.getEntry(path.substring(bundleNameEnd));
                URL fileURL = FileLocator.toFileURL((URL)bundleFileURL);
                soughtFile = new File(fileURL.getFile());
            } else {
                soughtFile = null;
            }
        } else {
            Path fullPath;
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (workspaceLocation.isPrefixOf((IPath)(fullPath = new Path(path)))) {
                fullPath = fullPath.removeFirstSegments(workspaceLocation.segmentCount());
            }
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
            soughtFile = soughtIFile.getLocation().toFile();
        }
        return soughtFile;
    }

    public synchronized Set<Object> getWorkspaceInstances() {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        LinkedHashSet<Object> workspaceInstances = new LinkedHashSet<Object>();
        for (String qualifiedName : this.workspaceLoadedClasses.keySet()) {
            workspaceInstances.add(this.getClassInstance(qualifiedName));
        }
        return workspaceInstances;
    }

    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener, 23);
    }

    public synchronized void refreshContributions() {
        if (this.changedContributions.size() == 0) {
            return;
        }
        for (IPluginModelBase candidate : this.changedContributions) {
            this.installBundle(candidate);
        }
        this.changedContributions.clear();
    }

    public synchronized Object refreshInstance(String qualifiedName, boolean loadNew) {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        if (loadNew || this.workspaceLoadedClasses.containsKey(qualifiedName)) {
            return this.getClassInstance(qualifiedName);
        }
        return null;
    }

    public synchronized Set<Object> refreshInstances(Set<String> qualifiedNames, boolean loadNew) {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        LinkedHashSet<Object> workspaceInstances = new LinkedHashSet<Object>();
        for (String qualifiedName : qualifiedNames) {
            if (!loadNew && !this.workspaceLoadedClasses.containsKey(qualifiedName)) continue;
            workspaceInstances.add(this.getClassInstance(qualifiedName));
        }
        return workspaceInstances;
    }

    public synchronized void reset() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    public String resolveAsPlatformPluginResource(String filePath) {
        String actualPath = filePath;
        if (actualPath.startsWith("file:/")) {
            actualPath = actualPath.substring("file:/".length());
        }
        String[] segments = filePath.split("/");
        Bundle bundle = null;
        String bundlePath = null;
        int i = segments.length - 1;
        while (i >= 0) {
            bundle = this.isBundleID(segments[i]) ? AcceleoCommonPlugin.getDefault().getContext().getBundle(Long.valueOf(segments[i]).longValue()) : Platform.getBundle((String)segments[i]);
            if (bundle != null) {
                bundlePath = "";
                int pathStart = i + 1;
                if (!".cp".equals(segments[pathStart]) && ".cp".equals(segments[pathStart + 1])) {
                    pathStart += 2;
                }
                int j = ++pathStart;
                while (j < segments.length) {
                    bundlePath = String.valueOf(bundlePath) + '/' + segments[j];
                    ++j;
                }
                URL fileURL = bundle.getEntry(bundlePath);
                if (fileURL != null) break;
            }
            --i;
        }
        if (bundle != null && bundlePath != null && !"".equals(bundlePath)) {
            return "platform:/plugin/" + bundle.getSymbolicName() + bundlePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void refreshPackages(Bundle[] bundles) {
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin == null) return;
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            context.removeFrameworkListener(listener);
            context.ungetService(packageAdminReference);
            return;
        }
    }

    void uninstallBundle(Bundle target) throws BundleException {
        target.uninstall();
        this.refreshPackages(null);
    }

    private void checkDependencies(IPluginModelBase model) {
        IPluginModelBase workspaceModel;
        int n;
        int n2;
        IPluginModelBase[] iPluginModelBaseArray;
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return;
        }
        BundleSpecification[] bundleSpecificationArray = desc.getRequiredBundles();
        int n3 = bundleSpecificationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    this.installBundle(workspaceModel);
                    break;
                }
                ++n;
            }
            ++n4;
        }
        bundleSpecificationArray = desc.getImportPackages();
        n3 = bundleSpecificationArray.length;
        n4 = 0;
        while (n4 < n3) {
            BundleSpecification importPackage = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                int n5 = exportPackageDescriptionArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ExportPackageDescription export = exportPackageDescriptionArray[n6];
                    if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                        this.installBundle(workspaceModel);
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
    }

    private Bundle getBundle(String pluginLocation) {
        Bundle[] bundles = AcceleoCommonPlugin.getDefault().getContext().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (pluginLocation.equals(bundles[i].getLocation())) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private Set<String> getOutputFolders(IProject project) {
        LinkedHashSet<String> classpathEntries = new LinkedHashSet<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath output;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null) {
                    classpathEntries.add(output.removeFirstSegments(1).toString());
                }
                ++n2;
            }
            IPath output = javaProject.getOutputLocation();
            classpathEntries.add(output.removeFirstSegments(1).toString());
        }
        catch (JavaModelException e) {
            AcceleoCommonPlugin.log((Exception)((Object)e), false);
        }
        return classpathEntries;
    }

    private void installBundle(IPluginModelBase model) {
        try {
            IResource candidateManifest = model.getUnderlyingResource();
            String candidateLocationReference = "reference:" + URLDecoder.decode(candidateManifest.getProject().getLocationURI().toURL().toExternalForm(), System.getProperty("file.encoding"));
            Bundle bundle = this.getBundle(candidateLocationReference);
            if (bundle == null) {
                this.checkDependencies(model);
                bundle = this.installBundle(candidateLocationReference);
                IProject project = model.getUnderlyingResource().getProject();
                this.setBundleClasspath(project, bundle);
                this.workspaceInstalledBundles.put(model, bundle);
            }
            this.refreshPackages(new Bundle[]{bundle});
        }
        catch (BundleException e) {
            AcceleoCommonPlugin.log((IStatus)new Status(2, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString("WorkspaceUtil.InstallationFailure", model.getBundleDescription().getName()), (Throwable)e));
        }
        catch (MalformedURLException e) {
            AcceleoCommonPlugin.log(e, false);
        }
        catch (UnsupportedEncodingException e) {
            AcceleoCommonPlugin.log(e, false);
        }
    }

    private Bundle installBundle(String pluginLocation) throws BundleException, IllegalStateException {
        Bundle target = AcceleoCommonPlugin.getDefault().getContext().installBundle(pluginLocation);
        int state = target.getState();
        if (state != 2) {
            throw new IllegalStateException(AcceleoCommonMessages.getString("WorkspaceUtil.IllegalBundleState", target, state));
        }
        return target;
    }

    private Object internalLoadClass(Bundle bundle, String qualifiedName) {
        try {
            Object instance;
            WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
            if (workspaceInstance == null) {
                Class clazz = bundle.loadClass(qualifiedName);
                instance = clazz.newInstance();
                this.workspaceLoadedClasses.put(qualifiedName, new WorkspaceClassInstance(instance, bundle.getSymbolicName()));
            } else if (workspaceInstance.isStale()) {
                Class clazz = bundle.loadClass(qualifiedName);
                instance = clazz.newInstance();
                workspaceInstance.setStale(false);
                workspaceInstance.setInstance(instance);
            } else {
                instance = workspaceInstance.getInstance();
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        catch (InstantiationException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassInstantiationFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        catch (IllegalAccessException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassConstructorFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        return null;
    }

    private boolean isBundleID(String s) {
        if (s.length() == 0 || s.length() > 5) {
            return false;
        }
        boolean isInteger = true;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                isInteger = false;
            }
            ++n2;
        }
        return isInteger;
    }

    private void setBundleClasspath(IProject plugin, Bundle bundle) {
        Set<String> classpathEntries = this.getOutputFolders(plugin);
        if (classpathEntries.size() > 0) {
            BaseData bundleData = (BaseData)((AbstractBundle)bundle).getBundleData();
            StringBuilder classpath = new StringBuilder();
            classpath.append(bundleData.getClassPathString()).append(',');
            Iterator<String> entryIterator = classpathEntries.iterator();
            while (entryIterator.hasNext()) {
                classpath.append(entryIterator.next());
                if (!entryIterator.hasNext()) continue;
                classpath.append(',');
            }
            bundleData.setClassPathString(classpath.toString());
        }
    }

    class WorkspaceResourcesListener
    implements IResourceChangeListener {
        WorkspaceResourcesListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IProject project;
                    IPluginModelBase model;
                    if (!(event.getResource() instanceof IProject) || (model = PluginRegistry.findModel((IProject)(project = (IProject)event.getResource()))) == null) break;
                    Bundle bundle = AcceleoWorkspaceUtil.this.workspaceInstalledBundles.remove(model);
                    AcceleoWorkspaceUtil.this.changedContributions.remove(model);
                    if (bundle == null) break;
                    try {
                        AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                    }
                    catch (BundleException e) {
                        AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
                    }
                    break;
                }
                case 16: {
                    this.processBuildEvent(event);
                }
            }
        }

        private void processBuildEvent(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            switch (event.getBuildKind()) {
                case 9: {
                    if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) break;
                }
                case 10: {
                    AcceleoDeltaVisitor visitor = new AcceleoDeltaVisitor();
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), false);
                    }
                    for (IProject changed : visitor.getChangedProjects()) {
                        IPluginModelBase model = PluginRegistry.findModel((IProject)changed);
                        if (model == null) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (String changedClass : visitor.getChangedClasses()) {
                        WorkspaceClassInstance workspaceInstance = AcceleoWorkspaceUtil.this.workspaceLoadedClasses.get(changedClass);
                        if (workspaceInstance == null) continue;
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 6: {
                    for (Map.Entry<IPluginModelBase, Bundle> entry : AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet()) {
                        IPluginModelBase model = entry.getKey();
                        if (model == null) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 15: {
                    for (Map.Entry<IPluginModelBase, Bundle> entry : AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet()) {
                        Bundle bundle = entry.getValue();
                        try {
                            AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                        }
                        catch (BundleException e) {
                            AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
                        }
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
            }
        }
    }
}

