/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class AcceleoOCLStdLibReflection {
    private EcoreEnvironment environment;
    private Object invalid;
    private EClassifier oclInvalid;

    public AcceleoOCLStdLibReflection(EcoreEnvironment env) {
        this.environment = env;
    }

    public Object getInvalid() {
        if (this.invalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getOclInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS) {
                methodName = "getInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.invalid = method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return this.invalid;
    }

    public EClassifier getOCLInvalid() {
        if (this.oclInvalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS) {
                methodName = "getOclInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.oclInvalid = (EClassifier)method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return this.oclInvalid;
    }
}

