/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoNonStandardLibrary {
    public static final String OPERATION_COLLECTION_SEP = "sep";
    public static final String OPERATION_OCLANY_ANCESTORS = "ancestors";
    public static final String OPERATION_OCLANY_SIBLINGS = "siblings";
    public static final String OPERATION_OCLANY_EALLCONTENTS = "eAllContents";
    public static final String OPERATION_OCLANY_ECONTAINER = "eContainer";
    public static final String OPERATION_OCLANY_EGET = "eGet";
    public static final String OPERATION_OCLANY_EINVERSE = "eInverse";
    public static final String OPERATION_OCLANY_INVOKE = "invoke";
    public static final String OPERATION_OCLANY_CURRENT = "current";
    public static final String OPERATION_OCLANY_GETPROPERTY = "getProperty";
    public static final String OPERATION_OCLANY_TOSTRING = "toString";
    public static final String OPERATION_STRING_CONTAINS = "contains";
    public static final String OPERATION_STRING_ENDSWITH = "endsWith";
    public static final String OPERATION_STRING_REPLACE = "replace";
    public static final String OPERATION_STRING_REPLACEALL = "replaceAll";
    public static final String OPERATION_STRING_STARTSWITH = "startsWith";
    public static final String OPERATION_STRING_SUBSTITUTEALL = "substituteAll";
    public static final String OPERATION_STRING_TOKENIZE = "tokenize";
    public static final String OPERATION_STRING_TRIM = "trim";
    public static final String PRIMITIVE_STRING_NAME = "String";
    public static final String TYPE_COLLECTION_NAME = "Collection(T)";
    public static final String TYPE_OCLANY_NAME = "OclAny";
    private static EPackage nonStdLibPackage;
    private static final String NS_URI = "http://www.eclipse.org/acceleo/mtl/0.8.0/mtlnonstdlib.ecore";
    private static EClass collectionType;
    private static EClass oclAnyType;
    private static EClass stringType;

    public AcceleoNonStandardLibrary() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            nonStdLibPackage = (EPackage)ModelUtils.load(URI.createURI((String)NS_URI), (ResourceSet)resourceSet);
            collectionType = (EClass)nonStdLibPackage.getEClassifier(TYPE_COLLECTION_NAME);
            oclAnyType = (EClass)nonStdLibPackage.getEClassifier(TYPE_OCLANY_NAME);
            stringType = (EClass)nonStdLibPackage.getEClassifier(PRIMITIVE_STRING_NAME);
        }
        catch (IOException iOException) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoNonStandardLibrary.LoadFailure"), false);
        }
    }

    public EList<EOperation> getExistingOperations(EClassifier type) {
        return this.getExistingOperations(type.getName());
    }

    public synchronized EList<EOperation> getExistingOperations(String classifierName) {
        BasicEList result = new BasicEList();
        if (PRIMITIVE_STRING_NAME.equals(classifierName)) {
            result.addAll((Collection)stringType.getEOperations());
        } else if (TYPE_OCLANY_NAME.equals(classifierName)) {
            result.addAll((Collection)oclAnyType.getEOperations());
        } else if (TYPE_COLLECTION_NAME.equals(classifierName)) {
            result.addAll((Collection)collectionType.getEOperations());
        }
        return result;
    }
}

