/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.AcceleoServicesRegistry;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.service.AcceleoDynamicTemplatesRegistry;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.options.EvaluationOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    private static final Object NULL_ARGUMENT = new Object();
    final Set<Module> currentModules = new HashSet<Module>();
    private final Map<Template, Set<Template>> dynamicOverrides = new HashMap<Template, Set<Template>>();
    private final Map<Template, Set<Template>> overridingTemplates = new HashMap<Template, Set<Template>>();
    private final List<Properties> properties = new ArrayList<Properties>();
    private EcoreUtil.CrossReferencer referencer;
    private final Map<String, Set<Template>> templates = new HashMap<String, Set<Template>>();
    private final Map<String, StringTokenizer> tokenizers = new HashMap<String, StringTokenizer>();
    private final Map<String, LinkedList<Object>> variableMap = new HashMap<String, LinkedList<Object>>();

    public AcceleoEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent, Module module, List<Properties> props) {
        super(parent);
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.properties.addAll(props);
    }

    public AcceleoEvaluationEnvironment(Module module, List<Properties> props) {
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.properties.addAll(props);
    }

    public void add(String name, Object value) {
        LinkedList<Object> values = this.variableMap.get(name);
        if (values == null) {
            values = new LinkedList();
            this.variableMap.put(name, values);
        }
        values.add(value);
    }

    public Object callNonStandardOperation(EOperation operation, Object source, Object ... args) {
        Object result = null;
        String operationName = operation.getName();
        if ("toString".equals(operationName)) {
            result = this.toString(source);
        } else if ("invoke".equals(operationName)) {
            if (args.length == 3) {
                result = this.invoke(operation.eResource().getURI(), source, args);
            }
        } else if ("current".equals(operationName)) {
            if (args.length == 1) {
                result = this.getContext(args);
            }
        } else if ("getProperty".equals(operationName)) {
            if (args.length == 1) {
                result = this.getProperty((String)args[0]);
            } else if (args.length == 2 && args[1] instanceof String) {
                result = this.getProperty((String)args[0], (String)args[1]);
            } else if (args.length == 2) {
                result = this.getProperty((String)args[0], ((List)args[1]).toArray());
            } else if (args.length == 3) {
                result = this.getProperty((String)args[0], (String)args[1], ((List)args[2]).toArray());
            }
        } else if (source instanceof String) {
            result = this.callNonStandardStringOperation(operation, (String)source, args);
        } else if (source instanceof EObject) {
            result = this.callNonStandardEObjectOperation(operation, (EObject)source, args);
        } else if (source instanceof Collection) {
            result = this.callNonStandardCollectionOperation(operation, (Collection)source, args);
        }
        if (result != null) {
            return result;
        }
        throw this.getExceptionOperationCallFailed(operation, source, args);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        Object result = null;
        result = operation.getEAnnotation("MTL") != null ? this.callStandardOperation(operation, source, args) : (operation.getEAnnotation("MTL non-standard") != null ? this.callNonStandardOperation(operation, source, args) : super.callOperation(operation, opcode, source, args));
        return result;
    }

    public Object callStandardOperation(EOperation operation, Object source, Object ... args) {
        Object result = null;
        if (source instanceof String) {
            String sourceValue = (String)source;
            if ("substitute".equals(operation.getName())) {
                result = this.substitute(sourceValue, (String)args[0], (String)args[1], false);
            } else if ("index".equals(operation.getName())) {
                result = sourceValue.indexOf((String)args[0]) + 1;
                if (result == Integer.valueOf(0)) {
                    result = -1;
                }
            } else if ("first".equals(operation.getName())) {
                int endIndex = (Integer)args[0];
                result = endIndex < 0 || endIndex > sourceValue.length() ? sourceValue : sourceValue.substring(0, endIndex);
            } else if ("last".equals(operation.getName())) {
                int charCount = (Integer)args[0];
                result = charCount < 0 || charCount > sourceValue.length() ? sourceValue : sourceValue.substring(sourceValue.length() - charCount, sourceValue.length());
            } else if ("strstr".equals(operation.getName())) {
                result = sourceValue.contains((String)args[0]);
            } else if ("strtok".equals(operation.getName())) {
                result = this.strtok(sourceValue, (String)args[0], (Integer)args[1]);
            } else if ("strcmp".equals(operation.getName())) {
                result = sourceValue.compareTo((String)args[0]);
            } else if ("isAlpha".equals(operation.getName())) {
                result = this.isAlpha(sourceValue);
            } else if ("isAlphanum".equals(operation.getName())) {
                result = this.isAlphanumeric(sourceValue);
            } else if ("toUpperFirst".equals(operation.getName())) {
                result = sourceValue.length() == 0 ? sourceValue : (sourceValue.length() == 1 ? sourceValue.toUpperCase() : String.valueOf(Character.toUpperCase(sourceValue.charAt(0))) + sourceValue.substring(1));
            } else if ("toLowerFirst".equals(operation.getName())) {
                result = sourceValue.length() == 0 ? sourceValue : (sourceValue.length() == 1 ? sourceValue.toLowerCase() : String.valueOf(Character.toLowerCase(sourceValue.charAt(0))) + sourceValue.substring(1));
            }
        } else if (source instanceof Integer || source instanceof Long) {
            if ("toString".equals(operation.getName())) {
                result = source.toString();
            }
        } else if ((source instanceof Double || source instanceof Float) && "toString".equals(operation.getName())) {
            result = source.toString();
        }
        if (result != null) {
            return result;
        }
        throw this.getExceptionOperationCallFailed(operation, source, args);
    }

    public void clear() {
        super.clear();
        this.variableMap.clear();
    }

    public List<Template> getAllCandidates(Module origin, Template call, List<Object> arguments) {
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            if (arg != null) {
                argumentTypes.add(arg.getClass());
                continue;
            }
            argumentTypes.add(NULL_ARGUMENT);
        }
        List<Template> orderedNamesakes = this.reorderCandidatesPriority(origin, this.getAllCandidateNamesakes(call, argumentTypes));
        List<Template> dynamicOverriding = this.reorderDynamicOverrides(this.getAllDynamicCandidateOverriding(orderedNamesakes, argumentTypes));
        List<Template> overriding = this.getAllCandidateOverriding(origin, orderedNamesakes, argumentTypes);
        ArrayList<Template> applicableCandidates = new ArrayList<Template>();
        applicableCandidates.addAll(dynamicOverriding);
        applicableCandidates.addAll(overriding);
        applicableCandidates.addAll(orderedNamesakes);
        return applicableCandidates;
    }

    public Template getMostSpecificTemplate(List<Template> candidates, List<Object> arguments) {
        Iterator<Template> candidateIterator = candidates.iterator();
        if (candidates.size() == 1) {
            return candidateIterator.next();
        }
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            argumentTypes.add(arg.getClass());
        }
        Template mostSpecific = candidateIterator.next();
        while (candidateIterator.hasNext()) {
            mostSpecific = this.mostSpecificTemplate(mostSpecific, candidateIterator.next(), arguments);
        }
        return mostSpecific;
    }

    public Object getValueOf(String name) {
        if (this.variableMap.containsKey(name)) {
            return this.variableMap.get(name).getLast();
        }
        return null;
    }

    public Object remove(String name) {
        if (!this.variableMap.containsKey(name)) {
            return null;
        }
        Object removedValue = this.variableMap.get(name).removeLast();
        if (this.variableMap.get(name).size() == 0) {
            this.variableMap.remove(name);
        }
        return removedValue;
    }

    public void replace(String name, Object value) {
        if (this.variableMap.containsKey(name)) {
            this.variableMap.get(name).removeLast();
        }
        this.add(name, value);
    }

    public String toString() {
        return this.variableMap.toString();
    }

    private Set<EObject> ancestors(EObject source, EClassifier filter) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        EObject container = source.eContainer();
        while (container != null) {
            if (filter == null || filter.isInstance((Object)container)) {
                result.add(container);
            }
            container = container.eContainer();
        }
        return result;
    }

    private Set<Template> applicableTemplates(Set<Template> candidates, List<Object> argumentTypes) {
        LinkedHashSet<Template> applicableCandidates = new LinkedHashSet<Template>(candidates);
        for (Template candidate : candidates) {
            if (candidate.getParameter().size() == argumentTypes.size()) continue;
            applicableCandidates.remove(candidate);
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            for (Template candidate : new LinkedHashSet<Template>(applicableCandidates)) {
                Object parameterType = ((Variable)candidate.getParameter().get(i)).getType();
                if (this.isApplicableArgument(parameterType, argumentTypes.get(i))) continue;
                applicableCandidates.remove(candidate);
            }
            ++i;
        }
        return applicableCandidates;
    }

    private Object callNonStandardCollectionOperation(EOperation operation, Collection<?> source, Object ... args) {
        ArrayList<Object> result = null;
        String operationName = operation.getName();
        if ("sep".equals(operationName)) {
            ArrayList<Object> temp = new ArrayList<Object>(source.size() << 1);
            Iterator<?> sourceIterator = source.iterator();
            while (sourceIterator.hasNext()) {
                temp.add(sourceIterator.next());
                if (!sourceIterator.hasNext()) continue;
                temp.add(args[0]);
            }
            result = temp;
        }
        return result;
    }

    private Object callNonStandardEObjectOperation(EOperation operation, EObject source, Object ... args) {
        Set<EObject> result = null;
        String operationName = operation.getName();
        if ("eAllContents".equals(operationName)) {
            if (args.length == 0) {
                result = this.eAllContents(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = this.eAllContents(source, (EClassifier)args[0]);
            }
        } else if ("ancestors".equals(operationName)) {
            if (args.length == 0) {
                result = this.ancestors(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = this.ancestors(source, (EClassifier)args[0]);
            }
        } else if ("siblings".equals(operationName)) {
            if (args.length == 0) {
                result = this.siblings(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = this.siblings(source, (EClassifier)args[0]);
            }
        } else if ("eInverse".equals(operationName)) {
            if (args.length == 0) {
                result = this.eInverse(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = this.eInverse(source, (EClassifier)args[0]);
            }
        } else if ("eGet".equals(operationName)) {
            result = this.eGet(source, (String)args[0]);
        } else if ("eContainer".equals(operationName)) {
            result = this.eContainer(source, (EClassifier)args[0]);
        }
        return result;
    }

    private Object callNonStandardStringOperation(EOperation operation, String source, Object ... args) {
        Object result = null;
        String operationName = operation.getName();
        if ("substituteAll".equals(operationName)) {
            result = this.substitute(source, (String)args[0], (String)args[1], true);
        } else if ("replace".equals(operationName)) {
            result = source.replaceFirst((String)args[0], (String)args[1]);
        } else if ("replaceAll".equals(operationName)) {
            result = source.replaceAll((String)args[0], (String)args[1]);
        } else if ("endsWith".equals(operationName)) {
            result = source.endsWith((String)args[0]);
        } else if ("startsWith".equals(operationName)) {
            result = source.startsWith((String)args[0]);
        } else if ("trim".equals(operationName)) {
            result = source.trim();
        } else if ("tokenize".equals(operationName)) {
            result = this.tokenize(source, (String)args[0]);
        } else if ("contains".equals(operationName)) {
            result = source.contains((String)args[0]);
        }
        return result;
    }

    private void createEInverseCrossreferencer(EObject target) {
        if (target.eResource() != null && target.eResource().getResourceSet() != null) {
            ResourceSet rs = target.eResource().getResourceSet();
            EcoreUtil.ContentTreeIterator<Notifier> contentIterator = new EcoreUtil.ContentTreeIterator<Notifier>(Collections.singleton(rs)){
                private static final long serialVersionUID = 1L;

                protected Iterator<Resource> getResourceSetChildren(ResourceSet resourceSet) {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    for (Resource res : resourceSet.getResources()) {
                        if ("emtl".equals(res.getURI().fileExtension())) continue;
                        resources.add(res);
                    }
                    this.resourceSetIterator = new EcoreUtil.ContentTreeIterator.ResourcesIterator(resources);
                    return this.resourceSetIterator;
                }
            };
            this.referencer = new EcoreUtil.CrossReferencer(rs, (EcoreUtil.ContentTreeIterator)contentIterator){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ EcoreUtil.ContentTreeIterator val$contentIterator;
                {
                    this.val$contentIterator = contentTreeIterator;
                    super($anonymous0);
                    this.crossReference();
                }

                protected TreeIterator<Notifier> newContentsIterator() {
                    return this.val$contentIterator;
                }
            };
        } else {
            this.referencer = target.eResource() != null ? new EcoreUtil.CrossReferencer(target.eResource()){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                }
            } : new EcoreUtil.CrossReferencer(EcoreUtil.getRootContainer((EObject)target)){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                }
            };
        }
    }

    private List<EObject> eAllContents(EObject source, EClassifier filter) {
        TreeIterator contentIterator = source.eAllContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (contentIterator.hasNext()) {
            EObject next = (EObject)contentIterator.next();
            if (filter != null && !filter.isInstance((Object)next)) continue;
            result.add(next);
        }
        return result;
    }

    private Object eContainer(EObject source, EClassifier filter) {
        EObject container = source.eContainer();
        while (!filter.isInstance((Object)container)) {
            container = container.eContainer();
        }
        return container;
    }

    private Object eGet(EObject source, String featureName) {
        Object result = null;
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            result = source.eGet(feature);
        }
        return result;
    }

    private Set<EObject> eInverse(EObject target, EClassifier filter) {
        Collection settings;
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        if (this.referencer == null) {
            this.createEInverseCrossreferencer(target);
        }
        if ((settings = (Collection)this.referencer.get((Object)target)) == null) {
            return Collections.emptySet();
        }
        for (EStructuralFeature.Setting setting : settings) {
            if (filter != null && !filter.isInstance((Object)setting.getEObject())) continue;
            result.add(setting.getEObject());
        }
        return result;
    }

    private Set<Template> getAllCandidateNamesakes(Template call, List<Object> argumentTypes) {
        LinkedHashSet<Template> namesakes = new LinkedHashSet<Template>();
        Set<Template> candidates = this.templates.get(call.getName());
        if (candidates == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ModuleResolutionError"));
        }
        namesakes.addAll(candidates);
        if (namesakes.size() == 1) {
            return namesakes;
        }
        namesakes.retainAll(this.applicableTemplates(candidates, argumentTypes));
        return namesakes;
    }

    private List<Template> getAllCandidateOverriding(Module origin, List<Template> overridenTemplates, List<Object> argumentTypes) {
        LinkedHashSet<Template> candidateOverriding = new LinkedHashSet<Template>();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.overridingTemplates.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            candidateOverriding.addAll(applicableCandidates);
            candidateOverriding.addAll(this.getAllCandidateOverriding(origin, new ArrayList<Template>(applicableCandidates), argumentTypes));
        }
        return this.reorderCandidatesPriority(origin, candidateOverriding);
    }

    private Set<Template> getAllDynamicCandidateOverriding(List<Template> overridenTemplates, List<Object> argumentTypes) {
        LinkedHashSet<Template> dynamicOverriding = new LinkedHashSet<Template>();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.dynamicOverrides.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            dynamicOverriding.addAll(applicableCandidates);
        }
        return dynamicOverriding;
    }

    private List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private Object getContext(Object[] args) {
        Object soughtValue;
        ArrayList<Object> allIterators = new ArrayList<Object>();
        int index = 0;
        Object value = this.getValueOf("context" + index++);
        while (value != null) {
            allIterators.add(value);
            value = this.getValueOf("context" + index++);
        }
        if (args[0] instanceof Integer) {
            int soughtIndex = (Integer)args[0];
            soughtValue = soughtIndex > allIterators.size() - 1 ? allIterators.get(0) : allIterators.get(allIterators.size() - soughtIndex - 1);
        } else {
            EClassifier filter = (EClassifier)args[0];
            int i = allIterators.size() - 1;
            while (i >= 0) {
                if (filter.isInstance(allIterators.get(i))) {
                    value = allIterators.get(i);
                    break;
                }
                --i;
            }
            soughtValue = value;
        }
        return soughtValue;
    }

    private UnsupportedOperationException getExceptionOperationCallFailed(EOperation operation, Object source, Object ... args) {
        StringBuilder argErrorMsg = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            argErrorMsg.append(args[i].getClass().getSimpleName());
            if (i < args.length - 1) {
                argErrorMsg.append(", ");
            }
            ++i;
        }
        String sourceName = source == null ? "null" : source.getClass().getName();
        return new UnsupportedOperationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.UndefinedOperation", operation.getName(), argErrorMsg.toString(), sourceName));
    }

    private String getProperty(String key) {
        String propertyValue = String.valueOf('!') + key + '!';
        for (Properties propertiesHolder : this.properties) {
            String property = propertiesHolder.getProperty(key);
            if (property == null) continue;
            propertyValue = MessageFormat.format(property, new Object[0]);
            break;
        }
        return propertyValue;
    }

    private String getProperty(String key, Object[] arguments) {
        String propertyValue = String.valueOf('!') + key + '!';
        for (Properties propertiesHolder : this.properties) {
            String property = propertiesHolder.getProperty(key);
            if (property == null) continue;
            propertyValue = MessageFormat.format(property, arguments);
            break;
        }
        return propertyValue;
    }

    private String getProperty(String propertiesFileName, String key) {
        String propertyValue = String.valueOf('!') + key + '!';
        for (Properties propertiesHolder : this.properties) {
            String property;
            String fileName;
            String soughtPropertiesFile = propertiesFileName;
            String propertiesExtension = ".properties";
            if (!propertiesFileName.endsWith(propertiesExtension)) {
                soughtPropertiesFile = String.valueOf(soughtPropertiesFile) + propertiesExtension;
            }
            if (!soughtPropertiesFile.equals(fileName = propertiesHolder.getProperty("properties.holder.file.name")) || (property = propertiesHolder.getProperty(key)) == null) continue;
            propertyValue = MessageFormat.format(property, new Object[0]);
            break;
        }
        return propertyValue;
    }

    private String getProperty(String propertiesFileName, String key, Object[] arguments) {
        String propertyValue = String.valueOf('!') + key + '!';
        for (Properties propertiesHolder : this.properties) {
            String property;
            String fileName;
            String soughtPropertiesFile = propertiesFileName;
            String propertiesExtension = ".properties";
            if (!propertiesFileName.endsWith(propertiesExtension)) {
                soughtPropertiesFile = String.valueOf(soughtPropertiesFile) + propertiesExtension;
            }
            if (!soughtPropertiesFile.equals(fileName = propertiesHolder.getProperty("properties.holder.file.name")) || (property = propertiesHolder.getProperty(key)) == null) continue;
            propertyValue = MessageFormat.format(property, arguments);
            break;
        }
        return propertyValue;
    }

    private Object invoke(URI moduleURI, Object source, Object[] args) {
        Object result = null;
        Object serviceInstance = AcceleoServicesRegistry.INSTANCE.addService(moduleURI, (String)args[0]);
        if (serviceInstance == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ClassNotFound", args[0], moduleURI.lastSegment()));
        }
        Class<?> serviceClass = serviceInstance.getClass();
        String methodSignature = (String)args[1];
        try {
            Method method;
            int openParenthesisIndex = methodSignature.indexOf(40);
            if (openParenthesisIndex != -1) {
                String methodName = methodSignature.substring(0, openParenthesisIndex);
                int closeParenthesisIndex = methodSignature.indexOf(41);
                if (closeParenthesisIndex - openParenthesisIndex > 1) {
                    String parameterType;
                    String parameterTypesString = methodSignature.substring(openParenthesisIndex + 1, closeParenthesisIndex);
                    ArrayList parameterTypes = new ArrayList();
                    int nextCommaIndex = parameterTypesString.indexOf(44);
                    int previousComma = 0;
                    while (nextCommaIndex != -1) {
                        parameterType = parameterTypesString.substring(previousComma, nextCommaIndex).trim();
                        if (serviceInstance.getClass().getClassLoader() != null) {
                            parameterTypes.add(serviceInstance.getClass().getClassLoader().loadClass(parameterType));
                        } else {
                            parameterTypes.add(Class.forName(parameterType));
                        }
                        previousComma = nextCommaIndex + 1;
                        nextCommaIndex = parameterTypesString.indexOf(nextCommaIndex, 44);
                    }
                    parameterType = parameterTypesString.substring(previousComma, parameterTypesString.length()).trim();
                    if (serviceInstance.getClass().getClassLoader() != null) {
                        parameterTypes.add(serviceInstance.getClass().getClassLoader().loadClass(parameterType));
                    } else {
                        parameterTypes.add(Class.forName(parameterType));
                    }
                    method = serviceClass.getMethod(methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
                } else {
                    method = serviceClass.getMethod(methodName, new Class[0]);
                }
            } else {
                method = serviceClass.getMethod(methodSignature, new Class[0]);
            }
            assert (method != null);
            List invocationArguments = (List)args[2];
            if (method.getParameterTypes().length == 0) {
                result = invocationArguments.size() == 0 ? method.invoke(source, new Object[0]) : method.invoke(invocationArguments.get(0), new Object[0]);
            } else {
                if (method.getParameterTypes().length - invocationArguments.size() == 1) {
                    invocationArguments.add(0, source);
                }
                if (method.getParameterTypes().length - invocationArguments.size() == -1) {
                    Object swappedSource = invocationArguments.remove(0);
                    result = method.invoke(swappedSource, invocationArguments.toArray(new Object[invocationArguments.size()]));
                } else {
                    result = method.invoke(serviceInstance, invocationArguments.toArray(new Object[invocationArguments.size()]));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.NoSuchMethod", args[1], args[0]), e);
        }
        catch (IllegalArgumentException e) {
            throw new AcceleoEvaluationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.RestrictedMethod", args[1], args[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new AcceleoEvaluationException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ParameterClassNotFound", args[1], args[0]), e);
        }
        return result;
    }

    private boolean isAlpha(String s) {
        char[] chars;
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isAlphanumeric(String s) {
        char[] chars;
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isApplicableArgument(Object expectedType, Object argumentType) {
        boolean isApplicable = false;
        isApplicable = argumentType == NULL_ARGUMENT ? true : (expectedType instanceof EClass && argumentType instanceof EClass ? expectedType == argumentType || this.isSubTypeOf((EClass)expectedType, (EClass)argumentType) : (expectedType instanceof Class && argumentType instanceof Class ? ((Class)expectedType).isAssignableFrom((Class)argumentType) : (expectedType instanceof EDataType && argumentType instanceof Class ? ((EDataType)expectedType).getInstanceClass() == argumentType : expectedType.getClass().isInstance(argumentType))));
        return isApplicable;
    }

    private boolean isSubTypeOf(EClass superType, EClass eClass) {
        for (EClass candidate : eClass.getEAllSuperTypes()) {
            if (candidate != superType) continue;
            return true;
        }
        return false;
    }

    private Set<Module> loadDynamicModules() {
        Set<File> dynamicModuleFiles = AcceleoDynamicTemplatesRegistry.INSTANCE.getRegisteredModules();
        LinkedHashSet<Module> dynamicModules = new LinkedHashSet<Module>();
        if (dynamicModuleFiles.size() > 0) {
            ResourceSet resourceSet = null;
            for (Module module : this.currentModules) {
                if (module.eResource() == null || module.eResource().getResourceSet() == null) continue;
                resourceSet = module.eResource().getResourceSet();
                break;
            }
            if (resourceSet == null) {
                AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.DynamicModulesLoadingFailure"), true);
                return dynamicModules;
            }
            if (!(resourceSet.getURIConverter() instanceof DynamicModulesURIConverter)) {
                resourceSet.setURIConverter((URIConverter)new DynamicModulesURIConverter());
            }
            for (File moduleFile : dynamicModuleFiles) {
                if (!moduleFile.exists() || !moduleFile.canRead()) continue;
                try {
                    Resource res = ModelUtils.load((File)moduleFile, (ResourceSet)resourceSet).eResource();
                    for (EObject root : res.getContents()) {
                        if (!(root instanceof Module)) continue;
                        dynamicModules.add((Module)root);
                    }
                }
                catch (IOException e) {
                    AcceleoEnginePlugin.log(e, false);
                }
            }
        }
        return dynamicModules;
    }

    private void mapAllTemplates(Module module) {
        if (this.currentModules.contains(module)) {
            return;
        }
        this.currentModules.add(module);
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Set<Template> namesakes = this.templates.get(elem.getName());
            if (namesakes == null) {
                namesakes = new LinkedHashSet<Template>();
                this.templates.put(elem.getName(), namesakes);
            }
            namesakes.add((Template)elem);
            this.mapOverridingTemplate((Template)elem);
        }
        for (Module extended : module.getExtends()) {
            this.mapAllTemplates(extended);
        }
        for (Module imported : module.getImports()) {
            this.mapAllTemplates(imported);
        }
    }

    private void mapDynamicModule(Module module, Set<Module> dynamicModules) {
        boolean map = false;
        LinkedHashSet<Module> unMappedRequiredModules = new LinkedHashSet<Module>();
        for (Module extended : module.getExtends()) {
            if (dynamicModules.contains(extended)) {
                this.mapDynamicModule(extended, dynamicModules);
            }
            if (this.currentModules.contains(extended)) {
                map = true;
                continue;
            }
            unMappedRequiredModules.add(extended);
        }
        if (!map) {
            return;
        }
        for (Module imported : module.getImports()) {
            if (this.currentModules.contains(imported)) continue;
            unMappedRequiredModules.add(imported);
        }
        for (Module required : unMappedRequiredModules) {
            this.mapAllTemplates(required);
        }
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Template ownedTemplate = (Template)elem;
            for (Template overriden : ownedTemplate.getOverrides()) {
                Set<Template> overriding = this.dynamicOverrides.get(overriden);
                if (overriding == null && this.templates.containsKey(overriden.getName())) {
                    overriding = new LinkedHashSet<Template>();
                    Template match = overriden;
                    Set<Template> candidates = this.templates.get(overriden.getName());
                    for (Template template : candidates) {
                        if (!EcoreUtil.equals((EObject)template, (EObject)overriden)) continue;
                        match = template;
                        break;
                    }
                    this.dynamicOverrides.put(match, overriding);
                }
                if (overriding == null) continue;
                overriding.add(ownedTemplate);
            }
            if (ownedTemplate.getOverrides().size() != 0) continue;
            Set<Template> namesakes = this.templates.get(ownedTemplate.getName());
            if (namesakes == null) {
                namesakes = new LinkedHashSet<Template>();
                this.templates.put(ownedTemplate.getName(), namesakes);
            }
            namesakes.add(ownedTemplate);
        }
        this.currentModules.add(module);
    }

    private void mapDynamicOverrides() {
        Set<Module> dynamicModules = this.loadDynamicModules();
        for (Module module : dynamicModules) {
            this.mapDynamicModule(module, dynamicModules);
        }
    }

    private void mapOverridingTemplate(Template elem) {
        for (Template overriden : elem.getOverrides()) {
            Set<Template> overriding = this.overridingTemplates.get(overriden);
            if (overriding == null) {
                overriding = new LinkedHashSet<Template>();
                this.overridingTemplates.put(overriden, overriding);
            }
            overriding.add(elem);
        }
    }

    private Template mostSpecificTemplate(Template template1, Template template2, List<Object> actualArgumentTypes) {
        int template1SpecificArgumentCount = 0;
        int template2SpecificArgumentCount = 0;
        int i = 0;
        while (i < actualArgumentTypes.size()) {
            EClassifier template2Type;
            Object actualArgumentType = actualArgumentTypes.get(i);
            EClassifier template1Type = (EClassifier)((Variable)template1.getParameter().get(i)).getType();
            if (template1Type != (template2Type = (EClassifier)((Variable)template2.getParameter().get(i)).getType())) {
                if (actualArgumentType instanceof EObject) {
                    if (this.isSubTypeOf((EClass)template1Type, (EClass)template2Type)) {
                        ++template2SpecificArgumentCount;
                    } else {
                        ++template1SpecificArgumentCount;
                    }
                } else assert (false);
            }
            ++i;
        }
        Template mostSpecific = template1SpecificArgumentCount >= template2SpecificArgumentCount ? template1 : template2;
        return mostSpecific;
    }

    private List<Template> reorderCandidatesPriority(Module origin, Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            if (candidate.eContainer() != origin) continue;
            reorderedList.add(candidate);
            candidates.remove(candidate);
        }
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            for (Module extended : origin.getExtends()) {
                if (candidate.eContainer() != extended) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        for (Template candidate : new LinkedHashSet<Template>(candidates)) {
            for (Module imported : origin.getImports()) {
                if (candidate.eContainer() != imported) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        return reorderedList;
    }

    private List<Template> reorderDynamicOverrides(Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        LinkedHashSet<Template> lowest = new LinkedHashSet<Template>(candidates);
        while (!lowest.isEmpty()) {
            for (Template candidate : new LinkedHashSet<Template>(lowest)) {
                for (Template overriden : candidate.getOverrides()) {
                    if (!lowest.contains(overriden)) continue;
                    lowest.remove(overriden);
                }
            }
            if (lowest.isEmpty()) {
                ArrayList<Template> remainingCandidates = new ArrayList<Template>(candidates);
                remainingCandidates.removeAll(reorderedList);
                reorderedList.addAll(remainingCandidates);
                continue;
            }
            reorderedList.addAll(lowest);
            lowest.clear();
            lowest.addAll(candidates);
            lowest.removeAll(reorderedList);
        }
        return reorderedList;
    }

    private Set<EObject> siblings(EObject source, EClassifier filter) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        EObject container = source.eContainer();
        for (EObject child : this.getContents(container)) {
            if (child == source || filter != null && !filter.isInstance((Object)child)) continue;
            result.add(child);
        }
        return result;
    }

    private String strtok(String source, String delimiters, Integer flag) {
        if (flag == 0) {
            StringTokenizer tokenizer = new StringTokenizer(source, delimiters);
            this.tokenizers.put(source, tokenizer);
            return tokenizer.nextToken();
        }
        if (flag == 1) {
            StringTokenizer tokenizer = this.tokenizers.get(source);
            if (tokenizer == null) {
                tokenizer = new StringTokenizer(source, delimiters);
                this.tokenizers.put(source, tokenizer);
            }
            String token = "";
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
            }
            return token;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.IllegalTokenizerFlag", flag));
    }

    private String substitute(String source, String substring, String replacement, boolean substituteAll) {
        if (substring == null || replacement == null) {
            throw new NullPointerException();
        }
        String regex = "\\Q" + substring + "\\E";
        String replacementValue = replacement.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
        if (substituteAll) {
            return source.replaceAll(regex, replacementValue);
        }
        return source.replaceFirst(regex, replacementValue);
    }

    private List<String> tokenize(String source, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(source, delim);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DynamicModulesURIConverter
    extends ExtensibleURIConverterImpl {
        public URI normalize(URI uri) {
            if (!"emtl".equals(uri.fileExtension()) || !"file".equals(uri.scheme())) {
                return super.normalize(uri);
            }
            URI normalized = (URI)this.getURIMap().get(uri);
            if (normalized == null) {
                String moduleName = uri.lastSegment();
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
                LinkedHashSet<URI> candidateURIs = new LinkedHashSet<URI>();
                Set<Module> candidateModules = this.searchCurrentModuleForCandidateMatches(moduleName);
                for (Module candidateModule : candidateModules) {
                    candidateURIs.add(candidateModule.eResource().getURI());
                }
                if (candidateURIs.size() == 0) {
                    candidateURIs.addAll(this.searchResourceSetForMatches(moduleName));
                }
                if (candidateURIs.size() == 1) {
                    normalized = (URI)candidateURIs.iterator().next();
                } else if (candidateURIs.size() > 0) {
                    normalized = this.findBestMatchFor(uri, candidateURIs);
                }
                if ((normalized == null || "file".equals(normalized.scheme())) && EMFPlugin.IS_ECLIPSE_RUNNING) {
                    String resolvedPath;
                    String uriToString = uri.toString();
                    if (uriToString.indexOf(35) > 0) {
                        uriToString = uriToString.substring(0, uriToString.indexOf(35));
                    }
                    if ((resolvedPath = AcceleoWorkspaceUtil.INSTANCE.resolveAsPlatformPluginResource(uriToString)) != null) {
                        normalized = URI.createURI((String)resolvedPath);
                    }
                }
                if (normalized == null) {
                    normalized = super.normalize(uri);
                }
                if (!uri.equals((Object)normalized)) {
                    this.getURIMap().put(uri, normalized);
                }
            }
            return normalized;
        }

        private URI findBestMatchFor(URI uri, Set<URI> candidateURIs) {
            URI normalized = null;
            Iterator<URI> candidatesIterator = candidateURIs.iterator();
            List<String> referenceSegments = Arrays.asList(uri.segments());
            Collections.reverse(referenceSegments);
            int highestEqualFragments = 0;
            while (candidatesIterator.hasNext()) {
                URI next = candidatesIterator.next();
                int equalFragments = 0;
                List<String> candidateSegments = Arrays.asList(next.segments());
                Collections.reverse(candidateSegments);
                int i = 0;
                while (i < Math.min(candidateSegments.size(), referenceSegments.size())) {
                    if (candidateSegments.get(i) != referenceSegments.get(i)) break;
                    ++equalFragments;
                    ++i;
                }
                if (equalFragments <= highestEqualFragments) continue;
                highestEqualFragments = equalFragments;
                normalized = next;
            }
            return normalized;
        }

        private Set<Module> searchCurrentModuleForCandidateMatches(String moduleName) {
            LinkedHashSet<Module> candidates = new LinkedHashSet<Module>();
            for (Module module : AcceleoEvaluationEnvironment.this.currentModules) {
                if (!moduleName.equals(module.getName())) continue;
                candidates.add(module);
            }
            return candidates;
        }

        private Set<URI> searchResourceSetForMatches(String moduleName) {
            LinkedHashSet<URI> candidates = new LinkedHashSet<URI>();
            ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
            for (Module module : AcceleoEvaluationEnvironment.this.currentModules) {
                ResourceSet resourceSet = module.eResource().getResourceSet();
                if (resourceSets.contains(resourceSet)) continue;
                resourceSets.add(resourceSet);
            }
            for (ResourceSet resourceSet : resourceSets) {
                for (Resource resource : resourceSet.getResources()) {
                    if (!"emtl".equals(resource.getURI().fileExtension())) continue;
                    String candidateName = resource.getURI().lastSegment();
                    if (!moduleName.equals(candidateName = candidateName.substring(0, candidateName.lastIndexOf(46)))) continue;
                    candidates.add(resource.getURI());
                }
            }
            return candidates;
        }
    }
}

