/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitorDecorator;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.InitSection;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.profiler.Profiler;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.impl.OCLExpressionImpl;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends EvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static IDebugAST debug;
    private static final String ITERATION_COUNT_VARIABLE_NAME = "i";
    private static final Object NULL_QUERY_RESULT;
    private static Profiler profile;
    private static final String SELF_VARIABLE_NAME = "self";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private static final String UNDEFINED_GUARD_MESSAGE_KEY = "AcceleoEvaluationVisitor.UndefinedGuard";
    private static final Object UNDEFINED_QUERY_RESULT;
    private final AcceleoEvaluationContext context;
    private int currentContextIndex;
    private boolean fireGenerationEvent;
    private EObject lastEObjectSelfValue;
    private OCLExpression<C> lastSourceExpression;
    private Object lastSourceExpressionResult;
    private final Object invalid = this.getAcceleoEnvironment().getOCLStandardLibraryReflection().getInvalid();
    private final Map<Query, Map<List<Object>, Object>> queryResults = new HashMap<Query, Map<List<Object>, Object>>();
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor;

    static {
        NULL_QUERY_RESULT = new Object();
        UNDEFINED_QUERY_RESULT = new Object();
    }

    public AcceleoEvaluationVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, AcceleoEvaluationContext context) {
        super(decoratedVisitor);
        this.context = context;
        this.visitor = this;
    }

    public static void setDebug(IDebugAST acceleoDebug) {
        debug = acceleoDebug;
    }

    public static void setProfile(Profiler acceleoProfile) {
        profile = acceleoProfile;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        this.context.append(string, sourceBlock, source, fireEvent);
    }

    public void createFileWriter(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        this.context.openNested(generatedFile, fileBlock, source, appendMode, charset);
    }

    public void visitAcceleoBlock(Block block) {
        for (OCLExpression nested : block.getBody()) {
            this.getVisitor().visitExpression(nested);
        }
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object fileURLResult = this.getVisitor().visitExpression((OCLExpression)fileBlock.getFileUrl());
        this.fireGenerationEvent = fireEvents;
        if (this.isUndefined(fileURLResult)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        if (fileURLResult instanceof Collection) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CollectionFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        String filePath = String.valueOf(fileURLResult).trim();
        String fileCharset = null;
        if (fileBlock.getCharset() != null) {
            Object fileCharsetResult = this.visitExpression((OCLExpression<C>)fileBlock.getCharset());
            if (this.isUndefined(fileCharsetResult)) {
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedFileCharset", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
                exception.fillInStackTrace();
                AcceleoEnginePlugin.log(exception, false);
            }
            fileCharset = String.valueOf(fileCharsetResult);
        }
        boolean appendMode = fileBlock.getOpenMode().getValue() == 0;
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        EObject source = currentSelf instanceof EObject ? (EObject)currentSelf : this.lastEObjectSelfValue;
        if ("stdout".equals(filePath)) {
            this.context.openNested(System.out);
        } else {
            this.delegateCreateFileWriter(filePath, (Block)fileBlock, source, appendMode, fileCharset);
        }
        for (OCLExpression nested : fileBlock.getBody()) {
            this.fireGenerationEvent = true;
            this.getVisitor().visitExpression(nested);
            this.fireGenerationEvent = fireEvents;
        }
        this.context.closeContext((Block)fileBlock, source);
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        ArrayList actualIteration;
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object iteration = this.visitExpression((OCLExpression<C>)forBlock.getIterSet());
        this.fireGenerationEvent = fireEvents;
        Variable loopVariable = forBlock.getLoopVariable();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(iteration)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.NullForIteration", forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (iteration instanceof Collection) {
            actualIteration = (ArrayList)iteration;
        } else {
            actualIteration = new ArrayList();
            ((List)actualIteration).add(iteration);
        }
        if (actualIteration.size() > 0 && forBlock.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)forBlock.getBefore());
        }
        Iterator contentIterator = actualIteration.iterator();
        boolean iterationCCE = false;
        boolean hasPrevious = false;
        String implicitContextVariableName = null;
        int count = 0;
        try {
            while (contentIterator.hasNext()) {
                Object guardValue;
                if (++count == 1) {
                    this.getEvaluationEnvironment().add(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                } else {
                    this.getEvaluationEnvironment().replace(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                }
                Object o = contentIterator.next();
                if (loopVariable != null && loopVariable.getType() != null && !((EClassifier)loopVariable.getType()).isInstance(o)) {
                    if (iterationCCE) continue;
                    AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.IterationClassCast", ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), o.getClass().getName(), ((EClassifier)loopVariable.getType()).getName()), false);
                    iterationCCE = true;
                    continue;
                }
                if (loopVariable != null) {
                    if (count == 1) {
                        this.getEvaluationEnvironment().add(loopVariable.getName(), o);
                    } else {
                        this.getEvaluationEnvironment().replace(loopVariable.getName(), o);
                    }
                }
                if (implicitContextVariableName == null) {
                    implicitContextVariableName = this.addContextVariableFor(o);
                } else {
                    this.getEvaluationEnvironment().replace(implicitContextVariableName, o);
                }
                this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, o);
                if (forBlock.getGuard() == null) {
                    guardValue = Boolean.TRUE;
                } else {
                    this.fireGenerationEvent = false;
                    guardValue = this.visitExpression((OCLExpression<C>)forBlock.getGuard());
                    this.fireGenerationEvent = fireEvents;
                }
                if (this.isInvalid(guardValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock, o, forBlock.getGuard()));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (guardValue == null || !((Boolean)guardValue).booleanValue()) continue;
                if (forBlock.getEach() != null && hasPrevious) {
                    this.visitExpression((OCLExpression<C>)forBlock.getEach());
                }
                for (OCLExpression nested : forBlock.getBody()) {
                    this.getVisitor().visitExpression(nested);
                }
                hasPrevious = true;
            }
        }
        finally {
            if (count > 0) {
                if (loopVariable != null) {
                    this.getEvaluationEnvironment().remove(loopVariable.getName());
                }
                this.getEvaluationEnvironment().remove(implicitContextVariableName);
                --this.currentContextIndex;
                this.getEvaluationEnvironment().remove(ITERATION_COUNT_VARIABLE_NAME);
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
        }
        if (actualIteration.size() > 0 && forBlock.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)forBlock.getAfter());
        }
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        org.eclipse.ocl.ecore.OCLExpression condition = ifBlock.getIfExpr();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object conditionValue = this.getVisitor().visitExpression((OCLExpression)condition);
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(conditionValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedCondition", ifBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)ifBlock)).getName(), ifBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (conditionValue != null && ((Boolean)conditionValue).booleanValue()) {
            for (OCLExpression nested : ifBlock.getBody()) {
                this.visitExpression(nested);
            }
        } else if (ifBlock.getElseIf().size() > 0) {
            IfBlock temp = null;
            for (IfBlock elseif : ifBlock.getElseIf()) {
                this.fireGenerationEvent = false;
                Object elseValue = this.getVisitor().visitExpression((OCLExpression)elseif.getIfExpr());
                this.fireGenerationEvent = fireEvents;
                if (this.isInvalid(elseValue)) {
                    String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseif)).getName();
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseCondition", elseif.getStartPosition(), rootName, elseif, currentSelf));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (elseValue == null || !((Boolean)elseValue).booleanValue()) continue;
                temp = elseif;
                break;
            }
            if (temp != null) {
                for (OCLExpression nested : temp.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (ifBlock.getElse() != null) {
                this.visitAcceleoBlock(ifBlock.getElse());
            }
        } else if (ifBlock.getElse() != null) {
            this.visitAcceleoBlock(ifBlock.getElse());
        }
    }

    public void visitAcceleoInitSection(InitSection init) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        for (Variable var : init.getVariable()) {
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
        }
        this.fireGenerationEvent = fireEvents;
    }

    public void visitAcceleoLetBlock(LetBlock letBlock) {
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Variable var = letBlock.getLetVariable();
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object value = this.visitExpression(var.getInitExpression());
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(value)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedLetValue", letBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)letBlock)).getName(), letBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        String varName = null;
        try {
            if (((EClassifier)var.getType()).isInstance(value)) {
                varName = var.getName();
                this.getEvaluationEnvironment().add(varName, value);
                for (OCLExpression nested : letBlock.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (letBlock.getElseLet().size() > 0) {
                LetBlock temp = null;
                for (LetBlock elseLet : letBlock.getElseLet()) {
                    var = elseLet.getLetVariable();
                    this.fireGenerationEvent = false;
                    value = this.visitExpression(var.getInitExpression());
                    this.fireGenerationEvent = fireEvents;
                    if (this.isInvalid(value)) {
                        String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseLet)).getName();
                        AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseLetValue", elseLet.getStartPosition(), rootName, elseLet, currentSelf));
                        exception.fillInStackTrace();
                        throw exception;
                    }
                    if (!((EClassifier)var.getType()).isInstance(value)) continue;
                    varName = var.getName();
                    this.getEvaluationEnvironment().add(var.getName(), value);
                    temp = elseLet;
                    break;
                }
                if (temp != null) {
                    for (OCLExpression nested : temp.getBody()) {
                        this.visitExpression(nested);
                    }
                } else if (letBlock.getElse() != null) {
                    this.visitAcceleoBlock(letBlock.getElse());
                }
            } else if (letBlock.getElse() != null) {
                this.visitAcceleoBlock(letBlock.getElse());
            }
        }
        catch (Throwable throwable) {
            if (varName != null) {
                this.getEvaluationEnvironment().remove(varName);
            }
            throw throwable;
        }
        if (varName != null) {
            this.getEvaluationEnvironment().remove(varName);
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object markerValue = this.getVisitor().visitExpression((OCLExpression)protectedArea.getMarker());
        this.fireGenerationEvent = fireEvents;
        Object source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(markerValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedAreaMarker", protectedArea.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)protectedArea)).getName(), protectedArea, source));
            exception.fillInStackTrace();
            throw exception;
        }
        String marker = this.toString(markerValue).trim();
        String areaContent = this.context.getProtectedAreaContent(marker);
        if (source instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        if (areaContent != null) {
            this.delegateAppend(areaContent, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        } else {
            this.context.openNested();
            this.fireGenerationEvent = false;
            this.visitAcceleoBlock((Block)protectedArea);
            this.fireGenerationEvent = fireEvents;
            String blockContent = this.context.closeContext();
            StringBuilder buffer = new StringBuilder();
            buffer.append(AcceleoEngineMessages.getString("usercode.start"));
            buffer.append(' ');
            buffer.append(marker);
            buffer.append(blockContent);
            buffer.append(AcceleoEngineMessages.getString("usercode.end"));
            this.delegateAppend(buffer.toString(), (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        query = invocation.getDefinition();
        implicitContextVariableName = null;
        arguments = new ArrayList<Object>();
        fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        i = 0;
        while (i < query.getParameter().size()) {
            var = (Variable)query.getParameter().get(i);
            var.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
            argValue = this.getEvaluationEnvironment().getValueOf(var.getName());
            if (this.isInvalid(argValue)) {
                rootName = ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName();
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", new Object[]{invocation.getStartPosition(), rootName, invocation, this.getEvaluationEnvironment().getValueOf("self"), invocation.getArgument().get(i)}));
                exception.fillInStackTrace();
                j = 0;
                while (j <= i) {
                    this.getEvaluationEnvironment().remove(((Variable)query.getParameter().get(j)).getName());
                    ++j;
                }
                throw exception;
            }
            arguments.add(argValue);
            var.setInitExpression(null);
            ++i;
        }
        this.fireGenerationEvent = fireEvents;
        if (this.queryResults.containsKey(query) && (result = (results = this.queryResults.get(query)).get(arguments)) != null) {
            for (Variable var : query.getParameter()) {
                this.getEvaluationEnvironment().remove(var.getName());
            }
            if (result == AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT) {
                rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", new Object[]{query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf("self")}));
                exception.fillInStackTrace();
                throw exception;
            }
            if (result == AcceleoEvaluationVisitor.NULL_QUERY_RESULT) {
                result = null;
            }
            return result;
        }
        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().add("self", arguments.get(0));
            implicitContextVariableName = this.addContextVariableFor(arguments.get(0));
        }
        result = null;
        try {
            result = this.visitExpression((OCLExpression<C>)query.getExpression());
        }
        finally {
            ** for (var : query.getParameter())
        }
lbl-1000:
        // 1 sources

        {
            this.getEvaluationEnvironment().remove(var.getName());
            continue;
        }
lbl57:
        // 1 sources

        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        if (this.queryResults.containsKey(query)) {
            results = this.queryResults.get(query);
            if (this.isInvalid(result)) {
                results.put(arguments, AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, AcceleoEvaluationVisitor.NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
        } else {
            results = new HashMap<K, V>(2);
            if (this.isInvalid(result)) {
                results.put(arguments, AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, AcceleoEvaluationVisitor.NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
            this.queryResults.put(query, results);
        }
        if (this.isInvalid(result)) {
            rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
            exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", new Object[]{query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf("self")}));
            exception.fillInStackTrace();
            throw exception;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        this.context.openNested();
        for (OCLExpression nested : template.getBody()) {
            this.getVisitor().visitExpression(nested);
        }
        return this.context.closeContext();
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        implicitContextVariableName = null;
        actualTemplate = this.prepareInvocation(invocation);
        if (actualTemplate.getParameter().size() > 0) {
            contextValue = this.getEvaluationEnvironment().getValueOf(((Variable)actualTemplate.getParameter().get(0)).getName());
            this.getEvaluationEnvironment().add("self", contextValue);
            implicitContextVariableName = this.addContextVariableFor(contextValue);
        }
        this.context.openNested();
        if (invocation.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getBefore());
        }
        if ((source = this.getEvaluationEnvironment().getValueOf("self")) instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        try {
            result = this.getVisitor().visitExpression((OCLExpression)actualTemplate);
            this.delegateAppend(this.toString(result), (Block)actualTemplate, this.lastEObjectSelfValue, false);
        }
        finally {
            i = 0;
            ** while (i < actualTemplate.getParameter().size())
        }
lbl-1000:
        // 1 sources

        {
            param = (Variable)actualTemplate.getParameter().get(i);
            param.setInitExpression(null);
            this.getEvaluationEnvironment().remove(param.getName());
            this.getEvaluationEnvironment().remove("temporaryInvocationVariable$" + i);
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        if (actualTemplate.getParameter().size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        if (invocation.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getAfter());
        }
        return this.context.closeContext();
    }

    public Object visitExpression(OCLExpression<C> expression) {
        Object result;
        block30: {
            result = null;
            EObject debugInput = null;
            ASTFragment astFragment = null;
            if (this.context.getProgressMonitor().isCanceled()) {
                this.cancel(astFragment, debugInput, result);
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                Object name;
                debugInput = this.lastEObjectSelfValue;
                astFragment = new ASTFragment(expression);
                if (debugInput != null && debugInput.eClass().getEStructuralFeature("name") != null && (name = debugInput.eGet(debugInput.eClass().getEStructuralFeature("name"))) instanceof String) {
                    astFragment.setEObjectNameFilter((String)name);
                }
                debug.startDebug(astFragment);
                debug.stepDebugInput(astFragment, debugInput);
            }
            if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                profile.start(expression);
                profile.loop(this.lastEObjectSelfValue);
            }
            boolean hasInit = expression instanceof Block && ((Block)expression).getInit() != null;
            try {
                if (hasInit) {
                    this.visitAcceleoInitSection(((Block)expression).getInit());
                }
                boolean fireEvents = this.fireGenerationEvent;
                if (expression == this.lastSourceExpression) {
                    this.fireGenerationEvent = false;
                }
                result = this.switchExpression((OCLExpression<C>)expression);
                this.fireGenerationEvent = fireEvents;
                if (expression == this.lastSourceExpression) {
                    this.lastSourceExpressionResult = result;
                }
                if (this.shouldGenerateText((EReference)expression.eContainingFeature())) {
                    Object source = null;
                    EObject generatedBlock = expression;
                    while (!(generatedBlock instanceof Block)) {
                        generatedBlock = generatedBlock.eContainer();
                    }
                    if (this.lastSourceExpressionResult == null) {
                        source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    } else {
                        source = this.lastSourceExpressionResult;
                        this.lastSourceExpressionResult = null;
                    }
                    if (source instanceof EObject) {
                        this.lastEObjectSelfValue = (EObject)source;
                    }
                    if (result != null) {
                        boolean fireEvent = this.fireGenerationEvent && !(expression instanceof TemplateInvocation) && !(expression instanceof Template);
                        this.delegateAppend(this.toString(result), (Block)generatedBlock, this.lastEObjectSelfValue, fireEvent);
                    }
                }
            }
            catch (AcceleoEvaluationException e) {
                AcceleoEnginePlugin.log(e, false);
                if (debug != null && !(expression instanceof StringLiteralExp)) {
                    debug.stepDebugOutput(astFragment, debugInput, result);
                    debug.endDebug(astFragment);
                }
                if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                    profile.stop();
                }
                if (hasInit) {
                    this.restoreInitVariables(((Block)expression).getInit());
                }
                break block30;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        this.context.dispose();
                    }
                    catch (AcceleoEvaluationException acceleoEvaluationException) {}
                    throw e;
                }
                catch (Throwable throwable) {
                    if (debug != null && !(expression instanceof StringLiteralExp)) {
                        debug.stepDebugOutput(astFragment, debugInput, result);
                        debug.endDebug(astFragment);
                    }
                    if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                        profile.stop();
                    }
                    if (hasInit) {
                        this.restoreInitVariables(((Block)expression).getInit());
                    }
                    throw throwable;
                }
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                debug.stepDebugOutput(astFragment, debugInput, result);
                debug.endDebug(astFragment);
            }
            if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                profile.stop();
            }
            if (hasInit) {
                this.restoreInitVariables(((Block)expression).getInit());
            }
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return this.getDelegate().visitOperationCallExp(callExp);
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return this.getDelegate().visitPropertyCallExp(callExp);
    }

    void setVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratingVisitor) {
        this.visitor = decoratingVisitor;
    }

    protected final AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getAcceleoVisitor() {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return (AcceleoEvaluationVisitorDecorator)this.getVisitor();
        }
        return null;
    }

    protected final EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getVisitor() {
        return this.visitor;
    }

    private String addContextVariableFor(Object contextValue) {
        String variableName = "context" + this.currentContextIndex++;
        while (this.getEvaluationEnvironment().getValueOf(variableName) != null) {
            variableName = "context" + this.currentContextIndex++;
        }
        this.getEvaluationEnvironment().add(variableName, contextValue);
        return variableName;
    }

    private void cancel(ASTFragment astFragment, EObject debugInput, Object result) {
        if (debug != null) {
            debug.stepDebugOutput(astFragment, debugInput, result);
            debug.endDebug(astFragment);
            debug = null;
        }
        this.context.dispose();
        throw new AcceleoEvaluationCancelledException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CancelException"));
    }

    private void delegateAppend(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().append(string, sourceBlock, source, fireEvent);
        } else {
            this.append(string, sourceBlock, source, fireEvent);
        }
    }

    private void delegateCreateFileWriter(String filePath, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().createFileWriter(this.context.getFileFor(filePath), fileBlock, source, appendMode, charset);
        } else {
            this.createFileWriter(this.context.getFileFor(filePath), fileBlock, source, appendMode, charset);
        }
    }

    private void evaluateGuards(List<Template> candidates, List<Variable> arguments) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        AcceleoEvaluationException exception = null;
        for (Template candidate : new ArrayList<Template>(candidates)) {
            int i = 0;
            while (i < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i);
                VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)arguments.get(i));
                param.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)param);
                if (i == 0) {
                    Object newContext = this.getEvaluationEnvironment().getValueOf(param.getName());
                    this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, newContext);
                }
                ++i;
            }
            Object guardValue = candidate.getGuard() == null ? Boolean.TRUE : this.getVisitor().visitExpression((OCLExpression)candidate.getGuard());
            int i2 = 0;
            while (i2 < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i2);
                param.setInitExpression(null);
                this.getEvaluationEnvironment().remove(param.getName());
                ++i2;
            }
            if (candidate.getParameter().size() > 0) {
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
            if (this.isInvalid(guardValue)) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, candidate.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)candidate)).getName(), candidate, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), candidate.getGuard()));
                exception.fillInStackTrace();
                candidates.remove(candidate);
                continue;
            }
            if (guardValue != null && ((Boolean)guardValue).booleanValue()) continue;
            candidates.remove(candidate);
        }
        if (candidates.size() == 0 && exception != null) {
            throw exception;
        }
        this.fireGenerationEvent = fireEvents;
    }

    private AcceleoEnvironment getAcceleoEnvironment() {
        return (AcceleoEnvironment)this.getEnvironment();
    }

    private boolean isInvalid(Object value) {
        return value == this.invalid;
    }

    private boolean isUndefined(Object value) {
        return value == null || value == this.invalid;
    }

    private Template prepareInvocation(TemplateInvocation invocation) {
        Template actualTemplate;
        Template template = invocation.getDefinition();
        ArrayList<Variable> temporaryArgVars = new ArrayList<Variable>(invocation.getArgument().size());
        if (invocation.isSuper()) {
            Template containingTemplate = (Template)invocation.eContainer();
            actualTemplate = containingTemplate.eContainer() instanceof TemplateInvocation ? ((TemplateInvocation)containingTemplate.eContainer()).getDefinition() : (Template)template.getOverrides().get(0);
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < actualTemplate.getParameter().size()) {
                Variable var = (Variable)actualTemplate.getParameter().get(i);
                VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)containingTemplate.getParameter().get(i));
                var.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
        } else {
            ArrayList<Object> argValues = new ArrayList<Object>();
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < invocation.getArgument().size()) {
                Variable tempVar = EcoreFactory.eINSTANCE.createVariable();
                tempVar.setName(TEMPORARY_INVOCATION_ARG_PREFIX + i);
                tempVar.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
                temporaryArgVars.add(tempVar);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)tempVar);
                Object argValue = this.getEvaluationEnvironment().getValueOf(tempVar.getName());
                if (this.isInvalid(argValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", invocation.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName(), invocation, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), invocation.getArgument().get(i)));
                    exception.fillInStackTrace();
                    int j = 0;
                    while (j <= i) {
                        this.getEvaluationEnvironment().remove(((org.eclipse.ocl.ecore.OCLExpression)invocation.getArgument().get(j)).getName());
                        ++j;
                    }
                    throw exception;
                }
                argValues.add(this.getEvaluationEnvironment().getValueOf(tempVar.getName()));
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
            List<Template> applicableCandidates = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getAllCandidates((Module)EcoreUtil.getRootContainer((EObject)invocation), template, argValues);
            this.evaluateGuards(applicableCandidates, temporaryArgVars);
            if (applicableCandidates.size() > 0) {
                actualTemplate = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getMostSpecificTemplate(applicableCandidates, argValues);
                int i2 = 0;
                while (i2 < actualTemplate.getParameter().size()) {
                    Variable var = (Variable)actualTemplate.getParameter().get(i2);
                    VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                    init.setReferredVariable((org.eclipse.ocl.expressions.Variable)temporaryArgVars.get(i2));
                    var.setInitExpression((OCLExpression)init);
                    this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                    ++i2;
                }
            } else {
                actualTemplate = MtlFactory.eINSTANCE.createTemplate();
            }
        }
        return actualTemplate;
    }

    private boolean profileExpression(OCLExpression<C> expression) {
        return !(expression instanceof StringLiteralExp);
    }

    private void restoreInitVariables(InitSection init) {
        for (Variable var : init.getVariable()) {
            this.getEvaluationEnvironment().remove(var.getName());
        }
    }

    private boolean shouldGenerateText(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }

    private Object switchExpression(OCLExpression<C> expression) {
        Object result;
        if (expression == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UnresolvedCompilationError"));
        }
        AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> delegate = this.getAcceleoVisitor();
        if (expression instanceof Template) {
            result = delegate != null ? delegate.visitAcceleoTemplate((Template)expression) : this.visitAcceleoTemplate((Template)expression);
        } else if (expression instanceof IfBlock) {
            if (delegate != null) {
                delegate.visitAcceleoIfBlock((IfBlock)expression);
            } else {
                this.visitAcceleoIfBlock((IfBlock)expression);
            }
            result = "";
        } else if (expression instanceof ForBlock) {
            if (delegate != null) {
                delegate.visitAcceleoForBlock((ForBlock)expression);
            } else {
                this.visitAcceleoForBlock((ForBlock)expression);
            }
            result = "";
        } else if (expression instanceof FileBlock) {
            if (delegate != null) {
                delegate.visitAcceleoFileBlock((FileBlock)expression);
            } else {
                this.visitAcceleoFileBlock((FileBlock)expression);
            }
            result = "";
        } else if (expression instanceof TemplateInvocation) {
            result = delegate != null ? delegate.visitAcceleoTemplateInvocation((TemplateInvocation)expression) : this.visitAcceleoTemplateInvocation((TemplateInvocation)expression);
        } else if (expression instanceof QueryInvocation) {
            result = delegate != null ? delegate.visitAcceleoQueryInvocation((QueryInvocation)expression) : this.visitAcceleoQueryInvocation((QueryInvocation)expression);
        } else if (expression instanceof LetBlock) {
            if (delegate != null) {
                delegate.visitAcceleoLetBlock((LetBlock)expression);
            } else {
                this.visitAcceleoLetBlock((LetBlock)expression);
            }
            result = "";
        } else if (expression instanceof ProtectedAreaBlock) {
            if (delegate != null) {
                delegate.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            } else {
                this.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            }
            result = "";
        } else {
            result = super.visitExpression(expression);
        }
        return result;
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterInitExpression
    extends OCLExpressionImpl {
        private final OCLExpression<C> referredExpression;

        public ParameterInitExpression(OCLExpression<C> expession) {
            this.referredExpression = expession;
        }

        public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
            return (T)this.referredExpression.accept(v);
        }
    }
}

