/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.internal.utils.AcceleoEngineRegistry;
import org.eclipse.acceleo.engine.internal.utils.DefaultEngineSelector;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoService {
    private static final List<IAcceleoTextGenerationListener> STATIC_LISTENERS = new ArrayList<IAcceleoTextGenerationListener>();
    private static final String TEMPLATE_CALL_NPE = AcceleoEngineMessages.getString("AcceleoService.NullArguments");
    private IAcceleoEngine generationEngine;
    private final IAcceleoGenerationStrategy strategy;

    public AcceleoService() {
        this(null);
    }

    public AcceleoService(IAcceleoGenerationStrategy generationStrategy) {
        this.strategy = generationStrategy == null ? new DefaultStrategy() : generationStrategy;
        this.createEngine();
    }

    public static void addStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.add(listener);
    }

    public static void removeStaticListener(IAcceleoTextGenerationListener listener) {
        STATIC_LISTENERS.remove(listener);
    }

    public void addListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.addListener(listener);
    }

    public void addProperties(Map<String, String> customProperties) {
        this.generationEngine.addProperties(customProperties);
    }

    public void addPropertiesFile(File propertiesFile) throws IOException {
        if (propertiesFile.exists()) {
            this.generationEngine.addProperties(propertiesFile);
        }
    }

    public void addPropertiesFile(String propertiesFilePath) throws IOException {
        File propertiesFile = propertiesFilePath.startsWith("platform:/") ? AcceleoWorkspaceUtil.INSTANCE.getWorkspaceFile(propertiesFilePath) : (propertiesFilePath.startsWith("file:/") ? new File(propertiesFilePath.substring(6)) : new File(propertiesFilePath));
        this.addPropertiesFile(propertiesFile);
    }

    public void dispose() {
        this.generationEngine.reset();
    }

    public Map<String, String> doGenerate(Map<Module, Set<String>> templates, EObject model, File generationRoot, Monitor monitor) {
        if (templates == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        HashMap templateTypes = new HashMap();
        for (Map.Entry<Module, Set<String>> entry : templates.entrySet()) {
            for (String string : entry.getValue()) {
                Template template = this.findTemplate(entry.getKey(), string, 1);
                EClassifier templateType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
                if (templateTypes.containsKey(templateType)) {
                    ((Set)templateTypes.get(templateType)).add(template);
                    continue;
                }
                HashSet<Template> temp = new HashSet<Template>();
                temp.add(template);
                templateTypes.put(templateType, temp);
            }
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        arguments.add(model);
        for (Map.Entry entry : templateTypes.entrySet()) {
            if (!((EClassifier)entry.getKey()).isInstance((Object)model)) continue;
            for (Template template : (Set)entry.getValue()) {
                previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
            }
        }
        TreeIterator treeIterator = model.eAllContents();
        while (treeIterator.hasNext()) {
            EObject potentialTarget = (EObject)treeIterator.next();
            for (Map.Entry entry : templateTypes.entrySet()) {
                if (!((EClassifier)entry.getKey()).isInstance((Object)potentialTarget)) continue;
                arguments.clear();
                arguments.add(potentialTarget);
                for (Template template : (Set)entry.getValue()) {
                    previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
                }
            }
        }
        return previewResult;
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, File generationRoot, Monitor monitor) {
        return this.doGenerate(this.findTemplate(module, templateName, 1), model, generationRoot, monitor);
    }

    public Map<String, String> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        if (model == null || arguments == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        Template template = this.findTemplate(module, templateName, arguments.size() + 1);
        HashMap<String, String> previewResult = new HashMap<String, String>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        if (argumentType.isInstance((Object)model)) {
            ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
            actualArguments.add(model);
            actualArguments.addAll(arguments);
            previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
        }
        TreeIterator targetElements = model.eAllContents();
        while (targetElements.hasNext()) {
            EObject potentialTarget = (EObject)targetElements.next();
            if (!argumentType.isInstance((Object)potentialTarget)) continue;
            ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
            actualArguments.add(potentialTarget);
            actualArguments.addAll(arguments);
            previewResult.putAll(this.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
        }
        return previewResult;
    }

    public Map<String, String> doGenerate(Template template, EObject model, File generationRoot, Monitor monitor) {
        if (template == null || model == null || !(this.strategy instanceof PreviewStrategy) && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != 1) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.VoidArguments"));
        }
        HashMap<String, String> previewResult = new HashMap<String, String>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        if (argumentType.isInstance((Object)model)) {
            arguments.add(model);
            previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
        }
        TreeIterator targetElements = model.eAllContents();
        while (targetElements.hasNext()) {
            EObject potentialTarget = (EObject)targetElements.next();
            if (!argumentType.isInstance((Object)potentialTarget)) continue;
            arguments.clear();
            arguments.add(potentialTarget);
            previewResult.putAll(this.doGenerateTemplate(template, arguments, generationRoot, monitor));
        }
        return previewResult;
    }

    public Map<String, String> doGenerateTemplate(Module module, String templateName, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        return this.doGenerateTemplate(this.findTemplate(module, templateName, arguments), arguments, generationRoot, monitor);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        var6_5 = AcceleoService.STATIC_LISTENERS.iterator();
        while (var6_5.hasNext()) {
            listener = var6_5.next();
            this.generationEngine.addListener(listener);
        }
        try {
            var6_5 = this.generationEngine.evaluate(template, arguments, generationRoot, this.strategy, monitor);
            return var6_5;
        }
        finally {
            ** for (listener : AcceleoService.STATIC_LISTENERS)
        }
lbl-1000:
        // 1 sources

        {
            this.generationEngine.removeListener(listener);
            continue;
        }
lbl13:
        // 1 sources

        return var6_5;
    }

    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.generationEngine.removeListener(listener);
    }

    public void removeProperties(Set<String> customPropertyKeys) {
        this.generationEngine.removeCustomProperties(customPropertyKeys);
    }

    public void removePropertiesFile(File propertiesFile) {
        this.generationEngine.removeProperties(propertiesFile);
    }

    public void removePropertiesFile(String propertiesFilePath) {
        try {
            File propertiesFile = propertiesFilePath.startsWith("platform:/") ? AcceleoWorkspaceUtil.INSTANCE.getWorkspaceFile(propertiesFilePath) : new File(propertiesFilePath);
            this.generationEngine.removeProperties(propertiesFile);
        }
        catch (IOException iOException) {}
    }

    public void removeProperty(String customPropertyKey) {
        HashSet<String> properties = new HashSet<String>();
        properties.add(customPropertyKey);
        this.generationEngine.removeCustomProperties(properties);
    }

    private void createEngine() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.generationEngine = new DefaultEngineSelector().selectEngine(AcceleoEngineRegistry.getRegisteredCreators());
        }
        if (this.generationEngine == null) {
            this.generationEngine = new AcceleoEngine();
        }
    }

    private Template findTemplate(Module module, String templateName, int argumentCount) {
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != argumentCount) continue;
            return template;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.UndefinedTemplate", templateName, module.getName()));
    }

    private Template findTemplate(Module module, String templateName, List<? extends Object> arguments) {
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != arguments.size()) continue;
            boolean parameterMatch = true;
            int i = 0;
            while (i < template.getParameter().size()) {
                if (!((EClassifier)((Variable)template.getParameter().get(i)).getType()).isInstance(arguments.get(i))) {
                    parameterMatch = false;
                }
                ++i;
            }
            if (!parameterMatch) continue;
            return template;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.UndefinedTemplate", templateName, module.getName()));
    }
}

