/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.runner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoContent;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAntCallWriter;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAntWriter;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableJavaWriter;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRunnableAcceleoOperation
implements IWorkspaceRunnable {
    private AcceleoProject acceleoProject;
    private List<IFile> files;

    public CreateRunnableAcceleoOperation(AcceleoProject acceleoProject, List<IFile> files) {
        this.acceleoProject = acceleoProject;
        this.files = files;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        block14: {
            try {
                filesIt = this.files.iterator();
                if (!filesIt.hasNext()) break block14;
                resolvedClasspath = new ArrayList<String>();
                entries = this.acceleoProject.getResolvedClasspath().iterator();
                eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                eclipseHome = new Path(Platform.getInstallLocation().getURL().getPath());
                while (entries.hasNext()) {
                    path = entries.next();
                    if (eclipseWorkspace.isPrefixOf(path)) {
                        resolvedClasspath.add("${ECLIPSE_WORKSPACE}/" + path.toString().substring(eclipseWorkspace.toString().length()));
                        continue;
                    }
                    if (!eclipseHome.isPrefixOf(path)) continue;
                    resolvedClasspath.add("${ECLIPSE_HOME}/" + path.toString().substring(eclipseHome.toString().length()));
                }
                while (filesIt.hasNext()) {
                    fileAcceleo = filesIt.next();
                    packageName = this.acceleoProject.getPackageName(fileAcceleo);
                    manifest = fileAcceleo.getProject().getFile("/META-INF/MANIFEST.MF");
                    if (manifest.exists() && FileContent.getFileContent((File)manifest.getLocation().toFile()).indexOf(packageName) == -1) {
                        this.reportError(fileAcceleo, 0, 0, 0, AcceleoUIMessages.getString("CreateRunnableAcceleoOperation.MissingExport", new Object[]{packageName}));
                    }
                    moduleURI = URI.createPlatformResourceURI((String)this.acceleoProject.getOutputFilePath(fileAcceleo).toString(), (boolean)true);
                    resourceSet = new ResourceSetImpl();
                    try {
                        this.registerPackages((ResourceSet)resourceSet);
                        packages = new ArrayList<String>();
                        module = ModelUtils.load((URI)moduleURI, (ResourceSet)resourceSet);
                        if (module instanceof Module) {
                            typedModelIt = ((Module)module).getInput().iterator();
                            while (typedModelIt.hasNext()) {
                                for (EPackage ePackage : ((TypedModel)typedModelIt.next()).getTakesTypesFrom()) {
                                    mClass = this.getMetamodelPackageClass(ePackage);
                                    if (mClass == null || packages.contains(mClass)) continue;
                                    packages.add(mClass);
                                }
                            }
                        }
                        classShortName = new Path(String.valueOf(Character.toUpperCase(fileAcceleo.getName().charAt(0))) + fileAcceleo.getName().substring(1)).removeFileExtension().lastSegment();
                        mainTemplateNames = new ArrayList<String>();
                        this.computesMainTemplateNames(mainTemplateNames, module);
                        if (mainTemplateNames.size() <= 0) ** break block15
                        arg = new CreateRunnableAcceleoContent(fileAcceleo.getProject().getName(), packageName, classShortName, new Path(fileAcceleo.getName()).removeFileExtension().lastSegment(), mainTemplateNames, packages, resolvedClasspath);
                        javaWriter = new CreateRunnableJavaWriter();
                        javaText = javaWriter.generate(arg);
                        javaFile = fileAcceleo.getParent().getFile(new Path(classShortName).addFileExtension("java"));
                        this.createFile(javaFile, javaText, monitor);
                        antFolder = fileAcceleo.getProject().getFolder("tasks");
                        if (antFolder.exists()) {
                            antWriter = new CreateRunnableAntWriter();
                            antText = antWriter.generate(arg);
                            antFile = antFolder.getFile(new Path(fileAcceleo.getName()).removeFileExtension().addFileExtension("xml"));
                            this.createFile(antFile, antText, monitor);
                            antCallWriter = new CreateRunnableAntCallWriter();
                            antCallText = antCallWriter.generate(arg);
                            antCallFile = antFolder.getFile(new Path(fileAcceleo.getName()).removeFileExtension().addFileExtension("readme"));
                            this.createFile(antCallFile, antCallText, monitor);
                        }
                        break block16;
                    }
                    finally {
                        resources = resourceSet.getResources().iterator();
                        if (true) ** GOTO lbl70
                    }
                    {
                        block16: {
                        }
                    }
                    do {
                        ((Resource)resources.next()).unload();
lbl70:
                        // 2 sources

                    } while (resources.hasNext());
                }
            }
            catch (IOException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
    }

    private String getMetamodelPackageClass(EPackage metamodel) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] members = extension.getConfigurationElements();
                int j = 0;
                while (j < members.length) {
                    String mClass;
                    IConfigurationElement member = members[j];
                    String mURI = member.getAttribute("uri");
                    if (mURI != null && mURI.equals(metamodel.getNsURI()) && (mClass = member.getAttribute("class")) != null) {
                        return mClass;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private void computesMainTemplateNames(List<String> mainTemplateNames, EObject eObject) {
        if (eObject instanceof Template) {
            Template eTemplate = (Template)eObject;
            if (eTemplate.isMain() && !mainTemplateNames.contains(eTemplate.getName())) {
                mainTemplateNames.add(eTemplate.getName());
            }
        } else if (eObject != null) {
            for (EObject eContent : eObject.eContents()) {
                this.computesMainTemplateNames(mainTemplateNames, eContent);
            }
        }
    }

    private void createFile(IFile newFile, String content, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException {
        String oldText;
        boolean update;
        IFile file = newFile;
        String text = content;
        if (file.exists() && "java".equals(file.getFileExtension())) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            ASTFacadeHelper astFacadeHelper = new ASTFacadeHelper();
            model.initialize((FacadeHelper)astFacadeHelper, jmergeFile);
            if (model.canMerge()) {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(text));
                try {
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(file.getLocation().toFile())));
                    jMerger.merge();
                    text = jMerger.getTargetCompilationUnit().getContents();
                }
                catch (FileNotFoundException e) {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                }
            } else {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("CreateRunnableAcceleoOperation.MergerFailure"), null));
            }
        }
        if (!file.exists() && file.getParent().exists()) {
            IResource[] members = file.getParent().members(1);
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile && file.getName().toLowerCase().equals(members[i].getName().toLowerCase())) {
                    file = (IFile)members[i];
                    break;
                }
                ++i;
            }
        }
        if (update = !file.exists() ? true : !text.equals(oldText = FileContent.getFileContent((File)file.getLocation().toFile()).toString()) && oldText.contains("@generated")) {
            ByteArrayInputStream javaStream = new ByteArrayInputStream(text.getBytes("UTF8"));
            if (!file.exists()) {
                file.create((InputStream)javaStream, true, monitor);
            } else {
                file.setContents((InputStream)javaStream, true, false, monitor);
            }
        }
    }

    private void reportError(IFile file, int line, int posBegin, int posEnd, String message) throws CoreException {
        IMarker m = file.createMarker("org.eclipse.acceleo.ide.ui.problem");
        m.setAttribute("lineNumber", line);
        m.setAttribute("charStart", posBegin);
        m.setAttribute("charEnd", posEnd);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
    }
}

