/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaServicesWrapperStrategy
implements IAcceleoExampleStrategy {
    @Override
    public String getDescription() {
        return AcceleoUIMessages.getString("JavaServicesWrapperStrategy.Description");
    }

    @Override
    public String getInitialFileNameFilter() {
        return "*.java";
    }

    @Override
    public boolean forceMetamodelURI() {
        return false;
    }

    @Override
    public boolean forceHasFile() {
        return true;
    }

    @Override
    public boolean forceHasMain() {
        return true;
    }

    @Override
    public boolean forceMetamodelType() {
        return true;
    }

    @Override
    public String getContent(IFile exampleFile, String moduleName, boolean templateHasFileBlock, boolean templateIsMain, String metamodelURI, String metamodelFileType) {
        StringBuilder buffer = new StringBuilder("");
        buffer.append("[module " + moduleName + "('");
        StringTokenizer st = new StringTokenizer(metamodelURI, ",");
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken().trim());
            if (!st.hasMoreTokens()) continue;
            buffer.append("', '");
        }
        buffer.append("')/]\n\n");
        if (exampleFile != null && exampleFile.exists()) {
            buffer.append(this.createWrapper(exampleFile));
        }
        return buffer.toString();
    }

    private String createWrapper(IFile exampleFile) {
        StringBuilder buffer = new StringBuilder();
        IJavaElement javaElement = JavaCore.create((IFile)exampleFile);
        if (javaElement instanceof ICompilationUnit) {
            IType[] types;
            ICompilationUnit classFile = (ICompilationUnit)javaElement;
            try {
                types = classFile.getTypes();
            }
            catch (JavaModelException javaModelException) {
                types = new IType[]{};
            }
            int i = 0;
            while (i < types.length) {
                String typeQualifiedName = types[i].getFullyQualifiedName();
                AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(exampleFile.getProject());
                try {
                    Class javaClass = AcceleoWorkspaceUtil.INSTANCE.getClass(typeQualifiedName, false);
                    if (javaClass != null) {
                        Method[] javaMethods = javaClass.getDeclaredMethods();
                        int j = 0;
                        while (j < javaMethods.length) {
                            Method javaMethod = javaMethods[j];
                            Class<?>[] javaParameters = javaMethod.getParameterTypes();
                            this.createQuery(buffer, typeQualifiedName, javaMethod, javaParameters);
                            ++j;
                        }
                    }
                }
                finally {
                    AcceleoWorkspaceUtil.INSTANCE.reset();
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private void createQuery(StringBuilder buffer, String typeQualifiedName, Method javaMethod, Class<?>[] javaParameters) {
        buffer.append("[query public ");
        buffer.append(javaMethod.getName());
        buffer.append("(");
        int i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append("arg");
            buffer.append(i);
            buffer.append(" : ");
            buffer.append(this.getShortName(javaParameters[i]));
            ++i;
        }
        buffer.append(") : ");
        buffer.append(this.getShortName(javaMethod.getReturnType()));
        buffer.append("\n\t= invoke('");
        buffer.append(typeQualifiedName);
        buffer.append("', '");
        buffer.append(javaMethod.getName());
        buffer.append("(");
        i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(javaParameters[i].getName());
            ++i;
        }
        buffer.append(")', Sequence{");
        i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("arg");
            buffer.append(i);
            ++i;
        }
        buffer.append("}) /]\n\n");
    }

    private String getShortName(Class<?> javaClass) {
        if (javaClass != null) {
            String type = javaClass.getName();
            int lastDot = type.lastIndexOf(46);
            if (lastDot > -1) {
                type = type.substring(lastDot + 1);
            }
            return type;
        }
        return "void";
    }
}

