/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AbstractAcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.internal.traceability.environment.AcceleoTraceabilityEnvironmentFactory;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.traceability.TraceabilityFactory;
import org.eclipse.acceleo.traceability.TraceabilityModel;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;

public class AcceleoTraceabilityEngine
extends AcceleoEngine {
    private TraceabilityModel evaluationTrace = TraceabilityFactory.eINSTANCE.createTraceabilityModel();
    private File generationRoot;

    protected AbstractAcceleoEnvironmentFactory createEnvironmentFactory(File genRoot, Module rootModule, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        this.generationRoot = genRoot;
        ArrayList<IAcceleoTextGenerationListener> listenersCopy = new ArrayList<IAcceleoTextGenerationListener>(this.listeners);
        ArrayList<Properties> propertiesCopy = new ArrayList<Properties>(this.loadedProperties.values());
        propertiesCopy.add(0, this.customProperties);
        return new AcceleoTraceabilityEnvironmentFactory(genRoot, rootModule, listenersCopy, propertiesCopy, strategy, monitor, this.evaluationTrace);
    }

    protected void fireGenerationEnd() {
        if (!this.notifyOnGenerationEnd) {
            return;
        }
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            if (!listener.listensToGenerationEnd()) continue;
            listener.generationEnd(new AcceleoTextGenerationEvent(null, null, null, (EObject)this.evaluationTrace));
        }
    }

    public void reset() {
        super.reset();
        this.generationRoot = null;
        this.evaluationTrace = null;
    }
}

