/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.strategy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.generation.strategy.AbstractGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.generation.writers.AcceleoWorkspaceFileWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceAwareStrategy
extends AbstractGenerationStrategy {
    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags) throws IOException {
        return this.createWriterFor(file, previous, appendMode, hasJMergeTags, null);
    }

    @Override
    public AbstractAcceleoWriter createWriterFor(File file, AbstractAcceleoWriter previous, boolean appendMode, boolean hasJMergeTags, String charset) throws IOException {
        AcceleoWorkspaceFileWriter writer;
        boolean fileExisted = file.exists();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                writer = new AcceleoWorkspaceFileWriter(file, appendMode, hasJMergeTags, charset);
            } else {
                String message = AcceleoEngineMessages.getString("AcceleoGenerationStrategy.UnsupportedCharset", charset);
                AcceleoEnginePlugin.log(message, false);
                writer = new AcceleoWorkspaceFileWriter(file, appendMode, hasJMergeTags);
            }
        } else {
            writer = new AcceleoWorkspaceFileWriter(file, appendMode, hasJMergeTags);
        }
        if (appendMode && fileExisted) {
            writer.append(LINE_SEPARATOR);
        }
        return writer;
    }

    @Override
    public void flushWriters(Map<String, Writer> preview) throws IOException {
        HashMap<IFile, Writer> needsValidation = new HashMap<IFile, Writer>();
        for (Map.Entry<String, Writer> entry : preview.entrySet()) {
            File targetFile = new File(entry.getKey());
            IFile workspaceFile = AcceleoWorkspaceUtil.INSTANCE.getWorkspaceFile(targetFile);
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FolderCreationError", targetFile.getParentFile()));
            }
            if (workspaceFile == null || !targetFile.exists() || !targetFile.canRead()) {
                entry.getValue().close();
                continue;
            }
            if (!((AcceleoWorkspaceFileWriter)entry.getValue()).hasChanged()) continue;
            needsValidation.put(workspaceFile, entry.getValue());
        }
        IFile[] validateFiles = needsValidation.keySet().toArray(new IFile[needsValidation.size()]);
        IStatus validationStatus = ResourcesPlugin.getWorkspace().validateEdit(validateFiles, IWorkspace.VALIDATE_PROMPT);
        if (validationStatus.isOK()) {
            for (Writer writer : needsValidation.values()) {
                writer.close();
            }
        }
    }

    @Override
    public Map<String, StringWriter> createLostFiles(Map<String, Map<String, String>> lostCode) {
        ArrayList<IFile> needsValidation = new ArrayList<IFile>();
        HashMap validatedLostFiles = new HashMap();
        for (Map.Entry<String, Map<String, String>> entry : lostCode.entrySet()) {
            File targetFile = new File(entry.getKey().concat(".lost"));
            IFile workspaceFile = AcceleoWorkspaceUtil.INSTANCE.getWorkspaceFile(targetFile);
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FolderCreationError", targetFile.getParentFile()));
            }
            if (workspaceFile == null || !targetFile.exists() || !targetFile.canRead()) {
                this.internalCreateLostFile(entry.getKey(), entry.getValue());
                continue;
            }
            needsValidation.add(workspaceFile);
        }
        IFile[] validateFiles = needsValidation.toArray(new IFile[needsValidation.size()]);
        IStatus validationStatus = ResourcesPlugin.getWorkspace().validateEdit(validateFiles, IWorkspace.VALIDATE_PROMPT);
        if (validationStatus.isOK()) {
            for (Map.Entry entry : validatedLostFiles.entrySet()) {
                this.internalCreateLostFile((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        return null;
    }

    private void internalCreateLostFile(String originalPath, Map<String, String> lostAreas) {
        block13: {
            StringBuilder lostContent = new StringBuilder();
            for (String lostAreaContent : lostAreas.values()) {
                lostContent.append(lostAreaContent);
                lostContent.append(LINE_SEPARATOR);
            }
            Writer writer = null;
            try {
                try {
                    File lostFile = new File(originalPath.concat(".lost"));
                    writer = new BufferedWriter(new FileWriter(lostFile, true));
                    writer.append(LINE_SEPARATOR).append(Calendar.getInstance().getTime().toString()).append(LINE_SEPARATOR);
                    writer.append("================================================================================");
                    writer.append(LINE_SEPARATOR);
                    writer.append(lostContent);
                }
                catch (IOException iOException) {
                    String errorMessage = AcceleoEngineMessages.getString("AcceleoEvaluationContext.LostContent", originalPath, lostContent);
                    AcceleoEnginePlugin.log(errorMessage, false);
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, false);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, false);
                    }
                }
            }
        }
    }
}

