/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class AcceleoBuilderSettings {
    public static final String BUILD_FULL_OMG_COMPLIANCE = "full";
    public static final String BUILD_PRAGMATIC_COMPLIANCE = "pragmatic";
    private static final String BUILD_COMPLIANCE_KEYWORD = "compliance";
    private IProject project;
    private String compliance;

    public AcceleoBuilderSettings(IProject project) {
        this.project = project;
        try {
            Object arg;
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand command = this.getCommand(commands);
            this.compliance = command != null ? (BUILD_FULL_OMG_COMPLIANCE.equals(arg = command.getArguments().get(BUILD_COMPLIANCE_KEYWORD)) ? BUILD_FULL_OMG_COMPLIANCE : BUILD_PRAGMATIC_COMPLIANCE) : BUILD_PRAGMATIC_COMPLIANCE;
        }
        catch (CoreException coreException) {
            this.compliance = BUILD_PRAGMATIC_COMPLIANCE;
        }
    }

    private ICommand getCommand(ICommand[] commands) {
        if (commands != null) {
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.acceleo.ide.ui.acceleoBuilder")) {
                    return commands[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String getCompliance() {
        return this.compliance;
    }

    public void setCompliance(String compliance) {
        this.compliance = compliance;
    }

    public void save() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ICommand command = this.getCommand(commands);
        if (command != null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(BUILD_COMPLIANCE_KEYWORD, this.compliance);
            command.setArguments(args);
            desc.setBuildSpec(commands);
            this.project.setDescription(desc, null);
        }
    }
}

