/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoOccurrencesFinderJob
extends Job {
    public static final String FIND_OCCURENCES_ANNOTATION_TYPE = "org.eclipse.jdt.ui.occurrences";
    private AcceleoEditor editor;
    private ReferencesSearchQuery query;

    public AcceleoOccurrencesFinderJob(AcceleoEditor editor, String name, ReferencesSearchQuery query) {
        super(name);
        this.editor = editor;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ReferencesSearchResult result = (ReferencesSearchResult)this.query.getSearchResult();
        IStatus status = null;
        int origPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (SecurityException securityException) {}
        try {
            status = this.query.run(monitor);
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setPriority(origPriority);
            }
            catch (SecurityException securityException) {}
            throw throwable;
        }
        try {
            Thread.currentThread().setPriority(origPriority);
        }
        catch (SecurityException securityException) {}
        List<Match> list = this.listOfTheOccurencesInTheCurrentFile(result);
        int length = list.size();
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
        int i = 0;
        while (i < length) {
            if (monitor.isCanceled()) {
                status = Status.CANCEL_STATUS;
            }
            if (this.editor.getDocumentProvider() == null || this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput()) == null) {
                status = Status.CANCEL_STATUS;
            }
            if (status == Status.CANCEL_STATUS) {
                return status;
            }
            String description = ((ReferenceEntry)list.get(i).getElement()).getMatch().toString();
            IRegion region = ((ReferenceEntry)list.get(i).getElement()).getRegion();
            Position position = new Position(region.getOffset(), region.getLength());
            annotationMap.put(new Annotation(FIND_OCCURENCES_ANNOTATION_TYPE, false, description), position);
            ++i;
        }
        IAnnotationModel annotationModel = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            for (Map.Entry mapEntry : annotationMap.entrySet()) {
                annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
            }
        }
        return status;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private List<Match> listOfTheOccurencesInTheCurrentFile(AbstractTextSearchResult result) {
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] array = result.getElements();
        int i = 0;
        while (i < array.length) {
            if (((ReferenceEntry)array[i]).getTemplateFile().equals((Object)this.editor.getFile()) && ((ReferenceEntry)array[i]).getRegion() != null) {
                list.add(new Match(array[i], ((ReferenceEntry)array[i]).getRegion().getOffset(), ((ReferenceEntry)array[i]).getRegion().getLength()));
            }
            ++i;
        }
        return list;
    }
}

