/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedTemplate;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameTemplateRefactoring
extends Refactoring {
    private static final String TEMPLATE = "template";
    private static final String NEWNAME = "newName";
    private static final String REFERENCES = "references";
    private String fNewTemplateName;
    private Map<IFile, TextFileChange> fChanges;
    private boolean fUpdateReferences = true;
    private AcceleoPositionedTemplate fTemplate;
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            if (this.fTemplate == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)"No template specified"));
            }
            this.fTemplate.computeOccurrencesOfTemplate();
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            if (this.fUpdateReferences) {
                this.putChangesNotInTheCurrentFile();
            }
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesNotInTheCurrentFile() {
        MultiTextEdit edit = new MultiTextEdit();
        for (Match match : this.fTemplate.getTemplateMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (entry.getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = ((ReferenceEntry)match.getElement()).getTemplateFile();
            TextFileChange tfc = new TextFileChange("Refactoring: Rename Template", file);
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fTemplate.getTemplateName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fTemplate.getTemplateName().length(), this.fNewTemplateName));
            tfc.setEdit((TextEdit)edit);
            tfc.setTextType("mtl");
            this.fChanges.put(file, tfc);
        }
    }

    private void putChangesOfTheCurrentFile() {
        MultiTextEdit edit = new MultiTextEdit();
        for (Match match : this.fTemplate.getTemplateMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (!entry.getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = ((ReferenceEntry)match.getElement()).getTemplateFile();
            TextFileChange tfc = new TextFileChange("Refactoring: Rename Template", file);
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fTemplate.getTemplateName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fTemplate.getTemplateName().length(), this.fNewTemplateName));
            tfc.setEdit((TextEdit)edit);
            tfc.setTextType("mtl");
            this.fChanges.put(file, tfc);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (AcceleoPositionedTemplate.getInput().length == 0) {
            status.merge(RefactoringStatus.createErrorStatus((String)"There are no template in the current file"));
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask("Creating change...", 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String description = "Renaming template " + AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName();
                    String comment = "Renaming template " + AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName() + " with the new name: " + AcceleoRenameTemplateRefactoring.this.fNewTemplateName;
                    arguments.put(AcceleoRenameTemplateRefactoring.TEMPLATE, AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName());
                    arguments.put(AcceleoRenameTemplateRefactoring.NEWNAME, AcceleoRenameTemplateRefactoring.this.fNewTemplateName);
                    arguments.put(AcceleoRenameTemplateRefactoring.REFERENCES, Boolean.valueOf(AcceleoRenameTemplateRefactoring.this.fUpdateReferences).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameTemplateDescriptor("Acceleo Rename Template", description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return "Rename Template";
    }

    public void setTemplate(AcceleoPositionedTemplate currentTemplate) {
        this.fTemplate = currentTemplate;
    }

    public AcceleoPositionedTemplate getTemplate() {
        return this.fTemplate;
    }

    public void setUpdateReferences(boolean selection) {
        this.fUpdateReferences = selection;
    }

    public RefactoringStatus setNewTemplateName(String text) {
        this.fNewTemplateName = text;
        RefactoringStatus status = this.checkTemplateName(this.fNewTemplateName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        RefactoringStatus status = new RefactoringStatus();
        AcceleoPositionedTemplate[] array = AcceleoPositionedTemplate.getInput();
        int i = 0;
        while (i < array.length) {
            if (this.fNewTemplateName.equals(array[i].getTemplateName())) {
                EList listOfParametersOfTheCurrentTemplate = this.fTemplate.getTemplate().getParameter();
                EList listOfParametersOfTheTemplateWithTheSameName = array[i].getTemplate().getParameter();
                if (listOfParametersOfTheCurrentTemplate.size() == listOfParametersOfTheTemplateWithTheSameName.size()) {
                    boolean overloadingError = true;
                    int j = 0;
                    while (j < listOfParametersOfTheCurrentTemplate.size()) {
                        if (!((Variable)listOfParametersOfTheCurrentTemplate.get(j)).getEType().equals(((Variable)listOfParametersOfTheTemplateWithTheSameName.get(j)).getEType())) {
                            overloadingError = false;
                            break;
                        }
                        ++j;
                    }
                    if (overloadingError) {
                        status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.TemplateOverloadingError")));
                    }
                }
            }
            ++i;
        }
        return status;
    }

    private RefactoringStatus checkTemplateName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.InvalidTemplateName")));
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(TEMPLATE);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewTemplateName(value);
        }
        if ((value = arguments.get(REFERENCES)) != null) {
            this.setUpdateReferences(Boolean.valueOf(value));
        }
        return status;
    }
}

