/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPositionedQuery {
    private static AcceleoPositionedQuery[] input;
    private static AcceleoEditor acceleoEditor;
    private Query fQuery;
    private List<Match> fMatches;
    private Match fDefinitionMatch;

    public AcceleoPositionedQuery(Query query) {
        this.fQuery = query;
        this.fMatches = new ArrayList<Match>();
    }

    public static void computeCompleteInput() {
        List<AcceleoPositionedQuery> list = AcceleoPositionedQuery.findAllPositionedQueries(acceleoEditor);
        input = list.toArray(new AcceleoPositionedQuery[list.size()]);
    }

    public static void computePartialInput(Query query) {
        ArrayList<AcceleoPositionedQuery> positionedQueryList = new ArrayList<AcceleoPositionedQuery>();
        Module astModule = acceleoEditor.getContent().getAST();
        EList moduleElementList = astModule.getOwnedModuleElement();
        for (ModuleElement moduleElement : moduleElementList) {
            if (!(moduleElement instanceof Query)) continue;
            positionedQueryList.add(new AcceleoPositionedQuery((Query)moduleElement));
        }
        boolean isInTheList = false;
        for (AcceleoPositionedQuery acceleoPositionedQuery : positionedQueryList) {
            if (!AcceleoPositionedQuery.checkQueryEqual(acceleoPositionedQuery.getQuery(), query)) continue;
            isInTheList = true;
            break;
        }
        if (!isInTheList) {
            positionedQueryList.add(new AcceleoPositionedQuery(query));
        }
        input = positionedQueryList.toArray(new AcceleoPositionedQuery[positionedQueryList.size()]);
    }

    private static boolean checkQueryEqual(Query q1, Query q2) {
        boolean result;
        if (q1 != null && q2 != null) {
            result = q1.getName().equals(q2.getName());
            result = result && q1.getStartPosition() == q2.getStartPosition();
            result = result && q1.getEndPosition() == q2.getEndPosition();
        } else {
            result = false;
        }
        return result;
    }

    public void computeOccurrencesOfQuery() {
        List<Match> list = OpenDeclarationUtils.findOccurrences(acceleoEditor, (EObject)this.fQuery);
        this.setQueryMatches(list);
        for (Match match : list) {
            if (match.getLength() <= this.getQuery().getName().length()) continue;
            this.setQueryDefinitionMatch(match);
        }
    }

    public static AcceleoPositionedQuery[] getInput() {
        return input;
    }

    public Query getQuery() {
        return this.fQuery;
    }

    public String getQueryName() {
        return this.fQuery.getName();
    }

    public void setQueryMatches(List<Match> matches) {
        this.fMatches = matches;
    }

    public List<Match> getQueryMatches() {
        return this.fMatches;
    }

    public void setQueryDefinitionMatch(Match match) {
        this.fDefinitionMatch = match;
    }

    public Match getQueryDefinitionMatch() {
        return this.fDefinitionMatch;
    }

    private static List<AcceleoPositionedQuery> findAllPositionedQueries(AcceleoEditor editor) {
        ArrayList<AcceleoPositionedQuery> positionedQueriesList = new ArrayList<AcceleoPositionedQuery>();
        ArrayList<Query> queryList = new ArrayList<Query>();
        Module astModule = editor.getContent().getAST();
        EList moduleElementList = astModule.getOwnedModuleElement();
        for (ModuleElement moduleElement : moduleElementList) {
            if (!(moduleElement instanceof Query)) continue;
            queryList.add((Query)moduleElement);
        }
        for (Query query : queryList) {
            AcceleoPositionedQuery positionedQuery = new AcceleoPositionedQuery(query);
            List<Match> list = OpenDeclarationUtils.findOccurrences(editor, (EObject)query);
            positionedQuery.setQueryMatches(list);
            for (Match match : list) {
                if (match.getLength() <= query.getName().length()) continue;
                positionedQuery.setQueryDefinitionMatch(match);
            }
            positionedQueriesList.add(positionedQuery);
        }
        return positionedQueriesList;
    }

    public static void setAcceleoEditor(AcceleoEditor editor) {
        acceleoEditor = editor;
    }
}

