/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoHover
implements IAnnotationHover,
ITextHover {
    protected AcceleoEditor editor;

    public AcceleoHover(AcceleoEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverText(sourceViewer.getAnnotationModel(), sourceViewer.getDocument(), lineNumber);
    }

    protected String getHoverText(IAnnotationModel model, IDocument document, int lineNumber) {
        StringBuffer text = null;
        for (Annotation annotation : this.findAnnotations(model, document, lineNumber)) {
            String msg = null;
            if (annotation instanceof MarkerAnnotation) {
                try {
                    msg = (String)((MarkerAnnotation)annotation).getMarker().getAttribute("message");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                }
            }
            if (msg == null) continue;
            if (text == null) {
                text = new StringBuffer(msg);
                continue;
            }
            text.append('\n');
            text.append(msg);
        }
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    private List<Annotation> findAnnotations(IAnnotationModel model, IDocument document, int lineNumber) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel annotationModel = model == null && this.editor != null ? this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput()) : model;
        if (annotationModel != null) {
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                Position position = annotationModel.getPosition(annotation);
                try {
                    if (document == null || document.getLineOfOffset(position.offset) != lineNumber) continue;
                    annotations.add(annotation);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return annotations;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ASTNode astNode;
        if (hoverRegion != null && this.editor != null && this.editor.getContent() != null && (astNode = this.editor.getContent().getASTNode(hoverRegion.getOffset(), hoverRegion.getOffset() + hoverRegion.getLength())) != null) {
            EObject eObject = OpenDeclarationUtils.findDeclarationFromAST(astNode);
            if (eObject instanceof IteratorExp) {
                eObject = OpenDeclarationUtils.findIteratorEOperation(this.editor.getContent().getOCLEnvironment(), (IteratorExp)eObject);
            }
            if (eObject != null) {
                return this.getInfo(eObject);
            }
        }
        return null;
    }

    private String getInfo(EObject eObject) {
        StringBuffer res = new StringBuffer();
        res.append("[");
        res.append(eObject.eClass().getName());
        res.append("]  ");
        if (eObject instanceof Variable) {
            res.append(((Variable)eObject).getName());
            if (((Variable)eObject).getType() != null) {
                res.append(" : ");
                res.append(((EClassifier)((Variable)eObject).getType()).getName());
            }
        } else if (eObject instanceof Module) {
            res.append(((Module)eObject).getName());
        } else if (eObject instanceof ModuleElement) {
            ModuleElement element = (ModuleElement)eObject;
            res.append(element.getName());
            if (element instanceof Template) {
                res.append('(');
                boolean first = true;
                for (Variable iVariable : ((Template)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        res.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    res.append(((EClassifier)iVariable.getType()).getName());
                }
                res.append(')');
            } else if (element instanceof Macro) {
                res.append('(');
                boolean first = true;
                for (Variable iVariable : ((Macro)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        res.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    res.append(((EClassifier)iVariable.getType()).getName());
                }
                res.append(')');
                if (((Macro)element).getType() != null) {
                    res.append(" : ");
                    res.append(((Macro)element).getType().getName());
                }
            } else if (element instanceof Query) {
                res.append('(');
                boolean first = true;
                for (Variable iVariable : ((Query)element).getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        res.append(',');
                    }
                    if (iVariable.getType() == null) continue;
                    res.append(((EClassifier)iVariable.getType()).getName());
                }
                res.append(')');
                if (((Query)element).getType() != null) {
                    res.append(" : ");
                    res.append(((Query)element).getType().getName());
                }
            }
        } else if (eObject instanceof EOperation) {
            EOperation eOperation = (EOperation)eObject;
            res.append(eOperation.getName());
            res.append('(');
            boolean first = true;
            for (EParameter eParameter : eOperation.getEParameters()) {
                if (first) {
                    first = false;
                } else {
                    res.append(',');
                }
                if (eParameter.getEType() == null) continue;
                res.append(eParameter.getEType().getName());
            }
            res.append(')');
            if (eOperation.getEType() != null) {
                res.append(" : ");
                res.append(eOperation.getEType().getName());
            }
        } else if (eObject instanceof EStructuralFeature) {
            res.append(((EStructuralFeature)eObject).getName());
            if (((EStructuralFeature)eObject).getEType() != null) {
                res.append(" : ");
                res.append(((EStructuralFeature)eObject).getEType().getName());
                res.append(" [");
                res.append(((EStructuralFeature)eObject).getLowerBound());
                res.append("..");
                if (((EStructuralFeature)eObject).getUpperBound() == -1) {
                    res.append("*");
                } else {
                    res.append(((EStructuralFeature)eObject).getUpperBound());
                }
                res.append("]");
            }
        } else if (eObject instanceof EClass) {
            res.append(((EClass)eObject).getName());
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (offset > -1) {
            return new Region(offset, 0);
        }
        return null;
    }
}

