/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.views.result.AcceleoResultContent;
import org.eclipse.acceleo.internal.ide.ui.views.result.AcceleoResultFilesFilter;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityContainer;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityElement;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityModel;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityRegion;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTemplate;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.navigator.ResourceNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoResultView
extends ResourceNavigator {
    private static final String RESULT_ACTIVE_REGION_MARKER_ID = "org.eclipse.acceleo.ide.ui.activeRegion";
    private AcceleoResultContent content;
    private IResourceChangeListener resourceChangeListener;
    private ISelectionListener selectionListener;
    private UIJob refreshUIJob;
    private AcceleoResultFilesFilter previewFilesFilter = new AcceleoResultFilesFilter(this);

    public AcceleoResultContent getContent() {
        return this.content;
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new AcceleoPreviewContentProvider());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new AcceleoPreviewLabelProvider());
    }

    private AdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.previewFilesFilter);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.content != null) {
            AcceleoService.removeStaticListener((IAcceleoTextGenerationListener)this.content);
        }
        this.content = new AcceleoResultContent();
        new InstanceScope().getNode("org.eclipse.acceleo.engine").putBoolean("org.eclipse.acceleo.traceability.activation", true);
        AcceleoService.addStaticListener((IAcceleoTextGenerationListener)this.content);
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    AcceleoResultView.this.refresh();
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    IEditorPart editor;
                    IFile file;
                    if (AcceleoResultView.this.getContent() != null && selection instanceof TextSelection && ((TextSelection)selection).getOffset() >= 0 && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (file = (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && editor.getEditorInput() != null ? (IFile)editor.getEditorInput().getAdapter(IFile.class) : null) != null && ((TextSelection)selection).getLength() > 0) {
                        int offset = ((TextSelection)selection).getOffset() + ((TextSelection)selection).getLength() - 1;
                        AcceleoResultView.this.expandElementsAt(file, offset);
                    }
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPostSelectionListener(this.selectionListener);
        }
    }

    private void refresh() {
        if (this.refreshUIJob != null) {
            this.refreshUIJob.cancel();
        }
        this.refreshUIJob = new UIJob("Acceleo"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AcceleoResultView.this.getViewer().refresh();
                return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
            }
        };
        this.refreshUIJob.setPriority(50);
        this.refreshUIJob.setSystem(true);
        this.refreshUIJob.setProgressGroup((IProgressMonitor)new NullProgressMonitor(), 1);
        this.refreshUIJob.schedule(2000L);
        this.refreshUIJob = null;
    }

    private void expandElementsAt(IFile generatedFile, int offset) {
        List<Object> elements = this.getElementsAt(this.getContent().getTargetFile(generatedFile.getLocation().toString()), offset);
        if (elements.size() > 0) {
            Object last = elements.get(elements.size() - 1);
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.setExpandedElements(elements.toArray());
            treeViewer.setSelection((ISelection)new StructuredSelection(elements), true);
            treeViewer.setSelection((ISelection)new StructuredSelection(last), true);
            Widget item = treeViewer.testFindItem(last);
            if (item instanceof TreeItem) {
                ((TreeItem)item).setExpanded(false);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.content != null) {
            AcceleoService.removeStaticListener((IAcceleoTextGenerationListener)this.content);
            this.content = null;
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        if (this.selectionListener != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePostSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        if (event.getSelection() instanceof TreeSelection && ((TreeSelection)event.getSelection()).getFirstElement() instanceof TraceabilityElement) {
            IFile file;
            TraceabilityElement element;
            TraceabilityElement fileElement = element = (TraceabilityElement)((TreeSelection)event.getSelection()).getFirstElement();
            while (fileElement != null && !(fileElement instanceof TraceabilityTargetFile)) {
                fileElement = fileElement.getParent();
            }
            IEditorPart part = null;
            if (fileElement instanceof TraceabilityTargetFile && (file = ((TraceabilityTargetFile)fileElement).getTargetFile()) != null && file.isAccessible()) {
                try {
                    file.deleteMarkers(RESULT_ACTIVE_REGION_MARKER_ID, true, 1);
                    this.reportActiveRegions(file, FileContent.getFileContent((File)file.getLocation().toFile()), element);
                    part = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)file);
                }
                catch (PartInitException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                if (element instanceof TraceabilityRegion) {
                    TraceabilityRegion region = (TraceabilityRegion)element;
                    editor.setHighlightRange(region.getTargetFileOffset(), region.getTargetFileLength(), true);
                } else if (element instanceof TraceabilityTemplate) {
                    int b = this.getMin((TraceabilityTemplate)element);
                    int e = this.getMax((TraceabilityTemplate)element);
                    editor.setHighlightRange(b, e - b, true);
                } else if (element instanceof TraceabilityModel) {
                    int b = this.getMin((TraceabilityModel)element);
                    int e = this.getMax((TraceabilityModel)element);
                    editor.setHighlightRange(b, e - b, true);
                }
            }
        } else {
            super.handleDoubleClick(event);
        }
    }

    private void reportActiveRegions(IFile file, StringBuffer buffer, TraceabilityElement element) throws CoreException {
        if (element instanceof TraceabilityModel) {
            TraceabilityModel model = (TraceabilityModel)element;
            if (model instanceof TraceabilityTemplate || !this.hasDirectlyActiveRegion(model)) {
                for (TraceabilityRegion region : model.getRegions()) {
                    this.reportActiveRegions(file, buffer, region);
                }
                for (TraceabilityModel child : model.getChildren()) {
                    this.reportActiveRegions(file, buffer, child);
                }
            } else {
                for (TraceabilityRegion region : model.getRegions()) {
                    this.reportActiveRegions(file, buffer, region);
                }
                for (TraceabilityModel child : model.getChildren()) {
                    if (!(child instanceof TraceabilityTemplate)) continue;
                    this.reportActiveRegions(file, buffer, child);
                }
            }
        } else if (element instanceof TraceabilityContainer) {
            for (TraceabilityModel child : ((TraceabilityContainer)element).getChildren()) {
                this.reportActiveRegions(file, buffer, child);
            }
        } else if (element instanceof TraceabilityRegion) {
            TraceabilityRegion region = (TraceabilityRegion)element;
            this.reportActiveRegion(file, buffer, region);
        }
    }

    private boolean hasDirectlyActiveRegion(TraceabilityModel model) {
        boolean hasActiveRegion;
        boolean bl = hasActiveRegion = model.getRegions().size() > 0;
        if (!hasActiveRegion) {
            for (TraceabilityModel child : model.getChildren()) {
                if (!(child instanceof TraceabilityTemplate)) continue;
                hasActiveRegion = true;
                break;
            }
        }
        return hasActiveRegion;
    }

    private void reportActiveRegion(IFile file, StringBuffer buffer, TraceabilityRegion region) throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String objectToString = "";
        String featureToString = "";
        String templateToString = "";
        TraceabilityElement current = region.getParent();
        while (current != null) {
            if (featureToString.length() == 0 && current instanceof TraceabilityTemplate && ((TraceabilityTemplate)current).getTemplateElement() instanceof ModuleElement) {
                featureToString = current.toString();
            } else if (templateToString.length() == 0 && current instanceof TraceabilityTemplate && ((TraceabilityTemplate)current).getTemplateElement() instanceof Module) {
                templateToString = current.toString();
            } else if (objectToString.length() == 0 && current instanceof TraceabilityModel && !(current instanceof TraceabilityTemplate)) {
                objectToString = current.toString();
            }
            current = current.getParent();
        }
        map.put("message", AcceleoUIMessages.getString("AcceleoResultView.ActiveRegionMarkerMessage", objectToString, featureToString, templateToString));
        map.put("severity", new Integer(0));
        map.put("priority", new Integer(1));
        int begin = region.getTargetFileOffset();
        int end = begin + region.getTargetFileLength();
        int line = FileContent.lineNumber((StringBuffer)buffer, (int)begin);
        map.put("charStart", new Integer(begin));
        map.put("charEnd", new Integer(end));
        map.put("lineNumber", new Integer(line));
        MarkerUtilities.createMarker((IResource)file, map, (String)RESULT_ACTIVE_REGION_MARKER_ID);
    }

    private int getMin(TraceabilityModel model) {
        int min = 0;
        if (model instanceof TraceabilityTemplate || !this.hasDirectlyActiveRegion(model)) {
            int b;
            for (TraceabilityRegion region : model.getRegions()) {
                b = region.getTargetFileOffset();
                if (b <= -1 || b >= min && min != 0) continue;
                min = b;
            }
            for (TraceabilityModel child : model.getChildren()) {
                b = this.getMin(child);
                if (b <= -1 || b >= min && min != 0) continue;
                min = b;
            }
        } else {
            int b;
            for (TraceabilityRegion region : model.getRegions()) {
                b = region.getTargetFileOffset();
                if (b <= -1 || b >= min && min != 0) continue;
                min = b;
            }
            for (TraceabilityModel child : model.getChildren()) {
                if (!(child instanceof TraceabilityTemplate) || (b = this.getMin(child)) <= -1 || b >= min && min != 0) continue;
                min = b;
            }
        }
        return min;
    }

    private int getMax(TraceabilityModel model) {
        int max = 0;
        if (model instanceof TraceabilityTemplate || !this.hasDirectlyActiveRegion(model)) {
            for (TraceabilityRegion region : model.getRegions()) {
                int b = region.getTargetFileOffset();
                int e = b + region.getTargetFileLength();
                if (e <= max) continue;
                max = e;
            }
            for (TraceabilityModel child : model.getChildren()) {
                int e = this.getMax(child);
                if (e <= max) continue;
                max = e;
            }
        } else {
            for (TraceabilityRegion region : model.getRegions()) {
                int b = region.getTargetFileOffset();
                int e = b + region.getTargetFileLength();
                if (e <= max) continue;
                max = e;
            }
            for (TraceabilityModel child : model.getChildren()) {
                int e;
                if (!(child instanceof TraceabilityTemplate) || (e = this.getMax(child)) <= max) continue;
                max = e;
            }
        }
        return max;
    }

    private List<Object> getElementsAt(TraceabilityContainer current, int offset) {
        List<Object> result = new ArrayList<Object>();
        if (current != null) {
            if (current instanceof TraceabilityModel) {
                for (TraceabilityRegion region : ((TraceabilityModel)current).getRegions()) {
                    int b = region.getTargetFileOffset();
                    int e = b + region.getTargetFileLength();
                    if (offset < b || offset >= e) continue;
                    result.add(current);
                    this.computeViewAncestors(current, result);
                    break;
                }
            }
            if (result.size() == 0) {
                for (TraceabilityModel child : current.getChildren()) {
                    result = this.getElementsAt(child, offset);
                    if (result.size() != 0) break;
                }
            }
        }
        return result;
    }

    private void computeViewAncestors(TraceabilityContainer current, List<Object> result) {
        IFile targetFile;
        TraceabilityElement parent = current.getParent();
        while (parent != null) {
            result.add(0, parent);
            if (parent instanceof TraceabilityTargetFile) break;
            parent = parent.getParent();
        }
        if (parent instanceof TraceabilityTargetFile && (targetFile = ((TraceabilityTargetFile)parent).getTargetFile()) != null) {
            result.add(0, targetFile);
            IContainer container = targetFile.getParent();
            while (container != null) {
                result.add(0, container);
                container = container.getParent();
            }
        }
    }

    private class AcceleoPreviewContentProvider
    extends WorkbenchContentProvider {
        private AcceleoPreviewContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof String) {
                return new Object[]{(String)element};
            }
            return super.getElements(element);
        }

        public Object[] getChildren(Object element) {
            Object[] result;
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                ArrayList<TraceabilityModel> children = new ArrayList<TraceabilityModel>();
                if (AcceleoResultView.this.content != null) {
                    TraceabilityTargetFile[] traceabilityTargetFileArray = AcceleoResultView.this.content.getTargetFiles();
                    int n = traceabilityTargetFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TraceabilityTargetFile targetFile = traceabilityTargetFileArray[n2];
                        if (path.isPrefixOf(targetFile.getTargetFileFullPath())) {
                            children.addAll(targetFile.getChildren());
                        }
                        ++n2;
                    }
                }
                result = children.toArray();
            } else if (element instanceof TraceabilityModel) {
                ArrayList<TraceabilityElement> children = new ArrayList<TraceabilityElement>();
                children.addAll(((TraceabilityModel)element).getChildren());
                children.addAll(((TraceabilityModel)element).getRegions());
                result = children.toArray();
            } else {
                result = element instanceof TraceabilityRegion ? new Object[]{} : super.getChildren(element);
            }
            return result;
        }
    }

    private class AcceleoPreviewLabelProvider
    extends DecoratingLabelProvider {
        private WorkbenchLabelProvider resourcesLabelProvider;

        public AcceleoPreviewLabelProvider() {
            super((ILabelProvider)new AdapterFactoryLabelProvider(AcceleoResultView.this.createAdapterFactory()), AcceleoResultView.this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator());
            this.resourcesLabelProvider = new WorkbenchLabelProvider();
        }

        public void dispose() {
            super.dispose();
            this.resourcesLabelProvider.dispose();
        }

        public String getText(Object element) {
            String text = this.resourcesLabelProvider.getText(element);
            if (text != null && text.length() > 0) {
                return text;
            }
            String result = element instanceof String ? (String)element : (element instanceof TraceabilityTemplate ? this.getText(((TraceabilityTemplate)element).getTemplateElement()) : (element instanceof TraceabilityModel ? this.getText(((TraceabilityModel)element).getEObject()) : (element instanceof TraceabilityRegion ? ((TraceabilityRegion)element).toString() : super.getText(element))));
            return result;
        }

        public Image getImage(Object element) {
            Image image = this.resourcesLabelProvider.getImage(element);
            if (image == null) {
                if (element instanceof String) {
                    image = AcceleoUIActivator.getDefault().getImage("icons/AcceleoPreview.gif");
                } else if (element instanceof TraceabilityTemplate) {
                    image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/" + ((TraceabilityTemplate)element).getEObject().eClass().getName() + ".gif");
                    if (image == null) {
                        image = this.getImage(((TraceabilityTemplate)element).getTemplateElement());
                    }
                } else {
                    image = element instanceof TraceabilityModel ? this.getImage(((TraceabilityModel)element).getEObject()) : (element instanceof TraceabilityRegion ? AcceleoUIActivator.getDefault().getImage("icons/AcceleoRegion.gif") : super.getImage(element));
                }
            }
            return image;
        }
    }
}

