/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedTemplate;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedVariable;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;

public class AcceleoRenameAction
implements IWorkbenchWindowActionDelegate {
    private final String name = "Rename...";
    private IWorkbenchWindow fWindow;
    private AcceleoEditor editor;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null || !(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof AcceleoEditor)) {
            return;
        }
        this.editor = (AcceleoEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.containsAcceleoError(this.editor.getFile())) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            box.setMessage(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.ErrorInTheCurrentFile"));
            box.open();
            return;
        }
        if (this.fWindow != null && this.allResourceSaved() && !this.editor.isDirty()) {
            EObject object = OpenDeclarationUtils.findDeclaration(this.editor);
            if (object instanceof Template) {
                this.launchRefactoringRenameTemplate((Template)object);
            } else if (object instanceof Query) {
                this.launchRefactoringRenameQuery((Query)object);
            } else if (object instanceof Variable) {
                this.launchRefactoringRenameVariable((Variable)object);
            } else if (object instanceof VariableExp) {
                this.launchRefactoringRenameVariable((VariableExp)object);
            } else {
                this.launchRefactorRenameTemplate();
            }
        }
    }

    private void launchRefactorRenameTemplate() {
        this.launchRefactoringRenameTemplate(null);
    }

    private void launchRefactoringRenameTemplate(Template template) {
        AcceleoRenameTemplateRefactoring refactoring = new AcceleoRenameTemplateRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedTemplate.setAcceleoEditor(this.editor);
        AcceleoPositionedTemplate.computePartialInput(template);
        AcceleoPositionedTemplate[] array = AcceleoPositionedTemplate.getInput();
        if (array.length > 0) {
            refactoring.setTemplate(array[0]);
            if (template != null) {
                int i = 0;
                while (i < array.length) {
                    AcceleoPositionedTemplate positionedTemplate = array[i];
                    if (template.getName().equals(positionedTemplate.getTemplateName())) {
                        refactoring.setTemplate(positionedTemplate);
                    }
                    ++i;
                }
            }
            this.runWizard(new AcceleoRenameTemplateWizard(refactoring, "Rename..."), this.fWindow.getShell(), "Rename...");
        }
    }

    private void launchRefactoringRenameQuery(Query query) {
        AcceleoRenameQueryRefactoring refactoring = new AcceleoRenameQueryRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedQuery.setAcceleoEditor(this.editor);
        AcceleoPositionedQuery.computePartialInput(query);
        AcceleoPositionedQuery[] array = AcceleoPositionedQuery.getInput();
        if (array.length > 0) {
            refactoring.setQuery(array[0]);
            int i = 0;
            while (i < array.length) {
                AcceleoPositionedQuery positionedQuery = array[i];
                if (query.getName().equals(positionedQuery.getQueryName())) {
                    refactoring.setQuery(positionedQuery);
                }
                ++i;
            }
            this.runWizard(new AcceleoRenameQueryWizard(refactoring, "Rename..."), this.fWindow.getShell(), "Rename...");
        }
    }

    private void launchRefactoringRenameVariable(Variable variable) {
        AcceleoRenameVariableRefactoring refactoring = new AcceleoRenameVariableRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedVariable apv = new AcceleoPositionedVariable(variable, this.editor);
        refactoring.setVariable(apv);
        this.runWizard(new AcceleoRenameVariableWizard(refactoring, "Rename..."), this.fWindow.getShell(), "Rename...");
    }

    private void launchRefactoringRenameVariable(VariableExp variable) {
        AcceleoRenameVariableRefactoring refactoring = new AcceleoRenameVariableRefactoring();
        AcceleoPositionedVariable apv = new AcceleoPositionedVariable(variable, this.editor);
        refactoring.setVariable(apv);
        this.runWizard(new AcceleoRenameVariableWizard(refactoring, "Rename..."), this.fWindow.getShell(), "Rename...");
    }

    private boolean allResourceSaved() {
        ArrayList<AcceleoEditor> dirtyEditorList = new ArrayList<AcceleoEditor>();
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IEditorPart[] editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors();
            int i = 0;
            while (i < editors.length) {
                if (editors[i] instanceof AcceleoEditor) {
                    dirtyEditorList.add((AcceleoEditor)editors[i]);
                }
                ++i;
            }
        }
        if (dirtyEditorList.size() > 0) {
            for (AcceleoEditor acceleoEditor : dirtyEditorList) {
                ISaveablesLifecycleListener modelManager = (ISaveablesLifecycleListener)acceleoEditor.getSite().getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
                Saveable[] saveableArray = acceleoEditor.getSaveables();
                ArrayList<Saveable> list = new ArrayList<Saveable>();
                int i = 0;
                while (i < saveableArray.length) {
                    list.add(saveableArray[i]);
                    ++i;
                }
                SaveablesLifecycleEvent event = new SaveablesLifecycleEvent((Object)acceleoEditor, 2, saveableArray, false);
                modelManager.handleLifecycleEvent(event);
            }
            boolean allSaved = true;
            for (AcceleoEditor acceleoEditor : dirtyEditorList) {
                if (!acceleoEditor.isDirty()) continue;
                allSaved = false;
                break;
            }
            return allSaved;
        }
        return true;
    }

    private boolean containsAcceleoError(IFile file) {
        boolean result = false;
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.acceleo.ide.ui.problem", true, 2);
            if (markers.length > 0) {
                result = true;
            }
        }
        catch (CoreException coreException) {
            result = true;
        }
        return result;
    }

    public void runWizard(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }
}

