/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DynamicModulesURIConverter
extends ExtensibleURIConverterImpl {
    private final AcceleoEvaluationEnvironment parentEnvironment;

    DynamicModulesURIConverter(AcceleoEvaluationEnvironment parent) {
        this.parentEnvironment = parent;
    }

    public URI normalize(URI uri) {
        if (!"emtl".equals(uri.fileExtension()) || !"file".equals(uri.scheme())) {
            return super.normalize(uri);
        }
        URI normalized = (URI)this.getURIMap().get(uri);
        if (normalized == null) {
            String moduleName = uri.lastSegment();
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
            LinkedHashSet<URI> candidateURIs = new LinkedHashSet<URI>();
            Set<Module> candidateModules = this.searchCurrentModuleForCandidateMatches(moduleName);
            for (Module candidateModule : candidateModules) {
                candidateURIs.add(candidateModule.eResource().getURI());
            }
            if (candidateURIs.size() == 0) {
                candidateURIs.addAll(this.searchResourceSetForMatches(moduleName));
            }
            if (candidateURIs.size() == 1) {
                normalized = (URI)candidateURIs.iterator().next();
            } else if (candidateURIs.size() > 0) {
                normalized = this.findBestMatchFor(uri, candidateURIs);
            }
            if ((normalized == null || "file".equals(normalized.scheme())) && EMFPlugin.IS_ECLIPSE_RUNNING) {
                String resolvedPath;
                String uriToString = uri.toString();
                if (uriToString.indexOf(35) > 0) {
                    uriToString = uriToString.substring(0, uriToString.indexOf(35));
                }
                if ((resolvedPath = AcceleoWorkspaceUtil.INSTANCE.resolveAsPlatformPluginResource(uriToString)) != null) {
                    normalized = URI.createURI((String)resolvedPath);
                }
            }
            if (normalized == null) {
                normalized = super.normalize(uri);
            }
            if (!uri.equals((Object)normalized)) {
                this.getURIMap().put(uri, normalized);
            }
        }
        return normalized;
    }

    private URI findBestMatchFor(URI uri, Set<URI> candidateURIs) {
        URI normalized = null;
        Iterator<URI> candidatesIterator = candidateURIs.iterator();
        List<String> referenceSegments = Arrays.asList(uri.segments());
        Collections.reverse(referenceSegments);
        int highestEqualFragments = 0;
        while (candidatesIterator.hasNext()) {
            URI next = candidatesIterator.next();
            int equalFragments = 0;
            List<String> candidateSegments = Arrays.asList(next.segments());
            Collections.reverse(candidateSegments);
            int i = 0;
            while (i < Math.min(candidateSegments.size(), referenceSegments.size())) {
                if (candidateSegments.get(i) != referenceSegments.get(i)) break;
                ++equalFragments;
                ++i;
            }
            if (equalFragments <= highestEqualFragments) continue;
            highestEqualFragments = equalFragments;
            normalized = next;
        }
        return normalized;
    }

    private Set<Module> searchCurrentModuleForCandidateMatches(String moduleName) {
        LinkedHashSet<Module> candidates = new LinkedHashSet<Module>();
        for (Module module : this.parentEnvironment.getCurrentModules()) {
            if (!moduleName.equals(module.getName())) continue;
            candidates.add(module);
        }
        return candidates;
    }

    private Set<URI> searchResourceSetForMatches(String moduleName) {
        LinkedHashSet<URI> candidates = new LinkedHashSet<URI>();
        ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
        for (Module module : this.parentEnvironment.getCurrentModules()) {
            ResourceSet resourceSet = module.eResource().getResourceSet();
            if (resourceSets.contains(resourceSet)) continue;
            resourceSets.add(resourceSet);
        }
        for (ResourceSet resourceSet : resourceSets) {
            for (Resource resource : resourceSet.getResources()) {
                if (!"emtl".equals(resource.getURI().fileExtension())) continue;
                String candidateName = resource.getURI().lastSegment();
                if (!moduleName.equals(candidateName = candidateName.substring(0, candidateName.lastIndexOf(46)))) continue;
                candidates.add(resource.getURI());
            }
        }
        return candidates;
    }
}

