/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedVariable;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameVariableRefactoring
extends Refactoring {
    private static final String VARIABLE = "variable";
    private static final String NEWNAME = "newName";
    private String fNewVariableName;
    private Map<IFile, TextFileChange> fChanges;
    private AcceleoPositionedVariable fVariable;
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            if (this.fVariable == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)"No variable specified"));
            }
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesOfTheCurrentFile() {
        for (Match match : this.fVariable.getVariableMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (!entry.getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = ((ReferenceEntry)match.getElement()).getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange("Refactoring: Rename Variable", file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fVariable.getVariableName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fVariable.getVariableName().length(), this.fNewVariableName));
            this.fChanges.put(file, tfc);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask("Creating change...", 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String description = "Renaming variable " + AcceleoRenameVariableRefactoring.this.fVariable.getVariableName();
                    String comment = "Renaming variable " + AcceleoRenameVariableRefactoring.this.fVariable.getVariableName() + " with the new name: " + AcceleoRenameVariableRefactoring.this.fNewVariableName;
                    arguments.put(AcceleoRenameVariableRefactoring.VARIABLE, AcceleoRenameVariableRefactoring.this.fVariable.getVariableName());
                    arguments.put(AcceleoRenameVariableRefactoring.NEWNAME, AcceleoRenameVariableRefactoring.this.fNewVariableName);
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameVariableDescriptor("Acceleo Rename Variable", description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return "Rename Variable";
    }

    public void setVariable(AcceleoPositionedVariable currentVariable) {
        this.fVariable = currentVariable;
    }

    public AcceleoPositionedVariable getVariable() {
        return this.fVariable;
    }

    public RefactoringStatus setNewVariableName(String text) {
        this.fNewVariableName = text;
        RefactoringStatus status = this.checkVariableName(this.fNewVariableName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    private RefactoringStatus checkVariableName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.InvalidVariableName")));
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(VARIABLE);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewVariableName(value);
        }
        return status;
    }
}

