/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameQueryRefactoring
extends Refactoring {
    private static final String QUERY = "query";
    private static final String NEWNAME = "newName";
    private static final String REFERENCES = "references";
    private String fNewQueryName;
    private Map<IFile, TextFileChange> fChanges;
    private boolean fUpdateReferences = true;
    private AcceleoPositionedQuery fQuery;
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            if (this.fQuery == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)"No query specified"));
            }
            this.fQuery.computeOccurrencesOfQuery();
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            if (this.fUpdateReferences) {
                this.putChangesNotInTheCurrentFile();
            }
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesNotInTheCurrentFile() {
        for (Match match : this.fQuery.getQueryMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (entry.getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = ((ReferenceEntry)match.getElement()).getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange("Refactoring: Rename Query", file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fQuery.getQueryName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fQuery.getQueryName().length(), this.fNewQueryName));
            this.fChanges.put(file, tfc);
        }
    }

    private void putChangesOfTheCurrentFile() {
        for (Match match : this.fQuery.getQueryMatches()) {
            ReferenceEntry entry = (ReferenceEntry)match.getElement();
            if (!entry.getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = ((ReferenceEntry)match.getElement()).getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange("Refactoring: Rename Query", file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.indexOf(this.fQuery.getQueryName());
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fQuery.getQueryName().length(), this.fNewQueryName));
            this.fChanges.put(file, tfc);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (AcceleoPositionedQuery.getInput().length == 0) {
            status.merge(RefactoringStatus.createErrorStatus((String)"There are no query in the current file"));
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask("Creating change...", 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String description = "Renaming query " + AcceleoRenameQueryRefactoring.this.fQuery.getQueryName();
                    String comment = "Renaming query " + AcceleoRenameQueryRefactoring.this.fQuery.getQueryName() + " with the new name: " + AcceleoRenameQueryRefactoring.this.fNewQueryName;
                    arguments.put(AcceleoRenameQueryRefactoring.QUERY, AcceleoRenameQueryRefactoring.this.fQuery.getQueryName());
                    arguments.put(AcceleoRenameQueryRefactoring.NEWNAME, AcceleoRenameQueryRefactoring.this.fNewQueryName);
                    arguments.put(AcceleoRenameQueryRefactoring.REFERENCES, Boolean.valueOf(AcceleoRenameQueryRefactoring.this.fUpdateReferences).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameQueryDescriptor("Acceleo Rename Query", description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return "Rename Query";
    }

    public void setQuery(AcceleoPositionedQuery currentQuery) {
        this.fQuery = currentQuery;
    }

    public AcceleoPositionedQuery getQuery() {
        return this.fQuery;
    }

    public void setUpdateReferences(boolean selection) {
        this.fUpdateReferences = selection;
    }

    public RefactoringStatus setNewQueryName(String text) {
        this.fNewQueryName = text;
        RefactoringStatus status = this.checkQueryName(this.fNewQueryName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        RefactoringStatus status = new RefactoringStatus();
        AcceleoPositionedQuery[] array = AcceleoPositionedQuery.getInput();
        int i = 0;
        while (i < array.length) {
            if (this.fNewQueryName.equals(array[i].getQueryName())) {
                EList listOfParametersOfTheCurrentQuery = this.fQuery.getQuery().getParameter();
                EList listOfParametersOfTheQueryWithTheSameName = array[i].getQuery().getParameter();
                if (listOfParametersOfTheCurrentQuery.size() == listOfParametersOfTheQueryWithTheSameName.size()) {
                    boolean overloadingError = true;
                    int j = 0;
                    while (j < listOfParametersOfTheCurrentQuery.size()) {
                        if (!((Variable)listOfParametersOfTheCurrentQuery.get(j)).getEType().equals(((Variable)listOfParametersOfTheQueryWithTheSameName.get(j)).getEType())) {
                            overloadingError = false;
                            break;
                        }
                        ++j;
                    }
                    if (overloadingError) {
                        status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.QueryOverloadingError")));
                    }
                }
            }
            ++i;
        }
        return status;
    }

    private RefactoringStatus checkQueryName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.InvalidQueryName")));
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(QUERY);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewQueryName(value);
        }
        if ((value = arguments.get(REFERENCES)) != null) {
            this.setUpdateReferences(Boolean.valueOf(value));
        }
        return status;
    }
}

