/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionChoice;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoSourceContent {
    private static final String DEFAULT_EMTL_URI = "http://acceleo.eclipse.org/default.emtl";
    private static final String DYNAMIC_TEMPLATES_EXTENSION_POINT = "org.eclipse.acceleo.engine.dynamic.templates";
    private IFile file;
    private AcceleoProject acceleoProject;
    private AcceleoSourceBufferWithASTJob source;
    private CSTParser cstParser;
    private int syntaxHelpCount;
    private ResourceSet syntaxHelpResourceSet;
    private SyntaxHelpJob syntaxHelpUnloadJob = new SyntaxHelpJob();

    public org.eclipse.acceleo.parser.cst.Module getCST() {
        if (this.source == null) {
            return null;
        }
        if (this.source.getCST() == null) {
            this.createCST();
        }
        return this.source.getCST();
    }

    public Module getAST() {
        if (this.source == null) {
            return null;
        }
        if (this.source.getAST() == null) {
            this.createAST();
        }
        return this.source.getAST();
    }

    public IFile getFile() {
        return this.file;
    }

    public void init(StringBuffer text) {
        this.init(text, null);
    }

    public void init(StringBuffer text, IFile aFile) {
        this.file = aFile;
        this.acceleoProject = this.file != null ? new AcceleoProject(this.file.getProject()) : null;
        this.source = new AcceleoSourceBufferWithASTJob(text);
        this.cstParser = new CSTParser((AcceleoSourceBuffer)this.source);
    }

    public void createCST() {
        this.source.getProblems().clear();
        this.source.createCST();
    }

    public CSTNode updateCST(int posBegin, int posEnd, String newText) {
        this.source.getProblems().clear();
        this.source.getBuffer().replace(posBegin, posEnd, newText);
        CSTNode current = this.getCSTNode(posBegin, posEnd);
        if (current instanceof TextExpression && newText.indexOf("[") > -1) {
            current = (CSTNode)current.eContainer();
        }
        if (!(current == null || posBegin != posEnd || posBegin != current.getStartPosition() || current instanceof TextExpression || current instanceof Variable || current instanceof ModelExpression)) {
            current = (CSTNode)current.eContainer();
        }
        while (current != null) {
            ModelExpression oldExpression;
            int shift;
            int newPosEnd;
            ModelExpression modified = null;
            if (current instanceof org.eclipse.acceleo.parser.cst.ModuleElement && ((org.eclipse.acceleo.parser.cst.ModuleElement)current).eContainingFeature() == CstPackage.eINSTANCE.getModule_OwnedModuleElement()) {
                org.eclipse.acceleo.parser.cst.ModuleElement oldModuleElement = (org.eclipse.acceleo.parser.cst.ModuleElement)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceModuleElement(oldModuleElement);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof ModelExpression) {
                oldExpression = (ModelExpression)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceModelExpression(oldExpression);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof TemplateExpression) {
                oldExpression = (TemplateExpression)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceTemplateExpression((TemplateExpression)oldExpression);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof Variable) {
                Variable oldVariable = (Variable)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceVariable(oldVariable);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            }
            if (modified instanceof CSTNode) {
                this.source.refreshAST();
                return (CSTNode)modified;
            }
            current = (CSTNode)current.eContainer();
        }
        this.doSave();
        return this.source.getCST();
    }

    public void doSave() {
        if (this.source != null) {
            this.source.cancel();
        }
        this.source.getProblems().clear();
        this.source.createCST();
    }

    private EObject replaceModuleElement(org.eclipse.acceleo.parser.cst.ModuleElement oldModuleElement) {
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        this.cstParser.parseModuleBody(oldModuleElement.getStartPosition(), oldModuleElement.getEndPosition(), tempModule);
        if (tempModule.getOwnedModuleElement().size() > 0) {
            try {
                org.eclipse.acceleo.parser.cst.ModuleElement newModuleElement = (org.eclipse.acceleo.parser.cst.ModuleElement)tempModule.getOwnedModuleElement().get(0);
                EcoreUtil.replace((EObject)oldModuleElement, (EObject)newModuleElement);
                return newModuleElement;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
        return null;
    }

    private ModelExpression replaceModelExpression(ModelExpression oldExpression) {
        oldExpression.setBefore(null);
        oldExpression.setEach(null);
        oldExpression.setAfter(null);
        this.cstParser.getPBlock().parseExpressionHeader(oldExpression.getStartPosition(), oldExpression.getEndPosition(), oldExpression);
        return oldExpression;
    }

    private EObject replaceTemplateExpression(TemplateExpression oldExpression) {
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        Template tempBlock = CstFactory.eINSTANCE.createTemplate();
        tempModule.getOwnedModuleElement().add((Object)tempBlock);
        this.cstParser.getPBlock().parse(oldExpression.getStartPosition(), oldExpression.getEndPosition(), (Block)tempBlock);
        if (tempBlock.getBody().size() > 0) {
            try {
                TemplateExpression newExpression = (TemplateExpression)tempBlock.getBody().get(0);
                EcoreUtil.replace((EObject)oldExpression, (EObject)newExpression);
                return newExpression;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
        return null;
    }

    private EObject replaceVariable(Variable oldVariable) {
        Variable newVariable;
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        if ((newVariable = this.cstParser.createVariable(oldVariable.getStartPosition(), oldVariable.getEndPosition(), tempModule)) != null) {
            try {
                EcoreUtil.replace((EObject)oldVariable, (EObject)newVariable);
                return newVariable;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {}
        }
        return null;
    }

    private void shiftPositionsAfter(int index, int shift) {
        if (this.getCST() != null) {
            TreeIterator eAllContents = this.getCST().eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof CSTNode)) continue;
                CSTNode cstNode = (CSTNode)eObject;
                this.shiftPositionsAfter(cstNode, index, shift);
            }
        }
    }

    private void shiftPositionsAfter(CSTNode candidate, int index, int shift) {
        if (candidate instanceof TextExpression || candidate instanceof Variable || candidate instanceof ModelExpression) {
            if (candidate.getStartPosition() > index) {
                assert (candidate.getStartPosition() + shift > -1);
                candidate.setStartPosition(candidate.getStartPosition() + shift);
            }
            if (candidate.getEndPosition() >= index) {
                assert (candidate.getEndPosition() + shift > -1);
                candidate.setEndPosition(candidate.getEndPosition() + shift);
            }
        } else {
            if (candidate.getStartPosition() >= index) {
                assert (candidate.getStartPosition() + shift > -1);
                candidate.setStartPosition(candidate.getStartPosition() + shift);
            }
            if (candidate.getEndPosition() > index) {
                assert (candidate.getEndPosition() + shift > -1);
                candidate.setEndPosition(candidate.getEndPosition() + shift);
            }
        }
    }

    public CSTNode getCSTNode(int posBegin, int posEnd) {
        if (this.getCST() != null) {
            org.eclipse.acceleo.parser.cst.Module candidate = this.getCST();
            CSTNode childrenCandidate = this.getChildrenCandidate((CSTNode)candidate, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((CSTNode)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    private CSTNode getChildrenCandidate(CSTNode candidate, int posBegin, int posEnd) {
        for (CSTNode eContent : candidate.eContents()) {
            int startPosition = eContent.getStartPosition();
            int endPosition = eContent.getEndPosition();
            assert (startPosition > -1 && endPosition > -1);
            if (startPosition > posBegin || endPosition < posEnd) continue;
            return eContent;
        }
        return null;
    }

    public CSTNode getCSTParent(CSTNode node, Class c) {
        CSTNode eContainer = (CSTNode)node.eContainer();
        while (eContainer != null) {
            if (c.isInstance(eContainer)) {
                return eContainer;
            }
            eContainer = (CSTNode)eContainer.eContainer();
        }
        return null;
    }

    public Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        return this.source.getOCLEnvironment();
    }

    public synchronized Collection<Choice> getSyntaxHelp(String text, int offset) {
        ++this.syntaxHelpCount;
        try {
            EClassifier eContext;
            OCLParser oclParser;
            if (this.getCST() != null) {
                Module vAST = this.source.getAST();
                if (vAST == null) {
                    this.createAST();
                    vAST = this.source.getAST();
                }
                if (vAST != null) {
                    Resource resource;
                    URI uri = vAST.eResource().getURI();
                    vAST = (Module)EcoreUtil.copy((EObject)vAST);
                    if (this.syntaxHelpResourceSet == null) {
                        this.syntaxHelpResourceSet = new ResourceSetImpl();
                    }
                    if (this.syntaxHelpResourceSet.getResources().size() > 0) {
                        resource = (Resource)this.syntaxHelpResourceSet.getResources().get(0);
                        resource.unload();
                    } else {
                        resource = this.syntaxHelpResourceSet.createResource(uri);
                    }
                    resource.getContents().add((Object)vAST);
                    oclParser = new OCLParser(resource);
                    if (!this.getCST().getImports().isEmpty() || !this.getCST().getExtends().isEmpty()) {
                        List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
                        this.loadImportsDependencies(vAST, dependenciesURIs);
                        this.loadExtendsDependencies(vAST, dependenciesURIs);
                    }
                    oclParser.addRecursivelyMetamodelsToScope(vAST);
                    boolean isAfterDot = this.isAfterDot(text);
                    oclParser.addRecursivelyBehavioralFeaturesToScope(vAST, true, !isAfterDot, this.getCurrentQualifiedName(text));
                    int specificOffset = this.getSpecificOffset(offset);
                    eContext = oclParser.addRecursivelyVariablesToScopeAndGetContextClassifierAt(vAST, specificOffset);
                    if (eContext != null) {
                        oclParser.pushContext(eContext);
                    }
                    Collection<Choice> collection = this.order(oclParser.getSyntaxHelp(text), oclParser);
                    return collection;
                }
            }
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            return arrayList;
            finally {
                if (eContext != null) {
                    oclParser.popContext();
                }
                this.syntaxHelpUnloadJob.run();
            }
        }
        finally {
            --this.syntaxHelpCount;
        }
    }

    private Collection<Choice> order(Collection<Choice> choices, OCLParser oclParser) {
        TreeSet<Choice> orderedChoices = new TreeSet<Choice>(new Comparator<Choice>(){

            @Override
            public int compare(Choice arg0, Choice arg1) {
                int value = arg0.getKind() == ChoiceKind.VARIABLE && arg1.getKind() == ChoiceKind.VARIABLE ? -1 : (arg0.getKind() == ChoiceKind.VARIABLE ? -1 : (arg1.getKind() == ChoiceKind.VARIABLE ? 1 : (arg0.getKind() == ChoiceKind.PROPERTY && arg1.getKind() == ChoiceKind.PROPERTY ? arg0.getName().compareTo(arg1.getName()) : (arg0 instanceof AcceleoCompletionChoice && !(arg1 instanceof AcceleoCompletionChoice) ? -1 : (arg0.getKind() == ChoiceKind.PROPERTY ? -1 : 1)))));
                return value;
            }
        });
        for (Choice choice : choices) {
            EOperation eOperation;
            ModuleElement eModuleElement;
            if (choice.getElement() instanceof EOperation && (eModuleElement = oclParser.getModuleElement(eOperation = (EOperation)choice.getElement())) != null) {
                AcceleoCompletionChoice acceleoChoice = new AcceleoCompletionChoice(choice, eModuleElement);
                choice = acceleoChoice;
            }
            orderedChoices.add(choice);
        }
        return orderedChoices;
    }

    private boolean isAfterDot(String text) {
        boolean isAfterDot = false;
        int i = text.length() - 1;
        while (!isAfterDot && i >= 0) {
            char c = text.charAt(i);
            if (c == '.') {
                isAfterDot = true;
            } else if (!Character.isJavaIdentifierPart(c)) break;
            --i;
        }
        return isAfterDot;
    }

    private String getCurrentQualifiedName(String text) {
        StringBuffer result = new StringBuffer();
        int i = text.length() - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) break;
            result.insert(0, c);
            --i;
        }
        return result.toString();
    }

    private int getSpecificOffset(int offset) {
        CSTNode cstNode = this.getCSTNode(offset, offset);
        int result = offset;
        if (cstNode != null) {
            EObject eContainer = cstNode.eContainer();
            EStructuralFeature eContainingFeature = cstNode.eContainingFeature();
            if (cstNode instanceof ModelExpression && eContainer instanceof ForBlock) {
                if (eContainingFeature == CstPackage.eINSTANCE.getForBlock_IterSet() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_Before() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_Each() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_After()) {
                    result = ((ForBlock)eContainer).getStartPosition();
                }
            } else if (cstNode instanceof TemplateOverridesValue && eContainer instanceof Template) {
                result = ((Template)eContainer).getStartPosition();
            } else if (cstNode instanceof Variable) {
                result = cstNode.getStartPosition();
            }
        }
        return result;
    }

    private void loadImportsDependencies(Module vAST, List<URI> dependenciesURIs) {
        block0: for (URI oURI : dependenciesURIs) {
            String oName = new Path(oURI.lastSegment()).removeFileExtension().lastSegment();
            for (ModuleImportsValue moduleImportsValue : this.getCST().getImports()) {
                if (moduleImportsValue == null || !oName.equals(moduleImportsValue.getName())) continue;
                Module otherModule = this.getModule(vAST.eResource().getResourceSet(), oURI);
                if (otherModule == null || !oName.equals(otherModule.getName()) || vAST.getImports().contains((Object)otherModule)) continue block0;
                vAST.getImports().add((Object)otherModule);
                continue block0;
            }
        }
    }

    private void loadExtendsDependencies(Module vAST, List<URI> dependenciesURIs) {
        block0: for (URI oURI : dependenciesURIs) {
            String oName = new Path(oURI.lastSegment()).removeFileExtension().lastSegment();
            for (ModuleExtendsValue moduleExtendsValue : this.getCST().getExtends()) {
                if (moduleExtendsValue == null || !oName.equals(moduleExtendsValue.getName())) continue;
                Module otherModule = this.getModule(vAST.eResource().getResourceSet(), oURI);
                if (otherModule == null || !oName.equals(otherModule.getName()) || vAST.getExtends().contains((Object)otherModule)) continue block0;
                vAST.getExtends().add((Object)otherModule);
                continue block0;
            }
        }
    }

    private void checkDynamicExtensionPoint() {
        if (this.file != null && !this.checkDynamicPathValue(this.file)) {
            try {
                IMarker[] markers = this.file.findMarkers("org.eclipse.acceleo.ide.ui.problem", false, 1);
                if (markers == null || markers.length == 0) {
                    this.reportError(this.file, 1, 0, 1, AcceleoUIMessages.getString("AcceleoSourceContent.NoPathFound", this.file.getName()));
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private boolean checkDynamicPathValue(IFile mtlFile) {
        IPluginModelBase plugin = PluginRegistry.findModel((IProject)mtlFile.getProject());
        if (plugin != null && plugin.getExtensions() != null) {
            IPluginExtension[] pluginExtensions = plugin.getExtensions().getExtensions();
            int i = 0;
            while (i < pluginExtensions.length) {
                if (DYNAMIC_TEMPLATES_EXTENSION_POINT.equals(pluginExtensions[i].getPoint())) {
                    IPluginObject[] children = pluginExtensions[i].getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IPluginAttribute attribute;
                        if (children[j] instanceof IPluginElement) {
                            IPluginElement element = (IPluginElement)children[j];
                            attribute = element.getAttribute("path");
                        } else {
                            attribute = null;
                        }
                        if (attribute != null && attribute.getValue() != null && new Path(attribute.getValue()).isPrefixOf(mtlFile.getProjectRelativePath())) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private void reportError(IFile mtlFile, int line, int posBegin, int posEnd, String message) throws CoreException {
        IMarker m = mtlFile.createMarker("org.eclipse.acceleo.ide.ui.problem");
        m.setAttribute("transient", true);
        m.setAttribute("lineNumber", line);
        m.setAttribute("charStart", posBegin);
        m.setAttribute("charEnd", posEnd);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
    }

    private Module getModule(ResourceSet resourceSet, URI uri) {
        try {
            EObject root = ModelUtils.load((URI)uri, (ResourceSet)resourceSet);
            if (root instanceof Module) {
                return (Module)root;
            }
        }
        catch (IOException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        return null;
    }

    public List<EClassifier> getTypes() {
        if (this.getCST() != null) {
            Module vAST = this.source.getAST();
            if (vAST == null) {
                this.createAST();
                vAST = this.source.getAST();
            }
            if (vAST != null) {
                URI uri = vAST.eResource().getURI();
                vAST = (Module)EcoreUtil.copy((EObject)vAST);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = ModelUtils.createResource((URI)uri, (ResourceSet)resourceSet);
                resource.getContents().add((Object)vAST);
                OCLParser oclParser = new OCLParser(resource);
                List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
                this.loadImportsDependencies(vAST, dependenciesURIs);
                this.loadExtendsDependencies(vAST, dependenciesURIs);
                oclParser.addRecursivelyMetamodelsToScope(vAST);
                List result = oclParser.getTypes();
                Iterator resources = resourceSet.getResources().iterator();
                while (resources.hasNext()) {
                    ((Resource)resources.next()).unload();
                }
                return result;
            }
        }
        return new ArrayList<EClassifier>();
    }

    public List<URI> getAccessibleOutputFiles() {
        if (this.acceleoProject != null) {
            return this.acceleoProject.getAccessibleOutputFiles();
        }
        return new ArrayList<URI>();
    }

    public String getText() {
        return this.source.getBuffer().toString();
    }

    protected void createAST() {
        IPath outputPath;
        URI fileURI = this.file != null ? ((outputPath = this.acceleoProject.getOutputFilePath(this.file)) != null ? URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false) : URI.createPlatformResourceURI((String)this.file.getFullPath().removeFileExtension().addFileExtension("emtl").toString(), (boolean)false)) : URI.createURI((String)DEFAULT_EMTL_URI);
        ResourceSetImpl oResourceSet = new ResourceSetImpl();
        Resource oResource = ModelUtils.createResource((URI)fileURI, (ResourceSet)oResourceSet);
        ArrayList<URI> resourceSetURIs = new ArrayList<URI>();
        resourceSetURIs.add(fileURI);
        this.source.createAST(oResource);
    }

    public ASTNode getASTNode(int posBegin, int posEnd) {
        Module vAST;
        if (posBegin > -1 && (vAST = this.getAST()) != null) {
            List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
            this.loadImportsDependencies(vAST, dependenciesURIs);
            this.loadExtendsDependencies(vAST, dependenciesURIs);
            this.source.resolveAST(posBegin, posEnd);
            ASTNode candidate = null;
            ASTNode childrenCandidate = this.getChildrenCandidate((EObject)vAST, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((EObject)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    private ASTNode getChildrenCandidate(EObject candidate, int posBegin, int posEnd) {
        for (EObject eContent : candidate.eContents()) {
            if (!(eContent instanceof ASTNode)) continue;
            ASTNode astNode = (ASTNode)eContent;
            int startPosition = astNode.getStartPosition();
            int endPosition = astNode.getEndPosition();
            assert (startPosition > -1 && endPosition > -1);
            if (startPosition > posBegin || endPosition < posEnd) continue;
            return astNode;
        }
        return null;
    }

    private class AcceleoSourceBufferWithASTJob
    extends AcceleoSourceBuffer {
        private Job createASTJob;

        public AcceleoSourceBufferWithASTJob(StringBuffer buffer) {
            super(buffer);
        }

        public void refreshAST() {
            if (this.createASTJob != null) {
                this.createASTJob.cancel();
            }
            this.createASTJob = this.createASTJob();
            this.createASTJob.setPriority(50);
            this.createASTJob.setSystem(true);
            this.createASTJob.schedule(1500L);
        }

        public void cancel() {
            if (this.createASTJob != null) {
                this.createASTJob.cancel();
            }
        }

        private Job createASTJob() {
            return new Job("Acceleo"){

                protected IStatus run(IProgressMonitor monitor) {
                    AcceleoSourceBufferWithASTJob.this.ast = null;
                    AcceleoSourceBufferWithASTJob.this.runCreateAST();
                    AcceleoSourceBufferWithASTJob.this.astCreator.canceling(false);
                    return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
                }

                protected void canceling() {
                    super.canceling();
                    if (AcceleoSourceBufferWithASTJob.this.astCreator != null) {
                        AcceleoSourceBufferWithASTJob.this.astCreator.canceling(true);
                    }
                }
            };
        }

        private void runCreateAST() {
            IFile fileMTL = AcceleoSourceContent.this.file;
            if (fileMTL != null && fileMTL.exists()) {
                AcceleoParserProblems problems;
                HashMap<String, IMarker> position2marker = new HashMap<String, IMarker>();
                try {
                    IMarker[] markers;
                    IMarker[] iMarkerArray = markers = fileMTL.findMarkers("org.eclipse.acceleo.ide.ui.problem", false, 2);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        String key = String.valueOf(MarkerUtilities.getCharStart((IMarker)marker)) + "," + MarkerUtilities.getCharEnd((IMarker)marker);
                        if (position2marker.containsKey(key)) {
                            marker.delete();
                        } else {
                            position2marker.put(key, marker);
                        }
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    AcceleoUIActivator.getDefault().getLog().log(ex.getStatus());
                }
                AcceleoSourceContent.this.createAST();
                Module vAST = this.getAST();
                if (vAST != null) {
                    List<URI> dependenciesURIs = AcceleoSourceContent.this.getAccessibleOutputFiles();
                    AcceleoSourceContent.this.loadImportsDependencies(vAST, dependenciesURIs);
                    AcceleoSourceContent.this.loadExtendsDependencies(vAST, dependenciesURIs);
                    AcceleoSourceContent.this.source.resolveAST();
                }
                if ((problems = AcceleoSourceContent.this.source.getProblems()) != null) {
                    for (AcceleoParserProblem problem : problems.getList()) {
                        try {
                            String key = String.valueOf(problem.getPosBegin()) + "," + problem.getPosEnd();
                            if (!position2marker.containsKey(key)) {
                                AcceleoSourceContent.this.reportError(fileMTL, problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
                                continue;
                            }
                            position2marker.remove(key);
                        }
                        catch (CoreException ex) {
                            AcceleoUIActivator.getDefault().getLog().log(ex.getStatus());
                        }
                    }
                }
                for (IMarker markerToDelete : position2marker.values()) {
                    try {
                        markerToDelete.delete();
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                    }
                }
                AcceleoSourceContent.this.source.getProblems().clear();
            }
        }
    }

    private class SyntaxHelpJob {
        Job unloadJob;

        private SyntaxHelpJob() {
        }

        public void run() {
            if (this.unloadJob != null) {
                this.unloadJob.cancel();
            }
            this.unloadJob = new Job("Acceleo"){

                protected IStatus run(IProgressMonitor monitor) {
                    ResourceSet resourceSet = AcceleoSourceContent.this.syntaxHelpResourceSet;
                    if (AcceleoSourceContent.this.syntaxHelpCount == 0) {
                        AcceleoSourceContent.this.syntaxHelpResourceSet = null;
                        if (resourceSet != null) {
                            Iterator resources = resourceSet.getResources().iterator();
                            while (resources.hasNext()) {
                                ((Resource)resources.next()).unload();
                            }
                        }
                    }
                    return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
                }
            };
            this.unloadJob.setPriority(50);
            this.unloadJob.setSystem(true);
            this.unloadJob.schedule(4000L);
        }
    }
}

