/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.wizards.newfile.example;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class AcceleoCopyExampleContentStrategy
implements IAcceleoExampleStrategy {
    public String getDescription() {
        return AcceleoUIMessages.getString("AcceleoCopyExampleContentStrategy.Description");
    }

    public String getInitialFileNameFilter() {
        return "*.java";
    }

    public boolean forceMetamodelURI() {
        return false;
    }

    public boolean forceHasFile() {
        return false;
    }

    public boolean forceHasMain() {
        return false;
    }

    public boolean forceMetamodelType() {
        return false;
    }

    public String getContent(IFile exampleFile, String moduleName, boolean templateHasFileBlock, boolean templateIsMain, String metamodelURI, String metamodelFileType) {
        String defaultEncoding;
        String var = metamodelFileType != null && metamodelFileType.length() > 0 ? String.valueOf(Character.toLowerCase(metamodelFileType.charAt(0))) : "v";
        String fileExtension = exampleFile != null && exampleFile.getFileExtension() != null ? ".concat('." + exampleFile.getFileExtension() + "')" : "";
        try {
            defaultEncoding = exampleFile != null ? exampleFile.getCharset() : System.getProperty("file.encoding");
        }
        catch (CoreException coreException) {
            defaultEncoding = System.getProperty("file.encoding");
        }
        StringBuffer buffer = new StringBuffer("[comment encoding = ");
        buffer.append(defaultEncoding);
        buffer.append(" /]\n");
        buffer.append("[module " + moduleName + "('");
        StringTokenizer st = new StringTokenizer(metamodelURI, ",");
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken().trim());
            if (!st.hasMoreTokens()) continue;
            buffer.append("', '");
        }
        buffer.append("')/]\n\n");
        buffer.append("[template public " + moduleName + "(" + var + " : " + metamodelFileType + ")]\n");
        if (templateIsMain) {
            buffer.append("\t\n");
            buffer.append("\t[comment @main /]\n");
        }
        if (templateHasFileBlock) {
            buffer.append("\t[file (" + var + ".name" + fileExtension + ", false, '" + defaultEncoding + "')]\n");
        }
        if (exampleFile != null && exampleFile.exists()) {
            StringBuffer text = this.readExampleContent(exampleFile);
            buffer.append(text);
        } else {
            buffer.append("\t[" + var + ".name/]\n");
        }
        if (templateHasFileBlock) {
            buffer.append("\t[/file]\n");
        }
        if (templateIsMain) {
            buffer.append("\t\n");
        }
        buffer.append("[/template]\n");
        return buffer.toString();
    }

    protected StringBuffer readExampleContent(IFile exampleFile) {
        StringBuffer text = FileContent.getFileContent((File)exampleFile.getLocation().toFile());
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        text = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '[') {
                text.append("['['/]");
            } else if (c == ']') {
                text.append("[']'/]");
            } else {
                text.append(c);
            }
            ++i;
        }
        return text;
    }
}

