/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.overrides;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionTemplateProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.internal.ide.ui.views.overrides.ModuleProjectHandler;
import org.eclipse.acceleo.internal.ide.ui.views.overrides.OverridesBrowserTemplateLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.views.overrides.OverridesBrowserTemplatesProvider;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverridesBrowser
extends ViewPart
implements IEditingDomainProvider {
    public static final String OVERRIDES_BROWSER_VIEW_ID = "org.eclipse.acceleo.ide.ui.views.overrides.OverridesBrowser";
    private AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private CheckboxTreeViewer templatesViewer;
    private IPartListener partListener;
    private Set<ResourceSet> toUnload = new HashSet<ResourceSet>();
    private IProject project;
    private boolean clean = true;
    private IResourceChangeListener resourceChangeListener;
    private Job refreshContent;

    public OverridesBrowser() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setFocus() {
        IEditorPart part = this.getSite().getPage().getActiveEditor();
        if (part instanceof AcceleoEditor) {
            AcceleoEditor editor = (AcceleoEditor)part;
            this.refreshContent(editor.getFile());
        }
    }

    public void createPartControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.verticalIndent = 1;
        rootContainer.setLayoutData((Object)gridData);
        GridLayout rootContainerLayout = new GridLayout();
        rootContainer.setLayout((Layout)rootContainerLayout);
        this.createTemplatesViewer(rootContainer);
        if (this.getSite() != null && this.getSite().getPage() != null && this.partListener == null) {
            this.partListener = this.createPartListener();
            this.getSite().getPage().addPartListener(this.partListener);
        }
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    try {
                        IResourceDelta delta = event.getDelta();
                        IFile aFile = OverridesBrowser.this.getFileInDelta(delta);
                        if (aFile != null) {
                            OverridesBrowser.this.clean = true;
                            OverridesBrowser.this.project = null;
                            OverridesBrowser.this.refreshContent(aFile);
                        }
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
    }

    private IFile getFileInDelta(IResourceDelta delta) throws CoreException {
        IFile result = null;
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                if ("mtl".equals(resource.getFileExtension()) || "MANIFEST.MF".equals(resource.getName())) {
                    result = (IFile)resource;
                }
            } else {
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (result == null && i < children.length) {
                    result = this.getFileInDelta(children[i]);
                    ++i;
                }
            }
        }
        return result;
    }

    private IPartListener createPartListener() {
        return new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof AcceleoEditor) {
                    AcceleoEditor editor = (AcceleoEditor)part;
                    OverridesBrowser.this.refreshContent(editor.getFile());
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == OverridesBrowser.this) {
                    OverridesBrowser.this.initializeTemplatesViewerContent();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof AcceleoEditor) {
                    AcceleoEditor editor = (AcceleoEditor)part;
                    OverridesBrowser.this.refreshContent(editor.getFile());
                }
            }
        };
    }

    private void refreshContent(IFile aFile) {
        IProject aProject = aFile != null ? aFile.getProject() : null;
        if (!this.clean && (aProject == null || aProject != null && aProject == this.project)) {
            return;
        }
        this.clean = false;
        this.project = aProject;
        if (this.refreshContent != null) {
            this.refreshContent.cancel();
        }
        this.refreshContent = new Job("Acceleo"){

            protected IStatus run(IProgressMonitor monitor) {
                OverridesBrowser.this.updateViewTemplates(monitor);
                return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
            }
        };
        this.refreshContent.setPriority(50);
        this.refreshContent.setSystem(true);
        this.refreshContent.schedule(1000L);
    }

    private synchronized void updateViewTemplates(IProgressMonitor monitor) {
        if (this.project != null) {
            HashSet<ResourceSet> newResourceSet = new HashSet<ResourceSet>();
            AcceleoProject acceleoProject = new AcceleoProject(this.project);
            ArrayList<ModuleProjectHandler> projects = new ArrayList<ModuleProjectHandler>();
            ResourceSet resourceSet = acceleoProject.loadAccessibleOutputFiles(monitor);
            this.computeModuleProjectHandlers(resourceSet, true, projects);
            newResourceSet.add(resourceSet);
            if (!monitor.isCanceled()) {
                resourceSet = acceleoProject.loadNotAccessibleOutputFiles(monitor);
                newResourceSet.add(resourceSet);
            }
            if (!monitor.isCanceled()) {
                this.computeModuleProjectHandlers(resourceSet, false, projects);
                this.asyncUpdateViewTemplates(projects);
                if (this.toUnload.size() > 0) {
                    for (ResourceSet resourceSetToUnload : this.toUnload) {
                        this.unloadResourceSet(resourceSetToUnload);
                    }
                    this.toUnload.clear();
                }
                this.toUnload.addAll(newResourceSet);
            } else {
                for (ResourceSet resourceSetToUnload : newResourceSet) {
                    this.unloadResourceSet(resourceSetToUnload);
                }
            }
        } else {
            ArrayList<ModuleProjectHandler> projects = new ArrayList<ModuleProjectHandler>();
            ResourceSet resourceSet = AcceleoProject.loadAllPlatformOutputFiles(monitor);
            if (!monitor.isCanceled()) {
                this.computeModuleProjectHandlers(resourceSet, false, projects);
                this.asyncUpdateViewTemplates(projects);
                if (this.toUnload.size() > 0) {
                    for (ResourceSet resourceSetToUnload : this.toUnload) {
                        this.unloadResourceSet(resourceSetToUnload);
                    }
                    this.toUnload.clear();
                }
                this.toUnload.add(resourceSet);
            } else {
                this.unloadResourceSet(resourceSet);
            }
        }
    }

    private void asyncUpdateViewTemplates(final List<ModuleProjectHandler> projects) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Object[] checkedElements = OverridesBrowser.this.templatesViewer.getCheckedElements();
                OverridesBrowser.this.templatesViewer.setInput((Object)projects.toArray());
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject eObject;
                    URI fileURI;
                    Object checkedElement = objectArray[n2];
                    if (checkedElement instanceof EObject && ((EObject)checkedElement).eResource() != null && (fileURI = (eObject = (EObject)checkedElement).eResource().getURI()) != null) {
                        String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
                        EObject newEObject = OverridesBrowser.this.expandFragment(fileURI, eObjectFragmentURI);
                        OverridesBrowser.this.templatesViewer.setChecked((Object)newEObject, true);
                    }
                    ++n2;
                }
            }
        });
    }

    private void unloadResourceSet(ResourceSet resourceSetToUnload) {
        for (Resource resource : resourceSetToUnload.getResources()) {
            if (!resource.isLoaded()) continue;
            resource.unload();
        }
    }

    private void computeModuleProjectHandlers(ResourceSet emtlResourceSet, boolean isResolved, List<ModuleProjectHandler> projects) {
        if (emtlResourceSet != null) {
            HashMap<String, ArrayList<Module>> project2emtl = new HashMap<String, ArrayList<Module>>();
            for (Resource emtlResource : emtlResourceSet.getResources()) {
                if (emtlResource.getContents().size() <= 0 || !(emtlResource.getContents().get(0) instanceof Module)) continue;
                Module eModule = (Module)emtlResource.getContents().get(0);
                String projectName = this.getModuleProjectName(eModule);
                ArrayList<Module> toFill = (ArrayList<Module>)project2emtl.get(projectName);
                if (toFill == null) {
                    toFill = new ArrayList<Module>();
                    project2emtl.put(projectName, toFill);
                }
                toFill.add(eModule);
            }
            for (Map.Entry entry : project2emtl.entrySet()) {
                String projectName = (String)entry.getKey();
                List eModules = (List)entry.getValue();
                ModuleProjectHandler projectHanlder = new ModuleProjectHandler(projectName, eModules.toArray(new Module[eModules.size()]), isResolved);
                if (this.project != null && projectName.equals(this.project.getName())) {
                    projects.add(0, projectHanlder);
                    continue;
                }
                projects.add(projectHanlder);
            }
        }
    }

    private String getModuleProjectName(Module eModule) {
        String result;
        Resource resource = eModule.eResource();
        if (resource != null) {
            String prefix;
            URI uri = resource.getURI();
            String path = uri.toString();
            if (path.startsWith(prefix = "platform:/resource/")) {
                path = path.substring(prefix.length());
            } else {
                prefix = "platform:/plugin/";
                if (path.startsWith(prefix)) {
                    path = path.substring(prefix.length());
                }
            }
            Path relativePath = new Path(path);
            result = relativePath.segmentCount() > 1 ? (uri.isPlatformPlugin() ? String.valueOf(relativePath.segment(0)) + " [plugin]" : relativePath.segment(0)) : "[others]";
        } else {
            result = "[others]";
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        if (this.getSite() != null && this.getSite().getPage() != null && this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.partListener = null;
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        if (this.toUnload.size() > 0) {
            for (ResourceSet resourceSet : this.toUnload) {
                this.unloadResourceSet(resourceSet);
            }
            this.toUnload.clear();
        }
    }

    private void createTemplatesViewer(Composite parent) {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.templatesViewer = new CheckboxTreeViewer(parent, 2048);
        this.templatesViewer.getTree().setLayoutData((Object)data);
        this.templatesViewer.getTree().setFont(parent.getFont());
        this.templatesViewer.setContentProvider((IContentProvider)new OverridesBrowserTemplatesProvider((AdapterFactory)this.adapterFactory));
        this.templatesViewer.setLabelProvider((IBaseLabelProvider)new OverridesBrowserTemplateLabelProvider((AdapterFactory)this.adapterFactory));
        this.templatesViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean active;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!this.active) {
                    this.active = true;
                    try {
                        if (event.getElement() instanceof ModuleProjectHandler) {
                            ModuleProjectHandler projectHandler = (ModuleProjectHandler)event.getElement();
                            OverridesBrowser.this.templatesViewer.expandToLevel((Object)projectHandler, 1);
                            Module[] moduleArray = projectHandler.getModules();
                            int n = moduleArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Module eModule = moduleArray[n2];
                                OverridesBrowser.this.templatesViewer.expandToLevel((Object)eModule, 1);
                                OverridesBrowser.this.templatesViewer.setChecked((Object)eModule, event.getChecked());
                                OverridesBrowser.this.checkStateTemplate(eModule, event.getChecked());
                                ++n2;
                            }
                        } else if (event.getElement() instanceof Module) {
                            Module eModule = (Module)event.getElement();
                            OverridesBrowser.this.checkStateTemplate(eModule, event.getChecked());
                        }
                    }
                    finally {
                        this.active = false;
                    }
                }
            }
        });
        this.templatesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
                    EObject eObject = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                    OverridesBrowser.this.handleDoubleClick(eObject);
                }
            }
        });
        this.initializeTemplatesViewerContent();
    }

    private void initializeTemplatesViewerContent() {
        IEditorPart part = this.getSite().getPage().getActiveEditor();
        if (part instanceof AcceleoEditor) {
            AcceleoEditor editor = (AcceleoEditor)part;
            this.refreshContent(editor.getFile());
        } else {
            this.refreshContent(null);
        }
    }

    private void handleDoubleClick(EObject eObject) {
        if (eObject.eResource() != null) {
            Region region = eObject instanceof ModuleElement ? new Region(((ModuleElement)eObject).getStartPosition(), ((ModuleElement)eObject).getEndPosition()) : null;
            URI fileURI = eObject.eResource().getURI();
            if (fileURI != null) {
                String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
                OpenDeclarationUtils.showEObject(this.getSite().getPage(), fileURI, (IRegion)region, eObject);
                this.expandFragment(fileURI, eObjectFragmentURI);
            }
        }
    }

    private EObject expandFragment(URI eObjectFileURI, String eObjectFragmentURI) {
        if (eObjectFileURI != null && eObjectFragmentURI != null && this.templatesViewer.getInput() instanceof Object[]) {
            Object[] inputs;
            Object[] objectArray = inputs = (Object[])this.templatesViewer.getInput();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                Object input = objectArray[n2];
                if (input instanceof ModuleProjectHandler) {
                    ModuleProjectHandler projectHandler = (ModuleProjectHandler)input;
                    Module[] moduleArray = projectHandler.getModules();
                    int n3 = moduleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Module eModule = moduleArray[n4];
                        EObject newEObject = eModule.eResource() != null && eModule.eResource().getURI().equals((Object)eObjectFileURI) ? eModule.eResource().getEObject(eObjectFragmentURI) : null;
                        if (newEObject instanceof ModuleElement) {
                            this.templatesViewer.setExpandedState((Object)projectHandler, true);
                            this.templatesViewer.setExpandedState((Object)newEObject.eContainer(), true);
                            this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)newEObject), true);
                        } else if (newEObject instanceof Module) {
                            this.templatesViewer.setExpandedState((Object)projectHandler, true);
                            this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)newEObject), true);
                        }
                        if (newEObject != null) {
                            return newEObject;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private synchronized void checkStateTemplate(Module eModule, boolean state) {
        for (ModuleElement eModuleElement : eModule.getOwnedModuleElement()) {
            this.templatesViewer.expandToLevel((Object)eModuleElement, 1);
            this.templatesViewer.setChecked((Object)eModuleElement, state);
        }
    }

    public List<ICompletionProposal> getExtendCompletionProposals(IDocument document, String text, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        StringBuilder proposalBuffer = new StringBuilder();
        Object[] templateCheckedElements = this.templatesViewer.getCheckedElements();
        if (templateCheckedElements.length > 0) {
            int index = offset;
            while (index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1))) {
                --index;
            }
            if (index > 0 && (text.charAt(index - 1) == '[' || text.charAt(index - 1) == ']')) {
                --index;
            }
            String start = text.substring(index, offset);
            HashMap<URI, StringBuffer> fileURI2Buffer = new HashMap<URI, StringBuffer>();
            int i = 0;
            while (i < templateCheckedElements.length) {
                Object templateCheckedElement = templateCheckedElements[i];
                if (templateCheckedElement instanceof ModuleElement && ((ModuleElement)templateCheckedElement).eResource() != null) {
                    ModuleElement element = (ModuleElement)templateCheckedElement;
                    URI fileURI = ((ModuleElement)templateCheckedElement).eResource().getURI();
                    StringBuffer currentBuffer = (StringBuffer)fileURI2Buffer.get(fileURI);
                    if (currentBuffer == null && fileURI != null) {
                        currentBuffer = this.createMTLContent(fileURI);
                        fileURI2Buffer.put(fileURI, currentBuffer);
                    }
                    if (currentBuffer != null && element.getEndPosition() > -1 && currentBuffer.length() >= element.getEndPosition()) {
                        StringBuffer currentText = new StringBuffer(currentBuffer.substring(element.getStartPosition(), element.getEndPosition()).replace("$", "$$"));
                        currentText.append("\n");
                        this.modifyModuleElementContent(element, currentText);
                        proposalBuffer.append(currentText);
                        proposalBuffer.append("\n");
                    }
                }
                ++i;
            }
            if (proposalBuffer.length() > 0) {
                org.eclipse.jface.text.templates.Template template = new org.eclipse.jface.text.templates.Template("Selected Overrides", "Selected Overrides", "__ACCELEO_block", proposalBuffer.toString(), true);
                TemplateContextType type = new TemplateContextType("__ACCELEO_block", "__ACCELEO_block");
                DocumentTemplateContext context = new DocumentTemplateContext(type, document, offset - start.length(), start.length());
                Region region = new Region(offset - start.length(), start.length());
                AcceleoCompletionTemplateProposal proposal = new AcceleoCompletionTemplateProposal(template, (TemplateContext)context, (IRegion)region, AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/OverridesBrowser.gif"));
                proposals.add((ICompletionProposal)proposal);
            }
        }
        return proposals;
    }

    private StringBuffer createMTLContent(URI fileURI) {
        StringBuffer currentBuffer = new StringBuffer();
        Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(fileURI);
        File absoluteFile = null;
        if (fileObject instanceof IFile) {
            absoluteFile = ((IFile)fileObject).getLocation().toFile();
        } else if (fileObject instanceof File) {
            absoluteFile = (File)fileObject;
        }
        if (absoluteFile != null) {
            File[] members;
            String mtlName = new Path(absoluteFile.getName()).removeFileExtension().addFileExtension("mtl").lastSegment();
            File[] fileArray = members = absoluteFile.getParentFile().listFiles();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                File member = fileArray[n2];
                if (mtlName.equals(member.getName())) {
                    currentBuffer = FileContent.getFileContent((File)member);
                    break;
                }
                ++n2;
            }
        }
        return currentBuffer;
    }

    private void modifyModuleElementContent(ModuleElement element, StringBuffer content) {
        int iBeginParenth = content.indexOf("(");
        if (iBeginParenth > -1) {
            if (element instanceof Template) {
                int iEndParenth;
                String templateName = ((Template)element).getName();
                EObject eObject = ((Template)element).eContainer();
                if (eObject instanceof Module) {
                    String newComment = "[comment @Override " + ((Module)eObject).getName() + "." + templateName + " /]\n";
                    content.insert(0, newComment);
                    iBeginParenth += newComment.length();
                }
                if ((iEndParenth = content.indexOf(")", iBeginParenth)) > -1 && ((Template)element).getOverrides().size() == 0) {
                    content.insert(iEndParenth += ")".length(), " overrides " + templateName + " ");
                }
            }
            int iEndName = iBeginParenth;
            while (iEndName > 0 && Character.isWhitespace(content.charAt(iEndName - 1))) {
                --iEndName;
            }
            int iBeginName = iEndName;
            while (iBeginName > 0 && Character.isJavaIdentifierPart(content.charAt(iBeginName - 1))) {
                --iBeginName;
            }
            content.insert(iEndName, "}");
            content.insert(iBeginName, "${");
        }
    }
}

