/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.internal.traceability.engine.AcceleoTraceabilityVisitor;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoTraceabilityOperationVisitor<C, PM> {
    private AcceleoTraceabilityVisitor<EPackage, C, EOperation, EStructuralFeature, EEnumLiteral, PM, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> visitor;

    public AcceleoTraceabilityOperationVisitor(AcceleoTraceabilityVisitor<EPackage, C, EOperation, EStructuralFeature, EEnumLiteral, PM, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> visitor) {
        this.visitor = visitor;
    }

    public String visitFirstOperation(String source, int endIndex) {
        String result = endIndex < 0 || endIndex > source.length() ? source : this.visitSubstringOperation(source, 0, endIndex);
        return result;
    }

    public Integer visitIndexOperation(String source, String substring) {
        int result = source.indexOf(substring);
        int digitCount = result == -1 ? 2 : 1 + (int)Math.log(result);
        ExpressionTrace<C> trace = this.visitor.getLastExpressionTrace();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                if (text.getEndOffset() < result || text.getStartOffset() > result) {
                    entry.getValue().remove(text);
                    continue;
                }
                text.setStartOffset(0);
                text.setEndOffset(digitCount);
            }
        }
        trace.setOffset(digitCount);
        if (++result == Integer.valueOf(0)) {
            result = -1;
        }
        return result;
    }

    public Boolean visitIsAlphanumOperation(String source) {
        char[] chars;
        boolean result = true;
        char[] cArray = chars = source.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                result = false;
                break;
            }
            ++n2;
        }
        this.changeTraceabilityIndicesBooleanReturn(result);
        return result;
    }

    public Boolean visitIsAlphaOperation(String source) {
        char[] chars;
        boolean result = true;
        char[] cArray = chars = source.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c)) {
                result = false;
                break;
            }
            ++n2;
        }
        this.changeTraceabilityIndicesBooleanReturn(result);
        return result;
    }

    public String visitLastOperation(String source, int charCount) {
        String result = charCount < 0 || charCount > source.length() ? source : this.visitSubstringOperation(source, source.length() - charCount, source.length());
        return result;
    }

    public String visitReplaceOperation(String source, String substring, String replacement, ExpressionTrace<C> substitutionTrace, boolean substituteAll, boolean useInvocationTrace) {
        if (substring == null || replacement == null) {
            throw new NullPointerException();
        }
        Matcher sourceMatcher = Pattern.compile(substring).matcher(source);
        StringBuffer result = new StringBuffer();
        boolean hasMatch = sourceMatcher.find();
        int addedLength = 0;
        boolean startsWithZeroGroupRef = replacement.startsWith("$0");
        while (hasMatch) {
            int startIndex = sourceMatcher.start() + addedLength;
            int endIndex = sourceMatcher.end() + addedLength;
            if (startsWithZeroGroupRef) {
                startIndex = endIndex;
            }
            int replacementLength = startIndex;
            sourceMatcher.appendReplacement(result, replacement);
            replacementLength = result.length() - startIndex;
            addedLength += (replacementLength -= endIndex - startIndex);
            if (useInvocationTrace && this.visitor.getCurrentFiles().size() > 0) {
                int offsetGap = -1;
                for (ExpressionTrace expressionTrace : this.visitor.getInvocationTraces()) {
                    for (Map.Entry<InputElement, Set<GeneratedText>> entry : expressionTrace.getTraces().entrySet()) {
                        for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                            if (offsetGap != -1 && text.getStartOffset() >= offsetGap) continue;
                            offsetGap = text.getStartOffset();
                        }
                    }
                }
                startIndex += offsetGap;
                endIndex += offsetGap;
                for (ExpressionTrace expressionTrace : this.visitor.getInvocationTraces()) {
                    this.changeTraceabilityIndicesOfReplaceOperation(expressionTrace, startIndex, endIndex, replacementLength);
                }
                GeneratedFile generatedFile = this.visitor.getCurrentFiles().getLast();
                int fileLength = generatedFile.getLength();
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : substitutionTrace.getTraces().entrySet()) {
                    for (GeneratedText text : entry.getValue()) {
                        GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                        copy.setStartOffset(copy.getStartOffset() + startIndex);
                        copy.setEndOffset(copy.getEndOffset() + startIndex);
                        generatedFile.getGeneratedRegions().add((Object)copy);
                    }
                }
                generatedFile.setLength(fileLength + replacementLength);
            } else {
                ExpressionTrace<C> trace = this.visitor.getLastExpressionTrace();
                this.changeTraceabilityIndicesOfReplaceOperation(trace, startIndex, endIndex, replacementLength);
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : substitutionTrace.getTraces().entrySet()) {
                    Set<GeneratedText> existingTraces = trace.getTraces().get(entry.getKey());
                    if (existingTraces == null) {
                        existingTraces = new LinkedHashSet<GeneratedText>();
                        trace.getTraces().put(entry.getKey(), existingTraces);
                    }
                    for (GeneratedText text : entry.getValue()) {
                        GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                        copy.setStartOffset(copy.getStartOffset() + startIndex);
                        copy.setEndOffset(copy.getEndOffset() + startIndex);
                        existingTraces.add(copy);
                    }
                }
            }
            if (!substituteAll) break;
            hasMatch = sourceMatcher.find();
        }
        sourceMatcher.appendTail(result);
        return result.toString();
    }

    public Collection<Object> visitSepOperation(Collection<Object> source, String separator) {
        ArrayList<Object> temp = new ArrayList<Object>(source.size() << 1);
        Iterator<Object> sourceIterator = source.iterator();
        while (sourceIterator.hasNext()) {
            temp.add(sourceIterator.next());
            if (!sourceIterator.hasNext()) continue;
            temp.add(separator);
        }
        return temp;
    }

    public String visitSubstringOperation(String source, int startIndex, int endIndex) {
        this.changeTraceabilityIndicesSubstringReturn(startIndex, endIndex);
        return source.substring(startIndex, endIndex);
    }

    public String visitTrimOperation(String source) {
        return this.visitTrimOperation(source, 0);
    }

    public String visitTrimOperation(String source, int gap) {
        int start = 0;
        int end = source.length();
        char[] chars = source.toCharArray();
        while (start < end && chars[start] <= ' ') {
            ++start;
        }
        while (start < end && chars[end - 1] <= ' ') {
            --end;
        }
        this.changeTraceabilityIndicesSubstringReturn(start += gap, end += gap);
        return source.trim();
    }

    private void changeTraceabilityIndicesBooleanReturn(boolean result) {
        ExpressionTrace<C> trace = this.visitor.getLastExpressionTrace();
        Map.Entry<InputElement, Set<GeneratedText>> lastEntry = null;
        GeneratedText lastRegion = null;
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                if (lastRegion == null) {
                    lastRegion = text;
                    lastEntry = entry;
                    continue;
                }
                if (text.getEndOffset() > lastRegion.getEndOffset()) {
                    assert (lastEntry != null);
                    lastEntry.getValue().remove(lastRegion);
                    lastRegion = text;
                    lastEntry = entry;
                    continue;
                }
                entry.getValue().remove(text);
            }
        }
        int length = result ? 4 : 5;
        if (lastRegion != null) {
            lastRegion.setStartOffset(0);
            lastRegion.setStartOffset(length);
        }
        trace.setOffset(length);
    }

    private void changeTraceabilityIndicesOfReplaceOperation(ExpressionTrace<C> trace, int startIndex, int endIndex, int replacementLength) {
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                if (text.getEndOffset() < startIndex) continue;
                if (text.getStartOffset() < startIndex && text.getEndOffset() <= endIndex) {
                    text.setEndOffset(startIndex);
                    continue;
                }
                if (text.getStartOffset() >= startIndex && text.getEndOffset() > endIndex) {
                    text.setStartOffset(startIndex + replacementLength);
                    text.setEndOffset(text.getEndOffset() + replacementLength);
                    continue;
                }
                if (text.getStartOffset() < startIndex && text.getEndOffset() > endIndex) {
                    GeneratedText endSubstring = (GeneratedText)EcoreUtil.copy((EObject)text);
                    endSubstring.setStartOffset(endIndex + replacementLength);
                    endSubstring.setEndOffset(text.getEndOffset() + replacementLength);
                    text.setEndOffset(startIndex);
                    if (text.eContainer() != null) {
                        ((List)text.eContainer().eGet(text.eContainingFeature())).add(endSubstring);
                    }
                    entry.getValue().add(endSubstring);
                    continue;
                }
                if (text.getStartOffset() >= startIndex && text.getEndOffset() <= endIndex) {
                    if (text.eContainer() != null) {
                        EcoreUtil.remove((EObject)text);
                    }
                    entry.getValue().remove(text);
                    continue;
                }
                text.setStartOffset(text.getStartOffset() + replacementLength);
                text.setEndOffset(text.getEndOffset() + replacementLength);
            }
        }
    }

    private void changeTraceabilityIndicesSubstringReturn(int startIndex, int endIndex) {
        ExpressionTrace<C> trace = this.visitor.getLastExpressionTrace();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
            for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                if (text.getEndOffset() <= startIndex || text.getStartOffset() >= endIndex) {
                    entry.getValue().remove(text);
                    continue;
                }
                if (text.getStartOffset() < startIndex && text.getEndOffset() > endIndex) {
                    text.setStartOffset(0);
                    text.setEndOffset(endIndex - startIndex);
                    continue;
                }
                if (text.getStartOffset() < startIndex) {
                    text.setStartOffset(0);
                    text.setEndOffset(text.getEndOffset() - startIndex);
                    continue;
                }
                if (text.getEndOffset() > endIndex) {
                    text.setStartOffset(text.getStartOffset() - startIndex);
                    text.setEndOffset(endIndex - startIndex);
                    continue;
                }
                text.setStartOffset(text.getStartOffset() - startIndex);
                text.setEndOffset(text.getEndOffset() - startIndex);
            }
        }
    }
}

