/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.JavaServicesUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaServicesWrapperStrategy
implements IAcceleoExampleStrategy {
    public String getDescription() {
        return AcceleoUIMessages.getString("JavaServicesWrapperStrategy.Description");
    }

    public String getInitialFileNameFilter() {
        return "*.java";
    }

    public boolean forceMetamodelURI() {
        return false;
    }

    public boolean forceHasFile() {
        return true;
    }

    public boolean forceHasMain() {
        return true;
    }

    public boolean forceMetamodelType() {
        return true;
    }

    public String getContent(IFile exampleFile, String moduleName, boolean templateHasFileBlock, boolean templateIsMain, String metamodelURI, String metamodelFileType) {
        StringBuilder buffer = new StringBuilder("");
        buffer.append("[module " + moduleName + "('");
        StringTokenizer st = new StringTokenizer(metamodelURI, ",");
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken().trim());
            if (!st.hasMoreTokens()) continue;
            buffer.append("', '");
        }
        buffer.append("')/]\n\n");
        if (exampleFile != null && exampleFile.exists()) {
            buffer.append(this.createWrapper(exampleFile));
        }
        return buffer.toString();
    }

    private String createWrapper(IFile exampleFile) {
        StringBuilder buffer = new StringBuilder();
        IJavaElement javaElement = JavaCore.create((IFile)exampleFile);
        if (javaElement instanceof ICompilationUnit) {
            IType[] types;
            ICompilationUnit classFile = (ICompilationUnit)javaElement;
            try {
                types = classFile.getTypes();
            }
            catch (JavaModelException javaModelException) {
                types = new IType[]{};
            }
            int i = 0;
            while (i < types.length) {
                String typeQualifiedName = types[i].getFullyQualifiedName();
                AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(exampleFile.getProject());
                try {
                    Class javaClass = AcceleoWorkspaceUtil.INSTANCE.getClass(typeQualifiedName, false);
                    if (javaClass != null) {
                        Method[] javaMethods = javaClass.getDeclaredMethods();
                        int j = 0;
                        while (j < javaMethods.length) {
                            Method javaMethod = javaMethods[j];
                            buffer.append(JavaServicesUtils.createQuery(javaMethod));
                            ++j;
                        }
                    }
                }
                finally {
                    AcceleoWorkspaceUtil.INSTANCE.reset();
                }
                ++i;
            }
        }
        return buffer.toString();
    }
}

