/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl.environment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoOCLReflection;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.acceleo.common.utils.AcceleoNonStandardLibrary;
import org.eclipse.acceleo.common.utils.AcceleoStandardLibrary;
import org.eclipse.acceleo.internal.compatibility.parser.ast.ocl.environment.AcceleoUMLReflectionHelios;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoUMLReflection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEnvironment
extends EcoreEnvironment {
    private AcceleoNonStandardLibrary acceleoNonStdLib;
    private AcceleoStandardLibrary acceleoStdLib;
    private List<EPackage> metamodels = new ArrayList<EPackage>();
    private List<EClassifier> types = new ArrayList<EClassifier>();
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> umlReflection;
    private AcceleoOCLReflection oclStdLibReflection;
    private Object firstProblemObject;

    public AcceleoEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
        if (!(parent instanceof AcceleoEnvironment)) {
            this.addAdditionalOperations();
        }
    }

    public AcceleoEnvironment(Resource oclEnvironmentResource) {
        super(EPackage.Registry.INSTANCE, oclEnvironmentResource);
        this.addAdditionalOperations();
    }

    public void addMetamodel(EPackage metamodel) {
        this.metamodels.add(metamodel);
        this.types.clear();
    }

    public void removeMetamodel(EPackage metamodel) {
        this.metamodels.remove(metamodel);
        this.types.clear();
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier classifier = null;
        if (names.size() > 0) {
            Iterator<EClassifier> eClassifierIt = this.getTypes().iterator();
            while (classifier == null && eClassifierIt.hasNext()) {
                EClassifier eClassifier = eClassifierIt.next();
                if (!names.get(names.size() - 1).equals(eClassifier.getName()) || names.size() >= 2 && !names.get(names.size() - 2).equals(eClassifier.getEPackage().getName())) continue;
                classifier = eClassifier;
            }
            if (classifier == null) {
                classifier = super.lookupClassifier(names);
            }
        }
        return classifier;
    }

    public EClassifier lookupClassifier(String name) {
        EClassifier classifier = null;
        if (name != null && (classifier = this.lookupSequenceClassifier(name)) == null) {
            ArrayList<String> names = new ArrayList<String>();
            int eNamespace = name.indexOf("::");
            if (eNamespace > -1) {
                String packageName = name.substring(0, eNamespace).trim();
                String className = name.substring(eNamespace + "::".length()).trim();
                names.add(packageName);
                names.add(className);
            } else {
                names.add(name);
            }
            classifier = this.lookupClassifier(names);
        }
        if (classifier != null) {
            classifier = (EClassifier)this.getUMLReflection().getOCLType((Object)classifier);
        }
        return classifier;
    }

    private EClassifier lookupSequenceClassifier(String name) {
        int iPar;
        if (name.endsWith(")") && (iPar = name.indexOf("(")) > -1) {
            String sequenceType = name.substring(0, iPar).trim();
            String elementType = name.substring(iPar + "(".length(), name.length() - ")".length()).trim();
            EClassifier elementClassifier = this.lookupClassifier(elementType);
            org.eclipse.ocl.types.CollectionType sequenceClassifier = null;
            if (elementClassifier != null && CollectionKind.getByName((String)sequenceType) != null) {
                sequenceClassifier = this.getTypeResolver().resolveCollectionType(CollectionKind.getByName((String)sequenceType), (Object)elementClassifier);
            }
            if (sequenceClassifier instanceof EClassifier) {
                return (EClassifier)sequenceClassifier;
            }
        }
        return null;
    }

    public List<EOperation> getAdditionalOperations(EClassifier classifier) {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        result.addAll(super.getAdditionalOperations((Object)classifier));
        if (!(classifier instanceof PrimitiveType)) {
            result.addAll(super.getAdditionalOperations((Object)EcorePackage.eINSTANCE.getEObject()));
        }
        return result;
    }

    public AcceleoNonStandardLibrary getAcceleoNonStandardLibrary() {
        if (this.acceleoNonStdLib == null) {
            this.acceleoNonStdLib = new AcceleoNonStandardLibrary();
        }
        return this.acceleoNonStdLib;
    }

    public AcceleoStandardLibrary getAcceleoStandardLibrary() {
        if (this.acceleoStdLib == null) {
            this.acceleoStdLib = new AcceleoStandardLibrary();
        }
        return this.acceleoStdLib;
    }

    public List<EClassifier> getTypes() {
        if (this.types.size() == 0) {
            for (EPackage ePackage : this.getMetamodels()) {
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    this.computeOCLType(this.types, eClassifier);
                }
            }
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getBag());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getBoolean());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getCollection());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getInteger());
            this.computeOCLType(this.types, this.getOCLStandardLibraryReflection().getOCLInvalid());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclAny());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclElement());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclExpression());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclMessage());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclType());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclVoid());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOrderedSet());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getReal());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getSequence());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getSet());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getState());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getString());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getT());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getT2());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural());
        }
        return this.types;
    }

    protected List<EPackage> getMetamodels() {
        ArrayList<EPackage> metamodelsInScope = new ArrayList<EPackage>(this.metamodels);
        Environment.Internal parent = this.getInternalParent();
        while (parent != null) {
            if (parent instanceof AcceleoEnvironment) {
                metamodelsInScope.addAll(((AcceleoEnvironment)parent).getMetamodels());
                break;
            }
            parent = this.getInternalParent();
        }
        return metamodelsInScope;
    }

    public AcceleoOCLReflection getOCLStandardLibraryReflection() {
        if (this.oclStdLibReflection == null) {
            this.oclStdLibReflection = new AcceleoOCLReflection((EcoreEnvironment)this);
        }
        return this.oclStdLibReflection;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.umlReflection == null) {
            this.umlReflection = AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GANYMEDE || AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GALILEO ? new AcceleoUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection()) : new AcceleoUMLReflectionHelios((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection());
        }
        return this.umlReflection;
    }

    private void computeOCLType(List<EClassifier> result, EClassifier type) {
        EClassifier oclType = (EClassifier)this.getTypeResolver().resolve((Object)type);
        if (oclType != null) {
            if (!result.contains(oclType)) {
                result.add(oclType);
            }
        } else if (!result.contains(type)) {
            result.add(type);
        }
    }

    public void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }

    private void addAdditionalOperations() {
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getInteger(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getInteger()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getReal(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getReal()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)EcorePackage.eINSTANCE.getEObject(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)EcorePackage.eINSTANCE.getEObject()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOclAny(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOclAny()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getCollection(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getCollection()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getSequence(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getSequence()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOrderedSet(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOrderedSet()));
    }

    public EOperation lookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        EOperation oper = (EOperation)super.lookupOperation((Object)owner, name, args);
        if (oper == null) {
            if (owner instanceof SequenceType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getSequence()), name, args);
            } else if (owner instanceof BagType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getBag()), name, args);
            } else if (owner instanceof OrderedSetType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getOrderedSet()), name, args);
            } else if (owner instanceof SetType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getSet()), name, args);
            } else if (owner instanceof CollectionType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getCollection()), name, args);
            }
        }
        if (oper == null && !(owner instanceof PrimitiveType)) {
            oper = (EOperation)super.lookupOperation((Object)EcorePackage.eINSTANCE.getEObject(), name, args);
        }
        return oper;
    }

    public void addHelperOperations(EClassifier owner, List<EOperation> operations) {
        for (EOperation operation : operations) {
            this.addHelperOperation(owner, operation);
        }
    }

    public Object getFirstProblemObject() {
        Object result = this.firstProblemObject != null ? this.firstProblemObject : (this.getInternalParent() instanceof AcceleoEnvironment ? ((AcceleoEnvironment)this.getInternalParent()).getFirstProblemObject() : null);
        return result;
    }

    public void deleteFirstProblemObject() {
        this.firstProblemObject = null;
        if (this.getInternalParent() instanceof AcceleoEnvironment) {
            ((AcceleoEnvironment)this.getInternalParent()).deleteFirstProblemObject();
        }
    }

    public void dispose() {
        super.dispose();
        this.acceleoNonStdLib = null;
        this.acceleoStdLib = null;
        this.firstProblemObject = null;
        this.metamodels.clear();
        this.metamodels = null;
        this.oclStdLibReflection = null;
        this.types.clear();
        this.types = null;
        this.umlReflection = null;
    }

    private void setFirstProblemObjectIfNull(Object problemObject) {
        if (this.firstProblemObject == null) {
            this.firstProblemObject = problemObject;
        }
        if (this.getInternalParent() instanceof AcceleoEnvironment) {
            ((AcceleoEnvironment)this.getInternalParent()).setFirstProblemObjectIfNull(problemObject);
        }
    }

    public void analyzerError(String problemMessage, String problemContext, Object problemObject) {
        this.setFirstProblemObjectIfNull(problemObject);
        super.analyzerError(problemMessage, problemContext, problemObject);
    }

    public void analyzerError(String problemMessage, String problemContext, List<?> problemObjects) {
        if (problemObjects != null && problemObjects.size() > 0) {
            this.setFirstProblemObjectIfNull(problemObjects.get(0));
        }
        super.analyzerError(problemMessage, problemContext, problemObjects);
    }
}

