/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.DoubleLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.ExpressionsFactory;
import org.eclipse.acceleo.compatibility.model.mt.expressions.IntegerLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Literal;
import org.eclipse.acceleo.compatibility.model.mt.expressions.StringLiteral;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Conventions;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class LiteralParser {
    protected static final String LITERAL_TRUE = TemplateConstants.getDefault().getLiteraltrue();
    protected static final String LITERAL_FALSE = TemplateConstants.getDefault().getLiteralfalse();
    protected static final String LITERAL_NULL = TemplateConstants.getDefault().getLiteralnull();

    private LiteralParser() {
    }

    public static Literal createLiteral(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        Literal expression;
        Region localRange = range;
        Region trim = TextSearch.trim(buffer, localRange.b(), localRange.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingElement"), template, localRange);
        }
        localRange = trim;
        String text = buffer.substring(localRange.b(), localRange.e());
        if (text.length() >= TemplateConstants.getDefault().getLiteral()[0].length() + TemplateConstants.getDefault().getLiteral()[1].length() && text.startsWith(TemplateConstants.getDefault().getLiteral()[0])) {
            if (!text.endsWith(TemplateConstants.getDefault().getLiteral()[1])) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidLitteral"), template, localRange);
            }
            String value = text.substring(TemplateConstants.getDefault().getLiteral()[0].length(), text.length() - TemplateConstants.getDefault().getLiteral()[1].length());
            expression = ExpressionsFactory.eINSTANCE.createStringLiteral();
            ((StringLiteral)expression).setValue(Conventions.unformatString(value));
        } else if (text.equals(LITERAL_TRUE)) {
            expression = ExpressionsFactory.eINSTANCE.createBooleanLiteral();
            expression.setValue(true);
        } else if (text.equals(LITERAL_FALSE)) {
            expression = ExpressionsFactory.eINSTANCE.createBooleanLiteral();
            expression.setValue(false);
        } else if (text.equals(LITERAL_NULL)) {
            expression = ExpressionsFactory.eINSTANCE.createNullLiteral();
        } else if (text.indexOf(".") > -1) {
            try {
                expression = ExpressionsFactory.eINSTANCE.createDoubleLiteral();
                ((DoubleLiteral)expression).setValue(Double.parseDouble(text));
            }
            catch (NumberFormatException e) {
                expression = null;
            }
        } else {
            try {
                expression = ExpressionsFactory.eINSTANCE.createIntegerLiteral();
                ((IntegerLiteral)expression).setValue(Integer.parseInt(text));
            }
            catch (NumberFormatException e) {
                expression = null;
            }
        }
        if (expression != null) {
            expression.setBegin(offset + localRange.b());
            expression.setEnd(offset + localRange.e());
        }
        return expression;
    }
}

