/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoPackageRegistry
extends HashMap<String, Object>
implements EPackage.Registry {
    public static final ResourceSet DYNAMIC_METAMODEL_RESOURCE_SET = new AcceleoDynamicMetamodelResourceSetImpl();
    public static final AcceleoPackageRegistry INSTANCE = new AcceleoPackageRegistry();
    private static final long serialVersionUID = 5976916017848022583L;
    private EPackage.Registry delegate = EPackage.Registry.INSTANCE;
    private Map<String, String> dynamicEcorePackagePaths = new HashMap<String, String>();

    private AcceleoPackageRegistry() {
    }

    @Override
    public void clear() {
        super.clear();
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value) || this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set dynamicEntries = super.entrySet();
        Set globalEntries = this.delegate.entrySet();
        return new AcceleoMultipleSet<Map.Entry<String, Object>>(dynamicEntries, globalEntries);
    }

    @Override
    public Object get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            result = this.delegate.get(key);
        }
        return result;
    }

    public Map<String, String> getDynamicEcorePackagePaths() {
        return this.dynamicEcorePackagePaths;
    }

    public EFactory getEFactory(String nsURI) {
        Object ePackage;
        if (this.containsKey(nsURI) && (ePackage = this.get(nsURI)) instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            return result.getEFactoryInstance();
        }
        return this.delegate.getEFactory(nsURI);
    }

    public EPackage getEPackage(String nsURI) {
        Object ePackage;
        if (this.containsKey(nsURI) && (ePackage = this.get(nsURI)) instanceof EPackage) {
            return (EPackage)ePackage;
        }
        EPackage result = this.delegate.getEPackage(nsURI);
        if (result == null && nsURI != null && !nsURI.startsWith("'")) {
            Collection<Object> values = this.values();
            for (Object object : values) {
                EPackage ePackage2;
                Resource eResource;
                URI uri;
                if (!(object instanceof EPackage) || ((EPackage)object).eResource() == null || (uri = (eResource = (ePackage2 = (EPackage)object).eResource()).getURI()) == null || !nsURI.equals(uri.toString())) continue;
                result = ePackage2;
            }
        }
        return result;
    }

    public String getRegisteredEcorePackagePath(String nsURI) {
        return this.dynamicEcorePackagePaths.get(nsURI);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.delegate.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        Set dynamicKeys = super.keySet();
        Set globalKeys = this.delegate.keySet();
        return new AcceleoMultipleSet<String>(dynamicKeys, globalKeys);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.dynamicEcorePackagePaths.containsKey(key)) {
            return super.put(key, value);
        }
        return this.delegate.put((Object)key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public String registerEcorePackages(String pathName, ResourceSet resourceSet) {
        EObject eObject = null;
        if (pathName != null && pathName.endsWith(".ecore") && !pathName.startsWith("http://") && !pathName.endsWith("Ecore.ecore")) {
            URI metaURI = URI.createURI((String)pathName, (boolean)false);
            eObject = this.safeLoad(metaURI, resourceSet);
            if (!(eObject instanceof EPackage)) {
                metaURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
                eObject = this.safeLoad(metaURI, resourceSet);
            }
            if (!(eObject instanceof EPackage)) {
                metaURI = URI.createPlatformPluginURI((String)pathName, (boolean)false);
                eObject = this.safeLoad(metaURI, resourceSet);
            }
        }
        if (eObject instanceof EPackage && ((EPackage)eObject).getNsURI() != null && !"".equals(((EPackage)eObject).getNsURI())) {
            EPackage ePackage = (EPackage)eObject;
            this.registerEcorePackageHierarchy(ePackage);
            return ePackage.getNsURI();
        }
        return pathName;
    }

    @Override
    public Object remove(Object key) {
        boolean hasBeenRemoved = false;
        if (this.dynamicEcorePackagePaths.containsKey(key)) {
            EList resources = DYNAMIC_METAMODEL_RESOURCE_SET.getResources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (key instanceof String && key.equals(resource.getURI().toString())) {
                    iterator.remove();
                    super.remove(key);
                    hasBeenRemoved = true;
                    continue;
                }
                String value = this.dynamicEcorePackagePaths.get(key);
                if (!value.equals(resource.getURI().toString())) continue;
                iterator.remove();
                super.remove(key);
                hasBeenRemoved = true;
            }
        }
        if (!hasBeenRemoved) {
            return this.delegate.remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return super.size() + this.delegate.size();
    }

    public void unregisterEcorePackages(String pathName) {
        Iterator<Map.Entry<String, String>> entryIterator = this.dynamicEcorePackagePaths.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> dynamicEcore = entryIterator.next();
            if (!dynamicEcore.getValue().endsWith(pathName)) continue;
            this.remove(dynamicEcore.getKey());
            entryIterator.remove();
        }
    }

    @Override
    public Collection<Object> values() {
        Collection dynamicValues = super.values();
        Collection globalValues = this.delegate.values();
        return new AcceleoMultipleCollection<Object>(dynamicValues, globalValues);
    }

    private void registerEcorePackageHierarchy(EPackage ePackage) {
        if (!(ePackage.getNsURI() == null || "mtl".equals(ePackage.getNsPrefix()) || "mtlnonstdlib".equals(ePackage.getNsPrefix()) || "mtlstdlib".equals(ePackage.getNsPrefix()))) {
            if (ePackage.eResource() != null) {
                this.dynamicEcorePackagePaths.put(ePackage.getNsURI(), ePackage.eResource().getURI().toString());
            }
            this.put(ePackage.getNsURI(), (Object)ePackage);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.registerEcorePackageHierarchy(subPackage);
        }
    }

    private EObject safeLoad(URI uri, ResourceSet resourceSet) {
        EObject result = null;
        try {
            result = ModelUtils.load(uri, resourceSet);
        }
        catch (IOException iOException) {
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleCollection<V>
    extends AbstractCollection<V> {
        private final Collection<V> firstCollection;
        private final Collection<V> secondCollection;

        public AcceleoMultipleCollection(Collection<V> collection1, Collection<V> collection2) {
            this.firstCollection = collection1;
            this.secondCollection = collection2;
        }

        @Override
        public Iterator<V> iterator() {
            return new AcceleoMultipleIterator<V>(this.firstCollection.iterator(), this.secondCollection.iterator());
        }

        @Override
        public int size() {
            return this.firstCollection.size() + this.secondCollection.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.firstCollection.contains(o) || this.secondCollection.contains(o);
        }

        @Override
        public void clear() {
            this.firstCollection.clear();
            this.secondCollection.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleIterator<E>
    implements Iterator<E> {
        private final Iterator<E> firstIterator;
        private final Iterator<E> secondIterator;
        private Iterator<E> current;

        public AcceleoMultipleIterator(Iterator<E> iterator1, Iterator<E> iterator2) {
            this.firstIterator = iterator1;
            this.secondIterator = iterator2;
            this.current = this.firstIterator;
        }

        @Override
        public boolean hasNext() {
            return this.firstIterator.hasNext() || this.secondIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.firstIterator.hasNext()) {
                return this.firstIterator.next();
            }
            this.current = this.secondIterator;
            return this.secondIterator.next();
        }

        @Override
        public void remove() {
            this.current.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleSet<K>
    extends AbstractSet<K> {
        private final Set<K> firstSet;
        private final Set<K> secondSet;

        public AcceleoMultipleSet(Set<K> set1, Set<K> set2) {
            this.firstSet = set1;
            this.secondSet = set2;
        }

        @Override
        public Iterator<K> iterator() {
            return new AcceleoMultipleIterator<K>(this.firstSet.iterator(), this.secondSet.iterator());
        }

        @Override
        public int size() {
            return this.firstSet.size() + this.secondSet.size();
        }
    }
}

