/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoInterpreterSourceContent;
import org.eclipse.acceleo.ui.interpreter.language.IInterpreterSourceViewer;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoSourceViewer
extends SourceViewer
implements IInterpreterSourceViewer {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String MODULE = "[module";
    protected static final String QUERY = "[query";
    protected static final String TEMPLATE = "[template";
    private static final String DUMMY_IMPORT = "[import {0}]" + LINE_SEPARATOR;
    private static final String DUMMY_MODULE = "[module temporaryInterpreterModule({0})]" + LINE_SEPARATOR;
    private static final String DUMMY_QUERY = "[query public temporaryInterpreterQuery(target : {0}, model : {1}{2}) : OclAny = " + LINE_SEPARATOR;
    private static final String DUMMY_QUERY_TAIL = String.valueOf(LINE_SEPARATOR) + "/]";
    private static final String DUMMY_TEMPLATE = "[template public temporaryInterpreterTemplate({0})]";
    private static final String DUMMY_TEMPLATE_MODEL_PARAM = "model : {0}";
    private static final String DUMMY_TEMPLATE_TAIL = String.valueOf(LINE_SEPARATOR) + "[/template]";
    private static final String DUMMY_TEMPLATE_TARGET_PARAM = "target : {0}";
    private ITextStore buffer = new GapTextStore();
    private AcceleoInterpreterSourceContent content;
    private String fullExpression;
    private int gap;
    private boolean hasExplicitModule;
    private IFile moduleImport;

    public AcceleoSourceViewer(Composite parent, IVerticalRuler ruler, int style) {
        super(parent, ruler, style);
    }

    private static String getQualifiedName(IPath moduleFile) {
        String path = moduleFile.removeFileExtension().toString();
        if (path.contains("src/")) {
            path = path.substring(path.indexOf("src/") + 4);
        }
        return path.replaceAll("/", "::");
    }

    public AcceleoSourceContent getContent() {
        return this.content;
    }

    public int getGap() {
        return this.gap;
    }

    public IFile getModuleImport() {
        return this.moduleImport;
    }

    public void handlePositionUpdate(int offset, int posEnd, String newText) {
        if (this.getContent() == null) {
            return;
        }
        int replacementLength = 0;
        if (offset < this.buffer.getLength()) {
            replacementLength = posEnd - offset;
        }
        this.buffer.replace(offset, replacementLength, newText);
        String moduleSignature = MODULE;
        if (offset <= MODULE.length()) {
            if (this.buffer.getLength() >= MODULE.length() && MODULE.equals(this.buffer.get(0, this.buffer.getLength()))) {
                this.hasExplicitModule = true;
            } else if (this.hasExplicitModule) {
                this.hasExplicitModule = false;
            }
        }
    }

    public void initializeContent() {
        this.content = new AcceleoInterpreterSourceContent();
        this.content.init(new StringBuffer(this.getDocument().get()));
    }

    public void setModuleImport(IFile moduleImport) {
        this.moduleImport = moduleImport;
    }

    public void showContentAssist(InterpreterContext context) {
        this.updateCST(context);
        this.fContentAssistant.showPossibleCompletions();
    }

    public void updateCST(InterpreterContext context) {
        this.fullExpression = this.rebuildFullExpression(context);
        this.getContent().updateCST(0, this.fullExpression.length(), this.fullExpression);
        if (this.getContent() instanceof AcceleoInterpreterSourceContent) {
            ((AcceleoInterpreterSourceContent)this.getContent()).setGap(this.gap);
        }
    }

    protected String computeQueryFromContext(InterpreterContext context, String queryName) {
        StringBuilder expressionBuffer = new StringBuilder();
        String text = this.getTextWidget().getText();
        ISelection selection = this.getSelection();
        if ((selection == null || !(selection instanceof TextSelection) || ((TextSelection)selection).getLength() != 0) && selection != null && selection instanceof TextSelection) {
            text = ((TextSelection)selection).getText();
        }
        if (text.contains(MODULE)) {
            return text;
        }
        EObject root = null;
        if (!context.getTargetEObjects().isEmpty()) {
            root = EcoreUtil.getRootContainer((EObject)((EObject)context.getTargetEObjects().get(0)));
        }
        String moduleSignature = DUMMY_MODULE;
        Set<String> metamodelURIs = this.getMetamodelURIs(context);
        if (metamodelURIs.size() == 0) {
            metamodelURIs.add("http://www.eclipse.org/emf/2002/Ecore");
        }
        StringBuilder nsURIs = new StringBuilder();
        Iterator<String> uriIterator = metamodelURIs.iterator();
        while (uriIterator.hasNext()) {
            nsURIs.append(String.valueOf('\'') + uriIterator.next() + '\'');
            if (!uriIterator.hasNext()) continue;
            nsURIs.append(',');
        }
        moduleSignature = MessageFormat.format(moduleSignature, nsURIs.toString());
        expressionBuffer.append(moduleSignature);
        if (this.moduleImport != null) {
            String modulePath = MessageFormat.format(DUMMY_IMPORT, AcceleoSourceViewer.getQualifiedName(this.moduleImport.getFullPath()));
            expressionBuffer.append(modulePath);
        }
        boolean appendTail = false;
        if (!text.contains(TEMPLATE) && !text.contains(QUERY)) {
            appendTail = true;
            String querySignature = "";
            querySignature = queryName == null ? DUMMY_QUERY : "[query public " + queryName + "(target : {0}, model : {1}{2}) : OclAny = " + LINE_SEPARATOR;
            List target = context.getTargetEObjects();
            String argumentType = null;
            if (target != null && !target.isEmpty()) {
                argumentType = this.inferArgumentType(target);
            }
            if (argumentType == null) {
                argumentType = EcorePackage.eINSTANCE.getEObject().getName();
            }
            String modelType = root == null ? EcorePackage.eINSTANCE.getEPackage().getName() : root.eClass().getName();
            StringBuilder additionalVariables = this.computeVariables(context);
            querySignature = MessageFormat.format(querySignature, argumentType, modelType, additionalVariables);
            expressionBuffer.append(querySignature);
        }
        expressionBuffer.append(text);
        if (appendTail) {
            expressionBuffer.append(DUMMY_QUERY_TAIL);
        }
        return expressionBuffer.toString();
    }

    protected String computeTemplateFromContext(InterpreterContext context, String templateName) {
        StringBuilder expressionBuffer = new StringBuilder();
        String text = this.getTextWidget().getText();
        ISelection selection = this.getSelection();
        if ((selection == null || !(selection instanceof TextSelection) || ((TextSelection)selection).getLength() != 0) && selection != null && selection instanceof TextSelection) {
            text = ((TextSelection)selection).getText();
        }
        if (text.contains(MODULE)) {
            return text;
        }
        EObject root = null;
        if (!context.getTargetEObjects().isEmpty()) {
            root = EcoreUtil.getRootContainer((EObject)((EObject)context.getTargetEObjects().get(0)));
        }
        String moduleSignature = DUMMY_MODULE;
        Set<String> metamodelURIs = this.getMetamodelURIs(context);
        if (metamodelURIs.size() == 0) {
            metamodelURIs.add("http://www.eclipse.org/emf/2002/Ecore");
        }
        StringBuilder nsURIs = new StringBuilder();
        Iterator<String> uriIterator = metamodelURIs.iterator();
        while (uriIterator.hasNext()) {
            nsURIs.append(String.valueOf('\'') + uriIterator.next() + '\'');
            if (!uriIterator.hasNext()) continue;
            nsURIs.append(',');
        }
        moduleSignature = MessageFormat.format(moduleSignature, nsURIs.toString());
        expressionBuffer.append(moduleSignature);
        if (this.moduleImport != null) {
            String modulePath = MessageFormat.format(DUMMY_IMPORT, AcceleoSourceViewer.getQualifiedName(this.moduleImport.getFullPath()));
            expressionBuffer.append(modulePath);
        }
        boolean appendTail = false;
        if (!text.contains(TEMPLATE) && !text.contains(QUERY)) {
            appendTail = true;
            String templateSignature = "";
            templateSignature = templateName == null ? DUMMY_TEMPLATE : "[template public " + templateName + "({0})]" + LINE_SEPARATOR;
            List target = context.getTargetEObjects();
            String targetType = null;
            if (target != null && !target.isEmpty()) {
                targetType = this.inferArgumentType(target);
            }
            String modelType = null;
            if (root != null) {
                modelType = root.eClass().getName();
            }
            StringBuilder templateParameters = new StringBuilder();
            if (targetType != null) {
                templateParameters.append(MessageFormat.format(DUMMY_TEMPLATE_TARGET_PARAM, targetType));
            }
            if (modelType != null) {
                if (templateParameters.length() != 0) {
                    templateParameters.append(',').append(' ');
                }
                templateParameters.append(MessageFormat.format(DUMMY_TEMPLATE_MODEL_PARAM, modelType));
            }
            StringBuilder additionalVariables = this.computeVariables(context);
            if (templateParameters.length() > 0 && additionalVariables.length() > 0) {
                templateParameters.append(',').append(' ');
            }
            templateParameters.append((CharSequence)additionalVariables);
            templateSignature = MessageFormat.format(templateSignature, templateParameters);
            expressionBuffer.append(templateSignature);
        }
        expressionBuffer.append(text);
        if (appendTail) {
            expressionBuffer.append(DUMMY_TEMPLATE_TAIL);
        }
        return expressionBuffer.toString();
    }

    protected String getFullExpression() {
        return this.fullExpression;
    }

    protected String rebuildFullExpression(InterpreterContext context) {
        this.gap = 0;
        String expression = this.buffer.get(0, this.buffer.getLength());
        if (this.hasExplicitModule) {
            return expression;
        }
        StringBuilder expressionBuffer = new StringBuilder();
        EObject root = null;
        if (!context.getTargetEObjects().isEmpty()) {
            root = EcoreUtil.getRootContainer((EObject)((EObject)context.getTargetEObjects().get(0)));
        }
        String moduleSignature = DUMMY_MODULE;
        Set<String> metamodelURIs = this.getMetamodelURIs(context);
        if (metamodelURIs.size() == 0) {
            metamodelURIs.add("http://www.eclipse.org/emf/2002/Ecore");
        }
        StringBuilder nsURIs = new StringBuilder();
        Iterator<String> uriIterator = metamodelURIs.iterator();
        while (uriIterator.hasNext()) {
            nsURIs.append(String.valueOf('\'') + uriIterator.next() + '\'');
            if (!uriIterator.hasNext()) continue;
            nsURIs.append(',');
        }
        moduleSignature = MessageFormat.format(moduleSignature, nsURIs.toString());
        expressionBuffer.append(moduleSignature);
        this.gap += moduleSignature.length();
        if (this.moduleImport != null) {
            String modulePath = MessageFormat.format(DUMMY_IMPORT, AcceleoSourceViewer.getQualifiedName(this.moduleImport.getFullPath()));
            expressionBuffer.append(modulePath);
            this.gap += modulePath.length();
        }
        boolean appendTail = false;
        if (!expression.contains(TEMPLATE) && !expression.contains(QUERY)) {
            appendTail = true;
            String templateSignature = DUMMY_TEMPLATE;
            List target = context.getTargetEObjects();
            String targetType = null;
            if (target != null && !target.isEmpty()) {
                targetType = this.inferArgumentType(target);
            }
            String modelType = null;
            if (root != null) {
                modelType = root.eClass().getName();
            }
            StringBuilder templateParameters = new StringBuilder();
            if (targetType != null) {
                templateParameters.append(MessageFormat.format(DUMMY_TEMPLATE_TARGET_PARAM, targetType));
            }
            if (modelType != null) {
                if (templateParameters.length() != 0) {
                    templateParameters.append(',').append(' ');
                }
                templateParameters.append(MessageFormat.format(DUMMY_TEMPLATE_MODEL_PARAM, modelType));
            }
            templateParameters.append((CharSequence)this.computeVariables(context));
            templateSignature = MessageFormat.format(templateSignature, templateParameters);
            expressionBuffer.append(templateSignature);
            this.gap += templateSignature.length();
        }
        expressionBuffer.append(expression);
        if (appendTail) {
            expressionBuffer.append(DUMMY_TEMPLATE_TAIL);
        }
        return expressionBuffer.toString();
    }

    private StringBuilder computeVariables(InterpreterContext context) {
        StringBuilder additionalVariables = new StringBuilder();
        for (Variable variable : context.getVariables()) {
            String varName = variable.getName();
            String varType = this.inferOCLType(variable.getValue());
            if (varName == null || varName.length() <= 0 || "self".equals(varName) || varType == null || varType.length() <= 0) continue;
            additionalVariables.append(',').append(' ');
            additionalVariables.append(varName);
            additionalVariables.append(" : ");
            additionalVariables.append(varType);
        }
        return additionalVariables;
    }

    private String extractNsURI(EObject object) {
        String uri;
        EPackage pack = object.eClass().getEPackage();
        if (pack != null && (uri = pack.getNsURI()) != null && uri.length() > 0) {
            return uri;
        }
        return null;
    }

    private Set<String> extractNsURIs(Object object) {
        HashSet<String> uris = new HashSet<String>();
        if (object instanceof EObject) {
            String uri = this.extractNsURI((EObject)object);
            if (uri != null) {
                uris.add(uri);
            }
        } else if (object instanceof Collection) {
            for (Object child : (Collection)object) {
                Set<String> childURIs = this.extractNsURIs(child);
                if (childURIs.isEmpty()) continue;
                uris.addAll(childURIs);
            }
        }
        return uris;
    }

    private Set<String> getMetamodelURIs(InterpreterContext context) {
        String modelNsURI;
        HashSet<String> uris = new HashSet<String>();
        String targetNsURI = this.extractNsURI((EObject)context.getTargetEObjects().get(0));
        if (targetNsURI != null) {
            uris.add(targetNsURI);
        }
        EObject root = null;
        if (!context.getTargetEObjects().isEmpty()) {
            root = EcoreUtil.getRootContainer((EObject)((EObject)context.getTargetEObjects().get(0)));
        }
        if (root != null && (modelNsURI = this.extractNsURI(root)) != null) {
            uris.add(modelNsURI);
        }
        for (Variable variable : context.getVariables()) {
            Set<String> variableValueURIs = this.extractNsURIs(variable.getValue());
            if (variableValueURIs.isEmpty()) continue;
            uris.addAll(variableValueURIs);
        }
        return uris;
    }

    private EClassifier getOCLType(EcoreEnvironment env, Object obj) {
        OCLStandardLibrary library = env.getOCLStandardLibrary();
        EClassifier oclType = (EClassifier)library.getOclAny();
        if (obj instanceof Number) {
            oclType = obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float ? (EClassifier)library.getReal() : (EClassifier)library.getInteger();
        } else if (obj instanceof String) {
            oclType = (EClassifier)library.getString();
        } else if (obj instanceof Boolean) {
            oclType = (EClassifier)library.getBoolean();
        } else if (obj instanceof EObject) {
            oclType = (EClassifier)env.getUMLReflection().asOCLType((Object)((EObject)obj).eClass());
        } else if (obj instanceof Collection) {
            oclType = obj instanceof LinkedHashSet ? (EClassifier)library.getOrderedSet() : (obj instanceof Set ? (EClassifier)library.getSet() : (obj instanceof Bag ? (EClassifier)library.getBag() : (EClassifier)library.getSequence()));
        }
        return oclType;
    }

    private String inferArgumentType(List<EObject> arguments) {
        EObject actualArgument = arguments;
        if (arguments.size() == 1) {
            actualArgument = arguments.get(0);
        }
        return this.inferOCLType(actualArgument);
    }

    private EClassifier inferCollectionContentOCLType(EcoreEnvironment env, Collection<?> coll) {
        if (coll.isEmpty()) {
            return (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        HashSet<EClassifier> types = new HashSet<EClassifier>();
        for (Object child : coll) {
            types.add(this.getOCLType(env, child));
        }
        Iterator iterator = types.iterator();
        EClassifier elementType = (EClassifier)iterator.next();
        while (iterator.hasNext()) {
            elementType = (EClassifier)env.getUMLReflection().getCommonSuperType((Object)elementType, (Object)((EClassifier)iterator.next()));
        }
        if (elementType == null) {
            elementType = (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        return elementType;
    }

    private String inferOCLType(Object obj) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (obj instanceof Collection) {
            EClassifier elementType = this.inferCollectionContentOCLType(env, (Collection)obj);
            CollectionKind kind = CollectionKind.SEQUENCE_LITERAL;
            if (obj instanceof LinkedHashSet) {
                kind = CollectionKind.ORDERED_SET_LITERAL;
            } else if (obj instanceof Set) {
                kind = CollectionKind.SET_LITERAL;
            } else if (obj instanceof Bag) {
                kind = CollectionKind.BAG_LITERAL;
            }
            oclType = env.getTypeResolver().resolveCollectionType(kind, (Object)elementType).getName();
        } else {
            oclType = this.getOCLType(env, obj).getName();
        }
        return oclType;
    }
}

