/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.view.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public final class NewVariableAction
extends Action {
    protected final TreeViewer variableViewer;
    private Object value;

    public NewVariableAction(TreeViewer viewer) {
        super(InterpreterMessages.getString("interpreter.action.createvariable.name"));
        this.variableViewer = viewer;
    }

    public NewVariableAction(TreeViewer viewer, Object value) {
        this(viewer);
        this.value = value;
    }

    public void run() {
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), InterpreterMessages.getString("interpreter.action.createvariable.popup.title"), String.valueOf(InterpreterMessages.getString("interpreter.action.createvariable.popup.message")) + ':', "", (IInputValidator)new VariableNameValidator());
        int result = dialog.open();
        if (result == 0) {
            ArrayList input;
            Variable newVar = new Variable(dialog.getValue());
            if (this.value != null) {
                newVar.setValue(this.value);
            }
            if (!((input = this.variableViewer.getInput()) instanceof List)) {
                input = new ArrayList();
                this.variableViewer.setInput(input);
            }
            ((List)this.variableViewer.getInput()).add(newVar);
            this.variableViewer.refresh();
        }
    }

    protected class VariableNameValidator
    implements IInputValidator {
        protected VariableNameValidator() {
        }

        public String isValid(String newText) {
            String errorMessage = null;
            if (newText == null || newText.equals("")) {
                errorMessage = InterpreterMessages.getString("interpreter.action.createvariable.popup.error.noname");
            } else if (!this.isJavaIdentifier(newText)) {
                errorMessage = InterpreterMessages.getString("interpreter.action.createvariable.popup.error.invalid", newText);
            } else {
                Object input = NewVariableAction.this.variableViewer.getInput();
                if (input instanceof List) {
                    for (Object var : (List)input) {
                        if (!(var instanceof Variable) || !newText.equals(((Variable)var).getName())) continue;
                        errorMessage = InterpreterMessages.getString("interpreter.action.createvariable.popup.error.duplicate");
                    }
                }
            }
            return errorMessage;
        }

        private boolean isJavaIdentifier(String name) {
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char character = cArray[n2];
                if (!Character.isJavaIdentifierPart(character)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

