/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.view.actions;

import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class RenameVariableAction
extends Action {
    protected boolean saving;
    protected Text textEditor;
    protected Composite textEditorParent;
    protected final TreeViewer variableViewer;
    private TreeEditor treeEditor;

    public RenameVariableAction(TreeViewer variableViewer) {
        super(InterpreterMessages.getString("interpreter.action.renamevariable.name"));
        this.variableViewer = variableViewer;
        this.treeEditor = new TreeEditor(this.getTree());
    }

    public Tree getTree() {
        if (this.variableViewer == null) {
            return null;
        }
        return this.variableViewer.getTree();
    }

    public boolean isEnabled() {
        return this.getCurrentVariable() != null;
    }

    public void run() {
        Variable currentVariable = this.getCurrentVariable();
        if (currentVariable != null) {
            this.runRename(currentVariable);
        }
    }

    protected void disposeTextWidget() {
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected Variable getCurrentVariable() {
        TreeItem[] selectedtems;
        if (this.getTree() != null && !this.getTree().isDisposed() && (selectedtems = this.getTree().getSelection()) != null && selectedtems.length > 0) {
            int i = 0;
            while (i < selectedtems.length) {
                TreeItem item = selectedtems[i];
                if (item.getData() instanceof Variable) {
                    return (Variable)item.getData();
                }
                ++i;
            }
        }
        return null;
    }

    protected void saveChangesAndDispose(Variable variable) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        final Variable renamedVariable = variable;
        final String newName = this.textEditor.getText();
        Runnable renameQuery = new Runnable(){

            public void run() {
                try {
                    if (!newName.equals(renamedVariable.getName())) {
                        renamedVariable.setName(newName);
                    }
                    RenameVariableAction.this.disposeTextWidget();
                    if (RenameVariableAction.this.getTree() != null && !RenameVariableAction.this.getTree().isDisposed()) {
                        RenameVariableAction.this.variableViewer.refresh();
                        RenameVariableAction.this.getTree().setFocus();
                    }
                }
                finally {
                    RenameVariableAction.this.saving = false;
                }
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(renameQuery);
    }

    private Composite createParent() {
        Tree tree = this.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(final Variable variable) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        boolean inset = true;
        this.textEditorParent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point textSize = RenameVariableAction.this.textEditor.getSize();
                Point parentSize = RenameVariableAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.getTree().getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point textSize = RenameVariableAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameVariableAction.this.textEditorParent.getSize();
                RenameVariableAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                RenameVariableAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: {
                        RenameVariableAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameVariableAction.this.saveChangesAndDispose(variable);
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameVariableAction.this.saveChangesAndDispose(variable);
            }
        });
    }

    private void runRename(Variable variable) {
        String currentName;
        if (this.textEditorParent == null) {
            this.createTextEditor(variable);
        }
        if ((currentName = variable.getName()) == null) {
            currentName = "";
        }
        this.textEditor.setText(currentName);
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = 1;
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }
}

