/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.compiler;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProject;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoParserUtils {
    private AcceleoParserUtils() {
    }

    public static List<Sequence> getImportSequencesToSearch(AcceleoProject acceleoProject, File file) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        String simpleModuleName = file.getName();
        if (simpleModuleName.endsWith("mtl")) {
            simpleModuleName = simpleModuleName.substring(0, simpleModuleName.length() - ("mtl".length() + 1));
        }
        String[] tokens = new String[]{"[", "import", simpleModuleName};
        result.add(new Sequence(tokens));
        tokens = new String[]{"extends", simpleModuleName};
        result.add(new Sequence(tokens));
        String fullModuleName = acceleoProject.getModuleQualifiedName(file);
        tokens = new String[]{"[", "import", fullModuleName};
        result.add(new Sequence(tokens));
        tokens = new String[]{"extends", fullModuleName};
        result.add(new Sequence(tokens));
        return result;
    }

    public static Set<URI> getAllModules(URI jar) {
        return null;
    }

    public static String getModuleName(URI moduleURI) {
        return null;
    }

    public static boolean removeDirectory(File directory) {
        String[] list;
        boolean result = false;
        if (!directory.exists()) {
            result = true;
        }
        if ((list = directory.list()) != null) {
            int i = 0;
            while (i < list.length) {
                File entry = new File(directory, list[i]);
                if (entry.isDirectory()) {
                    if (!AcceleoParserUtils.removeDirectory(entry)) {
                        result = false;
                    }
                } else if (!entry.delete()) {
                    result = false;
                }
                ++i;
            }
        }
        result = directory.delete();
        return result;
    }

    public static void registerResourceFactories(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlResourceFactoryImpl());
    }

    public static void registerPackages(ResourceSet resourceSet) {
        EPackage.Registry.INSTANCE.put((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)AcceleoParserUtils.getOCLStdLibPackage());
    }

    private static EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }

    public static void registerLibraries(ResourceSet resourceSet) {
        CodeSource acceleoModel = MtlPackage.class.getProtectionDomain().getCodeSource();
        if (acceleoModel != null) {
            String libraryLocation = acceleoModel.getLocation().toString();
            if (libraryLocation.endsWith(".jar")) {
                libraryLocation = "jar:" + libraryLocation + '!';
            } else if (libraryLocation.startsWith("file:/") && libraryLocation.endsWith("bin/")) {
                libraryLocation = libraryLocation.substring(6, libraryLocation.length() - 4);
            }
            String std = String.valueOf(libraryLocation) + "model/mtlstdlib.ecore";
            String nonstd = String.valueOf(libraryLocation) + "model/mtlnonstdlib.ecore";
            URL stdlib = MtlPackage.class.getResource("/model/mtlstdlib.ecore");
            URL resource = MtlPackage.class.getResource("/model/mtlnonstdlib.ecore");
            if (stdlib != null && resource != null) {
                URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlstdlib.ecore"), URI.createURI((String)stdlib.toString()));
                URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlnonstdlib.ecore"), URI.createURI((String)resource.toString()));
            } else {
                URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlstdlib.ecore"), URI.createFileURI((String)std));
                URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlnonstdlib.ecore"), URI.createFileURI((String)nonstd));
            }
        } else {
            System.err.println("Coudln't retrieve location of plugin 'org.eclipse.acceleo.model'.");
        }
    }
}

