/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.ModuleElementKind;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.example.AcceleoInitializationStrategyUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoProjectUtils {
    private AcceleoProjectUtils() {
    }

    public static IFile generateFiles(AcceleoProject acceleoProject, List<AcceleoModule> allModules, IProject project, boolean generateModules, IProgressMonitor monitor) {
        try {
            IFolder antTasksFolder = project.getFolder("tasks");
            if (!antTasksFolder.exists()) {
                antTasksFolder.create(true, false, monitor);
            }
            IProjectDescription description = project.getDescription();
            String[] natureIds = new String[]{"org.eclipse.acceleo.ide.ui.acceleoNature", "org.eclipse.pde.PluginNature", "org.eclipse.jdt.core.javanature"};
            description.setNatureIds(natureIds);
            project.setDescription(description, monitor);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        monitor.beginTask(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Monitor"), 100);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectSettings(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectClasspath(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectManifest(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateBuildProperties(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateActivator(acceleoProject, (IContainer)project);
        if (!generateModules) {
            return null;
        }
        IFile file = null;
        for (AcceleoModule acceleoModule : allModules) {
            monitor.worked(10);
            String parentFolder = acceleoModule.getParentFolder();
            IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
            if (!moduleProject.exists() || !moduleProject.isAccessible()) continue;
            Path parentFolderPath = new Path(parentFolder);
            IFolder folder = moduleProject.getFolder(parentFolderPath.removeFirstSegments(1));
            file = folder.getFile(String.valueOf(acceleoModule.getName()) + "." + "mtl");
            AcceleoUIGenerator.getDefault().generateAcceleoModule(acceleoModule, (IContainer)folder);
            if (!acceleoModule.isIsInitialized()) continue;
            String initializationKind = acceleoModule.getInitializationKind();
            IAcceleoInitializationStrategy strategy = null;
            List<IAcceleoInitializationStrategy> initializationStrategy = AcceleoInitializationStrategyUtils.getInitializationStrategy();
            for (IAcceleoInitializationStrategy iAcceleoInitializationStrategy : initializationStrategy) {
                if (iAcceleoInitializationStrategy.getDescription() == null || !iAcceleoInitializationStrategy.getDescription().equals(initializationKind)) continue;
                strategy = iAcceleoInitializationStrategy;
                break;
            }
            IFile exampleFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(acceleoModule.getInitializationPath()));
            String moduleElementKind = "template";
            if (acceleoModule.getModuleElement().getKind().equals((Object)ModuleElementKind.QUERY)) {
                moduleElementKind = "query";
            }
            if (strategy == null || !file.exists()) continue;
            try {
                strategy.configure(moduleElementKind, acceleoModule.getModuleElement().isGenerateFile(), acceleoModule.getModuleElement().isIsMain(), acceleoModule.isGenerateDocumentation());
                String content = strategy.getContent(exampleFile, acceleoModule.getName(), (List<String>)acceleoModule.getMetamodelURIs(), acceleoModule.getModuleElement().getParameterType());
                ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
                file.setContents((InputStream)javaStream, true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
            catch (UnsupportedEncodingException e) {
                AcceleoUIActivator.log(e, true);
            }
        }
        return file;
    }
}

