/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.Deque;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.environment.AcceleoLibraryOperationVisitor;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.engine.internal.environment.DynamicModulesURIConverter;
import org.eclipse.acceleo.engine.internal.utils.AcceleoOverrideAdapter;
import org.eclipse.acceleo.engine.service.AcceleoDynamicTemplatesRegistry;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.util.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    private static final Object NULL_ARGUMENT = new Object();
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private final Set<Module> currentModules = new CompactHashSet();
    private final Map<Template, Set<Template>> dynamicOverrides = new HashMap<Template, Set<Template>>();
    private final Map<Template, Set<Template>> overridingTemplates = new HashMap<Template, Set<Template>>();
    private AcceleoPropertiesLookup propertiesLookup;
    private final Map<String, Set<Template>> templates = new HashMap<String, Set<Template>>();
    private final Deque<Map<String, Deque<Object>>> scopedVariableMap = new CircularArrayDeque();
    private final Map<String, Deque<Object>> globalVariableMap = new HashMap<String, Deque<Object>>();

    public AcceleoEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent, Module module, AcceleoPropertiesLookup properties) {
        super(parent);
        this.scopedVariableMap.add(new HashMap());
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    public AcceleoEvaluationEnvironment(Module module, AcceleoPropertiesLookup properties) {
        this.scopedVariableMap.add(new HashMap());
        this.mapAllTemplates(module);
        this.mapDynamicOverrides();
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    public void add(String name, Object value) {
        Map variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : (Map)this.scopedVariableMap.getLast();
        CircularArrayDeque values = variableMap.get(name);
        if (values == null) {
            values = new CircularArrayDeque();
            variableMap.put(name, values);
        }
        values.add(value);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        Object result = null;
        result = operation.getEAnnotation("MTL") != null ? AcceleoLibraryOperationVisitor.callStandardOperation(this, operation, source, args) : (operation.getEAnnotation("MTL non-standard") != null ? AcceleoLibraryOperationVisitor.callNonStandardOperation(this, operation, source, args) : (operation.getEType() == EcorePackage.eINSTANCE.getEJavaObject() ? this.callOperationWorkaround287052(operation, opcode, source, args) : super.callOperation(operation, opcode, source, args)));
        return result;
    }

    private Object callOperationWorkaround287052(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        Object noResult;
        if (this.getParent() != null) {
            return this.getParent().callOperation((Object)operation, opcode, source, args);
        }
        Method method = this.getJavaMethodFor(operation, source);
        Object result = noResult = new Object();
        if (method != null) {
            try {
                Class<?>[] parmTypes = method.getParameterTypes();
                int i = 0;
                while (i < parmTypes.length) {
                    if (EList.class.isAssignableFrom(parmTypes[i])) {
                        if (args[i] == null) {
                            args[i] = ECollections.EMPTY_ELIST;
                        } else if (!(args[i] instanceof Collection)) {
                            BasicEList.FastCompare list = new BasicEList.FastCompare(1);
                            list.add(args[i]);
                            args[i] = list;
                        } else if (!(args[i] instanceof EList)) {
                            args[i] = new BasicEList.FastCompare((Collection)args[i]);
                        }
                    }
                    ++i;
                }
                result = method.invoke(source, args);
            }
            catch (Exception e) {
                AcceleoEnginePlugin.log(e, false);
                result = this.getInvalidResult();
            }
        }
        if (result == noResult) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public void clear() {
        super.clear();
        this.scopedVariableMap.clear();
        this.globalVariableMap.clear();
    }

    public void createVariableScope() {
        this.scopedVariableMap.add(new HashMap());
    }

    public List<Template> getAllCandidates(Module origin, Template call, List<Object> arguments) {
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            if (arg != null) {
                argumentTypes.add(arg.getClass());
                continue;
            }
            argumentTypes.add(NULL_ARGUMENT);
        }
        List<Template> orderedNamesakes = this.reorderCandidatesPriority(origin, this.getAllCandidateNamesakes(origin, call, argumentTypes));
        List<Template> dynamicOverriding = this.reorderDynamicOverrides(this.getAllDynamicCandidateOverriding(orderedNamesakes, argumentTypes));
        List<Template> overriding = this.getAllCandidateOverriding(origin, orderedNamesakes, argumentTypes);
        ArrayList<Template> applicableCandidates = new ArrayList<Template>();
        applicableCandidates.addAll(dynamicOverriding);
        applicableCandidates.addAll(overriding);
        applicableCandidates.addAll(orderedNamesakes);
        return applicableCandidates;
    }

    public Template getMostSpecificTemplate(List<Template> candidates, List<Object> arguments) {
        Iterator<Template> candidateIterator = candidates.iterator();
        if (candidates.size() == 1) {
            return candidateIterator.next();
        }
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.size());
        for (Object arg : arguments) {
            if (arg instanceof EObject) {
                argumentTypes.add(((EObject)arg).eClass());
                continue;
            }
            if (arg == null) continue;
            argumentTypes.add(arg.getClass());
        }
        Template mostSpecific = candidateIterator.next();
        while (candidateIterator.hasNext()) {
            mostSpecific = this.mostSpecificTemplate(mostSpecific, candidateIterator.next(), arguments);
        }
        return mostSpecific;
    }

    public AcceleoPropertiesLookup getPropertiesLookup() {
        return this.propertiesLookup;
    }

    public Map<String, Object> getCurrentVariables() {
        Map variableMap = (Map)this.scopedVariableMap.getLast();
        HashMap<String, Object> availableVariables = new HashMap<String, Object>();
        for (Map.Entry var : variableMap.entrySet()) {
            if (((Deque)var.getValue()).isEmpty()) continue;
            availableVariables.put((String)var.getKey(), ((Deque)var.getValue()).getLast());
        }
        return availableVariables;
    }

    public Object getInvalidResult() {
        return super.getInvalidResult();
    }

    public Object getValueOf(String name) {
        Object value = null;
        Map variableMap = (Map)this.scopedVariableMap.getLast();
        if (variableMap.containsKey(name)) {
            value = ((Deque)variableMap.get(name)).getLast();
        } else if (this.globalVariableMap.containsKey(name)) {
            value = this.globalVariableMap.get(name).getLast();
        }
        return value;
    }

    public boolean overrides(EOperation operation, int opcode) {
        boolean result = false;
        if (operation.getEAnnotation("MTL") != null) {
            result = true;
        } else if (operation.getEAnnotation("MTL non-standard") != null) {
            if (opcode == 1) {
                Adapter adapter = EcoreUtil.getAdapter((List)operation.eAdapters(), AcceleoOverrideAdapter.class);
                result = adapter != null;
                operation.eAdapters().remove((Object)adapter);
            } else {
                result = true;
            }
        } else {
            result = super.overrides((Object)operation, opcode);
        }
        return result;
    }

    public Object remove(String name) {
        Map<String, Deque<Object>> variableMap;
        if (((Map)this.scopedVariableMap.getLast()).containsKey(name)) {
            variableMap = (Map<String, Deque<Object>>)this.scopedVariableMap.getLast();
        } else if (this.globalVariableMap.containsKey(name)) {
            variableMap = this.globalVariableMap;
        } else {
            return null;
        }
        Object removedValue = variableMap.get(name).removeLast();
        if (variableMap.get(name).size() == 0) {
            variableMap.remove(name);
        }
        return removedValue;
    }

    public Map<String, Deque<Object>> removeVariableScope() {
        return (Map)this.scopedVariableMap.removeLast();
    }

    public void replace(String name, Object value) {
        Map variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : (Map)this.scopedVariableMap.getLast();
        if (variableMap.containsKey(name)) {
            ((Deque)variableMap.get(name)).removeLast();
        }
        this.add(name, value);
    }

    public String toString() {
        Map variableMap = (Map)this.scopedVariableMap.getLast();
        return variableMap.toString();
    }

    private Set<Template> applicableTemplates(Set<Template> candidates, List<Object> argumentTypes) {
        CompactLinkedHashSet applicableCandidates = new CompactLinkedHashSet(candidates);
        for (Template candidate : candidates) {
            if (candidate.getParameter().size() == argumentTypes.size() || candidate.getParameter().size() == 0 && argumentTypes.size() == 1) continue;
            applicableCandidates.remove(candidate);
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            for (Template candidate : new CompactLinkedHashSet((Collection)applicableCandidates)) {
                Object parameterType;
                if (candidate.getParameter().size() == 0 && argumentTypes.size() == 1 || this.isApplicableArgument(parameterType = ((Variable)candidate.getParameter().get(i)).getType(), argumentTypes.get(i))) continue;
                applicableCandidates.remove(candidate);
            }
            ++i;
        }
        return applicableCandidates;
    }

    private Set<Template> getAllCandidateNamesakes(Module origin, Template call, List<Object> argumentTypes) {
        CompactLinkedHashSet namesakes = new CompactLinkedHashSet();
        Set<Template> candidates = this.templates.get(call.getName());
        if (candidates == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ModuleResolutionError"));
        }
        CompactHashSet scope = new CompactHashSet();
        scope.add(origin);
        scope.addAll(this.getScopeOf(origin));
        for (Template candidate : candidates) {
            if (!scope.contains(candidate.eContainer())) continue;
            namesakes.add(candidate);
        }
        if (namesakes.size() == 1) {
            return namesakes;
        }
        namesakes.retainAll(this.applicableTemplates(candidates, argumentTypes));
        return namesakes;
    }

    private Set<Module> getScopeOf(Module module) {
        CompactHashSet scope = new CompactHashSet();
        if (module.getExtends().size() > 0) {
            Module extended = (Module)module.getExtends().get(0);
            scope.add(extended);
            scope.addAll(this.getExtendedScope(extended));
        }
        EList imports = module.getImports();
        scope.addAll(imports);
        for (Module importedModule : imports) {
            scope.addAll(this.getExtendedScope(importedModule));
        }
        return scope;
    }

    private Set<Module> getExtendedScope(Module module) {
        CompactHashSet scope = new CompactHashSet();
        if (module.getExtends().size() > 0) {
            Module extended = (Module)module.getExtends().get(0);
            scope.add(extended);
            scope.addAll(this.getExtendedScope(extended));
        }
        return scope;
    }

    private List<Template> getAllCandidateOverriding(Module origin, List<Template> overridenTemplates, List<Object> argumentTypes) {
        ArrayList<Template> candidateOverriding = new ArrayList<Template>();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.overridingTemplates.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            for (Template template : applicableCandidates) {
                EObject eContainer = template.eContainer();
                if (!(eContainer instanceof Module) || !this.getScopeOf(origin).contains(eContainer) && !eContainer.equals(origin)) continue;
                candidateOverriding.add(template);
            }
            candidateOverriding.addAll(this.getAllCandidateOverriding(origin, new ArrayList<Template>(applicableCandidates), argumentTypes));
        }
        Collections.reverse(candidateOverriding);
        return candidateOverriding;
    }

    private Set<Template> getAllDynamicCandidateOverriding(List<Template> overridenTemplates, List<Object> argumentTypes) {
        CompactLinkedHashSet dynamicOverriding = new CompactLinkedHashSet();
        for (Template overriden : overridenTemplates) {
            Set<Template> candidates = this.dynamicOverrides.get(overriden);
            if (candidates == null) continue;
            Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
            dynamicOverriding.addAll(applicableCandidates);
        }
        return dynamicOverriding;
    }

    Set<Module> getCurrentModules() {
        return new CompactHashSet(this.currentModules);
    }

    private boolean isApplicableArgument(Object expectedType, Object argumentType) {
        boolean isApplicable = false;
        if (argumentType == NULL_ARGUMENT) {
            isApplicable = true;
        } else if (expectedType instanceof EClass && argumentType instanceof EClass) {
            isApplicable = expectedType == argumentType || this.isSubTypeOf(expectedType, argumentType);
        } else if (expectedType instanceof Class && argumentType instanceof Class) {
            isApplicable = ((Class)expectedType).isAssignableFrom((Class)argumentType);
        } else if (expectedType instanceof EDataType && argumentType instanceof Class) {
            if (expectedType instanceof BagType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Bag.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof OrderedSetType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Set.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof SetType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Set.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof SequenceType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = List.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof CollectionType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Collection.class.isAssignableFrom(clazz);
            } else {
                isApplicable = ((EDataType)expectedType).getInstanceClass() == argumentType;
            }
        } else {
            isApplicable = expectedType instanceof AnyType ? true : expectedType.getClass().isInstance(argumentType);
        }
        return isApplicable;
    }

    private boolean isSubTypeOf(Object superType, Object eClass) {
        boolean result = false;
        if (superType instanceof EClass && eClass instanceof EClass) {
            for (EClass candidate : ((EClass)eClass).getEAllSuperTypes()) {
                if (candidate != superType) continue;
                result = true;
                break;
            }
        } else if (superType instanceof AnyType) {
            result = true;
        }
        return result;
    }

    private Set<Module> loadDynamicModules() {
        CompactLinkedHashSet dynamicModuleFiles = new CompactLinkedHashSet();
        CompactLinkedHashSet dynamicModules = new CompactLinkedHashSet();
        ResourceSet resourceSet = null;
        for (Module module : this.currentModules) {
            if (module.eResource() == null || module.eResource().getResourceSet() == null) continue;
            resourceSet = module.eResource().getResourceSet();
            break;
        }
        if (resourceSet == null) {
            AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.DynamicModulesLoadingFailure"), true);
            return dynamicModules;
        }
        if (!(resourceSet.getURIConverter() instanceof DynamicModulesURIConverter)) {
            resourceSet.setURIConverter((URIConverter)new DynamicModulesURIConverter(resourceSet.getURIConverter(), this));
        }
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            BundleURLConverter converter;
            URI uri = resource.getURI();
            String generatorID = uri.toString();
            if (uri.isPlatformPlugin() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if (uri.isPlatformResource() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if (uri.isPlatform() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if ((uri.isFile() || generatorID.startsWith("jar:file:")) && (generatorID = (converter = new BundleURLConverter(generatorID)).resolveAsPlatformPlugin()) != null && generatorID.startsWith("platform:/plugin/") && URI.createURI((String)generatorID).segments().length > 2) {
                URI tmpURI = URI.createURI((String)generatorID);
                generatorID = tmpURI.segment(1);
            }
            Set<File> dynamicAcceleoModulesFiles = AcceleoDynamicTemplatesRegistry.INSTANCE.getRegisteredModules(generatorID);
            dynamicModuleFiles.addAll(dynamicAcceleoModulesFiles);
        }
        for (File moduleFile : dynamicModuleFiles) {
            if (!moduleFile.exists() || !moduleFile.canRead()) continue;
            try {
                Resource res = ModelUtils.load((File)moduleFile, (ResourceSet)resourceSet).eResource();
                for (EObject root : res.getContents()) {
                    if (!(root instanceof Module)) continue;
                    dynamicModules.add((Module)root);
                }
            }
            catch (IOException e) {
                AcceleoEnginePlugin.log(e, false);
            }
        }
        return dynamicModules;
    }

    private void mapAllTemplates(Module module) {
        if (this.currentModules.contains(module)) {
            return;
        }
        this.currentModules.add(module);
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            CompactLinkedHashSet namesakes = this.templates.get(elem.getName());
            if (namesakes == null) {
                namesakes = new CompactLinkedHashSet();
                this.templates.put(elem.getName(), (Set<Template>)namesakes);
            }
            namesakes.add((Template)elem);
            this.mapOverridingTemplate((Template)elem);
        }
        for (Module extended : module.getExtends()) {
            this.mapAllTemplates(extended);
        }
        for (Module imported : module.getImports()) {
            this.mapAllTemplates(imported);
        }
    }

    private void mapDynamicModule(Module module, Set<Module> dynamicModules) {
        boolean map = false;
        CompactLinkedHashSet unMappedRequiredModules = new CompactLinkedHashSet();
        for (Module extended : module.getExtends()) {
            if (dynamicModules.contains(extended)) {
                this.mapDynamicModule(extended, dynamicModules);
            }
            if (this.currentModules.contains(extended)) {
                map = true;
                continue;
            }
            unMappedRequiredModules.add(extended);
        }
        if (!map) {
            return;
        }
        for (Module imported : module.getImports()) {
            if (this.currentModules.contains(imported)) continue;
            unMappedRequiredModules.add(imported);
        }
        for (Module required : unMappedRequiredModules) {
            this.mapAllTemplates(required);
        }
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Template ownedTemplate = (Template)elem;
            for (Template overriden : ownedTemplate.getOverrides()) {
                CompactLinkedHashSet overriding = this.dynamicOverrides.get(overriden);
                if (overriding == null && this.templates.containsKey(overriden.getName())) {
                    overriding = new CompactLinkedHashSet();
                    Template match = overriden;
                    Set<Template> candidates = this.templates.get(overriden.getName());
                    for (Template template : candidates) {
                        if (!EcoreUtil.equals((EObject)template, (EObject)overriden)) continue;
                        match = template;
                        break;
                    }
                    this.dynamicOverrides.put(match, (Set<Template>)overriding);
                }
                if (overriding == null) continue;
                overriding.add((Template)ownedTemplate);
            }
            if (ownedTemplate.getOverrides().size() != 0) continue;
            CompactLinkedHashSet namesakes = this.templates.get(ownedTemplate.getName());
            if (namesakes == null) {
                namesakes = new CompactLinkedHashSet();
                this.templates.put(ownedTemplate.getName(), (Set<Template>)namesakes);
            }
            namesakes.add((Template)ownedTemplate);
        }
        this.currentModules.add(module);
    }

    private void mapDynamicOverrides() {
        Set<Module> dynamicModules = this.loadDynamicModules();
        for (Module module : dynamicModules) {
            this.mapDynamicModule(module, dynamicModules);
        }
    }

    private void mapOverridingTemplate(Template elem) {
        for (Template overriden : elem.getOverrides()) {
            CompactLinkedHashSet overriding = this.overridingTemplates.get(overriden);
            if (overriding == null) {
                overriding = new CompactLinkedHashSet();
                this.overridingTemplates.put(overriden, (Set<Template>)overriding);
            }
            overriding.add((Template)elem);
        }
    }

    private Template mostSpecificTemplate(Template template1, Template template2, List<Object> actualArgumentTypes) {
        int template1SpecificArgumentCount = 0;
        int template2SpecificArgumentCount = 0;
        int i = 0;
        while (i < actualArgumentTypes.size()) {
            EClassifier template2Type;
            EClassifier template1Type;
            Object actualArgumentType = actualArgumentTypes.get(i);
            if ((template1.getParameter().size() != 0 || template2.getParameter().size() != 0) && (template1Type = (EClassifier)((Variable)template1.getParameter().get(i)).getType()) != (template2Type = (EClassifier)((Variable)template2.getParameter().get(i)).getType())) {
                if (actualArgumentType instanceof EObject) {
                    if (this.isSubTypeOf(template1Type, template2Type)) {
                        ++template2SpecificArgumentCount;
                    } else {
                        ++template1SpecificArgumentCount;
                    }
                } else {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UnresolvedCompilationError"));
                }
            }
            ++i;
        }
        Template mostSpecific = template1SpecificArgumentCount >= template2SpecificArgumentCount ? template1 : template2;
        return mostSpecific;
    }

    private List<Template> reorderCandidatesPriority(Module origin, Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        for (Template candidate : new CompactLinkedHashSet(candidates)) {
            boolean isOverridingCandidate = false;
            Module module = (Module)candidate.eContainer();
            while (!isOverridingCandidate && module != null && module.getExtends().size() > 0) {
                if (module.getExtends().get(0) == origin) {
                    reorderedList.add(candidate);
                    candidates.remove(candidate);
                    isOverridingCandidate = true;
                }
                module = (Module)module.getExtends().get(0);
            }
        }
        for (Template candidate : new CompactLinkedHashSet(candidates)) {
            if (candidate.eContainer() != origin) continue;
            reorderedList.add(candidate);
            candidates.remove(candidate);
        }
        for (Template candidate : new CompactLinkedHashSet(candidates)) {
            for (Module extended : origin.getExtends()) {
                if (candidate.eContainer() != extended) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        for (Template candidate : new CompactLinkedHashSet(candidates)) {
            for (Module imported : origin.getImports()) {
                if (candidate.eContainer() != imported) continue;
                reorderedList.add(candidate);
                candidates.remove(candidate);
            }
        }
        for (Template candidate : new CompactLinkedHashSet(candidates)) {
            Iterator iterator = origin.getImports().iterator();
            while (iterator.hasNext()) {
                Module imported;
                Module myImportedModule = imported = (Module)iterator.next();
                while (myImportedModule.getExtends().size() > 0) {
                    if (myImportedModule.getExtends().get(0) == candidate.eContainer()) {
                        reorderedList.add(candidate);
                        candidates.remove(candidate);
                    }
                    myImportedModule = (Module)myImportedModule.getExtends().get(0);
                }
            }
        }
        return reorderedList;
    }

    private List<Template> reorderDynamicOverrides(Set<Template> candidates) {
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        CompactLinkedHashSet lowest = new CompactLinkedHashSet(candidates);
        while (!lowest.isEmpty()) {
            for (Template candidate : new CompactLinkedHashSet((Collection)lowest)) {
                for (Template overriden : candidate.getOverrides()) {
                    if (!lowest.contains(overriden)) continue;
                    lowest.remove(overriden);
                }
            }
            if (lowest.isEmpty()) {
                ArrayList<Template> remainingCandidates = new ArrayList<Template>(candidates);
                remainingCandidates.removeAll(reorderedList);
                reorderedList.addAll(remainingCandidates);
                continue;
            }
            reorderedList.addAll((Collection<Template>)lowest);
            lowest.clear();
            lowest.addAll(candidates);
            lowest.removeAll(reorderedList);
        }
        return reorderedList;
    }
}

