/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.AcceleoASTNodeAdapter;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoLibraryOperationVisitor;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitorDecorator;
import org.eclipse.acceleo.engine.internal.evaluation.QueryCache;
import org.eclipse.acceleo.engine.internal.utils.AcceleoOverrideAdapter;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.InitSection;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.profiler.Profiler;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.impl.OCLExpressionImpl;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends EvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    public static final String PROTECTED_AREA_MARKER = "ACCELEO_PROTECTED_AREA_MARKER_FIT_INDENTATION";
    private static IDebugAST debug;
    private static final String ITERATION_COUNT_VARIABLE_NAME = "i";
    private static Profiler profile;
    private static final String SELF_VARIABLE_NAME = "self";
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private static final String UNDEFINED_GUARD_MESSAGE_KEY = "AcceleoEvaluationVisitor.UndefinedGuard";
    private final AcceleoEvaluationContext<C> context;
    private int currentContextIndex;
    private boolean evaluatingInitSection;
    private boolean fireGenerationEvent;
    private final Object invalid = this.getAcceleoEnvironment().getOCLStandardLibraryReflection().getInvalid();
    private EObject lastEObjectSelfValue;
    private OCLExpression<C> lastSourceExpression;
    private Object lastSourceExpressionResult;
    private QueryCache queryCache = new QueryCache(this.getAcceleoEnvironment().getOCLStandardLibraryReflection().getInvalid());
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor;

    public AcceleoEvaluationVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, AcceleoEvaluationContext<C> context) {
        super(decoratedVisitor);
        this.context = context;
        this.visitor = this;
    }

    public static void setDebug(IDebugAST acceleoDebug) {
        debug = acceleoDebug;
    }

    public static IDebugAST getDebug() {
        return debug;
    }

    public static void setProfile(Profiler acceleoProfile) {
        profile = acceleoProfile;
    }

    public static Profiler getProfiler() {
        return profile;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        this.getContext().append(string, sourceBlock, source, fireEvent);
    }

    public void cacheResult(Query query, List<Object> arguments, Object result) {
        this.queryCache.cacheResult(query, arguments, result);
    }

    public void createFileWriter(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        if (generatedFile.getName().endsWith(File.separator) || generatedFile.isDirectory()) {
            return;
        }
        this.getContext().openNested(generatedFile, fileBlock, source, appendMode, charset);
    }

    public String fitIndentationTo(String source, String indentation) {
        String regex = "\r\n|\r|\n";
        String replacement = "$0" + indentation;
        Matcher sourceMatcher = Pattern.compile(regex).matcher(source);
        StringBuffer result = new StringBuffer();
        boolean hasMatch = sourceMatcher.find();
        while (hasMatch) {
            sourceMatcher.appendReplacement(result, replacement);
            hasMatch = sourceMatcher.find();
        }
        sourceMatcher.appendTail(result);
        return result.toString();
    }

    public Object getCachedResult(Query query, List<Object> arguments) {
        return this.queryCache.getResult(query, arguments);
    }

    public AcceleoEvaluationContext<C> getContext() {
        return this.context;
    }

    public void visitAcceleoBlock(Block block) {
        for (org.eclipse.ocl.ecore.OCLExpression nested : block.getBody()) {
            this.getVisitor().visitExpression((OCLExpression)nested);
        }
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        Object currentSelf;
        boolean appendMode;
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object fileURLResult = this.getVisitor().visitExpression((OCLExpression)fileBlock.getFileUrl());
        this.fireGenerationEvent = fireEvents;
        if (this.isUndefined(fileURLResult)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.UndefinedFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        if (fileURLResult instanceof Collection) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.CollectionFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        if (!(fileURLResult instanceof String)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.NotStringFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        if ("".equals(fileURLResult)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.EmptyFileName", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        String filePath = String.valueOf(fileURLResult).trim();
        String fileCharset = null;
        if (fileBlock.getCharset() != null) {
            Object fileCharsetResult = this.visitExpression((OCLExpression<C>)fileBlock.getCharset());
            if (this.isUndefined(fileCharsetResult)) {
                AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.UndefinedFileCharset", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
                AcceleoEnginePlugin.log(exception, false);
            }
            fileCharset = String.valueOf(fileCharsetResult);
        }
        boolean bl = appendMode = fileBlock.getOpenMode().getValue() == 0;
        if (!appendMode) {
            this.getContext().generateFile(filePath);
        }
        EObject source = (currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)) instanceof EObject ? (EObject)currentSelf : this.lastEObjectSelfValue;
        this.getContext().getProgressMonitor().subTask(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.Generatingfile", filePath));
        if ("stdout".equals(filePath)) {
            this.getContext().openNested(System.out);
        } else {
            this.delegateCreateFileWriter(filePath, (Block)fileBlock, source, appendMode, fileCharset);
        }
        for (org.eclipse.ocl.ecore.OCLExpression nested : fileBlock.getBody()) {
            this.fireGenerationEvent = true;
            this.getVisitor().visitExpression((OCLExpression)nested);
            this.fireGenerationEvent = fireEvents;
        }
        this.getContext().closeContext((Block)fileBlock, source);
        this.getContext().getProgressMonitor().worked(1);
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        ArrayList actualIteration;
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object iteration = this.getVisitor().visitExpression((OCLExpression)forBlock.getIterSet());
        this.fireGenerationEvent = fireEvents;
        Variable loopVariable = forBlock.getLoopVariable();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(iteration)) {
            throw this.getContext().createAcceleoException((ASTNode)forBlock, "AcceleoEvaluationVisitor.InvalidForIteration", currentSelf);
        }
        if (iteration instanceof Collection) {
            actualIteration = (ArrayList)iteration;
        } else {
            actualIteration = new ArrayList();
            ((List)actualIteration).add(iteration);
        }
        if (actualIteration.size() > 0 && forBlock.getBefore() != null) {
            this.getVisitor().visitExpression((OCLExpression)forBlock.getBefore());
        }
        Iterator contentIterator = actualIteration.iterator();
        boolean iterationCCE = false;
        boolean hasPrevious = false;
        String implicitContextVariableName = null;
        int count = 0;
        try {
            while (contentIterator.hasNext()) {
                Object guardValue;
                if (++count == 1) {
                    this.getEvaluationEnvironment().add(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                } else {
                    this.getEvaluationEnvironment().replace(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                }
                Object o = contentIterator.next();
                if (loopVariable != null && loopVariable.getType() != null && !((EClassifier)loopVariable.getType()).isInstance(o)) {
                    if (iterationCCE) continue;
                    int line = this.getLineOf((ASTNode)forBlock);
                    String actualType = "null";
                    if (o != null) {
                        actualType = o.getClass().getName();
                    }
                    String expectedType = ((EClassifier)loopVariable.getType()).getName();
                    String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.IterationClassCast", line, ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), actualType, expectedType);
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(message);
                    exception.setStackTrace(this.getContext().createAcceleoStackTrace());
                    AcceleoEnginePlugin.log(exception, false);
                    iterationCCE = true;
                    continue;
                }
                if (loopVariable != null) {
                    if (count == 1) {
                        this.getEvaluationEnvironment().add(loopVariable.getName(), o);
                    } else {
                        this.getEvaluationEnvironment().replace(loopVariable.getName(), o);
                    }
                }
                if (implicitContextVariableName == null) {
                    implicitContextVariableName = this.addContextVariableFor(o);
                } else {
                    this.getEvaluationEnvironment().replace(implicitContextVariableName, o);
                }
                this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, o);
                if (forBlock.getGuard() == null) {
                    guardValue = Boolean.TRUE;
                } else {
                    this.fireGenerationEvent = false;
                    guardValue = this.getVisitor().visitExpression((OCLExpression)forBlock.getGuard());
                    this.fireGenerationEvent = fireEvents;
                }
                if (this.isInvalid(guardValue)) {
                    AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)forBlock, (OCLExpression<C>)forBlock.getGuard(), UNDEFINED_GUARD_MESSAGE_KEY, o);
                    throw exception;
                }
                if (guardValue != null && ((Boolean)guardValue).booleanValue()) {
                    if (forBlock.getEach() != null && hasPrevious) {
                        this.getVisitor().visitExpression((OCLExpression)forBlock.getEach());
                    }
                    for (org.eclipse.ocl.ecore.OCLExpression nested : forBlock.getBody()) {
                        this.getVisitor().visitExpression((OCLExpression)nested);
                    }
                    hasPrevious = true;
                }
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
        }
        finally {
            if (count > 0) {
                if (loopVariable != null) {
                    this.getEvaluationEnvironment().remove(loopVariable.getName());
                }
                this.getEvaluationEnvironment().remove(implicitContextVariableName);
                --this.currentContextIndex;
                this.getEvaluationEnvironment().remove(ITERATION_COUNT_VARIABLE_NAME);
            }
        }
        if (actualIteration.size() > 0 && forBlock.getAfter() != null) {
            this.getVisitor().visitExpression((OCLExpression)forBlock.getAfter());
        }
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        org.eclipse.ocl.ecore.OCLExpression condition = ifBlock.getIfExpr();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object conditionValue = this.getVisitor().visitExpression((OCLExpression)condition);
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(conditionValue)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)ifBlock, "AcceleoEvaluationVisitor.UndefinedCondition", currentSelf);
            throw exception;
        }
        if (conditionValue != null && !(conditionValue instanceof Boolean)) {
            throw this.getContext().createAcceleoException((ASTNode)ifBlock, (OCLExpression<C>)condition, "AcceleoEvaluationVisitor.NotBooleanCondition", currentSelf);
        }
        if (conditionValue != null && ((Boolean)conditionValue).booleanValue()) {
            for (org.eclipse.ocl.ecore.OCLExpression nested : ifBlock.getBody()) {
                this.getVisitor().visitExpression((OCLExpression)nested);
            }
        } else if (ifBlock.getElseIf().size() > 0) {
            IfBlock temp = null;
            for (IfBlock elseif : ifBlock.getElseIf()) {
                this.fireGenerationEvent = false;
                Object elseValue = this.getVisitor().visitExpression((OCLExpression)elseif.getIfExpr());
                this.fireGenerationEvent = fireEvents;
                if (this.isInvalid(elseValue)) {
                    AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)elseif, "AcceleoEvaluationVisitor.UndefinedElseCondition", currentSelf);
                    throw exception;
                }
                if (elseValue != null && !(elseValue instanceof Boolean)) {
                    throw this.getContext().createAcceleoException((ASTNode)ifBlock, (OCLExpression<C>)elseif.getIfExpr(), "AcceleoEvaluationVisitor.NotBooleanCondition", currentSelf);
                }
                if (elseValue == null || !((Boolean)elseValue).booleanValue()) continue;
                temp = elseif;
                break;
            }
            if (temp != null) {
                for (org.eclipse.ocl.ecore.OCLExpression nested : temp.getBody()) {
                    this.getVisitor().visitExpression((OCLExpression)nested);
                }
            } else if (ifBlock.getElse() != null) {
                this.visitAcceleoBlock(ifBlock.getElse());
            }
        } else if (ifBlock.getElse() != null) {
            this.visitAcceleoBlock(ifBlock.getElse());
        }
    }

    public void visitAcceleoInitSection(InitSection init) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        this.evaluatingInitSection = true;
        for (Variable var : init.getVariable()) {
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
        }
        this.evaluatingInitSection = false;
        this.fireGenerationEvent = fireEvents;
    }

    public void visitAcceleoLetBlock(LetBlock letBlock) {
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Variable var = letBlock.getLetVariable();
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object value = this.getVisitor().visitExpression(var.getInitExpression());
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(value)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)letBlock, "AcceleoEvaluationVisitor.UndefinedLetValue", currentSelf);
            throw exception;
        }
        String varName = null;
        try {
            if (((EClassifier)var.getType()).isInstance(value) || var.getType() == this.getEnvironment().getOCLStandardLibrary().getOclAny()) {
                varName = var.getName();
                this.getEvaluationEnvironment().add(varName, value);
                for (org.eclipse.ocl.ecore.OCLExpression nested : letBlock.getBody()) {
                    this.getVisitor().visitExpression((OCLExpression)nested);
                }
            } else if (letBlock.getElseLet().size() > 0) {
                LetBlock temp = null;
                for (LetBlock elseLet : letBlock.getElseLet()) {
                    var = elseLet.getLetVariable();
                    this.fireGenerationEvent = false;
                    value = this.visitExpression(var.getInitExpression());
                    this.fireGenerationEvent = fireEvents;
                    if (this.isInvalid(value)) {
                        AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)elseLet, "AcceleoEvaluationVisitor.UndefinedElseLetValue", currentSelf);
                        throw exception;
                    }
                    if (!((EClassifier)var.getType()).isInstance(value)) continue;
                    varName = var.getName();
                    this.getEvaluationEnvironment().add(var.getName(), value);
                    temp = elseLet;
                    break;
                }
                if (temp != null) {
                    for (org.eclipse.ocl.ecore.OCLExpression nested : temp.getBody()) {
                        this.getVisitor().visitExpression((OCLExpression)nested);
                    }
                } else if (letBlock.getElse() != null) {
                    this.visitAcceleoBlock(letBlock.getElse());
                }
            } else if (letBlock.getElse() != null) {
                this.visitAcceleoBlock(letBlock.getElse());
            }
        }
        catch (Throwable throwable) {
            if (varName != null) {
                this.getEvaluationEnvironment().remove(varName);
            }
            throw throwable;
        }
        if (varName != null) {
            this.getEvaluationEnvironment().remove(varName);
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object markerValue = this.getVisitor().visitExpression((OCLExpression)protectedArea.getMarker());
        this.fireGenerationEvent = fireEvents;
        Object source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(markerValue)) {
            AcceleoEvaluationException exception = this.getContext().createAcceleoException((ASTNode)protectedArea, "AcceleoEvaluationVisitor.UndefinedAreaMarker", source);
            throw exception;
        }
        String marker = this.toString(markerValue).trim();
        String areaContent = this.getContext().getProtectedAreaContent(marker);
        if (source instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        if (areaContent != null) {
            if (this.isInFileBlock(protectedArea)) {
                this.delegateAppend(areaContent, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
            } else {
                String actualContent = areaContent.replaceAll("\r\n", "ACCELEO_PROTECTED_AREA_MARKER_FIT_INDENTATION{rn}");
                actualContent = actualContent.replaceAll("\r", "ACCELEO_PROTECTED_AREA_MARKER_FIT_INDENTATION{r}");
                actualContent = actualContent.replaceAll("\n", "ACCELEO_PROTECTED_AREA_MARKER_FIT_INDENTATION{n}");
                this.delegateAppend(actualContent, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
            }
        } else {
            StringLiteralExp userCodeStart = EcoreFactory.eINSTANCE.createStringLiteralExp();
            userCodeStart.setStringSymbol(String.valueOf(AcceleoEngineMessages.getString("usercode.start")) + ' ');
            StringLiteralExp userCodeEnd = EcoreFactory.eINSTANCE.createStringLiteralExp();
            userCodeEnd.setStringSymbol(AcceleoEngineMessages.getString("usercode.end"));
            ProtectedAreaBlock dummy = MtlFactory.eINSTANCE.createProtectedAreaBlock();
            dummy.getBody().add((Object)userCodeStart);
            dummy.getBody().add((Object)userCodeEnd);
            this.getVisitor().visitExpression((OCLExpression)userCodeStart);
            this.getVisitor().visitExpression((OCLExpression)protectedArea.getMarker());
            this.visitAcceleoBlock((Block)protectedArea);
            this.getVisitor().visitExpression((OCLExpression)userCodeEnd);
        }
    }

    public static String removeProtectedMarkers(String string) {
        Matcher matcher = Pattern.compile("ACCELEO_PROTECTED_AREA_MARKER_FIT_INDENTATION\\{(.)(.)?\\}").matcher(string);
        if (matcher.find()) {
            StringBuffer buffer = new StringBuffer();
            do {
                String replacement = matcher.group(2) != null ? "\r\n" : ("n".equals(matcher.group(1)) ? "\n" : "\r");
                matcher.appendReplacement(buffer, replacement);
            } while (matcher.find());
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        if (this.getContext().getProgressMonitor().isCanceled()) {
            this.cancel(new ASTFragment((ASTNode)invocation));
        }
        query = invocation.getDefinition();
        implicitContextVariableName = null;
        arguments = new ArrayList<Object>();
        fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        i = 0;
        while (i < query.getParameter().size()) {
            var = (Variable)query.getParameter().get(i);
            var.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
            argValue = this.getEvaluationEnvironment().getValueOf(var.getName());
            if (this.isInvalid(argValue)) {
                failingExpression = (OCLExpression)invocation.getArgument().get(i);
                currentSelf = this.getEvaluationEnvironment().getValueOf("self");
                exception = this.getContext().createAcceleoException((ASTNode)invocation, failingExpression, "AcceleoEvaluationVisitor.UndefinedArgument", currentSelf);
                j = 0;
                while (j <= i) {
                    this.getEvaluationEnvironment().remove(((Variable)query.getParameter().get(j)).getName());
                    ++j;
                }
                throw exception;
            }
            arguments.add(argValue);
            var.setInitExpression(null);
            ++i;
        }
        this.fireGenerationEvent = fireEvents;
        cachedResult = this.delegateGetCachedResult(query, arguments);
        if (QueryCache.isCachedResult(cachedResult)) {
            for (Variable var : query.getParameter()) {
                this.getEvaluationEnvironment().remove(var.getName());
            }
            if (QueryCache.isInvalid(cachedResult) && AcceleoPreferences.isDebugMessagesEnabled()) {
                currentSelf = this.getEvaluationEnvironment().getValueOf("self");
                exception = this.getContext().createAcceleoException((ASTNode)query, (OCLExpression<C>)query.getExpression(), "AcceleoEvaluationVisitor.InvalidQuery", currentSelf);
                throw exception;
            }
            if (QueryCache.isNull(cachedResult)) {
                cachedResult = null;
            }
            return cachedResult;
        }
        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().add("self", arguments.get(0));
            implicitContextVariableName = this.addContextVariableFor(arguments.get(0));
        }
        result = null;
        try {
            result = this.visitExpression((OCLExpression<C>)query.getExpression());
        }
        finally {
            ** for (var : query.getParameter())
        }
lbl-1000:
        // 1 sources

        {
            this.getEvaluationEnvironment().remove(var.getName());
            continue;
        }
lbl57:
        // 1 sources

        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        this.delegateCacheResult(query, arguments, result);
        if (this.isInvalid(result) && AcceleoPreferences.isDebugMessagesEnabled()) {
            currentSelf = this.getEvaluationEnvironment().getValueOf("self");
            exception = this.getContext().createAcceleoException((ASTNode)query, (OCLExpression<C>)query.getExpression(), "AcceleoEvaluationVisitor.InvalidQuery", currentSelf);
            throw exception;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        this.getContext().openNested();
        for (org.eclipse.ocl.ecore.OCLExpression nested : template.getBody()) {
            this.getVisitor().visitExpression((OCLExpression)nested);
        }
        String result = this.getContext().closeContext();
        if (template.getPost() != null) {
            this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, (Object)result);
            Object postResult = this.getVisitor().visitExpression((OCLExpression)template.getPost());
            this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            if (this.isInvalid(postResult)) {
                int line = this.getLineOf((ASTNode)template);
                String moduleName = ((Module)EcoreUtil.getRootContainer((EObject)template)).getName();
                String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedPost", template.getPost(), line, moduleName, template, result);
                AcceleoEvaluationException exception = new AcceleoEvaluationException(message);
                throw exception;
            }
            result = this.toString(postResult);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        implicitContextVariableName = null;
        actualTemplate = this.prepareInvocation(invocation);
        if (actualTemplate.getParameter().size() > 0) {
            contextValue = this.getEvaluationEnvironment().getValueOf(((Variable)actualTemplate.getParameter().get(0)).getName());
            this.getEvaluationEnvironment().add("self", contextValue);
            implicitContextVariableName = this.addContextVariableFor(contextValue);
        }
        this.getContext().openNested();
        if (invocation.getBefore() != null) {
            this.getVisitor().visitExpression((OCLExpression)invocation.getBefore());
        }
        if ((source = this.getEvaluationEnvironment().getValueOf("self")) instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        try {
            result = this.getVisitor().visitExpression((OCLExpression)actualTemplate);
            this.delegateAppend(this.toString(result), (Block)actualTemplate, this.lastEObjectSelfValue, false);
        }
        finally {
            i = 0;
            ** while (i < actualTemplate.getParameter().size())
        }
lbl-1000:
        // 1 sources

        {
            param = (Variable)actualTemplate.getParameter().get(i);
            param.setInitExpression(null);
            this.getEvaluationEnvironment().remove(param.getName());
            this.getEvaluationEnvironment().remove("temporaryInvocationVariable$" + i);
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        if (actualTemplate.getParameter().size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        if (invocation.getAfter() != null) {
            this.getVisitor().visitExpression((OCLExpression)invocation.getAfter());
        }
        ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).removeVariableScope();
        invocationResult = this.getContext().closeContext();
        if (this.evaluatingInitSection) {
            return invocationResult;
        }
        return this.delegateFitIndentation(invocationResult);
    }

    /*
     * Exception decompiling
     */
    public Object visitExpression(OCLExpression<C> expression) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        Object result;
        block13: {
            URI uri;
            if (callExp.getOperationCode() == 1) {
                Object stringType = this.getEnvironment().getOCLStandardLibrary().getString();
                if (callExp.getSource().getType() == stringType || ((OCLExpression)callExp.getArgument().get(0)).getType() == stringType) {
                    ((EObject)callExp.getReferredOperation()).eAdapters().add((Object)new AcceleoOverrideAdapter());
                }
            } else if (((EObject)callExp.getReferredOperation()).eIsProxy() && (uri = ((InternalEObject)callExp.getReferredOperation()).eProxyURI()).fragment() != null && uri.fragment().endsWith("%2F")) {
                callExp.setOperationCode(4);
            }
            EOperation operation = (EOperation)callExp.getReferredOperation();
            this.lastSourceExpression = callExp.getSource();
            boolean isStandardOperation = false;
            boolean isNonStandardOperation = false;
            EList annotations = operation.getEAnnotations();
            int i = 0;
            while (i < annotations.size()) {
                EAnnotation annotation = (EAnnotation)annotations.get(i);
                if ("MTL non-standard".equals(annotation.getSource())) {
                    isNonStandardOperation = true;
                    break;
                }
                if ("MTL".equals(annotation.getSource())) {
                    isStandardOperation = true;
                    break;
                }
                ++i;
            }
            if (isStandardOperation || isNonStandardOperation) {
                Object source = this.getDelegate().visitExpression(callExp.getSource());
                Object[] args = new Object[callExp.getArgument().size()];
                int i2 = 0;
                while (i2 < callExp.getArgument().size()) {
                    args[i2] = this.getVisitor().visitExpression((OCLExpression)callExp.getArgument().get(i2));
                    ++i2;
                }
                try {
                    if (isStandardOperation) {
                        result = AcceleoLibraryOperationVisitor.callStandardOperation((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment(), operation, source, args);
                        break block13;
                    }
                    result = AcceleoLibraryOperationVisitor.callNonStandardOperation((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment(), operation, source, args);
                }
                catch (Exception e) {
                    AcceleoEnginePlugin.log(e, true);
                    result = this.invalid;
                }
            } else {
                return this.getDelegate().visitOperationCallExp(callExp);
            }
        }
        return result;
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return this.getDelegate().visitPropertyCallExp(callExp);
    }

    void setVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratingVisitor) {
        this.visitor = decoratingVisitor;
    }

    protected final AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getAcceleoVisitor() {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return (AcceleoEvaluationVisitorDecorator)this.getVisitor();
        }
        return null;
    }

    protected final EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getVisitor() {
        return this.visitor;
    }

    private String addContextVariableFor(Object contextValue) {
        String variableName = TEMPORARY_CONTEXT_VAR_PREFIX + this.currentContextIndex++;
        while (this.getEvaluationEnvironment().getValueOf(variableName) != null) {
            variableName = TEMPORARY_CONTEXT_VAR_PREFIX + this.currentContextIndex++;
        }
        this.getEvaluationEnvironment().add(variableName, contextValue);
        return variableName;
    }

    private void cancel(ASTFragment astFragment) {
        if (debug != null) {
            debug.endDebug(astFragment);
            debug = null;
        }
        this.getContext().dispose();
        throw new AcceleoEvaluationCancelledException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CancelException"));
    }

    private void delegateAppend(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        String actualString = string;
        if (this.shouldRemoveProtectedMarker(sourceBlock)) {
            actualString = AcceleoEvaluationVisitor.removeProtectedMarkers(string);
        }
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().append(actualString, sourceBlock, source, fireEvent);
        } else {
            this.append(actualString, sourceBlock, source, fireEvent);
        }
    }

    private boolean shouldRemoveProtectedMarker(Block sourceBlock) {
        boolean result = false;
        if (sourceBlock instanceof FileBlock) {
            result = true;
        } else {
            EObject parent = sourceBlock.eContainer();
            while (parent != null && !(parent instanceof FileBlock)) {
                parent = parent.eContainer();
            }
            if (parent instanceof FileBlock) {
                result = true;
            }
        }
        return result;
    }

    private void delegateCacheResult(Query query, List<Object> arguments, Object result) {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().cacheResult(query, arguments, result);
        } else {
            this.cacheResult(query, arguments, result);
        }
    }

    private void delegateCreateFileWriter(String filePath, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().createFileWriter(this.getContext().getFileFor(filePath), fileBlock, source, appendMode, charset);
        } else {
            this.createFileWriter(this.getContext().getFileFor(filePath), fileBlock, source, appendMode, charset);
        }
    }

    private String delegateFitIndentation(String source) {
        String currentIndent = this.getContext().getCurrentLineIndentation();
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return this.getAcceleoVisitor().fitIndentationTo(source, currentIndent);
        }
        return this.fitIndentationTo(source, currentIndent);
    }

    private Object delegateGetCachedResult(Query query, List<Object> arguments) {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return this.getAcceleoVisitor().getCachedResult(query, arguments);
        }
        return this.getCachedResult(query, arguments);
    }

    private void evaluateGuards(List<Template> candidates, List<Variable> arguments) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        AcceleoEvaluationException exception = null;
        for (Template candidate : new ArrayList<Template>(candidates)) {
            if (candidate.getGuard() == null) continue;
            int i = 0;
            while (i < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i);
                VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)arguments.get(i));
                param.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)param);
                if (i == 0) {
                    Object newContext = this.getEvaluationEnvironment().getValueOf(param.getName());
                    this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, newContext);
                }
                ++i;
            }
            Object guardValue = this.getVisitor().visitExpression((OCLExpression)candidate.getGuard());
            int i2 = 0;
            while (i2 < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i2);
                ((VariableExp)param.getInitExpression()).setReferredVariable(null);
                param.setInitExpression(null);
                this.getEvaluationEnvironment().remove(param.getName());
                ++i2;
            }
            if (candidate.getParameter().size() > 0) {
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
            if (this.isInvalid(guardValue)) {
                if (exception == null) {
                    Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    exception = this.getContext().createAcceleoException((ASTNode)candidate, (OCLExpression<C>)candidate.getGuard(), UNDEFINED_GUARD_MESSAGE_KEY, currentSelf);
                }
                candidates.remove(candidate);
                continue;
            }
            if (guardValue != null && ((Boolean)guardValue).booleanValue()) continue;
            candidates.remove(candidate);
        }
        if (candidates.size() == 0 && exception != null) {
            throw exception;
        }
        this.fireGenerationEvent = fireEvents;
    }

    private AcceleoEnvironment getAcceleoEnvironment() {
        return (AcceleoEnvironment)this.getEnvironment();
    }

    private int getLineOf(ASTNode node) {
        Adapter adapter = EcoreUtil.getAdapter((List)node.eAdapters(), AcceleoASTNodeAdapter.class);
        int line = 0;
        if (adapter != null) {
            line = ((AcceleoASTNodeAdapter)adapter).getLine();
        }
        return line;
    }

    private boolean isInFileBlock(ProtectedAreaBlock protectedArea) {
        EObject container = protectedArea.eContainer();
        boolean isInFileBlock = false;
        while (container != null && !isInFileBlock && !(container instanceof Template)) {
            isInFileBlock = container instanceof FileBlock;
            container = container.eContainer();
        }
        return isInFileBlock;
    }

    private boolean isInvalid(Object value) {
        return value == this.invalid;
    }

    private boolean isUndefined(Object value) {
        return value == null || value == this.invalid;
    }

    private Template prepareInvocation(TemplateInvocation invocation) {
        Template actualTemplate;
        Template template = invocation.getDefinition();
        ArrayList<Variable> temporaryArgVars = new ArrayList<Variable>(invocation.getArgument().size());
        if (invocation.isSuper()) {
            VariableExp init;
            Template containingTemplate = (Template)invocation.eContainer();
            actualTemplate = containingTemplate.eContainer() instanceof TemplateInvocation ? ((TemplateInvocation)containingTemplate.eContainer()).getDefinition() : (Template)template.getOverrides().get(0);
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < actualTemplate.getParameter().size()) {
                Variable tempVar = EcoreFactory.eINSTANCE.createVariable();
                tempVar.setName(TEMPORARY_INVOCATION_ARG_PREFIX + i);
                init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)containingTemplate.getParameter().get(i));
                tempVar.setInitExpression((OCLExpression)init);
                temporaryArgVars.add(tempVar);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)tempVar);
                ++i;
            }
            ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).createVariableScope();
            i = 0;
            while (i < actualTemplate.getParameter().size()) {
                Variable var = (Variable)actualTemplate.getParameter().get(i);
                init = EcoreFactory.eINSTANCE.createVariableExp();
                Variable temporaryVar = (Variable)temporaryArgVars.get(i);
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)temporaryVar);
                var.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                var.setInitExpression(null);
                init.setReferredVariable(null);
                temporaryVar.setType(null);
                temporaryVar.setInitExpression(null);
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
        } else {
            ArrayList<Object> argValues = new ArrayList<Object>();
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < invocation.getArgument().size()) {
                Variable tempVar = EcoreFactory.eINSTANCE.createVariable();
                tempVar.setName(TEMPORARY_INVOCATION_ARG_PREFIX + i);
                tempVar.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
                tempVar.setType((Object)((EClassifier)((OCLExpression)invocation.getArgument().get(i)).getType()));
                temporaryArgVars.add(tempVar);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)tempVar);
                Object argValue = this.getEvaluationEnvironment().getValueOf(tempVar.getName());
                if (this.isInvalid(argValue)) {
                    Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)invocation, (OCLExpression)invocation.getArgument().get(i), "AcceleoEvaluationVisitor.UndefinedArgument", currentSelf);
                    int j = 0;
                    while (j <= i) {
                        this.getEvaluationEnvironment().remove(((org.eclipse.ocl.ecore.OCLExpression)invocation.getArgument().get(j)).getName());
                        ++j;
                    }
                    throw exception;
                }
                argValues.add(this.getEvaluationEnvironment().getValueOf(tempVar.getName()));
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
            List<Template> applicableCandidates = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getAllCandidates((Module)EcoreUtil.getRootContainer((EObject)invocation), template, argValues);
            this.evaluateGuards(applicableCandidates, temporaryArgVars);
            ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).createVariableScope();
            if (applicableCandidates.size() > 0) {
                actualTemplate = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getMostSpecificTemplate(applicableCandidates, argValues);
                int i2 = 0;
                while (i2 < actualTemplate.getParameter().size()) {
                    Variable var = (Variable)actualTemplate.getParameter().get(i2);
                    VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                    Variable temporaryVar = (Variable)temporaryArgVars.get(i2);
                    init.setReferredVariable((org.eclipse.ocl.expressions.Variable)temporaryVar);
                    var.setInitExpression((OCLExpression)init);
                    this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                    var.setInitExpression(null);
                    init.setReferredVariable(null);
                    temporaryVar.setType(null);
                    temporaryVar.setInitExpression(null);
                    ++i2;
                }
            } else {
                actualTemplate = MtlFactory.eINSTANCE.createTemplate();
            }
        }
        return actualTemplate;
    }

    private boolean profileExpression(OCLExpression<C> expression) {
        return !(expression instanceof StringLiteralExp);
    }

    private void restoreInitVariables(InitSection init) {
        for (Variable var : init.getVariable()) {
            this.getEvaluationEnvironment().remove(var.getName());
        }
    }

    private boolean shouldGenerateText(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || this.fireGenerationEvent && reference == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }

    private Object switchExpression(OCLExpression<C> expression) {
        Object result;
        if (expression == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UnresolvedCompilationError"));
        }
        AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> delegate = this.getAcceleoVisitor();
        if (expression instanceof Template) {
            if (this.getContext().getProgressMonitor().isCanceled()) {
                this.cancel(new ASTFragment((ASTNode)expression));
            }
            result = delegate != null ? delegate.visitAcceleoTemplate((Template)expression) : this.visitAcceleoTemplate((Template)expression);
        } else if (expression instanceof IfBlock) {
            if (delegate != null) {
                delegate.visitAcceleoIfBlock((IfBlock)expression);
            } else {
                this.visitAcceleoIfBlock((IfBlock)expression);
            }
            result = this.getContext().getDefaultText();
            if (result == null) {
                result = "";
            }
        } else if (expression instanceof ForBlock) {
            if (delegate != null) {
                delegate.visitAcceleoForBlock((ForBlock)expression);
            } else {
                this.visitAcceleoForBlock((ForBlock)expression);
            }
            result = this.getContext().getDefaultText();
            if (result == null) {
                result = "";
            }
        } else if (expression instanceof FileBlock) {
            if (this.getContext().getProgressMonitor().isCanceled()) {
                this.cancel(new ASTFragment((ASTNode)expression));
            }
            if (delegate != null) {
                delegate.visitAcceleoFileBlock((FileBlock)expression);
            } else {
                this.visitAcceleoFileBlock((FileBlock)expression);
            }
            result = this.getContext().getDefaultText();
            if (result == null) {
                result = "";
            }
        } else if (expression instanceof TemplateInvocation) {
            result = delegate != null ? delegate.visitAcceleoTemplateInvocation((TemplateInvocation)expression) : this.visitAcceleoTemplateInvocation((TemplateInvocation)expression);
        } else if (expression instanceof QueryInvocation) {
            result = delegate != null ? delegate.visitAcceleoQueryInvocation((QueryInvocation)expression) : this.visitAcceleoQueryInvocation((QueryInvocation)expression);
        } else if (expression instanceof LetBlock) {
            if (delegate != null) {
                delegate.visitAcceleoLetBlock((LetBlock)expression);
            } else {
                this.visitAcceleoLetBlock((LetBlock)expression);
            }
            result = this.getContext().getDefaultText();
            if (result == null) {
                result = "";
            }
        } else if (expression instanceof ProtectedAreaBlock) {
            if (delegate != null) {
                delegate.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            } else {
                this.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            }
            result = this.getContext().getDefaultText();
            if (result == null) {
                result = "";
            }
        } else if (!(expression instanceof TemplateExpression)) {
            result = super.visitExpression(expression);
        } else {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UnresolvedCompilationError"));
        }
        return result;
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null) {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterInitExpression
    extends OCLExpressionImpl {
        private final OCLExpression<C> referredExpression;

        public ParameterInitExpression(OCLExpression<C> expession) {
            this.referredExpression = expession;
        }

        public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
            return (T)this.referredExpression.accept(v);
        }
    }
}

