/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModuleElement;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.ModuleElementKind;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.AcceleoRegisteredPackageDialog;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.IAcceleoModuleCompositeListener;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.example.AcceleoInitializationStrategyUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoModuleComposite
extends Composite {
    public static final String MODULE_NAME = "generate";
    public static final String MODULE_ELEMENT_NAME = "generateElement";
    private IAcceleoModuleCompositeListener listener;
    private AcceleoModule acceleoModule = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModule();
    private AcceleoModuleElement acceleoModuleElement = AcceleowizardmodelFactory.eINSTANCE.createAcceleoModuleElement();
    private Text moduleContainer;
    private Button moduleContainerBrowseButton;
    private Text moduleName;
    private Table metamodelTable;
    private Button addButton;
    private Button removeButton;
    private Combo metamodelType;
    private String[] metamodelTypes;
    private Label moduleElementNameLabel;
    private Text moduleElementName;
    private Button templateModuleElementKind;
    private Button queryModuleElementKind;
    private Button generateDocumentation;
    private Button generateFile;
    private Button isMain;
    private Button initializeContent;
    private Combo initializeContentKind;
    private Label initializeContentFileLabel;
    private Text initializeContentFile;
    private Button initializeContentBrowseButton;
    private boolean shouldUpdate = true;
    private String initialContainer;

    public AcceleoModuleComposite(Composite parent, IAcceleoModuleCompositeListener listener) {
        super(parent, 0);
        this.listener = listener;
        this.acceleoModule.setModuleElement(this.acceleoModuleElement);
        this.createControls();
        this.updateModule();
    }

    public void setModuleContainer(String container) {
        this.initialContainer = container;
        if (this.moduleContainer != null) {
            this.moduleContainer.setText(container);
        }
    }

    public boolean isComplete() {
        return true;
    }

    public void setAcceleoModule(AcceleoModule acceleoModule) {
        this.acceleoModule = acceleoModule;
        if (this.acceleoModule.getName() != null) {
            this.moduleName.setText(this.acceleoModule.getName());
        }
        if (this.acceleoModule.getParentFolder() != null) {
            this.moduleContainer.setText(this.acceleoModule.getParentFolder());
        }
        this.metamodelTable.removeAll();
        EList<String> metamodelURIs = this.acceleoModule.getMetamodelURIs();
        for (String uri : metamodelURIs) {
            TableItem item = new TableItem(this.metamodelTable, 0);
            item.setText(uri);
        }
        this.updateMetaModelTypes();
        if (this.acceleoModule.getModuleElement().getName() != null) {
            this.moduleElementName.setText(this.acceleoModule.getModuleElement().getName());
        }
        if (this.acceleoModule.getModuleElement().getParameterType() != null) {
            this.metamodelType.setText(this.acceleoModule.getModuleElement().getParameterType());
        }
        if (this.acceleoModule.getModuleElement().getKind() == ModuleElementKind.QUERY) {
            this.queryModuleElementKind.setSelection(true);
            this.templateModuleElementKind.setSelection(false);
            this.isMain.setEnabled(false);
            this.generateFile.setEnabled(false);
        } else if (this.acceleoModule.getModuleElement().getKind() == ModuleElementKind.TEMPLATE) {
            this.queryModuleElementKind.setSelection(false);
            this.templateModuleElementKind.setSelection(true);
            this.isMain.setEnabled(true);
            this.generateFile.setEnabled(true);
        }
        if (this.acceleoModule.isGenerateDocumentation()) {
            this.generateDocumentation.setSelection(true);
        } else {
            this.generateDocumentation.setSelection(false);
        }
        if (this.acceleoModule.getModuleElement().isGenerateFile()) {
            this.generateFile.setSelection(true);
        } else {
            this.generateFile.setSelection(false);
        }
        if (this.acceleoModule.getModuleElement().isIsMain()) {
            this.isMain.setSelection(true);
        } else {
            this.isMain.setSelection(false);
        }
        if (this.acceleoModule.isIsInitialized()) {
            this.initializeContent.setSelection(true);
            this.initializeContentKind.setEnabled(true);
            this.initializeContentFile.setEnabled(true);
        } else {
            this.initializeContent.setSelection(false);
            this.initializeContentKind.setEnabled(false);
            this.initializeContentFile.setEnabled(false);
        }
        if (this.acceleoModule.getInitializationKind() != null) {
            this.initializeContentKind.setText(this.acceleoModule.getInitializationKind());
        }
        if (this.acceleoModule.getInitializationPath() != null) {
            this.initializeContentFile.setText(this.acceleoModule.getInitializationPath());
        }
    }

    public void setAcceleoModuleWithoutUpdate(AcceleoModule anAcceleoModule) {
        this.shouldUpdate = false;
        this.setAcceleoModule(anAcceleoModule);
        this.shouldUpdate = true;
        this.updateModule();
    }

    private void updateModule() {
        TableItem[] items;
        if (!this.shouldUpdate) {
            return;
        }
        this.acceleoModule.setName(this.moduleName.getText());
        Path path = new Path(this.moduleContainer.getText());
        String projectName = path.segment(0);
        this.acceleoModule.setProjectName(projectName);
        this.acceleoModule.setParentFolder(this.moduleContainer.getText());
        EList<String> metamodelURIs = this.acceleoModule.getMetamodelURIs();
        TableItem[] tableItemArray = items = this.metamodelTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            metamodelURIs.add((Object)tableItem.getText());
            ++n2;
        }
        this.acceleoModule.getModuleElement().setName(this.moduleElementName.getText());
        this.acceleoModule.getModuleElement().setParameterType(this.metamodelType.getText());
        boolean isTemplate = this.templateModuleElementKind.getSelection();
        boolean isQuery = this.queryModuleElementKind.getSelection();
        if (isTemplate && !isQuery) {
            this.acceleoModule.getModuleElement().setKind(ModuleElementKind.TEMPLATE);
        } else if (isQuery && !isTemplate) {
            this.acceleoModule.getModuleElement().setKind(ModuleElementKind.QUERY);
            this.acceleoModule.getModuleElement().setIsMain(false);
            this.acceleoModule.getModuleElement().setGenerateFile(false);
        }
        if (isTemplate) {
            boolean hasMain = this.isMain.getSelection();
            this.acceleoModule.getModuleElement().setIsMain(hasMain);
            boolean generatesFile = this.generateFile.getSelection();
            this.acceleoModule.getModuleElement().setGenerateFile(generatesFile);
        }
        boolean hasDocumentation = this.generateDocumentation.getSelection();
        this.acceleoModule.setGenerateDocumentation(hasDocumentation);
        boolean isInitialized = this.initializeContent.getSelection();
        this.acceleoModule.setIsInitialized(isInitialized);
        this.acceleoModule.setInitializationKind(this.initializeContentKind.getText());
        this.acceleoModule.setInitializationPath(this.initializeContentFile.getText());
        this.checkErrors();
    }

    private void checkErrors() {
        Status status = new Status(0, "org.eclipse.acceleo.ide.ui", null);
        if (this.acceleoModule.getName() == null || "".equals(this.acceleoModule.getName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidName");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.getParentFolder() == null || "".equals(this.acceleoModule.getParentFolder())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidParentFolder");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.getMetamodelURIs() == null || this.acceleoModule.getMetamodelURIs().size() == 0) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.EmptyMetamodelURIs");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.getModuleElement().getName() == null || "".equals(this.acceleoModule.getModuleElement().getName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementName");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.getModuleElement().getParameterType() == null || "".equals(this.acceleoModule.getModuleElement().getParameterType())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementParameterType");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.isIsInitialized() && (this.acceleoModule.getInitializationKind() == null || "".equals(this.acceleoModule.getInitializationKind()))) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementInitializationKind");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.acceleoModule.isIsInitialized() && (this.acceleoModule.getInitializationPath() == null || "".equals(this.acceleoModule.getInitializationPath()))) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementInitializationPath");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        } else if (this.moduleExists(this.acceleoModule.getProjectName(), this.acceleoModule.getParentFolder(), this.acceleoModule.getName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.FileAlreadyExists");
            status = new Status(4, "org.eclipse.acceleo.ide.ui", message);
        }
        this.listener.applyToStatusLine((IStatus)status);
    }

    private boolean moduleExists(String projectName, String outputPath, String module) {
        Path path;
        IFolder folder;
        boolean result = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isAccessible() && (folder = project.getFolder((path = new Path(outputPath)).removeFirstSegments(1))).exists() && folder.isAccessible()) {
            IFile file = folder.getFile(String.valueOf(module) + '.' + "mtl");
            result = file.exists() && file.isAccessible();
        }
        return result;
    }

    private void createControls() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        gridData = new GridData(1808);
        int heightHint = 540;
        gridData.heightHint = 540;
        gridData.minimumHeight = 540;
        this.setLayoutData(gridData);
        this.createWidgets();
    }

    private void createWidgets() {
        Composite pageGroup = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        pageGroup.setLayout((Layout)layout);
        pageGroup.setLayoutData((Object)new GridData(1808));
        this.createModuleGroup(pageGroup);
        this.createSeparator(pageGroup);
        this.createModuleElementGroup(pageGroup);
        this.createSeparator(pageGroup);
        this.createInitializeGroup(pageGroup);
    }

    private void createSeparator(Composite pageGroup) {
        Label label = new Label(pageGroup, 258);
        GridData gd = new GridData(768);
        int eight = 8;
        gd.minimumHeight = 8;
        gd.heightHint = 8;
        gd.horizontalSpan = 4;
        label.setLayoutData((Object)gd);
    }

    private void createHelpButton(Composite parent, String helpMessage) {
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }

    private void createModuleGroup(Composite pageGroup) {
        Label label = new Label(pageGroup, 0);
        label.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleContainer")) + ':');
        this.moduleContainer = new Text(pageGroup, 2052);
        GridData gd = new GridData(768);
        this.moduleContainer.setLayoutData((Object)gd);
        this.moduleContainer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.moduleContainerBrowseButton = new Button(pageGroup, 8);
        this.moduleContainerBrowseButton.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.Browse"));
        this.moduleContainerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.handleBrowseWorkspace();
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleContainerHelp"));
        GridData gridData = new GridData(768);
        Label moduleNameLabel = new Label(pageGroup, 0);
        moduleNameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleName")) + ':');
        this.moduleName = new Text(pageGroup, 2052);
        this.moduleName.setText(MODULE_NAME);
        gridData = new GridData(768);
        int widthHint = 270;
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.moduleName.setLayoutData((Object)gridData);
        this.moduleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleNameHelp"));
        Label metamodelLabel = new Label(pageGroup, 0);
        metamodelLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.MetamodelURIs")) + ':');
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        metamodelLabel.setLayoutData((Object)gridData);
        this.metamodelTable = new Table(pageGroup, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        gridData.minimumHeight = 100;
        this.metamodelTable.setLayoutData((Object)gridData);
        Composite tableButtonComposite = new Composite(pageGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableButtonComposite.setLayoutData((Object)new GridData(1040));
        tableButtonComposite.setLayout((Layout)layout);
        this.addButton = new Button(tableButtonComposite, 8);
        Image addImage = AcceleoUIActivator.getDefault().getImage("icons/add_obj.gif");
        this.addButton.setImage(addImage);
        this.addButton.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.AddButton"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.handleSelectMetamodelURI();
                AcceleoModuleComposite.this.updateMetaModelTypes();
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.removeButton = new Button(tableButtonComposite, 8);
        Image removeImage = AcceleoUIActivator.getDefault().getImage("icons/delete_obj.gif");
        this.removeButton.setImage(removeImage);
        this.removeButton.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.RemoveButton"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices;
                int[] nArray = selectionIndices = AcceleoModuleComposite.this.metamodelTable.getSelectionIndices();
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    AcceleoModuleComposite.this.metamodelTable.remove(i);
                    ++n2;
                }
                AcceleoModuleComposite.this.updateMetaModelTypes();
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(tableButtonComposite, AcceleoUIMessages.getString("AcceleoModuleComposite.MetamodelURIsHelp"));
    }

    private void handleBrowseWorkspace() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AcceleoUIMessages.getString("AcceleoModuleComposite.ContainerSelection"));
        IResource current = null;
        Path path = new Path(this.moduleContainer.getText());
        while (current == null && path.segmentCount() > 0) {
            current = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (current != null) continue;
            path = path.removeLastSegments(1);
        }
        if (current != null) {
            dialog.setInitialSelections(new Object[]{current});
        }
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.moduleContainer.setText(((Path)result[0]).toString());
        }
    }

    private void updateMetaModelTypes() {
        if (this.metamodelType != null) {
            TableItem[] items;
            String oldSelection = this.metamodelType.getText();
            ArrayList<String> typeValues = new ArrayList<String>();
            TableItem[] tableItemArray = items = this.metamodelTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                String tableItemText = tableItem.getText();
                StringTokenizer st = new StringTokenizer(tableItemText, ",");
                while (st.hasMoreTokens()) {
                    EPackage ePackage = ModelUtils.getEPackage((String)st.nextToken().trim());
                    if (ePackage == null) continue;
                    ArrayList<EClassifier> eClassifiers = new ArrayList<EClassifier>();
                    AcceleoModuleComposite.computeClassifiers(eClassifiers, ePackage);
                    int i = 0;
                    while (i < eClassifiers.size()) {
                        EClassifier eClassifier = (EClassifier)eClassifiers.get(i);
                        typeValues.add(eClassifier.getName());
                        ++i;
                    }
                }
                ++n2;
            }
            Collections.sort(typeValues);
            this.metamodelTypes = typeValues.toArray(new String[typeValues.size()]);
            this.metamodelType.setItems(this.metamodelTypes);
            int visibleItemCount = 15;
            if (this.metamodelTypes.length < 15) {
                this.metamodelType.setVisibleItemCount(this.metamodelTypes.length);
            } else {
                this.metamodelType.setVisibleItemCount(15);
            }
            this.metamodelType.setText(oldSelection);
            if (this.metamodelType.getText().length() == 0) {
                this.updateDefaultTypes();
            }
        }
    }

    private static void computeClassifiers(List<EClassifier> eClassifiers, EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            eClassifiers.add(eClassifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            AcceleoModuleComposite.computeClassifiers(eClassifiers, (EPackage)packages.next());
        }
    }

    private void updateDefaultTypes() {
        this.metamodelType.setText("Element");
        this.metamodelType.setText("Model");
        this.metamodelType.setText("File");
        this.metamodelType.setText("Type");
        this.metamodelType.setText("EClass");
        this.metamodelType.setText("Class");
        if (this.metamodelType.getText() == null || "".equals(this.metamodelType.getText())) {
            this.metamodelType.select(0);
        }
    }

    private void handleSelectMetamodelURI() {
        AcceleoRegisteredPackageDialog registeredPackageDialog = new AcceleoRegisteredPackageDialog(this.getShell());
        registeredPackageDialog.open();
        Object[] result = registeredPackageDialog.getResult();
        if (result != null) {
            List<Object> nsURIs = Arrays.asList(result);
            CompactLinkedHashSet uriSet = new CompactLinkedHashSet();
            if (registeredPackageDialog.isDevelopmentTimeVersion()) {
                StringBuffer uris = new StringBuffer();
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.setPackageRegistry((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                    Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                    int i = 0;
                    while (i < result.length) {
                        Iterator location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                        Resource resource = resourceSet.getResource((URI)location, true);
                        EcoreUtil.resolveAll((Resource)resource);
                        ++i;
                    }
                    block3: for (Resource resource : resourceSet.getResources()) {
                        for (EPackage ePackage : this.getAllPackages(resource)) {
                            if (!nsURIs.contains(ePackage.getNsURI())) continue;
                            uriSet.add(ePackage.getNsURI());
                            uris.append(ePackage.getNsURI());
                            uris.append(',');
                            continue block3;
                        }
                    }
                }
                catch (WrappedException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            } else {
                int i = 0;
                while (i < result.length) {
                    uriSet.add(result[i].toString());
                    ++i;
                }
            }
            for (String uri : uriSet) {
                TableItem[] items;
                boolean exists = false;
                TableItem[] tableItemArray = items = this.metamodelTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.getText().equals(uri)) {
                        exists = true;
                    }
                    ++n2;
                }
                if (exists) continue;
                TableItem item = new TableItem(this.metamodelTable, 0);
                item.setText(uri);
            }
        }
    }

    private Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> iterator = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                if (eObject instanceof EPackage) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
                return Collections.emptyList().iterator();
            }
        };
        while (iterator.hasNext()) {
            Object content = iterator.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    private void createModuleElementGroup(Composite pageGroup) {
        GridData gridData = new GridData(768);
        this.moduleElementNameLabel = new Label(pageGroup, 0);
        this.moduleElementNameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameTemplate")) + ':');
        this.moduleElementName = new Text(pageGroup, 2052);
        this.moduleElementName.setText(MODULE_ELEMENT_NAME);
        gridData = new GridData(768);
        int widthHint = 270;
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.moduleElementName.setLayoutData((Object)gridData);
        this.moduleElementName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameHelp"));
        Label typeLabel = new Label(pageGroup, 0);
        typeLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementType")) + ':');
        this.metamodelType = new Combo(pageGroup, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.metamodelType.setLayoutData((Object)gridData);
        this.metamodelTable.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.Type"));
        this.metamodelType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementTypeHelp"));
        this.templateModuleElementKind = new Button(pageGroup, 16);
        this.templateModuleElementKind.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindTemplate"));
        this.templateModuleElementKind.setSelection(true);
        this.templateModuleElementKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.switchModuleElementKind();
                AcceleoModuleComposite.this.updateModule();
                AcceleoModuleComposite.this.updateModuleContainer();
            }
        });
        this.queryModuleElementKind = new Button(pageGroup, 16);
        this.queryModuleElementKind.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindQuery"));
        this.queryModuleElementKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.switchModuleElementKind();
                AcceleoModuleComposite.this.updateModule();
                AcceleoModuleComposite.this.updateModuleContainer();
            }
        });
        new Label(pageGroup, 0);
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindHelp"));
        this.generateDocumentation = new Button(pageGroup, 32);
        this.generateDocumentation.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleGenerateDocumentation"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.generateDocumentation.setLayoutData((Object)gridData);
        this.generateDocumentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleGenerateDocumentationHelp"));
        this.generateFile = new Button(pageGroup, 32);
        this.generateFile.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateGenerateFile"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.generateFile.setLayoutData((Object)gridData);
        this.generateFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.updateModule();
                AcceleoModuleComposite.this.updateModuleContainer();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateGenerateFileHelp"));
        this.isMain = new Button(pageGroup, 32);
        this.isMain.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateMain"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.isMain.setLayoutData((Object)gridData);
        this.isMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.updateModule();
                AcceleoModuleComposite.this.updateModuleContainer();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateMainHelp"));
    }

    private void updateModuleContainer() {
        String common = "/common";
        String main = "/main";
        String files = "/files";
        String requests = "/requests";
        String basicContainer = this.initialContainer;
        if (basicContainer != null && basicContainer.endsWith("/common")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/common".length());
        } else if (basicContainer != null && basicContainer.endsWith("/main")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/main".length());
        } else if (basicContainer != null && basicContainer.endsWith("/files")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/files".length());
        } else if (basicContainer != null && basicContainer.endsWith("/requests")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/requests".length());
        }
        boolean canUpdate = false;
        if (basicContainer != null && this.moduleContainer.getText() != null) {
            String currentContainer = this.moduleContainer.getText();
            canUpdate = canUpdate || currentContainer.equals(String.valueOf(basicContainer) + "/common");
            canUpdate = canUpdate || currentContainer.equals(String.valueOf(basicContainer) + "/main");
            canUpdate = canUpdate || currentContainer.equals(String.valueOf(basicContainer) + "/files");
            boolean bl = canUpdate = canUpdate || currentContainer.equals(String.valueOf(basicContainer) + "/requests");
        }
        if (canUpdate) {
            boolean isTemplate = this.templateModuleElementKind.getSelection();
            boolean isQuery = this.queryModuleElementKind.getSelection();
            if (isTemplate && !isQuery) {
                boolean hasMain = this.isMain.getSelection();
                boolean generatesFile = this.generateFile.getSelection();
                if (generatesFile && !hasMain) {
                    this.moduleContainer.setText(String.valueOf(basicContainer) + "/files");
                } else if (hasMain) {
                    this.moduleContainer.setText(String.valueOf(basicContainer) + "/main");
                } else {
                    this.moduleContainer.setText(String.valueOf(basicContainer) + "/common");
                }
            } else if (isQuery && !isTemplate && this.moduleContainer.getText() != null && !this.moduleContainer.getText().endsWith("/common") && !this.moduleContainer.getText().endsWith("/requests")) {
                this.moduleContainer.setText(String.valueOf(basicContainer) + "/requests");
            }
        }
    }

    private void switchModuleElementKind() {
        if (this.templateModuleElementKind.getSelection()) {
            this.generateFile.setEnabled(true);
            this.isMain.setEnabled(true);
            this.moduleElementNameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameTemplate")) + ':');
        } else {
            this.generateFile.setEnabled(false);
            this.isMain.setEnabled(false);
            this.moduleElementNameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameQuery")) + ':');
        }
    }

    private void createInitializeGroup(Composite pageGroup) {
        this.initializeContent = new Button(pageGroup, 32);
        this.initializeContent.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeContent"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.initializeContent.setLayoutData((Object)gridData);
        this.initializeContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.switchInitializeContent();
                AcceleoModuleComposite.this.changeStrategy();
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeContentHelp"));
        this.initializeContentKind = new Combo(pageGroup, 8);
        this.initializeContentKind.setEnabled(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.initializeContentKind.setLayoutData((Object)gridData);
        this.initializeContentKind.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.changeStrategy();
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.updateStrategies();
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeContentKindHelp"));
        this.initializeContentFileLabel = new Label(pageGroup, 0);
        gridData = new GridData(128);
        this.initializeContentFileLabel.setLayoutData((Object)gridData);
        this.initializeContentFileLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeFile"));
        this.initializeContentFileLabel.setEnabled(false);
        this.initializeContentFile = new Text(pageGroup, 2048);
        gridData = new GridData(768);
        this.initializeContentFile.setLayoutData((Object)gridData);
        this.initializeContentFile.setEnabled(false);
        this.initializeContentFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.initializeContentFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoModuleComposite.this.updateModule();
            }
        });
        this.initializeContentBrowseButton = new Button(pageGroup, 8);
        this.initializeContentBrowseButton.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.Browse"));
        this.initializeContentBrowseButton.setEnabled(false);
        this.initializeContentBrowseButton.addSelectionListener((SelectionListener)new ExampleBrowseSelectionAdapter());
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeFileHelp"));
    }

    private void switchInitializeContent() {
        if (this.initializeContent.getSelection()) {
            this.initializeContentKind.setEnabled(true);
            this.initializeContentFileLabel.setEnabled(true);
            this.initializeContentFile.setEnabled(true);
            this.initializeContentBrowseButton.setEnabled(true);
        } else {
            this.initializeContentKind.setEnabled(false);
            this.initializeContentFileLabel.setEnabled(false);
            this.initializeContentFile.setEnabled(false);
            this.initializeContentBrowseButton.setEnabled(false);
        }
    }

    private void changeStrategy() {
        this.metamodelTable.setEnabled(true);
        this.metamodelType.setEnabled(true);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.generateFile.setEnabled(true);
        this.isMain.setEnabled(true);
        this.generateDocumentation.setEnabled(true);
        this.templateModuleElementKind.setEnabled(true);
        this.queryModuleElementKind.setEnabled(true);
        IAcceleoInitializationStrategy strategy = this.getInitializationStrategy();
        if (strategy != null) {
            this.metamodelTable.setEnabled(!strategy.forceMetamodelURI());
            this.metamodelType.setEnabled(!strategy.forceMetamodelType());
            this.addButton.setEnabled(!strategy.forceMetamodelURI());
            this.removeButton.setEnabled(!strategy.forceMetamodelURI());
            this.generateFile.setEnabled(!strategy.forceHasFile());
            this.isMain.setEnabled(!strategy.forceHasMain());
            this.generateDocumentation.setEnabled(!strategy.forceDocumentation());
            if (strategy.forceQuery() && !strategy.forceTemplate()) {
                this.templateModuleElementKind.setSelection(false);
                this.queryModuleElementKind.setSelection(true);
                this.templateModuleElementKind.setEnabled(false);
            } else if (strategy.forceTemplate() && !strategy.forceQuery()) {
                this.templateModuleElementKind.setSelection(true);
                this.queryModuleElementKind.setSelection(false);
                this.queryModuleElementKind.setEnabled(false);
            }
        }
    }

    public IAcceleoInitializationStrategy getInitializationStrategy() {
        if (this.initializeContent.getSelection() && this.initializeContentKind != null && this.initializeContentKind.getSelectionIndex() > -1 && this.initializeContentKind.getSelectionIndex() < AcceleoInitializationStrategyUtils.getInitializationStrategy().size()) {
            return AcceleoInitializationStrategyUtils.getInitializationStrategy().get(this.initializeContentKind.getSelectionIndex());
        }
        return null;
    }

    private void updateStrategies() {
        if (this.initializeContentKind != null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            Iterator<IAcceleoInitializationStrategy> iterator = AcceleoInitializationStrategyUtils.getInitializationStrategy().iterator();
            while (iterator.hasNext()) {
                descriptions.add(iterator.next().getDescription());
            }
            this.initializeContentKind.setItems(descriptions.toArray(new String[descriptions.size()]));
            int visibleItemCount = 15;
            if (descriptions.size() < 15) {
                this.initializeContentKind.setVisibleItemCount(descriptions.size());
            } else {
                this.initializeContentKind.setVisibleItemCount(15);
            }
        }
    }

    public AcceleoModule getAcceleoModule() {
        return this.acceleoModule;
    }

    class ExampleBrowseSelectionAdapter
    extends SelectionAdapter {
        ExampleBrowseSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(AcceleoModuleComposite.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementExample"));
            String path = AcceleoModuleComposite.this.initializeContentFile.getText();
            if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
                dialog.setInitialPattern("*." + new Path(path).getFileExtension());
            } else {
                IAcceleoInitializationStrategy strategy = AcceleoModuleComposite.this.getInitializationStrategy();
                if (strategy != null) {
                    dialog.setInitialPattern(strategy.getInitialFileNameFilter());
                } else {
                    dialog.setInitialPattern("*.java");
                }
            }
            dialog.open();
            if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
                AcceleoModuleComposite.this.initializeContentFile.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
                AcceleoModuleComposite.this.moduleElementName.setText(((IFile)dialog.getResult()[0]).getFullPath().removeFileExtension().lastSegment().toLowerCase().replace('-', '_'));
            }
            AcceleoModuleComposite.this.updateModule();
        }
    }
}

