/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.compiler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;

public final class AcceleoParserTrimUtils {
    private static AcceleoParserTrimUtils instance;
    private ListMultimap<Module, ASTNode> operationsInModule = ArrayListMultimap.create();

    private AcceleoParserTrimUtils() {
    }

    public static AcceleoParserTrimUtils getInstance() {
        if (instance == null) {
            instance = new AcceleoParserTrimUtils();
        }
        return instance;
    }

    public void trimEnvironment(ResourceSet oResourceSet) {
        EList resources = oResourceSet.getResources();
        ConcurrentLinkedQueue conResources = new ConcurrentLinkedQueue(resources);
        for (Resource resource : conResources) {
            EList contents = resource.getContents();
            if (contents.size() <= 0 || !(contents.get(0) instanceof Module)) continue;
            Module module = (Module)contents.get(0);
            this.fillCache(module);
            ArrayList<EOperation> eOperations = new ArrayList<EOperation>();
            int i = 1;
            while (i < contents.size()) {
                EObject eObject = (EObject)contents.get(i);
                TreeIterator eAllContents = eObject.eAllContents();
                while (eAllContents.hasNext()) {
                    EObject next = (EObject)eAllContents.next();
                    if (!(next instanceof EOperation) || eOperations.contains(next) || this.operationUsed((EOperation)next, module, resource)) continue;
                    eOperations.add((EOperation)next);
                }
                ++i;
            }
            for (EOperation eOperation : eOperations) {
                EcoreUtil.remove((EObject)eOperation);
            }
        }
    }

    private void fillCache(Module module) {
        TreeIterator eAllContents = module.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (next.eResource() != module.eResource()) {
                eAllContents.prune();
                continue;
            }
            if (next instanceof OperationCallExp) {
                OperationCallExp operationCallExp = (OperationCallExp)next;
                this.operationsInModule.put((Object)module, (Object)operationCallExp);
                continue;
            }
            if (next instanceof TemplateInvocation) {
                TemplateInvocation templateInvocation = (TemplateInvocation)next;
                this.operationsInModule.put((Object)module, (Object)templateInvocation);
                continue;
            }
            if (next instanceof Template) {
                Template template = (Template)next;
                this.operationsInModule.put((Object)module, (Object)template);
                continue;
            }
            if (next instanceof QueryInvocation) {
                QueryInvocation queryInvocation = (QueryInvocation)next;
                this.operationsInModule.put((Object)module, (Object)queryInvocation);
                continue;
            }
            if (!(next instanceof Query)) continue;
            Query query = (Query)next;
            this.operationsInModule.put((Object)module, (Object)query);
        }
    }

    private boolean operationUsed(EOperation operation, Module module, Resource resource) {
        boolean result = false;
        List nodes = this.operationsInModule.get((Object)module);
        HashSet importedModules = new HashSet(module.getImports());
        HashSet extendedModules = new HashSet(module.getExtends());
        int i = 0;
        while (i < nodes.size() && !result) {
            EObject astNodeContainer;
            EObject definitionContainer;
            ASTNode astNode = (ASTNode)nodes.get(i);
            if (astNode instanceof OperationCallExp) {
                OperationCallExp operationCallExp = (OperationCallExp)astNode;
                if (((EOperation)operationCallExp.getReferredOperation()).equals(operation)) {
                    result = true;
                }
            } else if (astNode instanceof TemplateInvocation) {
                TemplateInvocation templateInvocation = (TemplateInvocation)astNode;
                definitionContainer = templateInvocation.getDefinition().eContainer();
                if (definitionContainer == module || importedModules.contains(definitionContainer) || extendedModules.contains(definitionContainer)) {
                    result = this.templateEqual(templateInvocation.getDefinition(), operation);
                }
            } else if (astNode instanceof Template) {
                astNodeContainer = astNode.eContainer();
                if (astNodeContainer == module || importedModules.contains(astNodeContainer) || extendedModules.contains(astNodeContainer)) {
                    result = this.templateEqual((Template)astNode, operation);
                    Template template = (Template)astNode;
                    EList overrides = template.getOverrides();
                    for (Template overridenTemplates : overrides) {
                        boolean bl = result = result || this.templateEqual(overridenTemplates, operation);
                    }
                }
            } else if (astNode instanceof QueryInvocation) {
                QueryInvocation queryInvocation = (QueryInvocation)astNode;
                definitionContainer = queryInvocation.getDefinition().eContainer();
                if (definitionContainer == module || importedModules.contains(definitionContainer) || extendedModules.contains(definitionContainer)) {
                    result = this.queryEqual(queryInvocation.getDefinition(), operation);
                }
            } else if (astNode instanceof Query && ((astNodeContainer = astNode.eContainer()) == module || importedModules.contains(astNodeContainer) || extendedModules.contains(astNodeContainer))) {
                result = this.queryEqual((Query)astNode, operation);
            }
            ++i;
        }
        return result;
    }

    private boolean queryEqual(Query definition, EOperation operation) {
        boolean result = true;
        result = result && definition.getName().equals(operation.getName());
        EList parameters = definition.getParameter();
        EList eParameters = operation.getEParameters();
        boolean bl = result = result && parameters.size() == eParameters.size();
        if (result) {
            int i = 0;
            while (i < parameters.size()) {
                Variable variable = (Variable)parameters.get(i);
                EParameter eParameter = (EParameter)eParameters.get(i);
                if (variable.getName() != null) {
                    boolean bl2 = result = result && variable.getName().equals(eParameter.getName());
                }
                if (variable.getEType() != null) {
                    result = result && variable.getEType().equals(eParameter.getEType());
                }
                ++i;
            }
        }
        return result;
    }

    private boolean templateEqual(Template definition, EOperation operation) {
        boolean result = true;
        result = result && definition.getName().equals(operation.getName());
        EList parameters = definition.getParameter();
        EList eParameters = operation.getEParameters();
        boolean bl = result = result && parameters.size() == eParameters.size();
        if (result) {
            int i = 0;
            while (i < parameters.size()) {
                Variable variable = (Variable)parameters.get(i);
                EParameter eParameter = (EParameter)eParameters.get(i);
                if (variable.getName() != null) {
                    boolean bl2 = result = result && variable.getName().equals(eParameter.getName());
                }
                if (variable.getEType() != null) {
                    result = result && variable.getEType().equals(eParameter.getEType());
                }
                ++i;
            }
        }
        return result;
    }
}

