/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoProjectUtils;
import org.eclipse.acceleo.internal.ide.ui.wizards.project.AcceleoModulesCreationPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.project.AcceleoProjectPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class AcceleoProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String MODULE_NAME_PREFIX = "org.eclipse.acceleo.module.";
    public static final String INITIAL_PROJECT_NAME = "org.eclipse.acceleo.module.sample";
    protected static final String RESOURCE_WORKING_SET_ID = "org.eclipse.ui.resourceWorkingSetPage";
    protected static final String JAVA_WORKING_SET_ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    protected IConfigurationElement configurationElement;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected AcceleoProjectPage newProjectPage;
    protected AcceleoModulesCreationPage newAcceleoModulesCreationPage;
    private String container;

    public AcceleoProjectWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iSelection) {
        this.workbench = iWorkbench;
        this.selection = iSelection;
    }

    public void addPages() {
        String newProjectWizardName = AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Name");
        this.newProjectPage = new AcceleoProjectPage(newProjectWizardName, this.getSelection());
        this.newProjectPage.setInitialProjectName(INITIAL_PROJECT_NAME);
        this.newProjectPage.setTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
        this.newProjectPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Description"));
        this.newProjectPage.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.addPage((IWizardPage)this.newProjectPage);
        this.newAcceleoModulesCreationPage = new AcceleoModulesCreationPage();
        this.addPage((IWizardPage)this.newAcceleoModulesCreationPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage) {
            WizardNewProjectCreationPage newPage = (WizardNewProjectCreationPage)page;
            this.container = newPage.getProjectName();
            this.container = String.valueOf(this.container) + "/src/" + this.container.replaceAll("\\.", "/");
            this.container = String.valueOf(this.container) + "/common";
            this.newAcceleoModulesCreationPage.setContainer(this.container);
        }
        return super.getNextPage(page);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public boolean canFinish() {
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage currentPage = iWizardContainer.getCurrentPage();
        if (currentPage instanceof WizardNewProjectCreationPage) {
            return this.newProjectPage.isPageComplete();
        }
        return this.newProjectPage.isPageComplete() && this.newAcceleoModulesCreationPage.isPageComplete();
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        try {
            IWizardContainer iWizardContainer = this.getContainer();
            IRunnableWithProgress projectCreation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AcceleoProjectWizard.this.newProjectPage.getProjectName());
                        IPath location = AcceleoProjectWizard.this.newProjectPage.getLocationPath();
                        if (!project.exists()) {
                            IProjectDescription desc = project.getWorkspace().newProjectDescription(AcceleoProjectWizard.this.newProjectPage.getProjectName());
                            if (ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                                location = null;
                            }
                            desc.setLocation(location);
                            project.create(desc, monitor);
                            project.open(monitor);
                            AcceleoProjectWizard.this.convert(project, monitor);
                        }
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            };
            iWizardContainer.run(false, false, projectCreation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
            return true;
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (InterruptedException e) {
            AcceleoUIActivator.log(e, true);
        }
        return false;
    }

    private void convert(IProject project, IProgressMonitor monitor) {
        String projectName = this.newProjectPage.getProjectName();
        String generatorName = this.computeGeneratorName(projectName);
        AcceleoProject acceleoProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
        acceleoProject.setName(projectName);
        acceleoProject.setGeneratorName(generatorName);
        acceleoProject.setJre("J2SE-1.5");
        acceleoProject.setJre(this.newProjectPage.getSelectedJVM());
        List<AcceleoModule> allModules = this.newAcceleoModulesCreationPage.getAllModules();
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage currentPage = iWizardContainer.getCurrentPage();
        if (!(currentPage instanceof WizardNewProjectCreationPage)) {
            for (AcceleoModule acceleoModule : allModules) {
                String parentFolder = acceleoModule.getParentFolder();
                IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
                if (moduleProject.exists() && moduleProject.isAccessible() && acceleoModule.getModuleElement() != null && acceleoModule.getModuleElement().isIsMain()) {
                    Path parentFolderPath = new Path(parentFolder);
                    IFolder folder = moduleProject.getFolder(parentFolderPath.removeFirstSegments(1));
                    acceleoProject.getExportedPackages().add((Object)folder.getProjectRelativePath().removeFirstSegments(1).toString().replaceAll("/", "\\."));
                }
                EList<String> metamodelURIs = acceleoModule.getMetamodelURIs();
                for (String metamodelURI : metamodelURIs) {
                    EPackage ePackage = AcceleoPackageRegistry.INSTANCE.getEPackage(metamodelURI);
                    if (ePackage == null || ePackage instanceof EcorePackage) continue;
                    Bundle bundle = AcceleoWorkspaceUtil.getBundle(ePackage.getClass());
                    acceleoProject.getPluginDependencies().add((Object)bundle.getSymbolicName());
                }
            }
        }
        boolean generateModules = !(currentPage instanceof WizardNewProjectCreationPage);
        AcceleoProjectUtils.generateFiles(acceleoProject, allModules, project, generateModules, monitor);
        try {
            IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)this.newProjectPage.getJREContainerPath());
            IJavaProject iJavaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] rawClasspath = iJavaProject.getRawClasspath();
            IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length];
            String jreContainerPrefix = "org.eclipse.jdt.launching.JRE_CONTAINER/";
            int cpt = 0;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                newRawClasspath[cpt] = iClasspathEntry.getPath() != null && iClasspathEntry.getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/") ? newContainerEntry : iClasspathEntry;
                ++cpt;
                ++n2;
            }
            iJavaProject.setRawClasspath(newRawClasspath, monitor);
            IWorkingSet[] workingSets = this.newProjectPage.getSelectedWorkingSets();
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    private String computeGeneratorName(String projectName) {
        String generatorName = projectName;
        if (generatorName.startsWith(MODULE_NAME_PREFIX)) {
            generatorName = generatorName.substring(MODULE_NAME_PREFIX.length());
        } else {
            int i = generatorName.lastIndexOf(46);
            if (i > -1) {
                generatorName = generatorName.substring(i + 1);
            }
        }
        if (generatorName.length() > 0) {
            StringTokenizer st = new StringTokenizer(generatorName, ".");
            generatorName = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                generatorName = String.valueOf(generatorName) + Character.toUpperCase(token.charAt(0)) + token.substring(1);
            }
        }
        return generatorName;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }
}

