/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.debug.core.ITemplateDebugger;
import org.eclipse.acceleo.internal.ide.ui.debug.core.ITemplateDebuggerListener;
import org.eclipse.acceleo.internal.ide.ui.debug.core.StackInfo;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoDebugger
implements IDebugAST,
ITemplateDebugger {
    private int state = 0;
    private boolean stepInto = true;
    private boolean stepOver = true;
    private boolean stepReturn = true;
    private boolean terminated;
    private Set<ASTFragment> breakpointsASTFragments = new CompactHashSet();
    private Map<ASTFragment, FileRegion> allASTFragments = new HashMap<ASTFragment, FileRegion>();
    private Set<ITemplateDebuggerListener> listeners = new CompactHashSet();
    private Stack<StackInfo> stackDebugger = new Stack();
    private int stackDebuggerSize;

    public AcceleoDebugger(IProject project) {
        this.init(project);
    }

    private void init(IProject project) {
        Map<File, Module> mtlFiles = this.getInputOutputAcceleoFiles(project);
        this.breakpointsASTFragments.clear();
        this.allASTFragments.clear();
        CompactHashSet conflicts = new CompactHashSet();
        for (Map.Entry<File, Module> entry : mtlFiles.entrySet()) {
            File file = entry.getKey();
            StringBuffer buffer = FileContent.getFileContent((File)file);
            Module eModule = entry.getValue();
            TreeIterator eAllContents = eModule.eAllContents();
            while (eAllContents.hasNext()) {
                ASTFragment fragment;
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof ASTNode) || conflicts.contains(fragment = new ASTFragment((ASTNode)eObject))) continue;
                conflicts.add(fragment);
                int start = ((ASTNode)eObject).getStartPosition();
                int end = ((ASTNode)eObject).getEndPosition();
                int line = this.lineNumber(buffer, start);
                if (start <= -1) continue;
                FileRegion region = new FileRegion();
                region.file = file;
                region.line = line;
                region.start = start;
                region.end = end;
                this.allASTFragments.put(fragment, region);
            }
        }
        this.state = 0;
        this.stepInto = false;
        this.stepOver = false;
        this.stepReturn = false;
        this.terminated = false;
        this.stackDebugger.clear();
    }

    private Map<File, Module> getInputOutputAcceleoFiles(IProject project) {
        HashMap<File, Module> result = new HashMap<File, Module>();
        for (AcceleoProject acceleoProject : new AcceleoProject(project).getRecursivelyAccessibleAcceleoProjects()) {
            try {
                List<IFile> mtlFiles = acceleoProject.getInputFiles();
                for (IFile mtlFile : mtlFiles) {
                    IPath outputFilePath = acceleoProject.getOutputFilePath(mtlFile);
                    if (outputFilePath == null) continue;
                    URI outputFileURI = URI.createPlatformResourceURI((String)outputFilePath.toString(), (boolean)false);
                    try {
                        EObject root = AcceleoUIResourceSet.getResource(outputFileURI);
                        if (!(root instanceof Module)) continue;
                        result.put(mtlFile.getLocation().toFile(), (Module)root);
                    }
                    catch (IOException e1) {
                        AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e1.getMessage(), (Throwable)e1));
                    }
                }
            }
            catch (CoreException e2) {
                AcceleoUIActivator.getDefault().getLog().log(e2.getStatus());
            }
        }
        return result;
    }

    public void startDebug(ASTFragment astFragment) {
        this.pushStack(astFragment);
    }

    public void stepDebugInput(ASTFragment astFragment, Map<String, Object> variables) {
        if (this.isBreakpoint(astFragment, false)) {
            this.waitForEvent(variables);
        } else {
            this.updateVariables(variables);
        }
    }

    public void updateVariables(Map<String, Object> variables) {
        if (variables != null && !this.stackDebugger.isEmpty()) {
            StackInfo stackInfo = this.stackDebugger.peek();
            for (String name : variables.keySet()) {
                Object value = variables.get(name);
                stackInfo.addVariable(name, value);
            }
        }
    }

    public void stepDebugOutput(ASTFragment astFragment, Object input, Object output) {
        if (astFragment != null && this.isBreakpoint(astFragment, true)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("output", output);
        }
    }

    public void endDebug(ASTFragment astFragment) {
        this.popStack(astFragment);
    }

    private int lineNumber(StringBuffer buffer, int index) {
        if (buffer != null && index < buffer.length()) {
            int line = 1;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') {
                    ++line;
                }
                --i;
            }
            return line;
        }
        return 0;
    }

    @Override
    public void addBreakpoint(ASTFragment astFragment) {
        if (!astFragment.isEmpty()) {
            this.breakpointsASTFragments.add(astFragment);
        }
    }

    @Override
    public void removeBreakpoint(ASTFragment astFragment) {
        if (!astFragment.isEmpty()) {
            this.breakpointsASTFragments.remove(astFragment);
        }
    }

    @Override
    public void addListener(ITemplateDebuggerListener aListener) {
        this.listeners.add(aListener);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void removeListener(ITemplateDebuggerListener aListener) {
        this.listeners.remove(aListener);
    }

    @Override
    public void resume() {
        this.stepInto = false;
        this.stepOver = false;
        this.stepReturn = false;
        this.state = 0;
    }

    @Override
    public void stepInto() {
        this.stepInto = true;
        this.stepOver = false;
        this.stepReturn = false;
        this.state = 0;
    }

    @Override
    public void stepOver() {
        this.stepInto = false;
        this.stepOver = true;
        this.stepReturn = false;
        this.state = 0;
        this.stackDebuggerSize = this.stackDebugger.size();
    }

    @Override
    public void stepReturn() {
        this.stepInto = false;
        this.stepOver = false;
        this.stepReturn = true;
        this.state = 0;
        this.stackDebuggerSize = this.stackDebugger.size();
    }

    @Override
    public void suspend() {
        this.stepInto = false;
        this.stepOver = false;
        this.stepReturn = false;
        this.state = 1;
    }

    @Override
    public void start() {
        this.fireStartEvent();
    }

    @Override
    public void end() {
        this.fireEndEvent();
    }

    private boolean isBreakpoint(ASTFragment astFragment, boolean isOutputStep) {
        if (this.terminated) {
            return false;
        }
        boolean ret = false;
        if (this.stepInto) {
            ret = true;
        } else if (this.stepOver) {
            if (this.stackDebugger.size() <= this.stackDebuggerSize) {
                ret = true;
                this.stackDebuggerSize = this.stackDebugger.size();
            } else {
                ret = false;
            }
        } else if (this.stepReturn) {
            if (this.stackDebugger.size() < this.stackDebuggerSize) {
                ret = true;
                this.stackDebuggerSize = this.stackDebugger.size();
            } else {
                ret = false;
            }
        } else {
            ret = astFragment.isEmpty() || isOutputStep ? false : this.breakpointsASTFragments.contains(astFragment);
        }
        if (ret) {
            this.state = 1;
        }
        return ret;
    }

    private void fireSuspendedBreakpointEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.suspendBreakpoint();
        }
    }

    private void fireResumedClientEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.resumeClient();
        }
    }

    private void fireResumedStepEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.resumeStep();
        }
    }

    private void fireSuspendedStepEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.suspendStep();
        }
    }

    private void fireStartEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.start();
        }
    }

    private void fireEndEvent() {
        for (ITemplateDebuggerListener debugListener : this.listeners) {
            debugListener.end();
        }
    }

    public void waitForEvent(Map<String, Object> variables) {
        if (this.state == 1 && !this.stackDebugger.isEmpty()) {
            if (variables != null) {
                StackInfo stackInfo = this.stackDebugger.peek();
                for (String name : variables.keySet()) {
                    Object value = variables.get(name);
                    stackInfo.addVariable(name, value);
                }
            }
            if (this.stepInto || this.stepOver || this.stepReturn) {
                this.fireSuspendedStepEvent();
            } else {
                this.fireSuspendedBreakpointEvent();
            }
            while (this.state == 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException stackInfo) {
                    // empty catch block
                }
            }
            if (this.stepInto || this.stepOver || this.stepReturn) {
                this.fireResumedClientEvent();
            } else {
                this.fireResumedClientEvent();
                this.fireResumedStepEvent();
            }
            try {
                int sleep = 300;
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public StackInfo[] getStack() {
        StackInfo[] ret = new StackInfo[this.stackDebugger.size()];
        int i = 0;
        Iterator iterator = this.stackDebugger.iterator();
        while (iterator.hasNext()) {
            StackInfo current;
            ret[i] = current = (StackInfo)iterator.next();
            ++i;
        }
        return ret;
    }

    @Override
    public void popStack(ASTFragment astFragment) {
        FileRegion fileRegion = this.allASTFragments.get(astFragment);
        if (fileRegion != null) {
            this.stackDebugger.pop();
        }
    }

    @Override
    public void pushStack(ASTFragment astFragment) {
        FileRegion fileRegion = this.allASTFragments.get(astFragment);
        if (fileRegion != null) {
            StackInfo stackInfo = new StackInfo();
            stackInfo.setNode(astFragment.getASTNode());
            stackInfo.setFile(fileRegion.file);
            stackInfo.setLine(fileRegion.line);
            stackInfo.setCharStart(fileRegion.start);
            stackInfo.setCharEnd(fileRegion.end);
            this.stackDebugger.push(stackInfo);
        }
    }

    @Override
    public void terminate() {
        this.terminated = true;
        this.state = 0;
    }

    private final class FileRegion {
        File file;
        int line;
        int start;
        int end;
    }
}

