/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPom;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;

public class CreatePomCommandHandler
extends AbstractHandler {
    private boolean enabled;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EvaluationContext context;
        Object defaultVariable;
        Object applicationContext = event.getApplicationContext();
        if (applicationContext instanceof EvaluationContext && (defaultVariable = (context = (EvaluationContext)applicationContext).getDefaultVariable()) instanceof List) {
            List variables = (List)defaultVariable;
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (Object object : variables) {
                if (object instanceof IProject) {
                    IProject project = (IProject)object;
                    projects.add(project);
                    continue;
                }
                if (object instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)object;
                    projects.add(javaProject.getProject());
                    continue;
                }
                if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
            }
            for (IProject iProject : projects) {
                try {
                    if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
                    this.generatePom(iProject);
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        return applicationContext;
    }

    private void generatePom(IProject project) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        String lr = System.getProperty("line.separator");
        AcceleoPom acceleoPom = AcceleowizardmodelFactory.eINSTANCE.createAcceleoPom();
        acceleoPom.setArtifactId(project.getName());
        IProject featureProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".feature");
        if (!featureProject.exists()) {
            IProject parentProject;
            try {
                featureProject.create((IProgressMonitor)monitor);
                featureProject.open((IProgressMonitor)monitor);
                IProjectDescription description = featureProject.getDescription();
                String[] oldNatureIds = description.getNatureIds();
                String[] newNatureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                newNatureIds[oldNatureIds.length] = "org.eclipse.pde.FeatureNature";
                description.setNatureIds(newNatureIds);
                featureProject.setDescription(description, (IProgressMonitor)monitor);
                IFile buildProperties = featureProject.getFile("build.properties");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(("bin.includes = feature.xml" + lr).getBytes());
                buildProperties.create((InputStream)inputStream, true, (IProgressMonitor)monitor);
                IFile featureXML = featureProject.getFile("feature.xml");
                StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lr);
                buffer.append("<feature" + lr);
                buffer.append("      id=\"" + project.getName() + ".feature\"" + lr);
                buffer.append("      label=\"Feature\"" + lr);
                buffer.append("      version=\"1.0.0.qualifier\">" + lr);
                buffer.append(lr);
                buffer.append("   <description url=\"http://www.example.com/description\">" + lr);
                buffer.append("      [Enter Feature Description here.]" + lr);
                buffer.append("   </description>" + lr);
                buffer.append(lr);
                buffer.append("   <copyright url=\"http://www.example.com/copyright\">" + lr);
                buffer.append("      [Enter Copyright Description here.]" + lr);
                buffer.append("   </copyright>" + lr);
                buffer.append(lr);
                buffer.append("   <license url=\"http://www.example.com/license\">" + lr);
                buffer.append("      [Enter License Description here.]" + lr);
                buffer.append("   </license>" + lr);
                buffer.append(lr);
                buffer.append("   <plugin" + lr);
                buffer.append("         id=\"" + project.getName() + "\"" + lr);
                buffer.append("         download-size=\"0\"" + lr);
                buffer.append("         install-size=\"0\"" + lr);
                buffer.append("         version=\"0.0.0\"" + lr);
                buffer.append("         unpack=\"false\"/>" + lr);
                buffer.append(lr);
                buffer.append("</feature>" + lr);
                inputStream = new ByteArrayInputStream(buffer.toString().getBytes());
                featureXML.create((InputStream)inputStream, true, (IProgressMonitor)monitor);
                AcceleoUIGenerator.getDefault().generatePomFeature(acceleoPom, (IContainer)featureProject, String.valueOf(project.getName()) + ".parent");
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
            IProject updateSiteProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".updatesite");
            if (!updateSiteProject.exists()) {
                try {
                    updateSiteProject.create((IProgressMonitor)monitor);
                    updateSiteProject.open((IProgressMonitor)monitor);
                    IProjectDescription description = updateSiteProject.getDescription();
                    String[] oldNatureIds = description.getNatureIds();
                    String[] newNatureIds = new String[oldNatureIds.length + 1];
                    System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                    newNatureIds[oldNatureIds.length] = "org.eclipse.pde.UpdateSiteNature";
                    description.setNatureIds(newNatureIds);
                    updateSiteProject.setDescription(description, (IProgressMonitor)monitor);
                    IFile categoryXML = updateSiteProject.getFile("category.xml");
                    StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lr);
                    buffer.append("<site>" + lr);
                    buffer.append("   <feature url=\"features/" + project.getName() + ".feature_1.0.0.qualifier.jar\" id=\"" + project.getName() + ".feature\" version=\"1.0.0.qualifier\">" + lr);
                    buffer.append("      <category name=\"" + project.getName() + ".category.id\"/>" + lr);
                    buffer.append("   </feature>" + lr);
                    buffer.append("   <category-def name=\"" + project.getName() + ".category.id\" label=\"Acceleo\"/>" + lr);
                    buffer.append("</site>" + lr);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.toString().getBytes());
                    categoryXML.create((InputStream)inputStream, true, (IProgressMonitor)monitor);
                    IFile siteXML = updateSiteProject.getFile("site.xml");
                    buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lr);
                    buffer.append("<site>" + lr);
                    buffer.append("</site>" + lr);
                    siteXML.create((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, (IProgressMonitor)monitor);
                    AcceleoUIGenerator.getDefault().generatePomUpdateSite(acceleoPom, (IContainer)updateSiteProject, String.valueOf(project.getName()) + ".parent");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
            if (!(parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".parent")).exists()) {
                try {
                    parentProject.create((IProgressMonitor)monitor);
                    parentProject.open((IProgressMonitor)monitor);
                    AcceleoUIGenerator.getDefault().generatePom(acceleoPom, (IContainer)parentProject, String.valueOf(project.getName()) + ".parent");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        AcceleoUIGenerator.getDefault().generatePomChild(acceleoPom, (IContainer)project, String.valueOf(project.getName()) + ".parent");
    }

    public void setEnabled(Object evaluationContext) {
        EvaluationContext context;
        Object defaultVariable;
        if (evaluationContext instanceof EvaluationContext && (defaultVariable = (context = (EvaluationContext)evaluationContext).getDefaultVariable()) instanceof List && ((List)defaultVariable).size() > 0) {
            List variables = (List)defaultVariable;
            for (Object object : variables) {
                try {
                    IProject project;
                    if (object instanceof IProject) {
                        project = (IProject)object;
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        project = ((IJavaProject)object).getProject();
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                    this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

