/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.Deque;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitorDecorator;
import org.eclipse.acceleo.engine.internal.evaluation.QueryCache;
import org.eclipse.acceleo.internal.traceability.AcceleoTraceabilityMessages;
import org.eclipse.acceleo.internal.traceability.AcceleoTraceabilityPlugin;
import org.eclipse.acceleo.internal.traceability.engine.AbstractTrace;
import org.eclipse.acceleo.internal.traceability.engine.AcceleoTraceabilityOperationVisitor;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.internal.traceability.engine.IterationTrace;
import org.eclipse.acceleo.internal.traceability.engine.QueryTraceCache;
import org.eclipse.acceleo.internal.traceability.engine.TraceabilityVisitorUtil;
import org.eclipse.acceleo.internal.traceability.engine.VariableTrace;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModelFile;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.ModuleFile;
import org.eclipse.acceleo.traceability.TraceabilityFactory;
import org.eclipse.acceleo.traceability.TraceabilityModel;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoTraceabilityVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static final int INITIAL_CACHE_SIZE = 128;
    private boolean addedTemplateScope;
    private Map<EObject, Set<InputElement>> cachedInputElements = new HashMap<EObject, Set<InputElement>>(128);
    private Map<EObject, ModuleElement> cachedModuleElements = new HashMap<EObject, ModuleElement>(128);
    private OCLExpression<C> currentExpression;
    private Deque<GeneratedFile> currentFiles = new CircularArrayDeque();
    private final Map<String, String> ecoreURLCache = new HashMap<String, String>();
    private boolean evaluatingIterationSet;
    private boolean evaluatingOperationCall;
    private boolean evaluatingPostCall;
    private final TraceabilityModel evaluationTrace;
    private org.eclipse.ocl.expressions.Variable<C, PM> initializingVariable;
    private Deque<ExpressionTrace<C>> invocationTraces;
    private OCLExpression<C> iterationBody;
    private Deque<Integer> iterationCount = new CircularArrayDeque();
    private Deque<IterationTrace<C, PM>> iterationTraces = new CircularArrayDeque();
    private int lastInvocationTracesLength;
    private ExpressionTrace<C> operationArgumentTrace;
    private Object operationCallSource;
    private OCLExpression<C> operationCallSourceExpression;
    private AcceleoTraceabilityOperationVisitor<C, PM> operationVisitor = new AcceleoTraceabilityOperationVisitor(this);
    private EObject propertyCallSource;
    private OCLExpression<C> propertyCallSourceExpression;
    private ModuleElement protectedAreaModuleElement;
    private InputElement protectedAreaSource;
    private QueryTraceCache<C> queryTraceCache = new QueryTraceCache();
    private boolean record = true;
    private final Deque<ExpressionTrace<C>> recordedTraces = new CircularArrayDeque(32);
    private Deque<EObject> scopeEObjects = new CircularArrayDeque();
    private final Map<org.eclipse.ocl.expressions.Variable<C, PM>, VariableTrace<C, PM>> variableTraces = new HashMap<org.eclipse.ocl.expressions.Variable<C, PM>, VariableTrace<C, PM>>();

    public AcceleoTraceabilityVisitor(AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, TraceabilityModel trace) {
        super(decoratedVisitor);
        this.evaluationTrace = trace;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        boolean considerTrace = true;
        considerTrace = considerTrace && string.length() > 0;
        considerTrace = considerTrace && this.currentFiles != null && !this.currentFiles.isEmpty();
        considerTrace = considerTrace && this.recordedTraces != null && !this.recordedTraces.isEmpty();
        Block rootSourceBlock = sourceBlock;
        if (!(rootSourceBlock instanceof Template)) {
            while (rootSourceBlock.eContainer() instanceof Block) {
                rootSourceBlock = (Block)rootSourceBlock.eContainer();
            }
        }
        boolean bl = considerTrace = considerTrace && (!(rootSourceBlock instanceof Template) || !this.evaluatingOperationCall);
        if (considerTrace && fireEvent) {
            GeneratedFile generatedFile = (GeneratedFile)this.currentFiles.getLast();
            boolean disposeTrace = !(sourceBlock instanceof IfBlock) && !(sourceBlock instanceof ForBlock);
            ExpressionTrace trace = disposeTrace ? (ExpressionTrace)this.recordedTraces.removeLast() : (ExpressionTrace)this.recordedTraces.getLast();
            if (trace.getReferredExpression() instanceof ProtectedAreaBlock && trace.getTraces().isEmpty()) {
                this.createProtectedAreaTrace(string, sourceBlock, trace);
            }
            int fileLength = generatedFile.getLength();
            int addedLength = 0;
            if (this.invocationTraces != null) {
                this.invocationTraces.remove((Object)trace);
                this.invocationTraces.add(new ExpressionTrace(trace));
            }
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                Iterator<GeneratedText> textIterator = entry.getValue().iterator();
                while (textIterator.hasNext()) {
                    GeneratedText text = textIterator.next();
                    textIterator.remove();
                    addedLength += text.getEndOffset() - text.getStartOffset();
                    text.setStartOffset(fileLength + text.getStartOffset());
                    text.setEndOffset(fileLength + text.getEndOffset());
                    generatedFile.getGeneratedRegions().add((Object)text);
                }
            }
            int stringLength = string.length();
            if (addedLength != stringLength && this.lastInvocationTracesLength != stringLength && !(sourceBlock instanceof ProtectedAreaBlock)) {
                generatedFile.setLength(fileLength + stringLength);
                addedLength = stringLength;
            } else {
                generatedFile.setLength(fileLength + addedLength);
            }
            this.lastInvocationTracesLength = this.invocationTraces != null ? (this.lastInvocationTracesLength += addedLength) : 0;
            if (disposeTrace) {
                trace.dispose();
            } else {
                trace.setOffset(0);
            }
        } else if (considerTrace && this.invocationTraces != null && !this.isProtectedAreaContent((EObject)sourceBlock) && this.invocationTraces.contains(this.recordedTraces.getLast())) {
            int fileLength = ((GeneratedFile)this.currentFiles.getLast()).getLength();
            ExpressionTrace trace = (ExpressionTrace)this.recordedTraces.removeLast();
            this.invocationTraces.remove((Object)trace);
            this.invocationTraces.add(new ExpressionTrace(trace));
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                for (GeneratedText text : entry.getValue()) {
                    text.setStartOffset(fileLength + text.getStartOffset());
                    text.setEndOffset(fileLength + text.getEndOffset());
                }
            }
            trace.dispose();
        }
        super.append(string, sourceBlock, source, fireEvent);
    }

    public void cacheResult(Query query, List<Object> arguments, Object result) {
        this.queryTraceCache.cacheTrace(query, arguments, new ExpressionTrace((ExpressionTrace)this.recordedTraces.getLast()));
        super.cacheResult(query, arguments, result);
    }

    public void createFileWriter(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        boolean fileExisted = generatedFile.exists();
        GeneratedFile file = this.getGeneratedFile(generatedFile, appendMode);
        file.setCharset(charset);
        file.setFileBlock(this.getModuleElement((EObject)fileBlock));
        this.currentFiles.add((Object)file);
        ExpressionTrace traceContext = (ExpressionTrace)this.recordedTraces.removeLast();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : traceContext.getTraces().entrySet()) {
            file.getSourceElements().add((Object)entry.getKey());
            file.getNameRegions().addAll((Collection)entry.getValue());
        }
        traceContext.dispose();
        if (appendMode && fileExisted) {
            file.setLength(file.getLength() + 1);
        }
        super.createFileWriter(generatedFile, fileBlock, source, appendMode, charset);
    }

    public String fitIndentationTo(String source, String indentation) {
        if ("".equals(indentation)) {
            return source;
        }
        String regex = "\r\n|\r|\n";
        String replacement = "$0" + indentation;
        EObject scopeEObject = this.retrieveScopeEObjectValue();
        InputElement input = this.getInputElement(scopeEObject);
        if (this.protectedAreaSource != null) {
            input = this.protectedAreaSource;
        }
        GeneratedText text = this.createGeneratedTextFor((EObject)this.currentExpression);
        text.setEndOffset(indentation.length());
        ExpressionTrace<C> indentationTrace = new ExpressionTrace<C>(this.currentExpression);
        indentationTrace.addTrace(input, text, indentation);
        String result = this.operationVisitor.visitReplaceOperation(source, regex, replacement, indentationTrace, true, true);
        indentationTrace.dispose();
        return result;
    }

    public Object getCachedResult(Query query, List<Object> arguments) {
        ExpressionTrace<C> cachedTraces = this.queryTraceCache.getCachedTrace(query, arguments);
        if (cachedTraces != null) {
            this.recordedTraces.removeLast();
            this.recordedTraces.add(new ExpressionTrace<C>(cachedTraces));
            return super.getCachedResult(query, arguments);
        }
        return QueryCache.NO_CACHED_RESULT;
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        Deque<ExpressionTrace<C>> oldInvocationTraces = this.invocationTraces;
        this.invocationTraces = null;
        super.visitAcceleoFileBlock(fileBlock);
        this.invocationTraces = oldInvocationTraces;
        GeneratedFile file = (GeneratedFile)this.currentFiles.removeLast();
        ArrayList regions = new ArrayList(file.getGeneratedRegions());
        Collections.sort(regions);
        int offset = 0;
        boolean hasProblems = false;
        for (GeneratedText region : regions) {
            if (region.getStartOffset() != offset) {
                hasProblems = true;
            }
            offset += region.getEndOffset() - region.getStartOffset();
            if (hasProblems) break;
        }
        if (hasProblems && AcceleoPreferences.isDebugMessagesEnabled()) {
            AcceleoEnginePlugin.log((String)("Traceability problems with file " + file.getName()), (boolean)false);
        }
        if (!this.recordedTraces.isEmpty() && ((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression() == fileBlock && ((ExpressionTrace)this.recordedTraces.getLast()).getTraces().isEmpty()) {
            ((ExpressionTrace)this.recordedTraces.removeLast()).dispose();
        }
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        if (forBlock.getLoopVariable() != null) {
            this.scopeEObjects.add((Object)forBlock.getLoopVariable());
        }
        this.iterationTraces.add(new IterationTrace(forBlock.getLoopVariable(), forBlock.getIterSet()));
        OCLExpression<C> oldIterationBody = this.iterationBody;
        if (!forBlock.getBody().isEmpty()) {
            this.iterationBody = (OCLExpression)forBlock.getBody().get(forBlock.getBody().size() - 1);
        }
        this.iterationCount.add((Object)0);
        try {
            super.visitAcceleoForBlock(forBlock);
        }
        finally {
            ((IterationTrace)this.iterationTraces.removeLast()).dispose();
            this.iterationBody = oldIterationBody;
            this.iterationCount.removeLast();
        }
        if (forBlock.getLoopVariable() != null) {
            this.scopeEObjects.removeLast();
        }
        if (!this.recordedTraces.isEmpty() && ((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression() == forBlock && ((ExpressionTrace)this.recordedTraces.getLast()).getTraces().isEmpty()) {
            this.recordedTraces.removeLast();
        }
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        super.visitAcceleoIfBlock(ifBlock);
        if (!this.recordedTraces.isEmpty() && ((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression() == ifBlock && ((ExpressionTrace)this.recordedTraces.getLast()).getTraces().isEmpty()) {
            this.recordedTraces.removeLast();
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        this.protectedAreaSource = this.getInputElement(this.retrieveScopeEObjectValue());
        this.protectedAreaModuleElement = this.getModuleElement((EObject)protectedArea);
        super.visitAcceleoProtectedArea(protectedArea);
        this.protectedAreaModuleElement = null;
        this.protectedAreaSource = null;
    }

    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        if (invocation.getDefinition().getParameter().size() > 0) {
            this.scopeEObjects.add((Object)((EObject)invocation.getDefinition().getParameter().get(0)));
        }
        org.eclipse.ocl.ecore.OCLExpression expression = invocation.getDefinition().getExpression();
        if (!this.isInitializingVariable()) {
            this.recordedTraces.add(new ExpressionTrace(expression));
        }
        Object result = super.visitAcceleoQueryInvocation(invocation);
        if (!this.isInitializingVariable()) {
            AbstractTrace queryTrace = (AbstractTrace)this.recordedTraces.removeLast();
            if (!this.iterationTraces.isEmpty() && EcoreUtil.isAncestor(((IterationTrace)this.iterationTraces.getLast()).getReferredExpression(), (EObject)invocation)) {
                ((IterationTrace)this.iterationTraces.getLast()).addTraceCopy(queryTrace);
            } else {
                ExpressionTrace currentTrace = (ExpressionTrace)this.recordedTraces.getLast();
                currentTrace.addTraceCopy(queryTrace);
            }
            queryTrace.dispose();
        }
        if (invocation.getDefinition().getParameter().size() > 0) {
            this.scopeEObjects.removeLast();
        }
        if (this.isPropertyCallSource((OCLExpression<C>)invocation)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)invocation)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        if (template.getParameter().size() > 0) {
            this.scopeEObjects.add((Object)((EObject)template.getParameter().get(0)));
            this.addedTemplateScope = true;
        }
        return super.visitAcceleoTemplate(template);
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        block8: {
            oldTraces = this.invocationTraces;
            oldTemplateHadScope = this.addedTemplateScope;
            this.addedTemplateScope = false;
            this.invocationTraces = new CircularArrayDeque();
            result = null;
            oldRecordState = this.switchRecordState((OCLExpression<C>)invocation);
            try {
                result = super.visitAcceleoTemplateInvocation(invocation);
            }
            finally {
                this.record = oldRecordState;
                if (oldTraces == null || this.invocationTraces == null) break block8;
                ** for (trace : this.invocationTraces)
            }
lbl-1000:
            // 1 sources

            {
                if (oldTraces.contains((Object)trace)) continue;
                oldTraces.add((Object)trace);
                continue;
            }
        }
        this.invocationTraces = oldTraces;
        if (this.addedTemplateScope) {
            this.scopeEObjects.removeLast();
        }
        this.addedTemplateScope = oldTemplateHadScope;
        if (this.isPropertyCallSource((OCLExpression<C>)invocation)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)invocation)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp<C, P> callExp) {
        Object result = super.visitAssociationClassCallExp(callExp);
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp<C> literalExp) {
        Object result = super.visitBooleanLiteralExp(literalExp);
        this.recordLiteral((OCLExpression<C>)literalExp, result);
        return result;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<C> literalExp) {
        Object result = super.visitCollectionLiteralExp(literalExp);
        if (this.isPropertyCallSource((OCLExpression<C>)literalExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)literalExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<C, EL> literalExp) {
        Object result = super.visitEnumLiteralExp(literalExp);
        this.recordLiteral((OCLExpression<C>)literalExp, result);
        if (this.isPropertyCallSource((OCLExpression<C>)literalExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)literalExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitExpression(OCLExpression<C> expression) {
        ExpressionTrace trace;
        boolean isOperationArgumentTrace;
        Object value;
        boolean isEvaluatingMainTemplateGuard;
        OCLExpression<C> oldExpression = this.currentExpression;
        this.currentExpression = expression;
        boolean bl = isEvaluatingMainTemplateGuard = this.scopeEObjects.isEmpty() && expression != null && expression.eContainer() instanceof Template && expression.eContainingFeature() == MtlPackage.eINSTANCE.getTemplate_Guard();
        if (isEvaluatingMainTemplateGuard) {
            for (Variable var : ((Template)expression.eContainer()).getParameter()) {
                value = this.getEvaluationEnvironment().getValueOf(var.getName());
                if (!(value instanceof EObject)) continue;
                this.scopeEObjects.add((Object)((EObject)value));
                break;
            }
        }
        if (this.scopeEObjects.isEmpty() && expression instanceof Template) {
            for (Variable var : ((Template)expression).getParameter()) {
                value = this.getEvaluationEnvironment().getValueOf(var.getName());
                if (!(value instanceof EObject)) continue;
                this.scopeEObjects.add((Object)((EObject)value));
                break;
            }
        }
        boolean oldRecordingValue = this.switchRecordState(expression);
        boolean oldIterSet = this.evaluatingIterationSet;
        this.evaluatingIterationSet = expression.eContainingFeature() == MtlPackage.eINSTANCE.getForBlock_IterSet();
        boolean oldEvaluatingPostCall = this.evaluatingPostCall;
        this.evaluatingPostCall = this.evaluatingPostCall || expression.eContainingFeature() == MtlPackage.eINSTANCE.getTemplate_Post();
        EReference containingFeature = (EReference)expression.eContainingFeature();
        boolean bl2 = isOperationArgumentTrace = this.evaluatingOperationCall && this.shouldRecordOperationTrace(expression);
        if (isOperationArgumentTrace || !this.evaluatingOperationCall && this.shouldRecordTrace(containingFeature)) {
            trace = new ExpressionTrace(expression);
            this.recordedTraces.add(trace);
            if (this.invocationTraces != null) {
                this.invocationTraces.add((Object)trace);
            }
        } else if (this.shouldRecordTrace(containingFeature) && this.invocationTraces != null && !this.invocationTraces.contains((Object)(trace = (ExpressionTrace)this.recordedTraces.getLast()))) {
            this.invocationTraces.add((Object)trace);
        }
        Object result = null;
        try {
            try {
                result = this.iterationBody == expression && expression.eContainingFeature() != MtlPackage.eINSTANCE.getBlock_Body() ? this.visitIteratorBody(expression) : this.getDelegate().visitExpression(expression);
            }
            catch (AcceleoEvaluationCancelledException e) {
                this.cancel();
                throw e;
            }
        }
        finally {
            this.record = oldRecordingValue;
            this.evaluatingIterationSet = oldIterSet;
            this.evaluatingPostCall = oldEvaluatingPostCall;
            if (isOperationArgumentTrace) {
                ExpressionTrace argTrace = (ExpressionTrace)this.recordedTraces.removeLast();
                ((ExpressionTrace)this.recordedTraces.getLast()).addTraceCopy(argTrace);
                if (!(this.invocationTraces == null || expression instanceof OperationCallExp && this.invocationTraces.size() <= 1)) {
                    this.invocationTraces.removeLast();
                    argTrace.dispose();
                }
            }
            if (this.iterationBody == expression && expression.eContainingFeature() == MtlPackage.eINSTANCE.getBlock_Body()) {
                Integer current = (Integer)this.iterationCount.removeLast();
                this.iterationCount.add((Object)(current + 1));
            }
            if (expression.eContainingFeature() == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker() && ((ExpressionTrace)this.recordedTraces.get(this.recordedTraces.size() - 2)).getReferredExpression() instanceof ProtectedAreaBlock) {
                ExpressionTrace firstMarkerTrace = (ExpressionTrace)this.recordedTraces.removeLast();
                if (this.invocationTraces != null) {
                    this.invocationTraces.remove((Object)firstMarkerTrace);
                }
                firstMarkerTrace.dispose();
            }
        }
        if (this.isPropertyCallSource(expression)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource(expression)) {
            this.operationCallSource = result;
        }
        if (expression.eContainingFeature() == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker() && ((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression() == expression) {
            ExpressionTrace trace2 = (ExpressionTrace)this.recordedTraces.getLast();
            int gap = -1;
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace2.getTraces().entrySet()) {
                for (GeneratedText text : entry.getValue()) {
                    if (gap != -1 && text.getStartOffset() >= gap) continue;
                    gap = text.getStartOffset();
                }
            }
            this.operationVisitor.visitTrimOperation((String)result, gap);
        }
        this.currentExpression = oldExpression;
        return result;
    }

    public Object visitIfExp(IfExp<C> ifExp) {
        Object result = super.visitIfExp(ifExp);
        if (this.isPropertyCallSource((OCLExpression<C>)ifExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)ifExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp<C> literalExp) {
        Object result = super.visitIntegerLiteralExp(literalExp);
        this.recordLiteral((OCLExpression<C>)literalExp, result);
        return result;
    }

    public Object visitIterateExp(IterateExp<C, PM> callExp) {
        this.scopeEObjects.add((Object)((EObject)callExp.getIterator().get(0)));
        Object result = super.visitIterateExp(callExp);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Object visitIteratorBody(OCLExpression<C> iteratorBody) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object visitIteratorExp(IteratorExp<C, PM> callExp) {
        boolean oldOperationEvaluationState = this.evaluatingOperationCall;
        this.evaluatingOperationCall = true;
        this.scopeEObjects.add((Object)((EObject)callExp.getIterator().get(0)));
        this.iterationTraces.add(new IterationTrace((org.eclipse.ocl.expressions.Variable)callExp.getIterator().get(0), callExp.getSource()));
        OCLExpression<C> oldIterationBody = this.iterationBody;
        this.iterationBody = callExp.getBody();
        this.iterationCount.add((Object)0);
        this.recordedTraces.add(new ExpressionTrace(callExp));
        Object result = null;
        try {
            result = super.visitIteratorExp(callExp);
        }
        finally {
            this.evaluatingOperationCall = oldOperationEvaluationState;
            ExpressionTrace traces = (ExpressionTrace)this.recordedTraces.removeLast();
            IterationTrace iterTrace = (IterationTrace)this.iterationTraces.removeLast();
            if (!(this.iterationTraces.isEmpty() || ((IterationTrace)this.iterationTraces.getLast()).getReferredExpression() != callExp && ((IterationTrace)this.iterationTraces.getLast()).getReferredExpression() != callExp.eContainer())) {
                ((IterationTrace)this.iterationTraces.getLast()).addTraceCopy(traces);
            } else {
                ((ExpressionTrace)this.recordedTraces.getLast()).addTraceCopy(traces);
            }
            traces.dispose();
            iterTrace.dispose();
            this.iterationBody = oldIterationBody;
            this.iterationCount.removeLast();
        }
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitLetExp(LetExp<C, PM> letExp) {
        this.scopeEObjects.add((Object)letExp.getVariable());
        Object result = super.visitLetExp(letExp);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)letExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)letExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        Object result;
        OCLExpression<C> oldOperationCallSourceExpression = this.operationCallSourceExpression;
        this.operationCallSourceExpression = callExp.getSource();
        boolean oldOperationEvaluationState = this.evaluatingOperationCall;
        boolean oldRecordingValue = this.switchRecordState((OCLExpression<C>)callExp);
        this.evaluatingOperationCall = true;
        boolean isGuard = callExp.eContainingFeature().getFeatureID() == 19;
        isGuard = isGuard && callExp.eContainer() instanceof Template;
        try {
            if (this.record && !isGuard && this.isTraceabilityImpactingOperation(callExp)) {
                if (this.isBooleanReturningOperation(callExp)) {
                    result = super.visitOperationCallExp(callExp);
                    ModuleElement moduleElement = this.getModuleElement((EObject)callExp);
                    Object source = this.operationCallSource;
                    if (source instanceof Collection || source == null) {
                        source = this.retrieveScopeEObjectValue();
                    }
                    this.operationVisitor.changeTraceabilityIndicesBooleanReturn((Boolean)result, source, moduleElement);
                } else if (this.isNumberReturningOperation(callExp)) {
                    result = super.visitOperationCallExp(callExp);
                    ModuleElement moduleElement = this.getModuleElement((EObject)callExp);
                    Object source = this.operationCallSource;
                    if (source instanceof Collection || source == null) {
                        source = this.retrieveScopeEObjectValue();
                    }
                    this.operationVisitor.changeTraceabilityIndicesNumberReturn((Number)result, source, moduleElement);
                } else {
                    result = this.internalVisitOperationCallExp(callExp);
                }
            } else {
                boolean isGetProperty = "getProperty".equals(((EOperation)callExp.getReferredOperation()).getName());
                boolean oldRecord = this.record;
                if (isGetProperty) {
                    this.record = false;
                }
                result = super.visitOperationCallExp(callExp);
                if (isGetProperty) {
                    this.record = oldRecord;
                }
                if (this.record && !isGuard && isGetProperty) {
                    this.recordLiteral((OCLExpression<C>)callExp, result);
                }
            }
        }
        finally {
            this.record = oldRecordingValue;
            this.evaluatingOperationCall = oldOperationEvaluationState;
        }
        if (result == null && AcceleoPreferences.isDebugMessagesEnabled()) {
            AcceleoTraceabilityPlugin.log(AcceleoTraceabilityMessages.getString("AcceleoTraceabilityVisitor.NullEvaluation", callExp.toString()), false);
        }
        this.operationCallSource = null;
        this.operationCallSourceExpression = oldOperationCallSourceExpression;
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        OCLExpression<C> oldPropertyCallSourceExpression = this.propertyCallSourceExpression;
        this.propertyCallSourceExpression = callExp.getSource();
        Object result = null;
        boolean oldRecordingValue = this.switchRecordState((OCLExpression<C>)callExp);
        try {
            result = this.getDelegate().visitPropertyCallExp(callExp);
        }
        finally {
            if (this.propertyCallSource != null && result != null && TraceabilityVisitorUtil.isPrimitive(result)) {
                InputElement propertyCallInput = this.getInputElement(this.propertyCallSource, (EStructuralFeature)callExp.getReferredProperty());
                this.propertyCallSource = null;
                if (this.protectedAreaSource != null) {
                    propertyCallInput = this.protectedAreaSource;
                }
                if (this.operationArgumentTrace != null) {
                    GeneratedText text = this.createGeneratedTextFor((EObject)callExp);
                    this.operationArgumentTrace.addTrace(propertyCallInput, text, result);
                } else if (this.isInitializingVariable()) {
                    GeneratedText text = this.createGeneratedTextFor((EObject)callExp);
                    this.variableTraces.get(this.initializingVariable).addTrace(propertyCallInput, text, result);
                } else if (this.record && !this.recordedTraces.isEmpty() && this.shouldRecordTrace((OCLExpression<C>)callExp)) {
                    GeneratedText text = this.createGeneratedTextFor((EObject)callExp);
                    ((ExpressionTrace)this.recordedTraces.getLast()).addTrace(propertyCallInput, text, result);
                } else if (!this.iterationTraces.isEmpty() && this.shouldRecordTrace((OCLExpression<C>)callExp)) {
                    GeneratedText text = this.createGeneratedTextFor((EObject)callExp);
                    ((IterationTrace)this.iterationTraces.getLast()).addTrace(propertyCallInput, text, result);
                }
            }
            this.propertyCallSourceExpression = oldPropertyCallSourceExpression;
            this.record = oldRecordingValue;
        }
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitRealLiteralExp(RealLiteralExp<C> literalExp) {
        Object result = super.visitRealLiteralExp(literalExp);
        this.recordLiteral((OCLExpression<C>)literalExp, result);
        return result;
    }

    public Object visitStateExp(StateExp<C, S> stateExp) {
        Object result = super.visitStateExp(stateExp);
        if (this.isPropertyCallSource((OCLExpression<C>)stateExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)stateExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitStringLiteralExp(StringLiteralExp<C> literalExp) {
        Object result = super.visitStringLiteralExp(literalExp);
        this.recordLiteral((OCLExpression<C>)literalExp, result);
        return result;
    }

    public Object visitVariable(org.eclipse.ocl.expressions.Variable<C, PM> variable) {
        boolean isPrimitive = TraceabilityVisitorUtil.isPrimitive(variable.getType()) || TraceabilityVisitorUtil.isPrimitiveCollection((EClassifier)variable.getType());
        org.eclipse.ocl.expressions.Variable<C, PM> oldVar = null;
        if (isPrimitive) {
            this.variableTraces.put(variable, new VariableTrace<C, PM>(variable));
            oldVar = this.initializingVariable;
            this.initializingVariable = variable;
        }
        Object result = this.getDelegate().visitVariable(variable);
        if (this.scopeEObjects.getLast() == variable && result instanceof EObject) {
            this.scopeEObjects.removeLast();
            this.scopeEObjects.add((Object)((EObject)result));
        }
        if (isPrimitive) {
            this.initializingVariable = oldVar;
        }
        return result;
    }

    public Object visitVariableExp(VariableExp<C, PM> variableExp) {
        Object result = super.visitVariableExp(variableExp);
        boolean recordOperationArgument = this.operationArgumentTrace != null && result instanceof String;
        boolean recordVariableInitialization = this.isInitializingVariable() && this.shouldRecordTrace((OCLExpression<C>)variableExp) && (this.variableTraces.get(variableExp.getReferredVariable()) != null || this.initializingVariable.getInitExpression() == variableExp);
        boolean recordTrace = !this.isInitializingVariable() && !this.recordedTraces.isEmpty() && TraceabilityVisitorUtil.isPrimitive(result) && result.toString().length() > 0;
        VariableTrace<C, PM> referredVarTrace = this.variableTraces.get(variableExp.getReferredVariable());
        ListIterator iterator = this.iterationTraces.listIterator(this.iterationTraces.size());
        boolean isSelf = "self".equals(variableExp.getReferredVariable().getName());
        boolean tracesFound = false;
        while (!tracesFound && iterator.hasPrevious()) {
            IterationTrace trace = (IterationTrace)iterator.previous();
            if (!isSelf && variableExp.getReferredVariable() != trace.getVariable()) continue;
            tracesFound = true;
            if (trace.getLastIteration() != ((Integer)this.iterationCount.getLast()).intValue()) {
                trace.advanceIteration(result.toString());
            }
            referredVarTrace = new VariableTrace(variableExp.getReferredVariable());
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTracesForIteration().entrySet()) {
                referredVarTrace.getTraces().put(entry.getKey(), entry.getValue());
            }
        }
        if (recordVariableInitialization || this.record && recordTrace || recordOperationArgument) {
            if (referredVarTrace != null) {
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : referredVarTrace.getTraces().entrySet()) {
                    InputElement input = entry.getKey();
                    if (this.protectedAreaSource != null) {
                        input = this.protectedAreaSource;
                    }
                    for (GeneratedText text : entry.getValue()) {
                        GeneratedText copy = (GeneratedText)EcoreUtil.copy((EObject)text);
                        int regionLength = copy.getEndOffset() - copy.getStartOffset();
                        if (recordOperationArgument) {
                            this.operationArgumentTrace.addTrace(input, copy, regionLength);
                            continue;
                        }
                        if (recordTrace) {
                            ((ExpressionTrace)this.recordedTraces.getLast()).addTrace(input, copy, regionLength);
                            continue;
                        }
                        if (!recordVariableInitialization) continue;
                        this.variableTraces.get(this.initializingVariable).addTrace(input, copy, regionLength);
                    }
                }
            } else {
                InputElement input = this.protectedAreaSource == null ? this.getInputElement(this.retrieveScopeEObjectValue(0)) : this.protectedAreaSource;
                if (recordOperationArgument) {
                    GeneratedText generatedText = this.createGeneratedTextFor((EObject)variableExp);
                    this.operationArgumentTrace.addTrace(input, generatedText, result);
                } else if (recordTrace && !this.isEvaluatingPostCall()) {
                    GeneratedText generatedText = this.createGeneratedTextFor((EObject)variableExp);
                    ((ExpressionTrace)this.recordedTraces.getLast()).addTrace(input, generatedText, result);
                } else if (recordVariableInitialization) {
                    GeneratedText generatedText = this.createGeneratedTextFor((EObject)variableExp);
                    this.variableTraces.get(this.initializingVariable).addTrace(input, generatedText, result);
                }
            }
        }
        if (this.isPropertyCallSource((OCLExpression<C>)variableExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)variableExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    Deque<GeneratedFile> getCurrentFiles() {
        return this.currentFiles;
    }

    AbstractTrace getInitializingVariableTrace() {
        return this.variableTraces.get(this.initializingVariable);
    }

    InputElement getInputElement(EObject modelElement) {
        ModelFile soughtModel = this.getModelFile(modelElement);
        CompactHashSet candidateInputs = this.cachedInputElements.get(modelElement);
        if (candidateInputs == null) {
            candidateInputs = new CompactHashSet();
            this.cachedInputElements.put(modelElement, (Set<InputElement>)candidateInputs);
        }
        for (InputElement input : candidateInputs) {
            if (input.getFeature() != null || input.getOperation() != null) continue;
            return input;
        }
        InputElement soughtElement = TraceabilityFactory.eINSTANCE.createInputElement();
        soughtElement.setModelElement(modelElement);
        soughtModel.getInputElements().add((Object)soughtElement);
        candidateInputs.add(soughtElement);
        return soughtElement;
    }

    Deque<ExpressionTrace<C>> getInvocationTraces() {
        return this.invocationTraces;
    }

    AbstractTrace getLastExpressionTrace() {
        return (AbstractTrace)this.recordedTraces.getLast();
    }

    boolean isEvaluatingPostCall() {
        return this.evaluatingPostCall;
    }

    boolean isInitializingVariable() {
        return this.initializingVariable != null;
    }

    EObject retrieveScopeEObjectValue() {
        return this.retrieveScopeEObjectValue(this.scopeEObjects.size() - 1);
    }

    private void createProtectedAreaTrace(String content, Block protectedArea, ExpressionTrace<C> trace) {
        String actualContent = AcceleoEvaluationVisitor.removeProtectedMarkers((String)content);
        String areaStart = String.valueOf(AcceleoEngineMessages.getString((String)"usercode.start")) + ' ';
        String areaEnd = AcceleoEngineMessages.getString((String)"usercode.end");
        int markerIndex = actualContent.indexOf(areaStart) + areaStart.length();
        int areaEndIndex = actualContent.indexOf(areaEnd);
        int markerEndIndex = actualContent.indexOf("\r\n", markerIndex);
        if (markerEndIndex == -1) {
            markerEndIndex = actualContent.indexOf(10, markerIndex);
        }
        if (markerEndIndex == -1) {
            markerEndIndex = actualContent.indexOf(13, markerIndex);
        }
        int endOffset = -1;
        GeneratedText markerRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
        markerRegion.setStartOffset(markerIndex);
        markerRegion.setEndOffset(markerEndIndex);
        markerRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
        markerRegion.setSourceElement(this.protectedAreaSource);
        GeneratedText startRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
        startRegion.setEndOffset(markerIndex);
        startRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
        startRegion.setSourceElement(this.protectedAreaSource);
        GeneratedText contentRegion = null;
        if (endOffset != areaEndIndex) {
            contentRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
            contentRegion.setStartOffset(markerEndIndex);
            contentRegion.setEndOffset(areaEndIndex);
            contentRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
            contentRegion.setSourceElement(this.protectedAreaSource);
        }
        GeneratedText endRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
        endRegion.setStartOffset(areaEndIndex);
        endRegion.setEndOffset(actualContent.length());
        endRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
        endRegion.setSourceElement(this.protectedAreaSource);
        CompactLinkedHashSet set = new CompactLinkedHashSet();
        trace.getTraces().put(this.protectedAreaSource, (Set<GeneratedText>)set);
        set.add(startRegion);
        set.add(markerRegion);
        if (contentRegion != null) {
            set.add(contentRegion);
        }
        set.add(endRegion);
    }

    private void cancel() {
        this.currentExpression = null;
        if (this.currentFiles != null) {
            this.currentFiles.clear();
            this.currentFiles = null;
        }
        this.initializingVariable = null;
        if (this.invocationTraces != null) {
            for (AbstractTrace trace : this.invocationTraces) {
                trace.dispose();
            }
            this.invocationTraces.clear();
            this.invocationTraces = null;
        }
        if (this.operationArgumentTrace != null) {
            this.operationArgumentTrace.dispose();
            this.operationArgumentTrace = null;
        }
        this.operationCallSource = null;
        this.operationCallSourceExpression = null;
        this.propertyCallSource = null;
        this.propertyCallSourceExpression = null;
        this.protectedAreaSource = null;
        this.record = true;
        for (AbstractTrace trace : this.recordedTraces) {
            trace.dispose();
        }
        this.recordedTraces.clear();
        if (this.scopeEObjects != null) {
            this.scopeEObjects.clear();
        }
        for (AbstractTrace trace : this.variableTraces.values()) {
            trace.dispose();
        }
        this.variableTraces.clear();
        for (AbstractTrace trace : this.iterationTraces) {
            trace.dispose();
        }
        this.iterationTraces.clear();
        this.iterationCount.clear();
    }

    private GeneratedText createGeneratedTextFor(EObject moduleElement) {
        ModuleElement modElement = this.getModuleElement(moduleElement);
        GeneratedText text = TraceabilityFactory.eINSTANCE.createGeneratedText();
        text.setModuleElement(modElement);
        return text;
    }

    private GeneratedFile getGeneratedFile(File generatedFile, boolean appendMode) {
        GeneratedFile soughtFile = this.evaluationTrace.getGeneratedFile(generatedFile.getPath());
        if (soughtFile == null) {
            soughtFile = TraceabilityFactory.eINSTANCE.createGeneratedFile();
            soughtFile.setPath(generatedFile.getPath());
            soughtFile.setName(this.stripFileNameFrom(generatedFile.getPath()));
            if (appendMode && generatedFile.exists() && generatedFile.canRead()) {
                int length;
                block17: {
                    length = 0;
                    BufferedReader reader = null;
                    try {
                        try {
                            reader = new BufferedReader(new FileReader(generatedFile));
                            String line = reader.readLine();
                            while (line != null) {
                                length += line.length() + 1;
                                line = reader.readLine();
                            }
                        }
                        catch (IOException e) {
                            AcceleoTraceabilityPlugin.log(e, false);
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                break block17;
                            }
                            catch (IOException e2) {
                                AcceleoTraceabilityPlugin.log(e2, false);
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e) {
                            AcceleoTraceabilityPlugin.log(e, false);
                        }
                        throw throwable;
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        AcceleoTraceabilityPlugin.log(e, false);
                    }
                }
                soughtFile.setLength(length);
            }
            this.evaluationTrace.getGeneratedFiles().add((Object)soughtFile);
        }
        return soughtFile;
    }

    private InputElement getInputElement(EObject modelElement, EStructuralFeature feature) {
        ModelFile soughtModel = this.getModelFile(modelElement);
        CompactHashSet candidateInputs = this.cachedInputElements.get(modelElement);
        if (candidateInputs == null) {
            candidateInputs = new CompactHashSet();
            this.cachedInputElements.put(modelElement, (Set<InputElement>)candidateInputs);
        }
        for (InputElement input : candidateInputs) {
            if (input.getFeature() != feature) continue;
            return input;
        }
        InputElement soughtElement = TraceabilityFactory.eINSTANCE.createInputElement();
        soughtElement.setModelElement(modelElement);
        soughtElement.setFeature(feature);
        soughtModel.getInputElements().add((Object)soughtElement);
        candidateInputs.add(soughtElement);
        return soughtElement;
    }

    private ModelFile getModelFile(EObject modelElement) {
        ModelFile soughtModel;
        URI modelURI;
        if (modelElement.eResource() != null) {
            modelURI = modelElement.eResource().getURI();
        } else if (modelElement.eIsProxy()) {
            modelURI = ((InternalEObject)modelElement).eProxyURI().trimFragment();
        } else {
            throw new IllegalArgumentException(AcceleoTraceabilityMessages.getString("AcceleoTraceabilityVisitor.MissingResource"));
        }
        String name = modelURI.lastSegment();
        String path = modelURI.toString();
        if (path.startsWith("http://") && EMFPlugin.IS_ECLIPSE_RUNNING) {
            if (this.ecoreURLCache.containsKey(path)) {
                path = this.ecoreURLCache.get(path);
            } else {
                String nsURI = path;
                EPackage pack = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                try {
                    URL ecoreURL = AcceleoWorkspaceUtil.getResourceURL(pack.getClass(), (String)"*.ecore");
                    if (ecoreURL != null) {
                        path = ecoreURL.toString();
                    }
                }
                catch (IOException e) {
                    AcceleoTraceabilityPlugin.log(e, false);
                }
                this.ecoreURLCache.put(nsURI, path);
            }
        }
        if ((soughtModel = this.evaluationTrace.getInputModel(path)) == null) {
            soughtModel = TraceabilityFactory.eINSTANCE.createModelFile();
            soughtModel.setPath(path);
            soughtModel.setName(name);
            this.evaluationTrace.getModelFiles().add((Object)soughtModel);
        }
        return soughtModel;
    }

    private ModuleElement getModuleElement(EObject moduleElement) {
        if (moduleElement instanceof StringLiteralExp && moduleElement.eContainer().eContainer() == null) {
            return this.protectedAreaModuleElement;
        }
        ModuleFile soughtModule = this.getModuleFile(moduleElement);
        ModuleElement element = this.cachedModuleElements.get(moduleElement);
        if (element == null) {
            element = TraceabilityFactory.eINSTANCE.createModuleElement();
            element.setModuleElement(moduleElement);
            soughtModule.getModuleElements().add((Object)element);
            this.cachedModuleElements.put(moduleElement, element);
        }
        return element;
    }

    private ModuleFile getModuleFile(EObject moduleElement) {
        ModuleFile soughtModule;
        URI moduleURI = moduleElement.eResource().getURI();
        String path = moduleURI.toString();
        if (path.startsWith("http://") && EMFPlugin.IS_ECLIPSE_RUNNING) {
            EPackage pack = EPackage.Registry.INSTANCE.getEPackage(path);
            try {
                URL emtlURL = AcceleoWorkspaceUtil.getResourceURL(pack.getClass(), (String)this.stripPathFrom(path));
                if (emtlURL != null) {
                    path = emtlURL.toString();
                }
            }
            catch (IOException e) {
                AcceleoTraceabilityPlugin.log(e, false);
            }
        }
        if ((soughtModule = this.evaluationTrace.getGenerationModule(path)) == null) {
            soughtModule = TraceabilityFactory.eINSTANCE.createModuleFile();
            soughtModule.setPath(path);
            soughtModule.setName(this.stripFileNameFrom(path));
            this.evaluationTrace.getModules().add((Object)soughtModule);
        }
        return soughtModule;
    }

    private List<String> getTraceabilityImpactingCollectionOperationNames() {
        ArrayList<String> operationNames = new ArrayList<String>();
        operationNames.add("reverse");
        operationNames.add("sep");
        operationNames.add("first");
        operationNames.add("last");
        return operationNames;
    }

    private List<String> getTraceabilityImpactingStringOperationNames() {
        ArrayList<String> operationNames = new ArrayList<String>();
        operationNames.add("first");
        operationNames.add("last");
        operationNames.add("strtok");
        operationNames.add("substitute");
        operationNames.add("replace");
        operationNames.add("replaceAll");
        operationNames.add("substituteAll");
        operationNames.add("substring");
        operationNames.add("tokenize");
        operationNames.add("trim");
        operationNames.add("substring");
        return operationNames;
    }

    private Object internalVisitNonStandardOperation(OperationCallExp<C, O> callExp, Object source) {
        Object result;
        String operationName = ((EOperation)callExp.getReferredOperation()).getName();
        ArrayList<Object> arguments = new ArrayList<Object>(callExp.getArgument().size());
        for (OCLExpression expression : callExp.getArgument()) {
            boolean oldRecordingValue = this.record;
            this.record = false;
            arguments.add(super.visitExpression(expression));
            this.record = oldRecordingValue;
        }
        if (operationName.equals("trim")) {
            result = this.operationVisitor.visitTrimOperation((String)source);
        } else if (operationName.equals("substring")) {
            int startIndex = (Integer)arguments.get(0) - 1;
            result = this.operationVisitor.visitSubstringOperation((String)source, startIndex);
        } else if (operationName.equals("reverse")) {
            result = this.operationVisitor.visitReverseOperation((Collection)source);
        } else if (operationName.equals("tokenize")) {
            String delims = (String)arguments.get(0);
            result = this.operationVisitor.visitTokenizeOperation((String)source, delims);
        } else if (operationName.equals("toString")) {
            ModuleElement moduleElement = this.getModuleElement((EObject)callExp);
            result = this.operationVisitor.visitTostringOperation(source, moduleElement);
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private Object internalVisitOCLOperation(OperationCallExp<C, O> callExp, Object source) {
        Object result;
        ArrayList<Object> arguments = new ArrayList<Object>(callExp.getArgument().size());
        for (OCLExpression expression : callExp.getArgument()) {
            boolean oldRecordingValue = this.record;
            this.record = false;
            arguments.add(super.visitExpression(expression));
            this.record = oldRecordingValue;
        }
        switch (callExp.getOperationCode()) {
            case 22: {
                int startIndex = (Integer)arguments.get(0) - 1;
                int endIndex = (Integer)arguments.get(1);
                result = this.operationVisitor.visitSubstringOperation((String)source, startIndex, endIndex);
                break;
            }
            case 159: {
                result = this.operationVisitor.visitFirstOperation((Collection)source);
                break;
            }
            case 162: {
                result = this.operationVisitor.visitLastOperation((Collection)source);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private Object internalVisitOperationCallExp(OperationCallExp<C, O> callExp) {
        Object result;
        String operationName = ((EOperation)callExp.getReferredOperation()).getName();
        Object sourceObject = this.visitExpression(callExp.getSource());
        if (operationName.equals("substitute") || operationName.equals("substituteAll") || operationName.equals("replace") || operationName.equals("replaceAll")) {
            boolean substituteAll = false;
            boolean substituteRegexes = false;
            if (operationName.equals("substituteAll")) {
                substituteAll = true;
            } else if (operationName.equals("replace")) {
                substituteRegexes = true;
            } else if (operationName.equals("replaceAll")) {
                substituteAll = true;
                substituteRegexes = true;
            }
            boolean oldRecordingValue = this.record;
            this.record = false;
            Object substring = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            this.record = oldRecordingValue;
            ExpressionTrace<C> oldArgTrace = this.operationArgumentTrace;
            this.operationArgumentTrace = new ExpressionTrace((OCLExpression)callExp.getArgument().get(1));
            Object substitution = super.visitExpression((OCLExpression)callExp.getArgument().get(1));
            if (!substituteRegexes) {
                substring = "\\Q" + substring + "\\E";
                substitution = ((String)substitution).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            }
            String result2 = this.operationVisitor.visitReplaceOperation((String)sourceObject, (String)substring, (String)substitution, this.operationArgumentTrace, substituteAll, false);
            this.operationArgumentTrace.dispose();
            this.operationArgumentTrace = oldArgTrace;
            return result2;
        }
        EOperation operation = (EOperation)callExp.getReferredOperation();
        if (operationName.equals("sep")) {
            ExpressionTrace<C> oldArgTrace = this.operationArgumentTrace;
            this.operationArgumentTrace = new ExpressionTrace((OCLExpression)callExp.getArgument().get(0));
            Object separator = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            result = this.operationVisitor.visitSepOperation((Collection)sourceObject, (String)separator, this.operationArgumentTrace);
            this.operationArgumentTrace.dispose();
            this.operationArgumentTrace = oldArgTrace;
        } else {
            result = operation.getEAnnotation("MTL") != null ? this.internalVisitStandardOperation(callExp, sourceObject) : (operation.getEAnnotation("MTL non-standard") != null ? this.internalVisitNonStandardOperation(callExp, sourceObject) : this.internalVisitOCLOperation(callExp, sourceObject));
        }
        return result;
    }

    private Object internalVisitStandardOperation(OperationCallExp<C, O> callExp, Object source) {
        String result;
        String operationName = ((EOperation)callExp.getReferredOperation()).getName();
        ArrayList<Object> arguments = new ArrayList<Object>(callExp.getArgument().size());
        for (OCLExpression expression : callExp.getArgument()) {
            boolean oldRecordingValue = this.record;
            this.record = false;
            arguments.add(super.visitExpression(expression));
            this.record = oldRecordingValue;
        }
        if (operationName.equals("first")) {
            int charCount = (Integer)arguments.get(0);
            result = this.operationVisitor.visitFirstOperation((String)source, charCount);
        } else if (operationName.equals("last")) {
            int charCount = (Integer)arguments.get(0);
            result = this.operationVisitor.visitLastOperation((String)source, charCount);
        } else if (operationName.equals("strtok")) {
            String delimiters = (String)arguments.get(0);
            Integer flag = (Integer)arguments.get(1);
            result = this.operationVisitor.visitStrtokOperation((String)source, delimiters, flag);
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private boolean isBooleanReturningOperation(OperationCallExp<C, O> operationCall) {
        EClassifier operationReturnEType = (EClassifier)operationCall.getType();
        EClassifier booleanClassifier = (EClassifier)this.getEnvironment().getOCLStandardLibrary().getBoolean();
        return booleanClassifier == operationReturnEType;
    }

    private boolean isIteratorCallSource(OCLExpression<?> expression) {
        boolean isSource = false;
        EObject eContainer = expression.eContainer();
        if (eContainer instanceof IteratorExp) {
            IteratorExp iteratorExp = (IteratorExp)eContainer;
            OCLExpression source = iteratorExp.getSource();
            isSource = source == expression || this.isIteratorCallSource((OCLExpression<?>)iteratorExp);
        } else if (eContainer instanceof CollectionItem) {
            CollectionItem collectionItem = (CollectionItem)eContainer;
            if ((eContainer = collectionItem.eContainer()) instanceof CollectionLiteralExp) {
                CollectionLiteralExp collectionLiteralExp = (CollectionLiteralExp)eContainer;
                isSource = this.isIteratorCallSource((OCLExpression<?>)collectionLiteralExp);
            }
        } else if (eContainer instanceof ForBlock) {
            isSource = EcoreUtil.isAncestor(((IterationTrace)this.iterationTraces.getLast()).getReferredExpression(), expression);
        }
        return isSource;
    }

    private boolean isNumberReturningOperation(OperationCallExp<C, O> operationCall) {
        EClassifier operationReturnEType = (EClassifier)operationCall.getType();
        EClassifier integerClassifier = (EClassifier)this.getEnvironment().getOCLStandardLibrary().getInteger();
        EClassifier realClassifier = (EClassifier)this.getEnvironment().getOCLStandardLibrary().getReal();
        return integerClassifier == operationReturnEType || realClassifier == operationReturnEType;
    }

    private boolean isOperationCallSource(OCLExpression<C> expression) {
        return expression == this.operationCallSourceExpression;
    }

    private boolean isProtectedAreaContent(EObject expression) {
        boolean isProtectedAreaContent = expression instanceof ProtectedAreaBlock;
        EObject container = expression.eContainer();
        while (container != null && !isProtectedAreaContent) {
            isProtectedAreaContent = container instanceof ProtectedAreaBlock;
            container = container.eContainer();
        }
        return isProtectedAreaContent;
    }

    private boolean isPropertyCallSource(OCLExpression<C> expression) {
        return expression == this.propertyCallSourceExpression;
    }

    private boolean isTraceabilityImpactingOperation(OperationCallExp<C, O> operationCall) {
        boolean isImpacting = false;
        EClassifier operationReceiverEType = (EClassifier)operationCall.getSource().getType();
        EClassifier stringType = (EClassifier)this.getEnvironment().getOCLStandardLibrary().getString();
        EClassifier collectionType = (EClassifier)this.getEnvironment().getOCLStandardLibrary().getCollection();
        if (this.isBooleanReturningOperation(operationCall) || this.isNumberReturningOperation(operationCall)) {
            isImpacting = true;
        } else {
            String operationName = ((EOperation)operationCall.getReferredOperation()).getName();
            if (operationReceiverEType == stringType || "String".equals(operationReceiverEType.getName())) {
                isImpacting = this.getTraceabilityImpactingStringOperationNames().contains(operationName);
            } else if (collectionType.eClass().isInstance((Object)operationReceiverEType)) {
                isImpacting = this.getTraceabilityImpactingCollectionOperationNames().contains(operationName);
            } else if ("toString".equals(operationName) && !TraceabilityVisitorUtil.isPrimitive(operationReceiverEType) && !(operationReceiverEType instanceof EEnum)) {
                isImpacting = true;
            }
        }
        return isImpacting;
    }

    private void recordLiteral(OCLExpression<C> expression, Object result) {
        boolean isFileBlockCharset;
        InputElement input = this.getInputElement(this.retrieveScopeEObjectValue());
        if (this.protectedAreaSource != null) {
            input = this.protectedAreaSource;
        }
        boolean bl = isFileBlockCharset = expression.eContainingFeature() == MtlPackage.eINSTANCE.getFileBlock_Charset();
        if (this.record && !isFileBlockCharset) {
            if (this.operationArgumentTrace != null) {
                GeneratedText text = this.createGeneratedTextFor((EObject)expression);
                this.operationArgumentTrace.addTrace(input, text, result);
            } else if (this.isInitializingVariable()) {
                GeneratedText text = this.createGeneratedTextFor((EObject)expression);
                this.variableTraces.get(this.initializingVariable).addTrace(input, text, result);
            } else if (!this.recordedTraces.isEmpty() && result.toString().length() > 0 && this.shouldRecordTrace(expression)) {
                GeneratedText text = this.createGeneratedTextFor((EObject)expression);
                ((ExpressionTrace)this.recordedTraces.getLast()).addTrace(input, text, result);
            } else if (this.isOperationCallSource(expression)) {
                GeneratedText text = this.createGeneratedTextFor((EObject)expression);
                ((ExpressionTrace)this.recordedTraces.getLast()).addTrace(input, text, result);
            } else if (!this.iterationTraces.isEmpty()) {
                GeneratedText text = this.createGeneratedTextFor((EObject)expression);
                ((IterationTrace)this.iterationTraces.getLast()).addTrace(input, text, result);
            }
        } else if (!this.record && this.operationArgumentTrace != null) {
            GeneratedText text = this.createGeneratedTextFor((EObject)expression);
            this.operationArgumentTrace.addTrace(input, text, result);
        }
    }

    private EObject retrieveScopeEObjectValue(int index) {
        EObject scopeValue = null;
        int i = index;
        while (i >= 0 && scopeValue == null) {
            Object value;
            EObject scope = (EObject)this.scopeEObjects.get(i);
            if (scope instanceof org.eclipse.ocl.expressions.Variable) {
                value = this.getEvaluationEnvironment().getValueOf(((org.eclipse.ocl.expressions.Variable)scope).getName());
                if (value instanceof EObject) {
                    scopeValue = (EObject)value;
                }
            } else if (scope instanceof VariableExp) {
                value = this.getEvaluationEnvironment().getValueOf(((VariableExp)scope).getReferredVariable().getName());
                if (value instanceof EObject) {
                    scopeValue = (EObject)value;
                }
            } else {
                Object self;
                scopeValue = scope;
                if (scope instanceof OCLExpression && (self = this.getEvaluationEnvironment().getValueOf("self")) instanceof EObject) {
                    scopeValue = (EObject)self;
                }
            }
            --i;
        }
        return scopeValue;
    }

    private boolean shouldRecordOperationTrace(OCLExpression<C> expression) {
        boolean recordTrace = false;
        if (expression instanceof OperationCallExp) {
            OperationCallExp call = (OperationCallExp)expression;
            recordTrace = call.eContainingFeature() != MtlPackage.eINSTANCE.getTemplate_Post() && this.isTraceabilityImpactingOperation(call);
        } else if (expression instanceof Template && ((Template)expression).getPost() instanceof OperationCallExp) {
            OperationCallExp call = (OperationCallExp)((Template)expression).getPost();
            recordTrace = this.isTraceabilityImpactingOperation(call);
        }
        return recordTrace;
    }

    private boolean shouldRecordTrace(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getFileBlock_FileUrl();
        generate = generate || reference == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }

    private boolean shouldRecordTrace(OCLExpression<C> expression) {
        boolean result = true;
        if (this.evaluatingIterationSet || !this.record) {
            return false;
        }
        if (this.isPropertyCallSource(expression)) {
            result = false;
        } else if (this.isOperationCallSource(expression)) {
            OperationCallExp call = (OperationCallExp)expression.eContainer();
            EOperation op = (EOperation)call.getReferredOperation();
            if (this.isTraceabilityImpactingOperation(call) && TraceabilityVisitorUtil.isPrimitive((EClassifier)call.getType())) {
                result = true;
            } else if (op.getEType() != this.getEnvironment().getOCLStandardLibrary().getString()) {
                result = false;
            }
        } else if (this.isIteratorCallSource(expression)) {
            result = !(((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression() instanceof IteratorExp) || !EcoreUtil.isAncestor(((ExpressionTrace)this.recordedTraces.getLast()).getReferredExpression(), expression);
        } else if (expression.eContainingFeature() == ExpressionsPackage.eINSTANCE.getOperationCallExp_Argument() && this.isTraceabilityImpactingOperation((OperationCallExp)expression.eContainer())) {
            result = false;
        }
        return result;
    }

    private String stripFileNameFrom(String filePath) {
        String fileName = filePath;
        if (fileName.indexOf(File.separator) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
        }
        if (fileName.indexOf(46) > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    private String stripPathFrom(String fileURI) {
        URI fileEMFURI = URI.createURI((String)fileURI);
        String filePath = fileEMFURI.path();
        if (fileEMFURI.isPlatform()) {
            int slashIndex = filePath.indexOf(47);
            if (slashIndex > 0) {
                slashIndex = filePath.indexOf(47, slashIndex + 1);
            }
            if (slashIndex > 0) {
                filePath = filePath.substring(slashIndex + 1);
            }
        }
        return filePath;
    }

    private boolean switchRecordState(OCLExpression<C> expression) {
        int opCode;
        if (!this.record) {
            return this.record;
        }
        boolean oldRecordingValue = this.record;
        EStructuralFeature containingFeature = expression.eContainingFeature();
        EObject container = expression.eContainer();
        this.record = containingFeature != MtlPackage.eINSTANCE.getIfBlock_IfExpr();
        this.record = this.record && containingFeature != ExpressionsPackage.eINSTANCE.getIfExp_Condition();
        this.record = this.record && containingFeature != MtlPackage.eINSTANCE.getForBlock_Guard();
        this.record = this.record && containingFeature != MtlPackage.eINSTANCE.getTemplate_Guard();
        boolean bl = this.record = this.record && (containingFeature != ExpressionsPackage.eINSTANCE.getVariable_InitExpression() || container.eContainingFeature() != MtlPackage.eINSTANCE.getLetBlock_LetVariable());
        if (this.record && container instanceof IteratorExp && (opCode = OCLStandardLibraryUtil.getOperationCode((String)((IteratorExp)container).getName())) != 206 && opCode != 207) {
            boolean bl2 = this.record = containingFeature != ExpressionsPackage.eINSTANCE.getLoopExp_Body();
        }
        if (this.record && containingFeature == ExpressionsPackage.eINSTANCE.getOperationCallExp_Argument()) {
            this.record = !this.isTraceabilityImpactingOperation((OperationCallExp)container);
        }
        return oldRecordingValue;
    }
}

