/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.AcceleoASTNodeAdapter;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.Deque;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.AcceleoRuntimeException;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.generation.writers.AcceleoFileWriter;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationContext<C> {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String JMERGE_TAG = "@generated";
    private static final String DOS_LINE_SEPARATOR = "\r\n";
    private static final String UNIX_LINE_SEPARATOR = "\n";
    private static final String MAC_LINE_SEPARATOR = "\r";
    protected final Map<String, Writer> generationPreview = new HashMap<String, Writer>();
    protected final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>(3);
    protected final boolean notifyOnGenerationEnd;
    private Deque<OCLExpression<C>> expressionStack = new CircularArrayDeque();
    private final File generationRoot;
    private boolean hasJMergeTag;
    private final Monitor progressMonitor;
    private final IAcceleoGenerationStrategy strategy;
    private final Map<Writer, Map<String, String>> userCodeBlocks = new HashMap<Writer, Map<String, String>>();
    private final Deque<Writer> writers = new CircularArrayDeque();
    private StringWriter defaultWriter;
    private Map<String, Integer> generateFiles = new HashMap<String, Integer>();

    public AcceleoEvaluationContext(File root, List<IAcceleoTextGenerationListener> listeners, IAcceleoGenerationStrategy generationStrategy, Monitor monitor) {
        this.generationRoot = root;
        this.strategy = generationStrategy;
        this.listeners.addAll(listeners);
        this.progressMonitor = monitor != null ? monitor : new BasicMonitor();
        boolean temp = false;
        for (IAcceleoTextGenerationListener listener : listeners) {
            if (!listener.listensToGenerationEnd()) continue;
            temp = true;
            break;
        }
        this.notifyOnGenerationEnd = temp;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) throws AcceleoEvaluationException {
        try {
            if (!this.writers.isEmpty()) {
                Writer currentWriter = (Writer)this.writers.getLast();
                currentWriter.append(string);
                if (fireEvent && string.length() > 0) {
                    this.fireTextGenerated(new AcceleoTextGenerationEvent(string, sourceBlock, source));
                }
            } else {
                String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.PossibleEmptyFileName");
                if (!EMFPlugin.IS_ECLIPSE_RUNNING || AcceleoPreferences.isDebugMessagesEnabled()) {
                    AcceleoEnginePlugin.log(message, false);
                }
                if (this.defaultWriter == null) {
                    this.defaultWriter = new StringWriter(1024);
                }
                this.defaultWriter.append(string);
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.AppendError"), e);
        }
    }

    public void addToStack(OCLExpression<C> expression) {
        this.expressionStack.add(expression);
    }

    public void awaitCompletion() throws InterruptedException {
        this.strategy.awaitCompletion();
    }

    public AcceleoEvaluationException createAcceleoException(ASTNode node, String messageKey, Object currentSelf) {
        return this.createAcceleoException(node, null, messageKey, currentSelf);
    }

    public AcceleoEvaluationException createAcceleoException(ASTNode node, OCLExpression<C> expression, String messageKey, Object currentSelf) {
        Adapter adapter = EcoreUtil.getAdapter((List)node.eAdapters(), AcceleoASTNodeAdapter.class);
        int line = 0;
        if (adapter instanceof AcceleoASTNodeAdapter) {
            line = ((AcceleoASTNodeAdapter)adapter).getLine();
        }
        String moduleName = ((Module)EcoreUtil.getRootContainer((EObject)node)).getName();
        String message = AcceleoEngineMessages.getString(messageKey, line, moduleName, node.toString(), currentSelf, expression);
        AcceleoFileWriter acceleoFileWriter = this.getAcceleoFileWriterFromContext();
        if (acceleoFileWriter != null) {
            message = String.valueOf(message) + " " + AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileException", acceleoFileWriter.getTargetPath());
        }
        AcceleoEvaluationException exception = new AcceleoEvaluationException(message);
        exception.setStackTrace(this.createAcceleoStackTrace());
        return exception;
    }

    private AcceleoFileWriter getAcceleoFileWriterFromContext() {
        int i = this.writers.size() - 1;
        while (i >= 0) {
            Writer writer = (Writer)this.writers.get(i);
            if (writer instanceof AcceleoFileWriter) {
                return (AcceleoFileWriter)writer;
            }
            --i;
        }
        return null;
    }

    public AcceleoRuntimeException createAcceleoRuntimeException(Throwable cause) {
        AcceleoRuntimeException exception = new AcceleoRuntimeException(cause);
        if (this.expressionStack.size() > 0) {
            exception.setStackTrace(this.createAcceleoStackTrace());
        }
        return exception;
    }

    public StackTraceElement[] createAcceleoStackTrace() {
        StackTraceElement[] stackTrace = new StackTraceElement[this.expressionStack.size()];
        int i = this.expressionStack.size() - 1;
        while (i >= 0) {
            OCLExpression expression = (OCLExpression)this.expressionStack.get(i);
            Module containingModule = (Module)EcoreUtil.getRootContainer((EObject)expression);
            String moduleFile = containingModule.eResource() != null && containingModule.eResource().getURI() != null ? String.valueOf(containingModule.eResource().getURI().trimFileExtension().lastSegment()) + '.' + "mtl" : String.valueOf(containingModule.getName()) + '.' + "mtl";
            OCLExpression containingModuleElement = expression;
            while (!(containingModuleElement instanceof ModuleElement)) {
                containingModuleElement = containingModuleElement.eContainer();
            }
            Adapter adapter = EcoreUtil.getAdapter((List)expression.eAdapters(), AcceleoASTNodeAdapter.class);
            int line = 0;
            if (adapter instanceof AcceleoASTNodeAdapter) {
                line = ((AcceleoASTNodeAdapter)adapter).getLine();
            }
            stackTrace[this.expressionStack.size() - i - 1] = new StackTraceElement(containingModule.getName(), containingModuleElement.toString(), moduleFile, line);
            --i;
        }
        return stackTrace;
    }

    public String closeContext() throws AcceleoEvaluationException {
        return this.closeContext(null, null);
    }

    public String closeContext(Block sourceBlock, EObject source) throws AcceleoEvaluationException {
        if (this.writers.isEmpty()) {
            String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.PossibleEmptyFileName");
            if (!EMFPlugin.IS_ECLIPSE_RUNNING && AcceleoPreferences.isDebugMessagesEnabled()) {
                AcceleoEnginePlugin.log(message, false);
            }
            return "";
        }
        Writer last = (Writer)this.writers.removeLast();
        try {
            String result;
            if (last instanceof AbstractAcceleoWriter) {
                Map<String, StringWriter> lostFiles;
                String filePath = ((AbstractAcceleoWriter)last).getTargetPath();
                Map<String, String> lostCode = this.userCodeBlocks.get(last);
                if (lostCode.size() > 0 && (lostFiles = this.strategy.createLostFile(filePath, lostCode)) != null) {
                    for (Map.Entry<String, StringWriter> lostFile : lostFiles.entrySet()) {
                        this.generationPreview.put(lostFile.getKey(), lostFile.getValue());
                    }
                }
                this.strategy.flushWriter(filePath, last);
                this.fireFileGenerated(filePath, sourceBlock, source);
                result = "";
            } else if (last instanceof OutputStreamWriter) {
                last.close();
                result = "";
            } else {
                result = last.toString();
            }
            return result;
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.WriteError"), e);
        }
    }

    public void dispose() throws AcceleoEvaluationException {
        AcceleoEvaluationException exception = null;
        try {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
            try {
                for (Writer writer : this.writers) {
                    writer.close();
                }
            }
            catch (IOException e) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.CleanUpError"), e);
            }
        }
        finally {
            this.generationPreview.clear();
            this.listeners.clear();
            this.userCodeBlocks.clear();
            this.writers.clear();
            this.expressionStack.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void generateFile(String filePath) {
        Integer timesGenerated = this.generateFiles.get(filePath);
        timesGenerated = timesGenerated == null ? Integer.valueOf(1) : Integer.valueOf(timesGenerated + 1);
        this.generateFiles.put(filePath, timesGenerated);
    }

    public String getLastFileIndentation() {
        Writer writer = null;
        int i = this.writers.size() - 1;
        while (i >= 0 && !(writer instanceof AbstractAcceleoWriter)) {
            writer = (Writer)this.writers.get(i);
            --i;
        }
        if (writer != null) {
            return ((AbstractAcceleoWriter)writer).getCurrentLineIndentation();
        }
        return "";
    }

    public Block getLastVisitedBlock() {
        OCLExpression previous;
        if (this.expressionStack.isEmpty()) {
            return null;
        }
        ListIterator expressionIterator = this.expressionStack.listIterator(this.expressionStack.size());
        while (!((previous = (OCLExpression)expressionIterator.previous()) instanceof Block) && expressionIterator.hasPrevious()) {
        }
        Block lastBlock = null;
        if (previous instanceof Block) {
            lastBlock = (Block)previous;
        }
        return lastBlock;
    }

    public String getCurrentLineIndentation() {
        StringBuffer currentIndentation = new StringBuffer();
        if (!this.writers.isEmpty()) {
            Writer writer = (Writer)this.writers.getLast();
            if (writer instanceof AbstractAcceleoWriter) {
                return ((AbstractAcceleoWriter)writer).getCurrentLineIndentation();
            }
            String content = writer.toString();
            int newLineIndex = -1;
            if (content.contains(DOS_LINE_SEPARATOR)) {
                newLineIndex = content.lastIndexOf(DOS_LINE_SEPARATOR) + DOS_LINE_SEPARATOR.length();
            } else if (content.contains(UNIX_LINE_SEPARATOR)) {
                newLineIndex = content.lastIndexOf(UNIX_LINE_SEPARATOR) + UNIX_LINE_SEPARATOR.length();
            } else if (content.contains(MAC_LINE_SEPARATOR)) {
                newLineIndex = content.lastIndexOf(MAC_LINE_SEPARATOR) + MAC_LINE_SEPARATOR.length();
            }
            if (newLineIndex == -1) {
                newLineIndex = 0;
            }
            int i = newLineIndex;
            while (i < content.length()) {
                if (!Character.isWhitespace(content.charAt(i))) break;
                currentIndentation.append(content.charAt(i));
                ++i;
            }
        }
        return currentIndentation.toString();
    }

    public String getDefaultText() {
        if (this.defaultWriter != null) {
            this.defaultWriter.flush();
            String text = this.defaultWriter.toString();
            this.defaultWriter = null;
            return text;
        }
        return null;
    }

    public File getFileFor(String filePath) {
        File generatedFile = filePath.startsWith("file:") ? new File(filePath) : new File(this.generationRoot, filePath);
        return generatedFile;
    }

    public Map<String, String> getGenerationPreview() {
        return new HashMap<String, String>(this.strategy.preparePreview(this.generationPreview));
    }

    public Monitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public String getProtectedAreaContent(String marker) {
        Writer writer = null;
        int i = this.writers.size() - 1;
        while (i >= 0 && !(writer instanceof AbstractAcceleoWriter)) {
            writer = (Writer)this.writers.get(i);
            --i;
        }
        Map<String, String> areas = this.userCodeBlocks.get(writer);
        if (areas != null) {
            return areas.remove(marker);
        }
        return null;
    }

    public void hookGenerationEnd() {
        HashMap<String, Map<String, String>> lostCode = new HashMap<String, Map<String, String>>();
        for (Map.Entry<Writer, Map<String, String>> entry : this.userCodeBlocks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            String filePath = ((AbstractAcceleoWriter)entry.getKey()).getTargetPath();
            lostCode.put(filePath, entry.getValue());
        }
        if (!lostCode.isEmpty()) {
            this.strategy.createLostFiles(lostCode);
        }
        try {
            this.strategy.flushWriters(this.generationPreview);
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.WriteError"), e);
        }
        Map filteredFiles = Maps.filterEntries(this.generateFiles, (Predicate)new Predicate<Map.Entry<String, Integer>>(){

            public boolean apply(Map.Entry<String, Integer> input) {
                return input.getValue() > 1;
            }
        });
        if (!filteredFiles.isEmpty()) {
            StringBuilder message = new StringBuilder(AcceleoEngineMessages.getString("AcceleoEvaluationContext.OverrodeFiles"));
            message.append('\n').append('\n');
            for (Map.Entry file : filteredFiles.entrySet()) {
                message.append(String.valueOf((String)file.getKey()) + " : " + ((Integer)file.getValue()).toString() + " times" + '\n');
            }
            AcceleoEnginePlugin.log(message.toString(), false);
        }
    }

    public void openNested() throws AcceleoEvaluationException {
        try {
            if (!this.writers.isEmpty()) {
                ((Writer)this.writers.getLast()).flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add((Object)new StringWriter(1024));
    }

    public void openNested(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        this.fireFilePathComputed(new AcceleoTextGenerationEvent(generatedFile.getPath(), fileBlock, source));
        try {
            if (!this.writers.isEmpty()) {
                ((Writer)this.writers.getLast()).flush();
            }
            HashMap<String, String> savedCodeBlocks = new HashMap<String, String>();
            if (generatedFile.exists()) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(generatedFile));
            }
            if (this.generationPreview.containsKey(generatedFile.getPath())) {
                savedCodeBlocks.putAll(this.saveProtectedAreas(this.generationPreview.get(generatedFile.getPath()).toString()));
            }
            AbstractAcceleoWriter writer = charset != null ? this.strategy.createWriterFor(generatedFile, (AbstractAcceleoWriter)this.generationPreview.get(generatedFile.getPath()), appendMode, this.hasJMergeTag, charset) : this.strategy.createWriterFor(generatedFile, (AbstractAcceleoWriter)this.generationPreview.get(generatedFile.getPath()), appendMode, this.hasJMergeTag);
            this.generationPreview.put(generatedFile.getPath(), writer);
            this.hasJMergeTag = false;
            this.userCodeBlocks.put(writer, savedCodeBlocks);
            this.writers.add((Object)writer);
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FileCreationError", generatedFile.getPath()), e);
        }
    }

    public void openNested(OutputStream stream) {
        try {
            if (!this.writers.isEmpty()) {
                ((Writer)this.writers.getLast()).flush();
            }
        }
        catch (IOException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.FlushError"), e);
        }
        this.writers.add((Object)new OutputStreamWriter(new AcceleoFilterOutputStream(stream)));
    }

    public void openNested(String filePath, Block fileBlock, EObject source, boolean appendMode) throws AcceleoEvaluationException {
        this.openNested(this.getFileFor(filePath), fileBlock, source, appendMode, null);
    }

    public void removeFromStack() {
        if (!this.expressionStack.isEmpty()) {
            this.expressionStack.removeLast();
        }
    }

    protected void fireFileGenerated(String filePath, Block fileBlock, EObject source) {
        AcceleoTextGenerationEvent event = new AcceleoTextGenerationEvent(filePath, fileBlock, source);
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.fileGenerated(event);
        }
    }

    private void fireFilePathComputed(AcceleoTextGenerationEvent event) {
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            listener.filePathComputed(event);
        }
    }

    private void fireTextGenerated(AcceleoTextGenerationEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).textGenerated(event);
            ++i;
        }
    }

    private Map<String, String> internalSaveProtectedAreas(LineReader reader) throws IOException {
        HashMap<String, String> protectedAreas = new HashMap<String, String>();
        String usercodeStart = AcceleoEngineMessages.getString("usercode.start");
        String usercodeEnd = AcceleoEngineMessages.getString("usercode.end");
        String line = reader.readLine();
        while (line != null) {
            if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                this.hasJMergeTag = true;
            }
            if (line.contains(usercodeStart)) {
                String marker = line.substring(line.indexOf(usercodeStart) + usercodeStart.length()).trim();
                StringBuffer areaContent = new StringBuffer(1024);
                int start = line.indexOf(usercodeStart);
                areaContent.append(line.substring(start));
                line = reader.readLine();
                while (line != null) {
                    areaContent.append(reader.getLastEOLSequence());
                    if (!this.hasJMergeTag && line.contains(JMERGE_TAG)) {
                        this.hasJMergeTag = true;
                    }
                    if (line.contains(usercodeEnd)) {
                        int endOffset = line.indexOf(usercodeEnd) + usercodeEnd.length();
                        areaContent.append(line.substring(0, endOffset));
                        break;
                    }
                    areaContent.append(line);
                    line = reader.readLine();
                }
                protectedAreas.put(marker, areaContent.toString());
            }
            line = reader.readLine();
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(File file) throws IOException {
        Map<String, String> protectedAreas = new HashMap<String, String>();
        LineReader reader = null;
        try {
            try {
                reader = new LineReader(new FileReader(file));
                protectedAreas = this.internalSaveProtectedAreas(reader);
            }
            catch (FileNotFoundException e) {
                AcceleoEnginePlugin.log(e, true);
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return protectedAreas;
    }

    private Map<String, String> saveProtectedAreas(String buffer) {
        Map<String, String> protectedAreas;
        block12: {
            protectedAreas = new HashMap<String, String>();
            LineReader reader = null;
            try {
                try {
                    reader = new LineReader(new StringReader(buffer));
                    protectedAreas = this.internalSaveProtectedAreas(reader);
                }
                catch (IOException e) {
                    AcceleoEnginePlugin.log(e, true);
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        AcceleoEnginePlugin.log(e2, true);
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, true);
                    }
                }
            }
        }
        return protectedAreas;
    }

    private final class AcceleoFilterOutputStream
    extends FilterOutputStream {
        public AcceleoFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.out != System.out) {
                this.out.close();
            }
        }
    }

    private final class LineReader
    extends Reader {
        private static final int BUFFER_SIZE = 8192;
        private char[] characterBuffer;
        private Reader input;
        private int nChars;
        private int nextChar;
        private String lastEOL;

        public LineReader(Reader in) {
            super((Object)in);
            this.characterBuffer = new char[8192];
            this.input = in;
            this.nChars = 0;
        }

        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                block4: {
                    this.ensureOpen();
                    if (this.nextChar < this.nChars) break block4;
                    this.fill();
                    if (this.nextChar < this.nChars) break block4;
                    return -1;
                }
                return this.characterBuffer[this.nextChar++];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.input == null) {
                    return;
                }
                this.input.close();
                this.input = null;
                this.characterBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cbuf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                block7: {
                    this.ensureOpen();
                    if (off < 0 || len < 0 || off + len > cbuf.length || off + len < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len != 0) break block7;
                    return 0;
                }
                int n = this.internalRead(cbuf, off, len);
                if (n > 0) {
                    while (n < len && this.input.ready()) {
                        int n1 = this.internalRead(cbuf, off + n, len - n);
                        if (n1 <= 0) break;
                        n += n1;
                    }
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLine() throws IOException {
            StringBuilder lineBuffer = null;
            String line = null;
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                while (line == null) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) {
                        if (lineBuffer == null || lineBuffer.length() <= 0) break;
                        line = lineBuffer.toString();
                        break;
                    }
                    boolean eol = false;
                    char c = '\u0000';
                    int i = this.nextChar;
                    while (i < this.nChars) {
                        c = this.characterBuffer[i];
                        if (c == '\n' || c == '\r') {
                            eol = true;
                            break;
                        }
                        ++i;
                    }
                    int startChar = this.nextChar;
                    this.nextChar = i;
                    if (eol) {
                        if (lineBuffer == null) {
                            line = new String(this.characterBuffer, startChar, i - startChar);
                        } else {
                            lineBuffer.append(this.characterBuffer, startChar, i - startChar);
                            line = lineBuffer.toString();
                        }
                        if (c == '\n') {
                            this.lastEOL = AcceleoEvaluationContext.UNIX_LINE_SEPARATOR;
                            ++this.nextChar;
                        } else if (c == '\r') {
                            if (this.characterBuffer[this.nextChar + 1] == '\n') {
                                this.lastEOL = AcceleoEvaluationContext.DOS_LINE_SEPARATOR;
                                this.nextChar += 2;
                            } else {
                                this.lastEOL = AcceleoEvaluationContext.MAC_LINE_SEPARATOR;
                                ++this.nextChar;
                            }
                        }
                    }
                    if (lineBuffer == null) {
                        lineBuffer = new StringBuilder();
                    }
                    lineBuffer.append(this.characterBuffer, startChar, i - startChar);
                }
            }
            return line;
        }

        public String getLastEOLSequence() {
            return this.lastEOL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return this.nextChar < this.nChars || this.input.ready();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long n) throws IOException {
            if (n < 0L) {
                throw new IllegalArgumentException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.NegativeSkip"));
            }
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                long r = n;
                while (r > 0L) {
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) break;
                    long d = this.nChars - this.nextChar;
                    if (r <= d) {
                        this.nextChar = (int)((long)this.nextChar + r);
                        r = 0L;
                        break;
                    }
                    r -= d;
                    this.nextChar = this.nChars;
                }
                return n - r;
            }
        }

        private int internalRead(char[] cbuf, int off, int len) throws IOException {
            if (this.nextChar >= this.nChars) {
                if (len >= this.characterBuffer.length) {
                    return this.input.read(cbuf, off, len);
                }
                this.fill();
            }
            int readChars = -1;
            if (this.nextChar < this.nChars) {
                readChars = Math.min(len, this.nChars - this.nextChar);
                System.arraycopy(this.characterBuffer, this.nextChar, cbuf, off, readChars);
                this.nextChar += readChars;
            }
            return readChars;
        }

        private void ensureOpen() throws IOException {
            if (this.input == null) {
                throw new IOException(AcceleoEngineMessages.getString("AcceleoEvaluationContext.ClosedStream"));
            }
        }

        private void fill() throws IOException {
            int n;
            while ((n = this.input.read(this.characterBuffer, 0, this.characterBuffer.length)) == 0) {
            }
            if (n > 0) {
                this.nChars = n;
                this.nextChar = 0;
            }
        }
    }
}

