/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoProjectUtils;
import org.eclipse.acceleo.internal.ide.ui.wizards.project.AcceleoModulesCreationPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.project.AcceleoProjectPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String MODULE_NAME_PREFIX = "org.eclipse.acceleo.module.";
    public static final String INITIAL_PROJECT_NAME = "org.eclipse.acceleo.module.sample";
    protected static final String RESOURCE_WORKING_SET_ID = "org.eclipse.ui.resourceWorkingSetPage";
    protected static final String JAVA_WORKING_SET_ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    protected IConfigurationElement configurationElement;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected AcceleoProjectPage newProjectPage;
    protected AcceleoModulesCreationPage newAcceleoModulesCreationPage;
    private String container;

    public AcceleoProjectWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iSelection) {
        IProject[] projects;
        this.workbench = iWorkbench;
        this.selection = iSelection;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            try {
                if (iProject.isAccessible()) {
                    List<IFile> members = this.members((IContainer)iProject, "ecore");
                    for (IFile iFile : members) {
                        Map dynamicEcorePackagePaths = AcceleoPackageRegistry.INSTANCE.getDynamicEcorePackagePaths();
                        Collection values = dynamicEcorePackagePaths.values();
                        boolean contains = values.contains(iFile.getFullPath().toString());
                        if (contains) continue;
                        AcceleoPackageRegistry.INSTANCE.registerEcorePackages(iFile.getFullPath().toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
                    }
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), false);
            }
            ++n2;
        }
    }

    public void addPages() {
        String newProjectWizardName = AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Name");
        this.newProjectPage = new AcceleoProjectPage(newProjectWizardName, this.getSelection());
        this.newProjectPage.setInitialProjectName(INITIAL_PROJECT_NAME);
        this.newProjectPage.setTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
        this.newProjectPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Description"));
        this.newProjectPage.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.addPage((IWizardPage)this.newProjectPage);
        this.newAcceleoModulesCreationPage = new AcceleoModulesCreationPage();
        this.addPage((IWizardPage)this.newAcceleoModulesCreationPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage) {
            WizardNewProjectCreationPage newPage = (WizardNewProjectCreationPage)page;
            this.container = newPage.getProjectName();
            this.container = String.valueOf(this.container) + "/src/" + this.container.replaceAll("\\.", "/");
            this.container = String.valueOf(this.container) + "/common";
            this.newAcceleoModulesCreationPage.setContainer(this.container);
        }
        return super.getNextPage(page);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public boolean canFinish() {
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage currentPage = iWizardContainer.getCurrentPage();
        if (currentPage instanceof WizardNewProjectCreationPage) {
            return this.newProjectPage.isPageComplete();
        }
        return this.newProjectPage.isPageComplete() && this.newAcceleoModulesCreationPage.isPageComplete();
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        try {
            IWizardContainer iWizardContainer = this.getContainer();
            IRunnableWithProgress projectCreation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    AcceleoProjectWizard.this.createProject(monitor);
                }
            };
            iWizardContainer.run(false, false, projectCreation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
            return true;
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (InterruptedException e) {
            AcceleoUIActivator.log(e, true);
        }
        return false;
    }

    private void createProject(IProgressMonitor monitor) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.newProjectPage.getProjectName());
            IPath location = this.newProjectPage.getLocationPath();
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(this.newProjectPage.getProjectName());
                if (ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                    location = null;
                }
                desc.setLocation(location);
                project.create(desc, monitor);
                project.open(monitor);
                boolean shouldGenerateModules = !(this.getContainer().getCurrentPage() instanceof WizardNewProjectCreationPage);
                AcceleoProjectWizard.convert(project, this.newProjectPage.getSelectedJVM(), this.newAcceleoModulesCreationPage.getAllModules(), shouldGenerateModules, monitor);
                IWorkingSet[] workingSets = this.newProjectPage.getSelectedWorkingSets();
                this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
                project.build(6, "org.eclipse.acceleo.ide.ui.acceleoBuilder", new HashMap(), monitor);
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    public static void convert(IProject project, String selectedJVM, List<AcceleoModule> allModules, boolean shouldGenerateModules, IProgressMonitor monitor) {
        Bundle bundle;
        String generatorName = AcceleoProjectWizard.computeGeneratorName(project.getName());
        AcceleoProject acceleoProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
        acceleoProject.setName(project.getName());
        acceleoProject.setGeneratorName(generatorName);
        acceleoProject.setJre(selectedJVM);
        if (acceleoProject.getJre() == null && acceleoProject.getJre().length() == 0) {
            acceleoProject.setJre("J2SE-1.5");
        }
        if (shouldGenerateModules) {
            for (AcceleoModule acceleoModule : allModules) {
                String parentFolder = acceleoModule.getParentFolder();
                IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
                if (moduleProject.exists() && moduleProject.isAccessible() && acceleoModule.getModuleElement() != null && acceleoModule.getModuleElement().isIsMain()) {
                    Path parentFolderPath = new Path(parentFolder);
                    IFolder folder = moduleProject.getFolder(parentFolderPath.removeFirstSegments(1));
                    acceleoProject.getExportedPackages().add((Object)folder.getProjectRelativePath().removeFirstSegments(1).toString().replaceAll("/", "\\."));
                }
                EList<String> metamodelURIs = acceleoModule.getMetamodelURIs();
                for (String metamodelURI : metamodelURIs) {
                    EPackage ePackage = AcceleoPackageRegistry.INSTANCE.getEPackage(metamodelURI);
                    if (ePackage == null || ePackage instanceof EcorePackage) continue;
                    bundle = AcceleoWorkspaceUtil.getBundle(ePackage.getClass());
                    acceleoProject.getPluginDependencies().add((Object)bundle.getSymbolicName());
                }
            }
        }
        try {
            IFolder classes;
            Bundle executionEnvironments;
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.acceleo.ide.ui.acceleoNature"});
            project.setDescription(description, monitor);
            IJavaProject iJavaProject = JavaCore.create((IProject)project);
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IExecutionEnvironmentsManager executionEnvironmentsManager = JavaRuntime.getExecutionEnvironmentsManager();
            bundle = executionEnvironments = executionEnvironmentsManager.getExecutionEnvironments();
            int ePackage = ((IExecutionEnvironment[])bundle).length;
            int n = 0;
            while (n < ePackage) {
                Bundle iExecutionEnvironment = bundle[n];
                if (acceleoProject.getJre().equals(iExecutionEnvironment.getId())) {
                    entries.add(JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IExecutionEnvironment)iExecutionEnvironment)));
                    break;
                }
                ++n;
            }
            entries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            IFolder target = project.getFolder("src");
            if (!target.exists()) {
                target.create(true, true, monitor);
            }
            if (!(classes = project.getFolder("bin")).exists()) {
                classes.create(true, true, monitor);
            }
            iJavaProject.setOutputLocation(classes.getFullPath(), monitor);
            IPackageFragmentRoot packageRoot = iJavaProject.getPackageFragmentRoot((IResource)target);
            entries.add(JavaCore.newSourceEntry((IPath)packageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)classes.getFullPath()));
            iJavaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
            iJavaProject.open(monitor);
            AcceleoProjectUtils.generateFiles(acceleoProject, allModules, project, shouldGenerateModules, monitor);
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            settings.setCompilationKind("compilation.platform.resource");
            settings.setResourceKind("xmi");
            settings.save();
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    private static String computeGeneratorName(String projectName) {
        String generatorName = projectName;
        if (generatorName.startsWith(MODULE_NAME_PREFIX)) {
            generatorName = generatorName.substring(MODULE_NAME_PREFIX.length());
        } else {
            int i = generatorName.lastIndexOf(46);
            if (i > -1) {
                generatorName = generatorName.substring(i + 1);
            }
        }
        if (generatorName.length() > 0) {
            StringTokenizer st = new StringTokenizer(generatorName, ".");
            generatorName = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                generatorName = String.valueOf(generatorName) + Character.toUpperCase(token.charAt(0)) + token.substring(1);
            }
        }
        return generatorName;
    }

    private List<IFile> members(IContainer iContainer, String extension) throws CoreException {
        IResource[] children;
        ArrayList<IFile> output = new ArrayList<IFile>();
        if (iContainer != null && (children = iContainer.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                    output.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    output.addAll(this.members((IContainer)resource, extension));
                }
                ++i;
            }
        }
        return output;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }
}

