/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.compiler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParserSignatureUtils;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParserTrimUtils;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParserUtils;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProject;
import org.eclipse.acceleo.internal.parser.compiler.IAcceleoParserURIHandler;
import org.eclipse.acceleo.internal.parser.compiler.IParserListener;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.model.mtl.resource.AcceleoResourceSetImpl;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.OperationCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoParser {
    private AcceleoProject acceleoProject;
    private boolean usebinaryResources;
    private boolean checkOMGCompliance;
    private ResourceSet resourceSet = new AcceleoResourceSetImpl();
    private Set<IParserListener> listeners = new LinkedHashSet<IParserListener>();
    private File dependingBuiltFile;
    private IAcceleoParserURIHandler uriHandler;
    private Set<File> mainFiles = new LinkedHashSet<File>();
    private Multimap<File, AcceleoParserProblem> problems = ArrayListMultimap.create();
    private Multimap<File, AcceleoParserWarning> warnings = ArrayListMultimap.create();
    private Multimap<File, AcceleoParserInfo> infos = ArrayListMultimap.create();
    private Set<File> dependenciesToBuild = new LinkedHashSet<File>();
    private boolean usePlatformResourcePath;

    public AcceleoParser(AcceleoProject acceleoProject, boolean useBinaryResources, boolean usePlatformResourcePath) {
        this.resourceSet.setPackageRegistry((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
        AcceleoParserUtils.registerResourceFactories(this.resourceSet);
        AcceleoParserUtils.registerPackages(this.resourceSet);
        AcceleoParserUtils.registerLibraries(this.resourceSet);
        this.acceleoProject = acceleoProject;
        this.usebinaryResources = useBinaryResources;
        this.usePlatformResourcePath = usePlatformResourcePath;
    }

    protected void addDependencyToBuild(File file) {
        this.dependenciesToBuild.add(file);
    }

    protected void clearDependencyToBuild() {
        this.dependenciesToBuild.clear();
    }

    protected void removeBuiltDependency(File file) {
        this.dependenciesToBuild.remove(file);
    }

    public void addListeners(IParserListener ... parserListeners) {
        IParserListener[] iParserListenerArray = parserListeners;
        int n = parserListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IParserListener iParserListener = iParserListenerArray[n2];
            this.listeners.add(iParserListener);
            ++n2;
        }
    }

    public void setURIHandler(IAcceleoParserURIHandler resolver) {
        this.uriHandler = resolver;
    }

    public void setFullOMGCompliance(boolean fullOMGCompilance) {
        this.checkOMGCompliance = fullOMGCompilance;
    }

    public Set<File> getMainFiles() {
        return this.mainFiles;
    }

    public Set<File> buildAll(Monitor monitor) {
        Set<File> allAcceleoModules = this.acceleoProject.getAllAcceleoModules();
        LinkedHashSet<File> built = new LinkedHashSet<File>();
        if (!monitor.isCanceled()) {
            for (File file : allAcceleoModules) {
                if (built.contains(file)) continue;
                built.addAll(this.build(file, monitor));
            }
        }
        return built;
    }

    public Set<File> buildFile(File file, Monitor monitor) {
        Set<File> built = Collections.emptySet();
        try {
            built = this.build(file, monitor);
        }
        catch (Throwable throwable) {
            Thread unloadThread = new Thread(){

                public void run() {
                    ArrayList resources = new ArrayList();
                    resources.addAll(AcceleoParser.this.resourceSet.getResources());
                    Iterator it = resources.iterator();
                    while (it.hasNext()) {
                        ((Resource)it.next()).unload();
                    }
                }
            };
            unloadThread.start();
            throw throwable;
        }
        Thread unloadThread = new /* invalid duplicate definition of identical inner class */;
        unloadThread.start();
        return built;
    }

    private Set<File> build(File file, File fileCausingTheBuild, Monitor monitor) {
        this.dependingBuiltFile = fileCausingTheBuild;
        return this.build(file, monitor);
    }

    private Set<File> build(File file, Monitor monitor) {
        for (IParserListener listener : this.listeners) {
            listener.startBuild(file);
        }
        monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.StartingBuild", file.getAbsolutePath()));
        LinkedHashSet<File> filesBuilt = new LinkedHashSet<File>();
        Set<AcceleoProject> dependingAcceleoProjects = this.acceleoProject.getProjectDependencies();
        boolean isImpactingBuild = false;
        List<Object> signature = Collections.emptyList();
        File outputFile = this.acceleoProject.getOutputFile(file);
        if (outputFile != null && !outputFile.exists()) {
            isImpactingBuild = true;
        } else {
            AcceleoResourceSetImpl resourceSetTMP = new AcceleoResourceSetImpl();
            AcceleoParserUtils.registerLibraries((ResourceSet)resourceSetTMP);
            AcceleoParserUtils.registerResourceFactories((ResourceSet)resourceSetTMP);
            AcceleoParserUtils.registerPackages((ResourceSet)resourceSetTMP);
            signature = AcceleoParserSignatureUtils.signature(outputFile, (ResourceSet)resourceSetTMP);
        }
        if (outputFile == null || monitor.isCanceled()) {
            return filesBuilt;
        }
        monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileCST", file.getAbsolutePath()));
        AcceleoFile acceleoFile = new AcceleoFile(file, this.acceleoProject.getModuleQualifiedName(file));
        AcceleoSourceBuffer acceleoSourceBuffer = new AcceleoSourceBuffer(acceleoFile);
        acceleoSourceBuffer.createCST();
        monitor.worked(1);
        Module module = acceleoSourceBuffer.getCST();
        List<String> newSignature = AcceleoParserSignatureUtils.signature(module);
        isImpactingBuild = isImpactingBuild || !signature.equals(newSignature);
        EList<ModuleImportsValue> importedModules = module.getImports();
        EList<ModuleExtendsValue> extendedModules = module.getExtends();
        LinkedHashSet<String> moduleDependencies = new LinkedHashSet<String>();
        for (ModuleImportsValue moduleImportsValue : importedModules) {
            moduleDependencies.add(moduleImportsValue.getName());
        }
        for (ModuleExtendsValue moduleExtendsValue : extendedModules) {
            moduleDependencies.add(moduleExtendsValue.getName());
        }
        LinkedHashSet<URI> dependingModulesURI = new LinkedHashSet<URI>(moduleDependencies.size());
        Set<File> dependingModulesFiles = new LinkedHashSet<File>(moduleDependencies.size());
        AcceleoParserSignatureUtils.signature(file, (ResourceSet)new ResourceSetImpl());
        monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ResolvingDependencies", file.getAbsolutePath()));
        for (String moduleDependency : moduleDependencies) {
            URI moduleURI;
            int originalSize;
            boolean found = false;
            File acceleoModule = this.acceleoProject.getFileDependency(moduleDependency);
            if (acceleoModule != null && !monitor.isCanceled()) {
                originalSize = dependingModulesFiles.size();
                boolean bl = found = (dependingModulesFiles = this.computeModuleFileDependency(file, filesBuilt, dependingModulesFiles, acceleoModule, monitor)).size() > originalSize;
            }
            if (!found && !monitor.isCanceled()) {
                originalSize = dependingModulesFiles.size();
                boolean bl = found = (dependingModulesFiles = this.computeModuleFileDependencyInOtherProjects(file, filesBuilt, dependingAcceleoProjects, dependingModulesFiles, moduleDependency, monitor)).size() > originalSize;
            }
            if (found || monitor.isCanceled() || (moduleURI = this.acceleoProject.getURIDependency(moduleDependency)) == null) continue;
            dependingModulesURI.add(moduleURI);
            found = true;
        }
        if (!filesBuilt.contains(file) && !monitor.isCanceled()) {
            if (this.hasMainTag(acceleoSourceBuffer.getBuffer())) {
                this.mainFiles.add(file);
            }
            monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileAST", file.getAbsolutePath()));
            this.doBuild(file, filesBuilt, outputFile, acceleoSourceBuffer, dependingModulesURI, dependingModulesFiles, monitor);
            if (isImpactingBuild) {
                filesBuilt.addAll(this.buildImpactedModules(file, monitor, filesBuilt));
            }
        }
        for (IParserListener listener : this.listeners) {
            listener.endBuild(file);
        }
        return filesBuilt;
    }

    private Set<File> computeModuleFileDependency(File file, Set<File> filesBuilt, Set<File> dependingModulesFiles, File acceleoModule, Monitor monitor) {
        File output = this.acceleoProject.getOutputFile(acceleoModule);
        if (output != null && !output.exists() && !this.dependenciesToBuild.contains(acceleoModule)) {
            this.addDependencyToBuild(acceleoModule);
            filesBuilt.addAll(this.build(acceleoModule, file, monitor));
            filesBuilt.add(acceleoModule);
            this.removeBuiltDependency(acceleoModule);
        }
        if (output != null && !output.exists() && this.dependenciesToBuild.contains(acceleoModule)) {
            this.problems.put((Object)file, (Object)new AcceleoParserProblem(AcceleoParserMessages.getString("AcceleoParser.CircularDependency", this.acceleoProject.getModuleQualifiedName(file), this.acceleoProject.getModuleQualifiedName(acceleoModule)), 0, 0, 0));
        }
        if (output != null && output.exists()) {
            dependingModulesFiles.add(output);
        }
        return dependingModulesFiles;
    }

    private Set<File> computeModuleFileDependencyInOtherProjects(File file, Set<File> filesBuilt, Set<AcceleoProject> dependingAcceleoProjects, Set<File> dependingModulesFiles, String moduleDependency, Monitor monitor) {
        boolean found = false;
        Iterator<AcceleoProject> iterator = dependingAcceleoProjects.iterator();
        while (iterator.hasNext() && !found) {
            AcceleoProject dependingAcceleoProject = iterator.next();
            File dependingModule = dependingAcceleoProject.getFileDependency(moduleDependency);
            if (dependingModule == null) continue;
            File output = dependingAcceleoProject.getOutputFile(dependingModule);
            if (output != null && !output.exists() && !this.dependenciesToBuild.contains(dependingModule)) {
                AcceleoParser parser = new AcceleoParser(dependingAcceleoProject, this.usebinaryResources, this.usePlatformResourcePath);
                parser.addListeners(this.listeners.toArray(new IParserListener[this.listeners.size()]));
                parser.setURIHandler(this.uriHandler);
                parser.addDependencyToBuild(dependingModule);
                filesBuilt.addAll(parser.build(dependingModule, file, monitor));
                filesBuilt.add(dependingModule);
                parser.removeBuiltDependency(dependingModule);
                this.problems.putAll((Object)dependingModule, parser.getProblems(dependingModule));
                this.warnings.putAll((Object)dependingModule, parser.getWarnings(dependingModule));
                this.infos.putAll((Object)dependingModule, parser.getInfos(dependingModule));
            }
            if ((output = dependingAcceleoProject.getOutputFile(dependingModule)) == null || !output.exists()) continue;
            dependingModulesFiles.add(output);
            found = true;
        }
        return dependingModulesFiles;
    }

    private void doBuild(File file, Set<File> filesBuilt, File outputFile, AcceleoSourceBuffer acceleoSourceBuffer, Set<URI> dependingModulesURI, Set<File> dependingModulesFiles, Monitor monitor) {
        URI fileURI = URI.createFileURI((String)outputFile.getAbsolutePath());
        Resource oResource = this.createResource(fileURI, this.resourceSet);
        acceleoSourceBuffer.createAST(oResource);
        monitor.worked(1);
        for (URI uri : dependingModulesURI) {
            try {
                for (IParserListener listener : this.listeners) {
                    listener.loadDependency(uri);
                }
                ModelUtils.load((URI)uri, (ResourceSet)this.resourceSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (File dependingModule : dependingModulesFiles) {
            try {
                for (IParserListener listener : this.listeners) {
                    listener.loadDependency(dependingModule);
                }
                if (EMFPlugin.IS_ECLIPSE_RUNNING && this.usePlatformResourcePath) {
                    AcceleoProject dependingModuleAcceleoProject = null;
                    if (this.acceleoProject.getAllCompiledAcceleoModules().contains(dependingModule)) {
                        dependingModuleAcceleoProject = this.acceleoProject;
                    } else {
                        for (AcceleoProject anAcceleoProject : this.acceleoProject.getProjectDependencies()) {
                            if (!anAcceleoProject.getAllCompiledAcceleoModules().contains(dependingModule)) continue;
                            dependingModuleAcceleoProject = anAcceleoProject;
                            break;
                        }
                    }
                    if (dependingModuleAcceleoProject == null) continue;
                    URI dependingModuleURI = URI.createPlatformResourceURI((String)(String.valueOf(dependingModuleAcceleoProject.getProjectRoot().getName()) + dependingModule.getAbsolutePath().substring(dependingModuleAcceleoProject.getProjectRoot().getAbsolutePath().length())), (boolean)true);
                    ModelUtils.load((URI)dependingModuleURI, (ResourceSet)this.resourceSet);
                    continue;
                }
                ModelUtils.load((File)dependingModule, (ResourceSet)this.resourceSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        acceleoSourceBuffer.resolveAST();
        acceleoSourceBuffer.resolveASTDocumentation();
        for (Resource resource : this.resourceSet.getResources()) {
            URI reusableURI;
            URI resourceURI = resource.getURI();
            if (this.uriHandler == null || resourceURI == null || (reusableURI = this.uriHandler.transform(resourceURI)) == null) continue;
            resource.setURI(reusableURI);
        }
        AcceleoParserTrimUtils.getInstance().trimEnvironment(this.resourceSet);
        HashMap<String, String> options = new HashMap<String, String>();
        if (!this.usebinaryResources) {
            String encoding = acceleoSourceBuffer.getEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            options.put("ENCODING", encoding);
        }
        if (this.checkOMGCompliance && oResource.getContents().size() > 0) {
            this.checkOMGCompilance(file, acceleoSourceBuffer, oResource);
        }
        monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.SaveAST", file.getAbsolutePath()));
        try {
            for (IParserListener listener : this.listeners) {
                listener.fileSaved(file);
            }
            oResource.save(options);
            monitor.worked(10);
            filesBuilt.add(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.problems.putAll((Object)file, acceleoSourceBuffer.getProblems().getList());
        this.warnings.putAll((Object)file, acceleoSourceBuffer.getWarnings().getList());
        this.infos.putAll((Object)file, acceleoSourceBuffer.getInfos().getList());
    }

    private boolean hasMainTag(StringBuffer contents) {
        Sequence pattern = new Sequence("@main");
        return pattern.search(contents).b() > -1;
    }

    private void checkOMGCompilance(File file, AcceleoSourceBuffer acceleoSourceBuffer, Resource oResource) {
        EObject eObject = (EObject)oResource.getContents().get(0);
        TreeIterator oAllContents = eObject.eAllContents();
        while (oAllContents.hasNext()) {
            OperationCallExp oOperationCallExp;
            EObject oNext = (EObject)oAllContents.next();
            if (!(oNext instanceof OperationCallExp) || (oOperationCallExp = (OperationCallExp)oNext).getReferredOperation() == null || ((EOperation)oOperationCallExp.getReferredOperation()).getEAnnotation("MTL non-standard") == null) continue;
            String message = AcceleoParserMessages.getString("AcceleoParser.NotFullyCompliant", ((EOperation)oOperationCallExp.getReferredOperation()).getName());
            int line = acceleoSourceBuffer.getLineOfOffset(oOperationCallExp.getStartPosition());
            int posBegin = oOperationCallExp.getStartPosition();
            int posEnd = oOperationCallExp.getEndPosition();
            AcceleoParserProblem problem = new AcceleoParserProblem(message, line, posBegin, posEnd);
            this.problems.put((Object)file, (Object)problem);
        }
    }

    private Set<File> buildImpactedModules(File file, Monitor monitor, Set<File> filesBuilt) {
        Set<Object> filesToBuild = Sets.newLinkedHashSet();
        if (!monitor.isCanceled()) {
            List<Sequence> sequencesToSearch = AcceleoParserUtils.getImportSequencesToSearch(this.acceleoProject, file);
            filesToBuild = this.acceleoProject.getFilesDependingOn(sequencesToSearch);
            LinkedHashSet<File> fileBuiltByPropagation = new LinkedHashSet<File>();
            for (File file2 : filesToBuild) {
                if (file2.equals(this.dependingBuiltFile) || fileBuiltByPropagation.contains(file2) || monitor.isCanceled()) continue;
                fileBuiltByPropagation.clear();
                this.clearDependencyToBuild();
                filesBuilt.addAll(this.build(file2, monitor));
                filesBuilt.add(file2);
                fileBuiltByPropagation.addAll(filesBuilt);
            }
            filesToBuild = new LinkedHashSet();
            for (AcceleoProject acceleoProject : this.acceleoProject.getDependentProjects()) {
                filesToBuild.addAll(acceleoProject.getFilesDependingOn(sequencesToSearch));
                fileBuiltByPropagation = new LinkedHashSet();
                for (File file3 : filesToBuild) {
                    if (file3.equals(this.dependingBuiltFile) || fileBuiltByPropagation.contains(file3) || monitor.isCanceled()) continue;
                    fileBuiltByPropagation.clear();
                    AcceleoParser parser = new AcceleoParser(acceleoProject, this.usebinaryResources, this.usePlatformResourcePath);
                    parser.addListeners(this.listeners.toArray(new IParserListener[this.listeners.size()]));
                    parser.setURIHandler(this.uriHandler);
                    parser.clearDependencyToBuild();
                    filesBuilt.addAll(parser.build(file3, monitor));
                    filesBuilt.add(file3);
                    fileBuiltByPropagation.addAll(filesBuilt);
                }
            }
        }
        return filesBuilt;
    }

    private Resource createResource(URI oURI, ResourceSet oResourceSet) {
        if (this.usebinaryResources) {
            return ModelUtils.createBinaryResource((URI)oURI, (ResourceSet)oResourceSet);
        }
        return ModelUtils.createResource((URI)oURI, (ResourceSet)oResourceSet);
    }

    public Collection<AcceleoParserProblem> getProblems(File file) {
        return Collections.unmodifiableCollection(this.problems.get((Object)file));
    }

    public Collection<AcceleoParserWarning> getWarnings(File file) {
        return Collections.unmodifiableCollection(this.warnings.get((Object)file));
    }

    public Collection<AcceleoParserInfo> getInfos(File file) {
        return Collections.unmodifiableCollection(this.infos.get((Object)file));
    }
}

