/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WorkspaceClassInstance {
    private final String bundle;
    private Class<?> clazz;
    private Object instance;
    private boolean stale;

    public WorkspaceClassInstance(Class<?> clazz, String bundle) {
        this.clazz = clazz;
        this.bundle = bundle;
    }

    public boolean isStale() {
        return this.stale;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getQualifiedName() {
        return this.clazz.getName();
    }

    public Class<?> getClassInstance() {
        return this.clazz;
    }

    public Object getInstance() {
        if (this.instance == null) {
            try {
                this.instance = this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassInstantiationFailure", this.clazz.getName(), this.bundle), e, false);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassConstructorFailure", this.clazz.getName(), this.bundle), e, false);
            }
        }
        return this.instance;
    }

    public void setClass(Class<?> newClass) {
        this.clazz = newClass;
        this.instance = null;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }
}

